/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.passay.dictionary.ArrayWordList;
import org.passay.dictionary.Dictionary;
import org.passay.dictionary.WordListDictionary;
import org.passay.dictionary.WordLists;
import org.passay.dictionary.sort.ArraySorter;
import org.passay.dictionary.sort.ArraysSort;

public class DictionaryBuilder {
    private static final ArraySorter SORTER = new ArraysSort();
    private final List<Reader> sources = new ArrayList<Reader>();
    private boolean caseSensitive;

    public DictionaryBuilder addFile(String path) {
        try {
            return this.addReader(new FileReader(new File(path)));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(path + " does not exist", e);
        }
    }

    public DictionaryBuilder addReader(Reader reader) {
        this.sources.add(reader);
        return this;
    }

    public DictionaryBuilder setCaseSensitive(boolean flag) {
        this.caseSensitive = flag;
        return this;
    }

    public Dictionary build() {
        try {
            ArrayList<String> wordList = new ArrayList<String>();
            for (Reader reader : this.sources) {
                WordLists.readWordList(reader, wordList);
            }
            String[] words = new String[wordList.size()];
            wordList.toArray(words);
            return new WordListDictionary(new ArrayWordList(words, this.caseSensitive, SORTER));
        }
        catch (IOException e) {
            throw new RuntimeException("IO error building dictionary", e);
        }
    }
}

