/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.LinkedList;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsyncIOWriterAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereInterceptorWriter
extends AsyncIOWriterAdapter {
    private final Logger logger = LoggerFactory.getLogger(AtmosphereInterceptorWriter.class);
    protected final LinkedList<AsyncIOInterceptor> filters = new LinkedList();
    protected final LinkedList<AsyncIOInterceptor> reversedFilters = new LinkedList();

    @Override
    public AsyncIOWriter redirect(AtmosphereResponse response, String location) throws IOException {
        for (AsyncIOInterceptor i : this.filters) {
            i.redirect(response, location);
        }
        return this;
    }

    @Override
    public AsyncIOWriter writeError(AtmosphereResponse response, int errorCode, String message) throws IOException {
        for (AsyncIOInterceptor i : this.filters) {
            byte[] b = i.error(response, errorCode, message);
            this.writeReady(response, b);
        }
        return this;
    }

    @Override
    public AsyncIOWriter write(AtmosphereResponse response, String data) throws IOException {
        return this.write(response, data.getBytes(response.getCharacterEncoding()));
    }

    @Override
    public AsyncIOWriter write(AtmosphereResponse response, byte[] data) throws IOException {
        return this.write(response, data, 0, data.length);
    }

    @Override
    public AsyncIOWriter write(AtmosphereResponse response, byte[] data, int offset, int length) throws IOException {
        this.invokeInterceptor(response, data, offset, length);
        return this;
    }

    protected void invokeInterceptor(AtmosphereResponse response, byte[] data, int offset, int length) throws IOException {
        for (AsyncIOInterceptor i : this.filters) {
            i.prePayload(response, data, offset, length);
        }
        byte[] responseDraft = new byte[length];
        System.arraycopy(data, offset, responseDraft, 0, length);
        for (AsyncIOInterceptor i : this.filters) {
            responseDraft = i.transformPayload(response, responseDraft, data);
        }
        this.writeReady(response, responseDraft);
        for (AsyncIOInterceptor i : this.reversedFilters) {
            i.postPayload(response, data, offset, length);
        }
    }

    protected void writeReady(AtmosphereResponse response, byte[] responseDraft) throws IOException {
        response.write(responseDraft);
    }

    @Override
    public void close(AtmosphereResponse response) throws IOException {
        response.closeStreamOrWriter();
    }

    @Override
    public AsyncIOWriter flush(AtmosphereResponse response) throws IOException {
        response.flushBuffer();
        return this;
    }

    public AtmosphereInterceptorWriter interceptor(AsyncIOInterceptor filter) {
        if (!this.filters.contains(filter)) {
            this.logger.trace("Adding AsyncIOInterceptor {}", (Object)filter.getClass().getName());
            this.filters.addLast(filter);
            this.reversedFilters.addFirst(filter);
        }
        return this;
    }

    public AtmosphereInterceptorWriter interceptor(AsyncIOInterceptor filter, int index) {
        if (!this.filters.contains(filter)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Adding AsyncIOInterceptor {} at index {}", (Object)filter.getClass().getName(), (Object)index);
            }
            this.filters.add(index, filter);
            this.reversedFilters.add(this.reversedFilters.size() - index, filter);
        }
        return this;
    }

    public LinkedList<AsyncIOInterceptor> filters() {
        return this.filters;
    }
}

