/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import java.util.Map;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class ScrollEvent
extends Event {
    private final int _pos;
    private final double _dPos;
    private boolean _outBound;

    public static final ScrollEvent getScrollEvent(AuRequest request) {
        Map<String, Object> data = request.getData();
        Object decimal = data.get("decimal");
        double dPos = 0.0;
        if (decimal != null) {
            dPos = AuRequests.getDouble(data, "decimal", 0L);
            int pos = (int)dPos;
        } else {
            int pos = AuRequests.getInt(data, "", 0);
            dPos = pos;
        }
        Object outBound = data.get("outBound");
        if (outBound != null) {
            return new ScrollEvent(request.getCommand(), request.getComponent(), dPos, (boolean)((Boolean)outBound));
        }
        return new ScrollEvent(request.getCommand(), request.getComponent(), dPos);
    }

    public ScrollEvent(String name, Component target, int pos) {
        super(name, target);
        this._pos = pos;
        this._dPos = pos;
    }

    public ScrollEvent(String name, Component target, double pos) {
        super(name, target);
        this._pos = (int)pos;
        this._dPos = pos;
    }

    public ScrollEvent(String name, Component target, int pos, boolean outBound) {
        super(name, target);
        this._pos = pos;
        this._dPos = pos;
        this._outBound = outBound;
    }

    public ScrollEvent(String name, Component target, double dPos, boolean outBound) {
        super(name, target);
        this._pos = (int)dPos;
        this._dPos = dPos;
        this._outBound = outBound;
    }

    public final int getPos() {
        return this._pos;
    }

    public final double getPosInDouble() {
        return this._dPos;
    }

    public boolean isOutOfBound() {
        return this._outBound;
    }
}

