/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.idom.Document;
import org.zkoss.util.CollectionsX;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.VariableResolverX;
import org.zkoss.xel.XelContext;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.impl.ProxyEvent;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionInfo;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.Visualizer;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Callback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExecution
implements Execution,
ExecutionCtrl {
    private static final Logger _zklog = LoggerFactory.getLogger((String)"org.zkoss.zk.log");
    private Desktop _desktop;
    private Page _curpage;
    private PageDefinition _curpgdef;
    private final Map<Integer, List<EventInfo>> _evtInfos = new TreeMap<Integer, List<EventInfo>>(new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            return o2.compareTo(o1);
        }
    });
    private List<Map<?, ?>> _args;
    private final Page _creating;
    private String _reqId;
    private Collection<AuResponse> _resps;
    private ExecutionInfo _execinf;
    private List<VariableResolver> _resolvers;
    protected static final String Add_ON_ACTIVATE = "org.zkoss.zk.ui.executions.addOnActivate";
    protected static final String Add_ON_DEACTIVATE = "org.zkoss.zk.ui.executions.addOnDeactivate";

    protected AbstractExecution(Desktop desktop, Page creating) {
        this._desktop = desktop;
        this._curpage = this._creating = creating;
        if (this._curpage == null) {
            this._curpage = AbstractExecution.getPage(desktop);
        }
    }

    private static Page getPage(Desktop desktop) {
        return desktop != null ? desktop.getFirstPage() : null;
    }

    @Override
    public final boolean isAsyncUpdate(Page page) {
        if (page != null) {
            return this._creating != page;
        }
        Visualizer uv = this.getVisualizer();
        return uv != null && uv.isEverAsyncUpdate();
    }

    @Override
    public Desktop getDesktop() {
        return this._desktop;
    }

    @Override
    public Session getSession() {
        return this._desktop != null ? this._desktop.getSession() : Sessions.getCurrent();
    }

    @Override
    public void postEvent(Event evt) {
        this.postEvent(0, evt);
    }

    @Override
    public void postEvent(int priority, Event evt) {
        if (evt == null) {
            throw new IllegalArgumentException("null");
        }
        if ((evt = ((DesktopCtrl)((Object)this._desktop)).beforePostEvent(evt)) == null) {
            return;
        }
        List<EventInfo> eventInfos = this._evtInfos.get(priority);
        if (eventInfos != null) {
            eventInfos.add(new EventInfo(priority, evt));
        } else {
            eventInfos = new LinkedList<EventInfo>();
            eventInfos.add(new EventInfo(priority, evt));
            this._evtInfos.put(priority, eventInfos);
        }
    }

    @Override
    public void postEvent(int priority, Component realTarget, Event evt) {
        this.postEvent(priority, realTarget != evt.getTarget() ? new ProxyEvent(realTarget, evt) : evt);
    }

    @Override
    public Object getAttribute(String name, boolean recurse) {
        Desktop desktop;
        Object val = this.getAttribute(name);
        return val != null || !recurse || (desktop = this.getDesktop()) == null ? val : desktop.getAttribute(name, true);
    }

    @Override
    public boolean hasAttribute(String name, boolean recurse) {
        Desktop desktop;
        return this.hasAttribute(name) || recurse && (desktop = this.getDesktop()) != null && desktop.hasAttribute(name, true);
    }

    @Override
    public Object setAttribute(String name, Object value, boolean recurse) {
        Desktop desktop;
        if (recurse && !this.hasAttribute(name) && (desktop = this.getDesktop()) != null && desktop.hasAttribute(name, true)) {
            return desktop.setAttribute(name, value, true);
        }
        return this.setAttribute(name, value);
    }

    @Override
    public Object removeAttribute(String name, boolean recurse) {
        if (recurse && !this.hasAttribute(name)) {
            Desktop desktop = this.getDesktop();
            if (desktop != null && desktop.hasAttribute(name, true)) {
                return desktop.removeAttribute(name, true);
            }
            return null;
        }
        return this.removeAttribute(name);
    }

    @Override
    public final Page getCurrentPage() {
        if (this._curpage == null) {
            this._curpage = AbstractExecution.getPage(this._desktop);
        }
        return this._curpage;
    }

    @Override
    public final void setCurrentPage(Page curpage) {
        if (this._curpage != null && curpage != null && this._curpage != curpage) {
            Desktop _curdt = this._curpage.getDesktop();
            Desktop curdt = curpage.getDesktop();
            if (_curdt != null && curdt != null && _curdt != curdt) {
                throw new IllegalStateException("Change current page to another desktop? " + curpage);
            }
        }
        this._curpage = curpage;
    }

    @Override
    public PageDefinition getCurrentPageDefinition() {
        return this._curpgdef;
    }

    @Override
    public void setCurrentPageDefinition(PageDefinition pgdef) {
        this._curpgdef = pgdef;
    }

    @Override
    public Event getNextEvent() {
        Iterator<Map.Entry<Integer, List<EventInfo>>> i$;
        if (!this._evtInfos.isEmpty() && (i$ = this._evtInfos.entrySet().iterator()).hasNext()) {
            Map.Entry<Integer, List<EventInfo>> me = i$.next();
            List<EventInfo> value = me.getValue();
            EventInfo remove = value.remove(0);
            if (value.isEmpty()) {
                this._evtInfos.remove(me.getKey());
            }
            return remove.event;
        }
        ((DesktopCtrl)((Object)this._desktop)).onPiggyback();
        if (!this._evtInfos.isEmpty() && (i$ = this._evtInfos.entrySet().iterator()).hasNext()) {
            Map.Entry<Integer, List<EventInfo>> me = i$.next();
            List<EventInfo> value = me.getValue();
            EventInfo remove = value.remove(0);
            if (value.isEmpty()) {
                this._evtInfos.remove(me.getKey());
            }
            return remove.event;
        }
        return null;
    }

    @Override
    public boolean isActivated() {
        return this.getVisualizer() != null;
    }

    @Override
    public void onActivate() {
        List callbacks;
        if (this._desktop != null && (callbacks = (List)this._desktop.getAttribute(Add_ON_ACTIVATE)) != null) {
            Iterator it = callbacks.iterator();
            while (it.hasNext()) {
                Callback callback = (Callback)it.next();
                callback.call(null);
                it.remove();
            }
        }
    }

    @Override
    public void onBeforeDeactivate() {
        List callbacks;
        if (this._desktop != null && (callbacks = (List)this._desktop.getAttribute(Add_ON_DEACTIVATE)) != null) {
            Iterator it = callbacks.iterator();
            while (it.hasNext()) {
                Callback callback = (Callback)it.next();
                callback.call(null);
                it.remove();
            }
        }
    }

    @Override
    public void onDeactivate() {
    }

    @Override
    public boolean isRecovering() {
        Visualizer uv = this.getVisualizer();
        return uv != null && uv.isRecovering();
    }

    @Override
    public Visualizer getVisualizer() {
        return this._desktop != null ? ((DesktopCtrl)((Object)this._desktop)).getVisualizer() : null;
    }

    @Override
    public String toAbsoluteURI(String uri, boolean skipInclude) {
        String dir;
        char cc;
        if (!(uri == null || uri.length() <= 0 || (cc = uri.charAt(0)) == '/' || cc == '~' || skipInclude && this.isIncluded() || Servlets.isUniversalURL((String)uri) || (dir = this.getDesktop().getCurrentDirectory()) == null)) {
            return dir + uri;
        }
        return uri;
    }

    private final UiEngine getUiEngine() {
        return ((WebAppCtrl)((Object)this._desktop.getWebApp())).getUiEngine();
    }

    @Override
    public Component createComponents(String uri, Component parent, Map<?, ?> arg) {
        return this.createComponents0(uri, parent, null, null, arg);
    }

    @Override
    public Component createComponents(String uri, Component parent, Component insertBefore, VariableResolver resolver) {
        return this.createComponents0(uri, parent, insertBefore, resolver, null);
    }

    @Override
    public Component[] createComponents(String uri, Component parent, Component insertBefore, VariableResolver resolver, Map<?, ?> arg) {
        Component[] cs = this.getUiEngine().createComponents(this, this.getPageDefinition(uri), this.getCurrentPage(), parent, insertBefore, resolver, arg);
        return cs.length > 0 ? cs : null;
    }

    private Component createComponents0(String uri, Component parent, Component insertBefore, VariableResolver resolver, Map<?, ?> arg) {
        Component[] cs = this.getUiEngine().createComponents(this, this.getPageDefinition(uri), this.getCurrentPage(), parent, insertBefore, resolver, arg);
        return cs.length > 0 ? cs[0] : null;
    }

    @Override
    public Component createComponents(PageDefinition pagedef, Component parent, Map<?, ?> arg) {
        return this.createComponents0(pagedef, parent, null, null, arg);
    }

    @Override
    public Component createComponents(PageDefinition pagedef, Component parent, Component insertBefore, VariableResolver resolver) {
        return this.createComponents0(pagedef, parent, insertBefore, resolver, null);
    }

    private Component createComponents0(PageDefinition pagedef, Component parent, Component insertBefore, VariableResolver resolver, Map<?, ?> arg) {
        if (pagedef == null) {
            throw new IllegalArgumentException("pagedef cannot be null");
        }
        Component[] cs = this.getUiEngine().createComponents(this, pagedef, this.getCurrentPage(), parent, insertBefore, resolver, arg);
        return cs.length > 0 ? cs[0] : null;
    }

    @Override
    public Component createComponentsDirectly(String content, String ext, Component parent, Map<?, ?> arg) {
        return this.createComponentsDirectly0(content, ext, parent, null, null, arg);
    }

    @Override
    public Component createComponentsDirectly(String content, String ext, Component parent, Component insertBefore, VariableResolver resolver) {
        return this.createComponentsDirectly0(content, ext, parent, insertBefore, resolver, null);
    }

    private Component createComponentsDirectly0(String content, String ext, Component parent, Component insertBefore, VariableResolver resolver, Map<?, ?> arg) {
        Component[] cs = this.getUiEngine().createComponents(this, this.getPageDefinitionDirectly(content, ext), this.getCurrentPage(), parent, insertBefore, resolver, arg);
        return cs.length > 0 ? cs[0] : null;
    }

    @Override
    public Component createComponentsDirectly(Document content, String ext, Component parent, Map<?, ?> arg) {
        return this.createComponentsDirectly0(content, ext, parent, null, null, arg);
    }

    @Override
    public Component createComponentsDirectly(Document content, String ext, Component parent, Component insertBefore, VariableResolver resolver) {
        return this.createComponentsDirectly0(content, ext, parent, insertBefore, resolver, null);
    }

    private Component createComponentsDirectly0(Document content, String ext, Component parent, Component insertBefore, VariableResolver resolver, Map<?, ?> arg) {
        Component[] cs = this.getUiEngine().createComponents(this, this.getPageDefinitionDirectly(content, ext), this.getCurrentPage(), parent, insertBefore, resolver, arg);
        return cs.length > 0 ? cs[0] : null;
    }

    @Override
    public Component createComponentsDirectly(Reader reader, String ext, Component parent, Map<?, ?> arg) throws IOException {
        return this.createComponentsDirectly0(reader, ext, parent, null, null, arg);
    }

    @Override
    public Component createComponentsDirectly(Reader reader, String ext, Component parent, Component insertBefore, VariableResolver resolver) throws IOException {
        return this.createComponentsDirectly0(reader, ext, parent, insertBefore, resolver, null);
    }

    private Component createComponentsDirectly0(Reader reader, String ext, Component parent, Component insertBefore, VariableResolver resolver, Map<?, ?> arg) throws IOException {
        Component[] cs = this.getUiEngine().createComponents(this, this.getPageDefinitionDirectly(reader, ext), this.getCurrentPage(), parent, insertBefore, resolver, arg);
        return cs.length > 0 ? cs[0] : null;
    }

    @Override
    public Component[] createComponents(String uri, Map<?, ?> arg) {
        return this.getUiEngine().createComponents(this, this.getPageDefinition(uri), null, null, null, null, arg);
    }

    @Override
    public Component[] createComponents(String uri, Page page, VariableResolver resolver, Map<?, ?> arg) {
        return this.getUiEngine().createComponents(this, this.getPageDefinition(uri), page, null, null, resolver, arg);
    }

    @Override
    public Component[] createComponents(PageDefinition pagedef, Map<?, ?> arg) {
        if (pagedef == null) {
            throw new IllegalArgumentException("pagedef cannot be null");
        }
        return this.getUiEngine().createComponents(this, pagedef, null, null, null, null, arg);
    }

    @Override
    public Component[] createComponentsDirectly(String content, String ext, Map<?, ?> arg) {
        return this.getUiEngine().createComponents(this, this.getPageDefinitionDirectly(content, ext), null, null, null, null, arg);
    }

    @Override
    public Component[] createComponentsDirectly(Document content, String ext, Map<?, ?> arg) {
        return this.getUiEngine().createComponents(this, this.getPageDefinitionDirectly(content, ext), null, null, null, null, arg);
    }

    @Override
    public Component[] createComponentsDirectly(Reader reader, String ext, Map<?, ?> arg) throws IOException {
        return this.getUiEngine().createComponents(this, this.getPageDefinitionDirectly(reader, ext), null, null, null, null, arg);
    }

    @Override
    public void sendRedirect(String uri) {
        this.getUiEngine().sendRedirect(uri, null);
    }

    @Override
    public void sendRedirect(String uri, String target) {
        this.getUiEngine().sendRedirect(uri, target);
    }

    @Override
    public void sendRedirect(String uri, boolean respRedirect) {
        if (!respRedirect) {
            this.sendRedirect(uri);
            return;
        }
        uri = uri == null ? "" : uri;
        HttpServletResponse resp = (HttpServletResponse)this.getNativeResponse();
        try {
            String destUrl = this.encodeURL(uri);
            String destUrlParam = URLEncoder.encode(destUrl, "utf-8");
            String updateURI = this._desktop.getUpdateURI("/redirect?redirectUrl=" + destUrlParam);
            updateURI = resp.encodeRedirectURL(updateURI);
            resp.setHeader("Location", updateURI);
            resp.setStatus(302);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<?, ?> getArg() {
        if (this._args != null) {
            return this._args.get(0);
        }
        return Collections.emptyMap();
    }

    @Override
    public void pushArg(Map<?, ?> arg) {
        if (this._args == null) {
            this._args = new LinkedList();
        }
        this._args.add(0, arg);
    }

    @Override
    public void popArg() {
        if (this._args != null) {
            if (this._args.size() == 1) {
                this._args = null;
            } else {
                this._args.remove(0);
            }
        }
    }

    @Override
    public void addAuResponse(AuResponse response) {
        this.getUiEngine().addResponse(response);
    }

    @Override
    public void addAuResponse(String key, AuResponse response) {
        this.getUiEngine().addResponse(key, response);
    }

    @Override
    public void setDesktop(Desktop desktop) {
        if (desktop == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._desktop != null && this._desktop != desktop) {
            throw new IllegalStateException("assign diff desktop");
        }
        this._desktop = desktop;
    }

    @Override
    public void setRequestId(String reqId) {
        this._reqId = reqId;
    }

    @Override
    public String getRequestId() {
        return this._reqId;
    }

    @Override
    public Collection<AuResponse> getResponses() {
        return this._resps;
    }

    @Override
    public void setResponses(Collection<AuResponse> responses) {
        this._resps = responses;
    }

    @Override
    public ExecutionInfo getExecutionInfo() {
        return this._execinf;
    }

    @Override
    public void setExecutionInfo(ExecutionInfo execinf) {
        this._execinf = execinf;
    }

    @Override
    public boolean addVariableResolver(VariableResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._resolvers == null) {
            this._resolvers = new LinkedList<VariableResolver>();
        } else if (this._resolvers.contains(resolver)) {
            return false;
        }
        this._resolvers.add(0, resolver);
        return true;
    }

    @Override
    public boolean removeVariableResolver(VariableResolver resolver) {
        return this._resolvers != null && this._resolvers.remove(resolver);
    }

    @Override
    public boolean hasVariableResolver(VariableResolver resolver) {
        return this._resolvers != null && this._resolvers.contains(resolver);
    }

    @Override
    public boolean hasVariableResolver(Class<? extends VariableResolver> cls) {
        if (this._resolvers != null) {
            for (VariableResolver resolver : this._resolvers) {
                if (!cls.isInstance(resolver)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getExtraXelVariable(String name) {
        return this.getExtraXelVariable(null, null, name);
    }

    @Override
    public Object getExtraXelVariable(XelContext ctx, Object base, Object name) {
        if (this._resolvers != null) {
            Iterator it = CollectionsX.comodifiableIterator(this._resolvers);
            while (it.hasNext()) {
                VariableResolver vr = (VariableResolver)it.next();
                Object o = vr instanceof VariableResolverX ? ((VariableResolverX)vr).resolveVariable(ctx, base, name) : (base == null && name != null ? vr.resolveVariable(name.toString()) : null);
                if (o == null) continue;
                return o;
            }
        }
        return null;
    }

    @Override
    public void log(String msg) {
        if (this._desktop != null) {
            this._desktop.getWebApp().log(msg);
        } else {
            _zklog.info(msg);
        }
    }

    @Override
    public void log(String msg, Throwable ex) {
        if (this._desktop != null) {
            this._desktop.getWebApp().log(msg, ex);
        } else {
            _zklog.error(msg, ex);
        }
    }

    @Override
    public void addOnActivate(Callback callback) {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("Execution cannot be null!");
        }
        Desktop desktop = exec.getDesktop();
        if (desktop != null) {
            LinkedList<Callback> callbacks = (LinkedList<Callback>)desktop.getAttribute(Add_ON_ACTIVATE);
            if (callbacks == null) {
                callbacks = new LinkedList<Callback>();
                desktop.setAttribute(Add_ON_ACTIVATE, callbacks);
            }
            callbacks.add(callback);
        }
    }

    @Override
    public void addOnDeactivate(Callback callback) {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("Execution cannot be null!");
        }
        Desktop desktop = exec.getDesktop();
        if (desktop != null) {
            LinkedList<Callback> callbacks = (LinkedList<Callback>)desktop.getAttribute(Add_ON_DEACTIVATE);
            if (callbacks == null) {
                callbacks = new LinkedList<Callback>();
                desktop.setAttribute(Add_ON_DEACTIVATE, callbacks);
            }
            callbacks.add(callback);
        }
    }

    public String toString() {
        return "[Exec" + System.identityHashCode(this) + ": " + this._desktop + ']';
    }

    private static class EventInfo {
        private final int priority;
        private final Event event;

        private EventInfo(int priority, Event event) {
            this.priority = priority;
            this.event = event;
        }

        public String toString() {
            return "[" + this.priority + ": " + this.event.toString() + "]";
        }
    }
}

