/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.util.Converter;
import org.zkoss.util.Pair;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.annotation.Command;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.select.impl.Reflections;
import org.zkoss.zk.ui.util.ConventionWire;

public class ConventionWires {
    private static final Logger log = LoggerFactory.getLogger(ConventionWires.class);

    public static final void wireFellows(IdSpace idspace, Object controller) {
        new ConventionWire(controller).wireFellows(idspace);
    }

    public static final void wireFellows(IdSpace idspace, Object controller, char separator) {
        new ConventionWire(controller, separator).wireFellows(idspace);
    }

    public static final void wireFellows(IdSpace idspace, Object controller, char separator, boolean ignoreZScript, boolean ignoreXel) {
        new ConventionWire(controller, separator, ignoreZScript, ignoreXel).wireFellows(idspace);
    }

    public static final void wireVariables(Component comp, Object controller) {
        new ConventionWire(controller).wireVariables(comp);
    }

    public static final void wireVariables(Component comp, Object controller, char separator) {
        new ConventionWire(controller, separator).wireVariables(comp);
    }

    public static final void wireVariables(Component comp, Object controller, char separator, boolean ignoreZScript, boolean ignoreXel) {
        new ConventionWire(controller, separator, ignoreZScript, ignoreXel).wireVariables(comp);
    }

    public static final void wireVariables(Page page, Object controller) {
        new ConventionWire(controller).wireVariables(page);
    }

    public static final void wireVariables(Page page, Object controller, char separator) {
        new ConventionWire(controller, separator).wireVariables(page);
    }

    public static final void wireVariables(Page page, Object controller, char separator, boolean ignoreZScript, boolean ignoreXel) {
        new ConventionWire(controller, separator, ignoreZScript, ignoreXel).wireVariables(page);
    }

    public static final void wireController(Component comp, Object controller) {
        ConventionWires.wireController(comp, controller, '$');
    }

    public static final void wireServiceCommand(final Component comp, final Object controller) {
        Reflections.forMethods(controller.getClass(), Command.class, new Reflections.MethodRunner<Command>(){

            @Override
            public void onMethod(Class<?> clazz, final Method method, Command annotation) {
                if ((method.getModifiers() & 8) != 0) {
                    throw new UiException("Cannot add forward to static method: " + method.getName());
                }
                AuService auService = comp.getAuService();
                final AuService prevAuService = auService instanceof WireAuService ? null : auService;
                comp.setAuService(new WireAuService(){
                    private Converter<Pair<Class<?>, Object>, Object> converter;
                    {
                        String property = Library.getProperty((String)"org.zkoss.zk.ui.jsonServiceParamConverter.class");
                        if (property == null) {
                            this.converter = new Converter<Pair<Class<?>, Object>, Object>(){

                                public Object convert(Pair<Class<?>, Object> pair) {
                                    return pair.getY();
                                }
                            };
                        } else {
                            try {
                                this.converter = (Converter)Classes.newInstanceByThread((String)property);
                            }
                            catch (Exception x) {
                                log.error(x.getMessage(), (Throwable)x);
                            }
                        }
                    }

                    public boolean service(AuRequest request, boolean everError) {
                        String command = request.getCommand();
                        if (command.startsWith("onAuServiceCommand$")) {
                            Map<String, Object> data = request.getData();
                            String cmd = (String)data.get("cmd");
                            List args = (List)data.get("args");
                            LinkedList<String> stringList = new LinkedList<String>(Arrays.asList(method.getAnnotation(Command.class).value()));
                            stringList.add(method.getName());
                            if (stringList.contains(cmd)) {
                                try {
                                    Class<?>[] types = method.getParameterTypes();
                                    if (types.length == 0) {
                                        method.invoke(controller, new Object[0]);
                                    } else {
                                        if (args == null || args.size() != types.length) {
                                            throw new IllegalArgumentException("The number of the parameters from the json value are not the same as the method parameters");
                                        }
                                        Object[] params = new Object[types.length];
                                        int index = 0;
                                        for (Class<?> type : types) {
                                            params[index] = this.converter.convert((Object)new Pair(type, args.get(index)));
                                            ++index;
                                        }
                                        method.invoke(controller, params);
                                    }
                                }
                                catch (Exception e) {
                                    throw UiException.Aide.wrap(e);
                                }
                            }
                            return true;
                        }
                        if (prevAuService != null) {
                            return prevAuService.service(request, everError);
                        }
                        return false;
                    }
                });
            }
        });
    }

    public static final void wireController(Component comp, Object controller, char separator) {
        Object onm = comp.getAttribute("composerName");
        if (onm instanceof String && ((String)onm).length() > 0) {
            comp.setAttribute((String)onm, controller);
        } else {
            comp.setAttribute("_$composer$_", controller);
        }
        comp.setAttribute(separator + "composer", controller);
        String id = comp.getId();
        comp.setAttribute(id + separator + "composer", controller);
        comp.setAttribute(ConventionWires.composerNameByClass(id, controller.getClass(), separator), controller);
    }

    private static String composerNameByClass(String id, Class cls, char separator) {
        String clsname = cls.getName();
        int j = clsname.lastIndexOf(46);
        return id + separator + (j >= 0 ? clsname.substring(j + 1) : clsname);
    }

    public static final void wireImplicit(Component comp, Object controller) {
        new ConventionWire(controller, '$', true, true).wireImplicit(comp);
    }

    public static void addForwards(Component comp, Object controller) {
        ConventionWires.addForwards(comp, controller, '$');
    }

    public static void addForwards(Component comp, Object controller, char separator) {
        Class<?> cls = controller.getClass();
        Method[] mtds = cls.getMethods();
        block0: for (int j = 0; j < mtds.length; ++j) {
            Method md = mtds[j];
            String mdname = md.getName();
            if (mdname.length() < 5 || !Events.isValid(mdname)) continue;
            Component xcomp = comp;
            int k = 0;
            do {
                if ((k = mdname.lastIndexOf(separator)) < 3) continue;
                String srcevt = mdname.substring(0, k);
                if (k + 1 < mdname.length()) {
                    Page page;
                    String srccompid = mdname.substring(k + 1);
                    Object srccomp = xcomp.getAttributeOrFellow(srccompid, true);
                    if (srccomp == null && (page = xcomp.getPage()) != null) {
                        srccomp = page.getXelVariable(null, null, srccompid, true);
                    }
                    if (srccomp == null || !(srccomp instanceof Component)) {
                        if (!log.isDebugEnabled()) continue block0;
                        log.debug("Cannot find the associated component to forward event: " + mdname);
                        continue block0;
                    }
                    ((Component)srccomp).addForward(srcevt, xcomp, mdname);
                    xcomp = (Component)srccomp;
                    mdname = srcevt;
                    continue;
                }
                throw new UiException("Illegal event method name(component id not specified or consecutive '" + separator + "'): " + md.getName());
            } while (k >= 3);
        }
    }

    private static interface WireAuService
    extends AuService {
    }
}

