
(function () {
	var _aftAnims = [], 
		_jqstop = jq.fx.stop;

	jq.fx.stop = function () {
		_jqstop();
		for (var fn; fn = _aftAnims.shift();)
			fn();
	};

	function _addAnique(id, data) {
		var ary = zk._anique[id];
		if (!ary)
			ary = zk._anique[id] = [];
		ary.push(data);
	}
	function _doAnique(id) {
		var ary = zk._anique[id];
		if (ary) {
			var al = ary.length;
			while (al) {
				var data = ary.shift();
				if (jq(data.el).is(':animated')) {
					ary.unshift(data);
					break;
				}
				zk(data.el)[data.anima](data.wgt, data.opts);
				al--;
			}

			if (!al)
				delete zk._anique[id];
		}
	}

	function _saveProp(self, set) {
		var ele = self.jq;
		for(var i = set.length; i--;)
			if(set[i] !== null) ele.data('zk.cache.'+set[i], ele[0].style[set[i]]);
		return self;
	}
	function _restoreProp(self, set) {
		var ele = self.jq;
		for(var i = set.length; i--;)
			if(set[i] !== null) ele.css(set[i], ele.data('zk.cache.'+set[i]));
		return self;
	}
	function _checkAnimated(self, wgt, opts, anima) {
		if (self.jq.is(':animated')) {
			_addAnique(wgt.uuid, {el: self.jq[0], wgt: wgt, opts: opts, anima: anima});
			return true;
		}
		return false;
	}
	function _checkPosition(self, css) {
		var pos = self.jq.css('position');
		if (!pos || pos == 'static')
			css.position = 'relative';
		return self;
	}


zk.copy(zk, {
	
	animating: function () {
		return !!jq.timers.length;
	},
	
	afterAnimate: function (fn, delay) {
		if (zk.animating())
			_aftAnims.push(fn);
		else if (delay < 0) {
			fn();
			return true;
		} else
			setTimeout(fn, delay);
	},
	_anique: {}
});


zk.copy(zjq.prototype, {
	
	getAnimationSpeed : function (defaultValue) {
		var animationSpeed = jq(this.$().$n()).data('animationspeed'),
			jqSpeed = jq.fx.speeds;
		
		if(typeof animationSpeed === 'string') {
			if(jqSpeed[animationSpeed])
				return jqSpeed[animationSpeed];
			else
				animationSpeed = parseInt(animationSpeed);
		}
		
		
		return typeof animationSpeed === 'number' && !isNaN(animationSpeed) ? animationSpeed + 1 : (defaultValue || jqSpeed._default);
	},
	
	slideDown: function (wgt, opts) {
		if (_checkAnimated(this, wgt, opts, 'slideDown'))
			return this;

		var anchor = opts ? opts.anchor || 't': 't',
			prop = ['top', 'left', 'height', 'width', 'overflow', 'position'],
			anima = {},
			css = {overflow: 'hidden'},
			dims = this.dimension();

		opts = opts || {};
		_checkPosition(_saveProp(this, prop), css);

		switch (anchor) {
		case 't':
			css.height = '0';
			anima.height = jq.px0(dims.height);
			break;
		case 'b':
			css.height = '0';
			css.top = jq.px(dims.top + dims.height);
			anima.height = jq.px0(dims.height);
			anima.top = jq.px(dims.top);
			break;
		case 'l':
			css.width = '0';
			anima.width = jq.px0(dims.width);
			break;
		case 'r':
			css.width = '0';
			css.left = jq.px(dims.left + dims.width);
			anima.width = jq.px0(dims.width);
			anima.left = jq.px(dims.left);
			break;
		}

		return this.defaultAnimaOpts(wgt, opts, prop, true)
			.jq.css(css).show().animate(anima, {
			queue: false, easing: opts.easing, duration: this.getAnimationSpeed(opts.duration || 250),
			complete: opts.afterAnima
		});
	},
	
	slideUp: function (wgt, opts) {
		if (_checkAnimated(this, wgt, opts, 'slideUp'))
			return this;
		
		var anchor = opts ? opts.anchor || 't': 't',
			prop = ['top', 'left', 'height', 'width', 'overflow', 'position'],
			anima = {},
			css = {overflow: 'hidden'},
			dims = this.dimension();

		opts = opts || {};
		_checkPosition(_saveProp(this, prop), css);

		switch (anchor) {
		case 't':
			anima.height = 'hide';
			break;
		case 'b':
			css.height = jq.px0(dims.height);
			anima.height = 'hide';
			anima.top = jq.px(dims.top + dims.height);
			break;
		case 'l':
			anima.width = 'hide';
			break;
		case 'r':
			css.width = jq.px0(dims.width);
			anima.width = 'hide';
			anima.left = jq.px(dims.left + dims.width);
			break;
		}

		return this.defaultAnimaOpts(wgt, opts, prop)
			.jq.css(css).animate(anima, {
			queue: false, easing: opts.easing, duration: this.getAnimationSpeed(opts.duration || 250),
			complete: opts.afterAnima
		});
	},
	
	slideOut: function (wgt, opts) {
		if (_checkAnimated(this, wgt, opts, 'slideOut'))
			return this;
		
		var anchor = opts ? opts.anchor || 't': 't',
			prop = ['top', 'left', 'position'],
			anima = {},
			css = {},
			dims = this.dimension();

		opts = opts || {};
		_checkPosition(_saveProp(this, prop), css);

		switch (anchor) {
		case 't':
			anima.top = jq.px(dims.top - dims.height);
			break;
		case 'b':
			anima.top = jq.px(dims.top + dims.height);
			break;
		case 'l':
			anima.left = jq.px(dims.left - dims.width);
			break;
		case 'r':
			anima.left = jq.px(dims.left + dims.width);
			break;
		}

		return this.defaultAnimaOpts(wgt, opts, prop)
			.jq.css(css).animate(anima, {
			queue: false, easing: opts.easing, duration: this.getAnimationSpeed(opts.duration || 350),
			complete: opts.afterAnima
		});
	},
	
	slideIn: function (wgt, opts) {
		if (_checkAnimated(this, wgt, opts, 'slideIn'))
			return this;
		
		var anchor = opts ? opts.anchor || 't': 't',
			prop = ['top', 'left', 'position'],
			anima = {},
			css = {},
			dims = this.dimension();

		opts = opts || {};
		_checkPosition(_saveProp(this, prop), css);

		switch (anchor) {
		case 't':
			css.top = jq.px(dims.top - dims.height);
			anima.top = jq.px(dims.top);
			break;
		case 'b':
			css.top = jq.px(dims.top + dims.height);
			anima.top = jq.px(dims.top);
			break;
		case 'l':
			css.left = jq.px(dims.left - dims.width);
			anima.left = jq.px(dims.left);
			break;
		case 'r':
			css.left = jq.px(dims.left + dims.width);
			anima.left = jq.px(dims.left);
			break;
		}

		return this.defaultAnimaOpts(wgt, opts, prop, true)
			.jq.css(css).show().animate(anima, {
			queue: false, easing: opts.easing, duration: this.getAnimationSpeed(opts.duration || 350),
			complete: opts.afterAnima
		});
	},
	_updateProp: function(prop) { 
		_saveProp(this, prop);
	},
	
	defaultAnimaOpts: function (wgt, opts, prop, visible) {
		var self = this;
		jq.timers.push(function() {
			if (!visible)
				zWatch.fireDown('onHide', wgt);
			if (opts.beforeAnima)
				opts.beforeAnima.call(wgt, self);
		});

		var aftfn = opts.afterAnima;
		opts.afterAnima = function () {
			if (prop) _restoreProp(self, prop);
			if (visible) {
				
				if (zk.ie == 8 || zk.ie == 10) zk(self.jq[0]).redoCSS(); 
				zUtl.fireShown(wgt);
			} else {
				self.jq.hide();
			}
			if (aftfn) aftfn.call(wgt, self.jq.context);
			wgt.afterAnima_(visible);
			setTimeout(function () {
				_doAnique(wgt.uuid);
			});
		};
		return this;
	}
});
})();