/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationMessagesImpl
implements ValidationMessages,
Collection<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Message> _messages = new LinkedList<Message>();
    private final Map<Component, List<Message>> _compMsgsMap = new LinkedHashMap<Component, List<Message>>();
    private final Map<String, List<Message>> _keyMsgsMap = new LinkedHashMap<String, List<Message>>();

    @Override
    public void clearMessages(Component comp) {
        List<Message> remove = this._compMsgsMap.get(comp);
        if (remove == null || remove.size() == 0) {
            return;
        }
        this._messages.removeAll(remove);
        for (List<Message> keyMsgs : this._keyMsgsMap.values()) {
            keyMsgs.removeAll(remove);
        }
        this._compMsgsMap.remove(comp);
    }

    @Override
    public void clearMessages(Component comp, String attr) {
        List<Message> compMsgs = this._compMsgsMap.get(comp);
        if (compMsgs == null || compMsgs.size() == 0) {
            return;
        }
        ArrayList<Message> remove = new ArrayList<Message>();
        for (Message message : compMsgs) {
            if (!Objects.equals((Object)message.attr, (Object)attr)) continue;
            remove.add(message);
        }
        if (remove.size() == 0) {
            return;
        }
        this._messages.removeAll(remove);
        for (List list : this._keyMsgsMap.values()) {
            list.removeAll(remove);
        }
        compMsgs.removeAll(remove);
    }

    @Override
    public void clearKeyMessages(Component comp, String key) {
        List<Message> compMsgs = this._compMsgsMap.get(comp);
        if (compMsgs == null || compMsgs.size() == 0) {
            return;
        }
        ArrayList<Message> remove = new ArrayList<Message>();
        for (Message message : compMsgs) {
            if (!Objects.equals((Object)message.key, (Object)key)) continue;
            remove.add(message);
        }
        if (remove.size() == 0) {
            return;
        }
        this._messages.removeAll(remove);
        for (List list : this._keyMsgsMap.values()) {
            list.removeAll(remove);
        }
        compMsgs.removeAll(remove);
    }

    @Override
    public void clearKeyMessages(String key) {
        List<Message> keyMsgs = this._keyMsgsMap.get(key);
        if (keyMsgs == null || keyMsgs.size() == 0) {
            return;
        }
        ArrayList<Message> remove = new ArrayList<Message>();
        for (Message message : keyMsgs) {
            if (!Objects.equals((Object)message.key, (Object)key)) continue;
            remove.add(message);
        }
        if (remove.size() == 0) {
            return;
        }
        this._messages.removeAll(remove);
        for (List list : this._compMsgsMap.values()) {
            list.removeAll(remove);
        }
        keyMsgs.removeAll(remove);
    }

    @Override
    public void clearAllMessages() {
        this._messages.clear();
        this._compMsgsMap.clear();
        this._keyMsgsMap.clear();
    }

    @Override
    public String[] getMessages(Component comp, String attr) {
        List<Message> compMsgs = this._compMsgsMap.get(comp);
        if (compMsgs == null || compMsgs.size() == 0) {
            return null;
        }
        ArrayList<String> msgs = new ArrayList<String>();
        for (Message msg : compMsgs) {
            if (!Objects.equals((Object)msg.attr, (Object)attr)) continue;
            msgs.add(msg.msg);
        }
        return msgs.size() == 0 ? null : msgs.toArray(new String[msgs.size()]);
    }

    @Override
    public String[] getMessages(Component comp) {
        List<Message> compMsgs = this._compMsgsMap.get(comp);
        if (compMsgs == null || compMsgs.size() == 0) {
            return null;
        }
        ArrayList<String> msgs = new ArrayList<String>();
        for (Message msg : compMsgs) {
            msgs.add(msg.msg);
        }
        return msgs.toArray(new String[msgs.size()]);
    }

    @Override
    public String[] getMessages() {
        if (this._messages.size() == 0) {
            return null;
        }
        ArrayList<String> msgs = new ArrayList<String>(this._messages.size());
        for (Message mm : this._messages) {
            msgs.add(mm.msg);
        }
        return msgs.size() == 0 ? null : msgs.toArray(new String[msgs.size()]);
    }

    @Override
    public String[] getKeyMessages(Component comp, String key) {
        List<Message> compMsgs = this._compMsgsMap.get(comp);
        if (compMsgs == null || compMsgs.size() == 0) {
            return null;
        }
        ArrayList<String> msgs = new ArrayList<String>();
        for (Message msg : compMsgs) {
            if (!Objects.equals((Object)msg.key, (Object)key)) continue;
            msgs.add(msg.msg);
        }
        return msgs.size() == 0 ? null : msgs.toArray(new String[msgs.size()]);
    }

    @Override
    public String[] getKeyMessages(String key) {
        List<Message> keyMsgs = this._keyMsgsMap.get(key);
        if (keyMsgs == null || keyMsgs.size() == 0) {
            return null;
        }
        ArrayList<String> msgs = new ArrayList<String>();
        for (Message msg : keyMsgs) {
            msgs.add(msg.msg);
        }
        return msgs.toArray(new String[msgs.size()]);
    }

    @Override
    public void setMessages(Component comp, String attr, String key, String[] messages) {
        this.setMessages(comp, attr, key, messages, null);
    }

    @Override
    public void addMessages(Component comp, String attr, String key, String[] messages) {
        this.addMessages(comp, attr, key, messages, null);
    }

    @Override
    public void setMessages(Component comp, String attr, String key, String[] messages, Object value) {
        this.clearMessages(comp, attr);
        this.addMessages(comp, attr, key, messages, value);
    }

    @Override
    public void addMessages(Component comp, String attr, String key, String[] messages, Object value) {
        List<Message> compMsgs = this._compMsgsMap.get(comp);
        if (compMsgs == null) {
            compMsgs = new ArrayList<Message>();
            this._compMsgsMap.put(comp, compMsgs);
        }
        for (String s : messages) {
            Message msg = new Message(comp, attr, key, s, value);
            this._messages.add(msg);
            compMsgs.add(msg);
            if (key == null) continue;
            List<Message> keyMsgs = this._keyMsgsMap.get(key);
            if (keyMsgs == null) {
                keyMsgs = new ArrayList<Message>();
                this._keyMsgsMap.put(key, keyMsgs);
            }
            keyMsgs.add(msg);
        }
    }

    private List<Message> getMessage(Component comp, String key) {
        List<Message> compMsgs = this._compMsgsMap.get(comp);
        if (compMsgs == null || compMsgs.size() == 0) {
            return null;
        }
        ArrayList<Message> msgs = new ArrayList<Message>();
        for (Message msg : compMsgs) {
            if (!Objects.equals((Object)msg.key, (Object)key)) continue;
            msgs.add(msg);
        }
        return msgs;
    }

    @Override
    public Object getFieldValue(String key) {
        List<Message> keyMsgs = this._keyMsgsMap.get(key);
        if (keyMsgs == null || keyMsgs.size() == 0) {
            return null;
        }
        return keyMsgs.get((int)0).value;
    }

    @Override
    public Object getFieldValue(Component comp, String key) {
        List<Message> messages = this.getMessage(comp, key);
        return messages.isEmpty() ? null : messages.get((int)0).value;
    }

    @Override
    public Object[] getFieldValues(String key) {
        List<Message> keyMsgs = this._keyMsgsMap.get(key);
        if (keyMsgs == null || keyMsgs.size() == 0) {
            return null;
        }
        ArrayList<Object> msgs = new ArrayList<Object>();
        for (Message msg : keyMsgs) {
            msgs.add(msg.value);
        }
        return msgs.toArray(new Object[0]);
    }

    @Override
    public Object[] getFieldValues(Component comp, String key) {
        List<Message> messages = this.getMessage(comp, key);
        ArrayList<Object> msgs = new ArrayList<Object>();
        for (Message msg : messages) {
            msgs.add(msg.value);
        }
        return msgs.toArray(new Object[0]);
    }

    @Override
    public Component getAssociate(String key) {
        List<Message> keyMsgs = this._keyMsgsMap.get(key);
        if (keyMsgs == null || keyMsgs.size() == 0) {
            return null;
        }
        return keyMsgs.get((int)0).comp;
    }

    @Override
    public Component[] getAssociates(String key) {
        List<Message> keyMsgs = this._keyMsgsMap.get(key);
        if (keyMsgs == null || keyMsgs.size() == 0) {
            return null;
        }
        ArrayList<Component> msgs = new ArrayList<Component>();
        for (Message msg : keyMsgs) {
            msgs.add(msg.comp);
        }
        return msgs.toArray(new Component[0]);
    }

    @Override
    public int size() {
        return this._messages.size();
    }

    @Override
    public boolean isEmpty() {
        return this._messages.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this._messages.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return new ArrayList<Message>(this._messages).iterator();
    }

    @Override
    public Object[] toArray() {
        return this._messages.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._messages.toArray(a);
    }

    @Override
    public boolean add(Object e) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._messages.contains(c);
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("read only");
    }

    static class Message
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Component comp;
        final String attr;
        final String key;
        final String msg;
        final Object value;

        public Message(Component comp, String attr, String key, String msg, Object value) {
            this.comp = comp;
            this.attr = attr;
            this.key = key;
            this.msg = msg;
            this.value = value;
        }
    }
}

