/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.proxy;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.annotation.ImmutableElements;
import org.zkoss.bind.proxy.AbstractCollectionProxy;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.FormProxyObjectListener;
import org.zkoss.bind.proxy.ProxyHelper;
import org.zkoss.bind.sys.FormBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapProxy<K, V>
implements Map<K, V>,
Proxy,
FormProxyObject,
Serializable,
FormProxyObjectListener {
    private Map<K, V> _cache;
    private boolean _dirty;
    private Map<K, V> _origin;
    private FormProxyObjectListener _listener;
    private List<Annotation> _callerAnnots;
    private static final long serialVersionUID = 20141226161502L;
    private boolean isImmutableElements;

    public MapProxy(Map<K, V> origin, Annotation[] callerAnnots) {
        this._origin = origin;
        this._cache = new LinkedHashMap(origin.size());
        if (callerAnnots != null) {
            for (Annotation annot : callerAnnots) {
                if (!annot.annotationType().isAssignableFrom(ImmutableElements.class)) continue;
                this.isImmutableElements = true;
                break;
            }
        }
        this.resetFromOrigin();
    }

    @Override
    public Object getOriginObject() {
        return this._origin;
    }

    protected Object replaceOrigin(Object origin) {
        Map<K, V> old = this._origin;
        this._origin = (Map)origin;
        return old;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._cache.entrySet();
    }

    @Override
    public void resetFromOrigin() {
        this._cache.clear();
        this.setDirty(false);
        for (Map.Entry me : ((Map)this.getOriginObject()).entrySet()) {
            this._cache.put(me.getKey(), this.createProxyObject(me.getValue()));
        }
    }

    @Override
    public void submitToOrigin(BindContext ctx) {
        this._origin.clear();
        for (Map.Entry<K, V> me : this._cache.entrySet()) {
            V value = me.getValue();
            if (value instanceof FormProxyObject) {
                FormProxyObject proxyValue = (FormProxyObject)value;
                proxyValue.submitToOrigin(ctx);
                this._origin.put(me.getKey(), proxyValue.getOriginObject());
                continue;
            }
            this._origin.put(me.getKey(), me.getValue());
        }
        this.setDirty(false);
    }

    @Override
    public void addFormProxyObjectListener(FormProxyObjectListener l) {
        if (this._listener == null) {
            this._listener = l;
        }
    }

    @Override
    public void onDirtyChange() {
        if (this._listener != null) {
            this._listener.onDirtyChange();
        }
    }

    @Override
    public void onDataChange(Object o) {
        if (this._listener != null) {
            this._listener.onDataChange(o);
        }
    }

    protected void setDirty(boolean d) {
        if (this._dirty != d) {
            this._dirty = d;
            this.onDirtyChange();
        }
        if (d) {
            this.onDataChange(this);
        }
    }

    @Override
    public boolean isFormDirty() {
        if (this._dirty) {
            return true;
        }
        for (Map.Entry<K, V> me : this._cache.entrySet()) {
            if (!(me.getValue() instanceof FormProxyObject) || !((FormProxyObject)me.getValue()).isFormDirty()) continue;
            return true;
        }
        return false;
    }

    public void setHandler(MethodHandler mi) {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public int size() {
        return this._cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this._cache.containsKey(this.createProxyObject(key));
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<V> it = this._cache.values().iterator();
        Object proxyValue = this.createProxyObject(value);
        while (it.hasNext()) {
            if (!AbstractCollectionProxy.testEquals(it.next(), proxyValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this._cache.get(this.createProxyObject(key));
    }

    @Override
    public V put(K key, V value) {
        this.setDirty(true);
        return this._cache.put(this.createProxyObject(key), this.createProxyObject(value));
    }

    @Override
    public V remove(Object key) {
        this.setDirty(true);
        return this._cache.remove(this.createProxyObject(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.setDirty(true);
        this._cache.clear();
    }

    @Override
    public Set<K> keySet() {
        return this._cache.keySet();
    }

    @Override
    public Collection<V> values() {
        return this._cache.values();
    }

    @Override
    public void setFormOwner(Object owner, FormBinding binding) {
        throw new IllegalAccessError("Not supported");
    }

    private <T> T createProxyObject(T t) {
        T p;
        T t2 = p = this.isImmutableElements ? t : ProxyHelper.createProxyIfAny(t);
        if (p instanceof FormProxyObject) {
            FormProxyObject fpo = (FormProxyObject)p;
            fpo.addFormProxyObjectListener(this);
        }
        return p;
    }
}

