/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.xel.zel;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Property;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.Immutable;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.bind.annotation.NotifyChangeDisabled;
import org.zkoss.bind.annotation.SmartNotifyChange;
import org.zkoss.bind.impl.AllocUtil;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.LoadChildrenBindingImpl;
import org.zkoss.bind.impl.LoadFormBindingImpl;
import org.zkoss.bind.impl.LoadPropertyBindingImpl;
import org.zkoss.bind.impl.PropertyImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.xel.zel.BindELResolver;
import org.zkoss.lang.Primitives;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.xel.ExpressionX;
import org.zkoss.xel.ValueReference;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.zel.XelELContext;
import org.zkoss.zel.ELResolver;
import org.zkoss.zel.impl.parser.AstBracketSuffix;
import org.zkoss.zel.impl.parser.AstDotSuffix;
import org.zkoss.zel.impl.parser.AstMethodParameters;
import org.zkoss.zel.impl.parser.AstValue;
import org.zkoss.zel.impl.parser.Node;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindELContext
extends XelELContext {
    private static final String TMPBASE = "$TMPBASE$";

    public BindELContext(XelContext xelc) {
        super(xelc);
    }

    protected ELResolver newELResolver(XelContext xelc) {
        return new BindELResolver(xelc);
    }

    public Binding getBinding() {
        return (Binding)this.getXelContext().getAttribute("$BINDING$");
    }

    public BindContext getBindContext() {
        return (BindContext)this.getXelContext().getAttribute("$BINDCTX$");
    }

    public boolean ignoreTracker() {
        return this.getBinding() == null || Boolean.TRUE.equals(this.getXelContext().getAttribute("$IGNORE_TRACKER$"));
    }

    public Object getAttribute(String name) {
        return this.getXelContext().getAttribute(name);
    }

    public Object setAttribute(String name, Object value) {
        return this.getXelContext().setAttribute(name, value);
    }

    public Object removeAttribute(String name) {
        return this.getXelContext().removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Property prepareProperty(Object base, String prop, Object value, BindContext ctx) {
        if (ctx != null && prop.indexOf(91) >= 0) {
            Binder binder = ctx.getBinder();
            Component comp = ctx.getComponent();
            Object old = null;
            try {
                old = comp.setAttribute(TMPBASE, base);
                BindEvaluatorX eval = binder.getEvaluatorX();
                BindContext bctx = BindContextUtil.newBindContext(binder, null, false, null, comp, null);
                String expression = TMPBASE + (prop.startsWith("[") ? prop : "." + prop);
                ExpressionX exprX = eval.parseExpressionX(bctx, expression, Object.class);
                String propTrim = prop.trim();
                ValueReference valref = eval.getValueReference(bctx, comp, exprX);
                if (valref == null) {
                    throw new UiException("value reference not found by expression [" + exprX.getExpressionString() + "]");
                }
                base = valref.getBase();
                prop = propTrim.endsWith("]") ? "[" + valref.getProperty() + "]" : "" + valref.getProperty();
            }
            finally {
                comp.setAttribute(TMPBASE, old);
            }
        }
        return new PropertyImpl(base, prop, value);
    }

    public static Set<Property> getNotifys(Method m, Object base, String prop, Object value, BindContext ctx) {
        Property propx;
        String[] notifies;
        LinkedHashSet<Property> notifys = new LinkedHashSet<Property>();
        if (m == null) {
            return notifys;
        }
        NotifyChange annt = m.getAnnotation(NotifyChange.class);
        NotifyChangeDisabled anntdis = m.getAnnotation(NotifyChangeDisabled.class);
        SmartNotifyChange sannt = m.getAnnotation(SmartNotifyChange.class);
        if (annt != null && anntdis != null) {
            throw new UiException("don't use " + NotifyChange.class + " with " + NotifyChangeDisabled.class + ", choose only one");
        }
        if (sannt != null && anntdis != null) {
            throw new UiException("don't use " + SmartNotifyChange.class + " with " + NotifyChangeDisabled.class + ", choose only one");
        }
        if (annt != null) {
            notifies = annt.value();
            if (notifies.length > 0) {
                for (String notify : notifies) {
                    propx = BindELContext.prepareProperty(base, notify, value, ctx);
                    notifys.add(propx);
                }
            } else if (prop != null) {
                notifys.add(new PropertyImpl(base, prop, value));
            }
        } else if (anntdis == null && prop != null) {
            notifys.add(new PropertyImpl(base, prop, value));
        }
        if (sannt != null) {
            notifies = sannt.value();
            if (notifies.length > 0) {
                for (String notify : notifies) {
                    propx = null;
                    try {
                        propx = !"*".equals(notify) && !".".equals(notify) ? BindELContext.prepareProperty(base, notify, Fields.get((Object)base, (String)notify), ctx) : BindELContext.prepareProperty(base, notify, value, ctx);
                    }
                    catch (NoSuchMethodException e) {
                        propx = BindELContext.prepareProperty(base, notify, value, ctx);
                    }
                    if (propx == null) continue;
                    notifys.add(propx);
                }
            } else if (prop != null) {
                notifys.add(new PropertyImpl(base, prop, value));
            }
        }
        return notifys;
    }

    public static void addNotifys(Object base, String prop, Object value, BindContext ctx) {
        HashSet<Property> properties = new HashSet<Property>(3);
        properties.add(new PropertyImpl(base, prop, value));
        BindELContext.addNotifys(properties, ctx);
    }

    public static void addNotifys(Method m, Object base, String prop, Object value, BindContext ctx) {
        Set<Property> props = BindELContext.getNotifys(m, base, prop, value, ctx);
        BindELContext.addNotifys(props, ctx);
    }

    public static void addNotifys(Set<Property> props, BindContext ctx) {
        if (ctx == null) {
            return;
        }
        Set<Property> notifys = BindELContext.getNotifys(ctx);
        if (notifys == null) {
            notifys = new LinkedHashSet<Property>();
            ctx.setAttribute("$NOTIFYS$", notifys);
        }
        notifys.addAll(props);
    }

    public static Set<Property> getNotifys(BindContext ctx) {
        return (Set)ctx.getAttribute("$NOTIFYS$");
    }

    private static Set<Property> getValidates(BindContext ctx) {
        return (Set)ctx.getAttribute("$VALIDATES$");
    }

    private static void addValidates(Set<Property> props, BindContext ctx) {
        if (ctx == null) {
            return;
        }
        Set<Property> validates = BindELContext.getValidates(ctx);
        if (validates == null) {
            validates = new LinkedHashSet<Property>();
            ctx.setAttribute("$VALIDATES$", validates);
        }
        validates.addAll(props);
    }

    public static String toNodeString(Node next, StringBuilder path) {
        if (next instanceof AstBracketSuffix) {
            String bracketString = BindELContext.toNodeString(next.jjtGetChild(0), new StringBuilder());
            path.append("[").append(bracketString).append("]");
        } else if (next instanceof AstValue) {
            int len = next.jjtGetNumChildren();
            for (int j = 0; j < len; ++j) {
                Node kid = next.jjtGetChild(j);
                BindELContext.toNodeString(kid, path);
            }
        } else if (next instanceof AstDotSuffix) {
            path.append(".").append(next.getImage());
        } else if (next instanceof AstMethodParameters) {
            StringBuilder subPath = new StringBuilder();
            int len = next.jjtGetNumChildren();
            for (int j = 0; j < len; ++j) {
                if (j > 0) {
                    subPath.append(',');
                }
                Node kid = next.jjtGetChild(j);
                BindELContext.toNodeString(kid, subPath);
            }
            path.append("(").append((CharSequence)subPath).append(")");
        } else {
            path.append(next.getImage());
        }
        return path.toString();
    }

    public static String toNodeString(Node next, StringBuffer path) {
        if (next instanceof AstBracketSuffix) {
            String bracketString = BindELContext.toNodeString(next.jjtGetChild(0), new StringBuffer());
            path.append("[").append(bracketString).append("]");
        } else if (next instanceof AstValue) {
            int len = next.jjtGetNumChildren();
            for (int j = 0; j < len; ++j) {
                Node kid = next.jjtGetChild(j);
                BindELContext.toNodeString(kid, path);
            }
        } else if (next instanceof AstDotSuffix) {
            path.append(".").append(next.getImage());
        } else if (next instanceof AstMethodParameters) {
            StringBuilder subPath = new StringBuilder();
            int len = next.jjtGetNumChildren();
            for (int j = 0; j < len; ++j) {
                if (j > 0) {
                    subPath.append(',');
                }
                Node kid = next.jjtGetChild(j);
                BindELContext.toNodeString(kid, subPath);
            }
            path.append("(").append((CharSequence)subPath).append(")");
        } else {
            path.append(next.getImage());
        }
        return path.toString();
    }

    public static boolean isBracket(String script) {
        return script.startsWith("[") && script.endsWith("]");
    }

    public static String appendFields(String prefix, String field) {
        return prefix + (BindELContext.isBracket(field) ? "" : Character.valueOf('.')) + field;
    }

    public static void addDependsOnTrackings(Method m, String basepath, List<String> srcpath, Binding binding, BindContext ctx) {
        String[] props;
        DependsOn annt = m.getAnnotation(DependsOn.class);
        if (annt != null && (props = annt.value()).length > 0) {
            if (binding instanceof LoadPropertyBindingImpl) {
                ((LoadPropertyBindingImpl)binding).addDependsOnTrackings(srcpath, basepath, props);
            } else if (binding instanceof LoadFormBindingImpl) {
                ((LoadFormBindingImpl)binding).addDependsOnTrackings(srcpath, basepath, props);
            } else if (binding instanceof LoadChildrenBindingImpl) {
                ((LoadChildrenBindingImpl)binding).addDependsOnTrackings(srcpath, basepath, props);
            }
        }
    }

    public static String pathToString(List<String> path) {
        StringBuffer sb = new StringBuffer();
        for (String prop : path) {
            sb.append(prop);
        }
        return sb.toString();
    }

    public static void addDependsOnTracking(Binding srcBinding, List<String> srcPath, String dependsOnBasepath, String dependsOnProp) {
        String dependsOnPath = BindELContext.appendFields(dependsOnBasepath, dependsOnProp);
        Component srcComp = srcBinding.getComponent();
        BindELContext.addDependsOnTracking(srcBinding, srcPath, srcComp, dependsOnPath, srcComp);
    }

    public static void addDependsOnTracking(Binding srcBinding, List<String> srcPath, Component srcComp, String dependsOnPath, Component dependsOnComp) {
        Binder binder = srcBinding.getBinder();
        BindEvaluatorX eval = binder.getEvaluatorX();
        BindContext ctxparse = BindContextUtil.newBindContext(binder, srcBinding, false, null, srcComp, null);
        ctxparse.setAttribute("$SRCPATH$", srcPath);
        ctxparse.setAttribute("$DEPENDS_ON_COMP", dependsOnComp);
        ExpressionX expr = eval.parseExpressionX(ctxparse, dependsOnPath, Object.class);
        BindContext ctx = BindContextUtil.newBindContext(binder, srcBinding, false, null, srcComp, null);
        eval.getValue(ctx, srcComp, expr);
    }

    public static boolean isImmutable(Object value) {
        if (value == null) {
            return true;
        }
        Class<?> cls = value.getClass();
        return cls.isPrimitive() || Primitives.toPrimitive(cls) != null || value instanceof String || BindELContext.isAnnotatedImmutable(cls) || cls.isEnum();
    }

    public static String getModelName(Component comp) {
        return (String)AllocUtil.inst.processScript("$MODEL$" + comp.getUuid());
    }

    public static void addModel(Component comp, Object model) {
        String name = BindELContext.getModelName(comp);
        comp.setAttribute(name, model);
    }

    public static Object removeModel(Component comp) {
        String name = BindELContext.getModelName(comp);
        return comp.removeAttribute(name);
    }

    private static boolean isAnnotatedImmutable(Class<? extends Object> cls) {
        return cls.getAnnotation(Immutable.class) != null;
    }

    public void putContext(Class key, Object contextObject) {
        BindContext bindCtx;
        if (contextObject instanceof Method && key == Method.class && (bindCtx = (BindContext)this.getXelContext().getAttribute("$BINDCTX$")) != null) {
            bindCtx.setAttribute(String.valueOf(key), ((Method)contextObject).getDeclaredAnnotations());
        }
        super.putContext(key, contextObject);
    }
}

