
(function () {
	var _WidgetX = {};

zk.override(zk.Widget.prototype, _WidgetX, {
	$binder: function () {
		var w = this;
		for (; w ; w = w.parent) {
			if (w['$ZKBINDER$'])
				break;
		}
		if (w) {
			if (!w._$binder)
				w._$binder = new zkbind.Binder(w, this); 
			return w._$binder;
		}
		return null;
	},
	$afterCommand: function (command, args) {
		var binder = this.$binder();
		if (binder)
			binder.$doAfterCommand(command, args);
	},
	unbind_: function () {
		if (this._$binder) {
			this._$binder.destroy();
			this._$binder = null;
		}
		_WidgetX.unbind_.apply(this, arguments);
	}
});

zkbind.$ = function (n, opts) {
	var widget = zk.Widget.$(n, opts);
	if (widget)
		return widget.$binder();
	zk.error('Not found ZK Binder with [' + n + ']');
};
	function _fixCommandName(prefix, opts, prop) {
		if (opts[prop]) {
			var ignores = {};
			for (var key in opts[prop]) {
				ignores[prefix+key] = opts[prop][key];
			}
			opts[prop] = ignores;
		}
	}

zkbind.Binder = zk.$extends(zk.Object, {
	$init: function (widget, currentTarget) {
		this.$supers('$init', arguments);
		this.$view = widget;
		this.$currentTarget = currentTarget;
		this._aftercmd = {};
	},
	
	after: function (cmd, fn) {
		if (!fn && jq.isFunction(cmd)) {
			fn = cmd;
			cmd = this._lastcmd;
		}
			
		var ac = this._aftercmd[cmd];
		if (!ac) this._aftercmd[cmd] = [fn];
		else
			ac.push(fn);
		return this;
	},
	
	unAfter: function (cmd, fn) {
		var ac = this._aftercmd[cmd];
		for (var j = ac ? ac.length: 0; j--;) {
			if (ac[j] == fn)
				ac.splice(j, 1);
		}
		return this;
	},
	
	destroy: function () {
		this._aftercmd = null;
		this.$view = null;
		this.$currentTarget = null;
	},
	
	command: function (cmd, args, opts, timeout) {
		var wgt = this.$view;
		if (opts) {
			if (opts.duplicateIgnore)
				_fixCommandName('onBindCommand$', opts, 'duplicateIgnore');
			if (opts.repeatIgnore)
				_fixCommandName('onBindCommand$', opts, 'repeatIgnore');
		}
		zAu.send(new zk.Event(wgt, 'onBindCommand$' + cmd, {cmd: cmd, args: args}, zk.copy({toServer:true}, opts)), timeout != undefined ? timeout : 38);
		this._lastcmd = cmd;
		return this;
	},
	
	globalCommand: function (cmd, args, timeout) {
		var wgt = this.$view;
		if (opts) {
			if (opts.duplicateIgnore)
				_fixCommandName('onBindGlobalCommand$', opts, 'duplicateIgnore');
			if (opts.repeatIgnore)
				_fixCommandName('onBindGlobalCommand$', opts, 'repeatIgnore');
		}
		zAu.send(new zk.Event(wgt, "onBindGlobalCommand$" + cmd, {cmd: cmd, args: args}, zk.copy({toServer:true}, opts)), timeout != undefined ? timeout : 38);
		this._lastcmd = cmd;
		return this;
	},
	$doAfterCommand: function (cmd, args) {
		var ac = this._aftercmd[cmd];
		for (var i = 0, j = ac ? ac.length: 0; i < j; i++)
			ac[i].apply(this, [args]);
	}
}, {
	
	postCommand: function (dom, command, args, timeout) {
		var w = zk.Widget.$(dom);
		if (w) {
			var binder = w.$binder();
			if (binder) {
				binder.command(command, args, timeout);
			}
		}
	},
	
	postGlobalCommand: function (dom, command, args, timeout) {
		var w = zk.Widget.$(dom);
		if (w) {
			var binder = w.$binder();
			if (binder) {
				binder.globalCommand(command, args, timeout);
			}
		}
	}
});
})();