

zk.BigDecimal = zk.$extends(zk.Object, {
	_precision: 0,
	$define: {
		
		
		precision: null
	},
	
	$init: function (value) {
		value = value ? '' + value : '0';
		var jdot = -1;
		for (var j = 0, len = value.length; j < len; ++j) {
			var cc = value.charAt(j);
			if (((cc < '0' || cc > '9') && cc != '-' && cc != '+')
				|| (j && (cc == '-' || cc == '+')))
				if (jdot < 0 && cc == '.') {
					jdot = j;
				} else {
					value = value.substring(0, j);
					break;
				}
		}
		if (jdot >= 0) {
			value = value.substring(0, jdot) + value.substring(jdot + 1);
			this._precision = value.length - jdot;
			this._dot = true;
		}
		this._value = value;
	},
	$toNumber: function () {
		var v = parseFloat(this._value), p;
		if (p = this._precision)
			v /= Math.pow(10, p);
		return v;
	},
	
	$toString: function () { 
		if (this._value.length == 0) return '';
		var j = this._value.length - this._precision,
			valFixed = '';
		if (j < 0)
			for (var len = -j; len-- > 0;)
				valFixed += '0';
		return this._value.substring(0, j) + (this._dot || this._precision ? '.' + valFixed + this._value.substring(j) : '');
	},
	
	$toLocaleString: function () { 
		if (this._value.length == 0) return '';
		var j = this._value.length - this._precision;
		if (j <= 0) {
			var valFixed = '';
			for (var len = -j; len-- > 0;)
				valFixed += '0';
			return '0' + (this._precision ? zk.DECIMAL + valFixed + this._value : '');
		}
		return this._value.substring(0, j) + (this._precision ? zk.DECIMAL + this._value.substring(j) : '');
	}
});


zk.Long = zk.$extends(zk.Object, {
	
	$init: function (value) {
	
	
	
		value = value ? '' + value : '0';
		var len = value.length;
		for (var j = 0; j < len; ++j) {
			var cc = value.charAt(j);
			if ((cc < '0' || cc > '9') && (j > 0 || (cc != '-' && cc != '+'))) {
				value = value.substring(0, j);
				break;
			}
		}
		if (len == 1) {
			var c = value.charAt(0);
			if (cc < '0' || cc > '9')
				value = 'NaN';
		}
		this._value = value;
	},
	
	scale: function (digits) {
		var val = this._value || '',
			n = val.length;
		if (n)
			if (digits > 0) {
				if (n > 1 || val.charAt(0) != '0')
					while (digits-- > 0) 
						val += '0';
			} else if (digits < 0)
				this._value = (n += digits) <= 0 ? '0' : val.substring(0, n);
	},
	$toNumber: function () {
		return parseFloat(this._value);
	},
	
	$toString: zkf = function () { 
		return this._value;
	},
	
	$toLocaleString: zkf
});
