/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.util.media.ContentTypes;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.servlet.dsp.DspContext;
import org.zkoss.web.servlet.dsp.DspException;
import org.zkoss.web.servlet.dsp.Interpretation;
import org.zkoss.web.servlet.dsp.ServletDspContext;
import org.zkoss.web.servlet.dsp.impl.Parser;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;

public class Interpreter {
    public static final String getContentType(String path) {
        if (path == null) {
            return null;
        }
        int j = path.lastIndexOf(46);
        if (j < 0 || path.indexOf(47, j + 1) >= 0) {
            return null;
        }
        int k = path.indexOf(59, j + 1);
        String ext = (k >= 0 ? path.substring(j + 1, k) : path.substring(j + 1)).toLowerCase(Locale.ENGLISH);
        if ("dsp".equals(ext)) {
            if (j == 0) {
                return null;
            }
            k = path.lastIndexOf(46, j - 1);
            if (k < 0) {
                return null;
            }
            ext = path.substring(k + 1, j);
            if (ext.indexOf(47) >= 0) {
                return null;
            }
        }
        return ContentTypes.getContentType((String)ext);
    }

    public final Interpretation parse(String content, String ctype, XelContext xelc, Locator loc) throws DspException, IOException, XelException {
        return new Parser().parse(content, ctype, xelc, loc);
    }

    public final void interpret(DspContext dc, String content, String ctype, XelContext xelc) throws DspException, IOException, XelException {
        this.parse(content, ctype, xelc, dc.getLocator()).interpret(dc);
    }

    public final void interpret(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String content, String ctype, Locator locator) throws DspException, IOException, XelException {
        this.interpret(new ServletDspContext(ctx, request, response, locator), content, ctype, null);
    }

    public final void interpret(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, Writer out, String content, String ctype, Locator locator) throws DspException, IOException, XelException {
        this.interpret(new ServletDspContext(ctx, request, response, out, locator), content, ctype, null);
    }
}

