/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import org.zkoss.io.Files;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ExecutionCtrl;

public class Path {
    private final String _path;

    public Path() {
        this((String)null);
    }

    public Path(String path) {
        this._path = Files.normalize((String)path);
    }

    public Path(String parent, String child) {
        this(parent == null || parent.length() == 0 ? child : (child == null || child.length() == 0 ? parent : parent + '/' + child));
    }

    public Path(Path parent, String child) {
        this(parent != null ? parent.getPath() : null, child);
    }

    public Path(Component comp) {
        this(Path.getPath(comp));
    }

    public String getPath() {
        return this._path;
    }

    public static final String getPath(Component comp) {
        StringBuffer sb = new StringBuffer(64);
        while (true) {
            Component p;
            String compId;
            if (sb.length() > 0) {
                sb.insert(0, '/');
            }
            if ((compId = comp.getId()).length() == 0) {
                throw new UiException("ID required: " + comp);
            }
            sb.insert(0, compId);
            IdSpace is = comp.getSpaceOwner();
            if (is instanceof Page || is == comp && ((p = ((Component)((Object)is)).getParent()) == null || (is = p.getSpaceOwner()) instanceof Page)) break;
            comp = (Component)((Object)is);
        }
        sb.insert(0, '/');
        return sb.toString();
    }

    public Component getComponent() {
        return Path.getComponent0(null, this._path);
    }

    public static final Component getComponent(String path) {
        return Path.getComponent0(null, Files.normalize((String)path));
    }

    public static final Component getComponent(IdSpace is, String path) {
        return Path.getComponent0(is, Files.normalize((String)path));
    }

    private static final Component getComponent0(IdSpace is, String path) {
        Object found = null;
        int j = 0;
        while (true) {
            int k;
            if ((k = path.indexOf(47, j)) == 0) {
                Execution exec = Executions.getCurrent();
                Desktop desktop = exec.getDesktop();
                Page page = ((ExecutionCtrl)((Object)exec)).getCurrentPage();
                if (page == null && (page = desktop.getFirstPage()) == null) {
                    return null;
                }
                if (path.length() == 1) {
                    return page.getFirstRoot();
                }
                if (path.charAt(1) == '/') {
                    k = path.indexOf(47, 2);
                    if (k < 0) {
                        return null;
                    }
                    String nm = path.substring(2, k);
                    is = desktop.getPageIfAny(nm);
                    if (is == null) {
                        return null;
                    }
                } else {
                    is = page;
                }
            } else {
                Component c;
                String nm;
                String string = nm = k >= 0 ? path.substring(j, k) : path.substring(j);
                if ("..".equals(nm)) {
                    if (!(is instanceof Component)) {
                        return null;
                    }
                    c = (Component)((Object)is);
                    Component p = c.getParent();
                    IdSpace idSpace = is = p != null ? p.getSpaceOwner() : c.getPage();
                    if (k < 0) {
                        return is instanceof Component ? (Component)((Object)is) : null;
                    }
                } else {
                    if (is == null) {
                        return null;
                    }
                    c = is.getFellowIfAny(nm);
                    if (k < 0 || c == null) {
                        return c;
                    }
                    if (!(c instanceof IdSpace)) {
                        return null;
                    }
                    is = (IdSpace)((Object)c);
                }
            }
            j = k + 1;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Path && ((Path)o)._path.equals(this._path);
    }

    public int hashCode() {
        return this._path.hashCode();
    }

    public String toString() {
        return this._path;
    }
}

