/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.accessibility.fo.FO2StructureTreeConverter;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FOTreeBuilder;
import org.apache.fop.fo.FOTreeBuilderContext;
import org.apache.fop.fo.FOValidationEventProducer;
import org.apache.fop.fo.PropertyListMaker;
import org.apache.fop.fo.pagination.Root;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FOTreeBuilder
extends DefaultHandler {
    private static final Log LOG = LogFactory.getLog(FOTreeBuilder.class);
    protected ElementMappingRegistry elementMappingRegistry;
    protected Root rootFObj;
    protected MainFOHandler mainFOHandler;
    protected ContentHandler delegate;
    private FOTreeBuilderContext builderContext;
    private FOEventHandler foEventHandler;
    private Locator locator;
    private FOUserAgent userAgent;
    private boolean used;
    private boolean empty = true;
    private int depth;
    private boolean errorinstart;

    public FOTreeBuilder(String outputFormat, FOUserAgent foUserAgent, OutputStream stream) throws FOPException {
        this.userAgent = foUserAgent;
        this.elementMappingRegistry = this.userAgent.getElementMappingRegistry();
        this.foEventHandler = foUserAgent.getRendererFactory().createFOEventHandler(foUserAgent, outputFormat, stream);
        if (this.userAgent.isAccessibilityEnabled()) {
            this.foEventHandler = new FO2StructureTreeConverter(foUserAgent.getStructureTreeEventHandler(), this.foEventHandler);
        }
        this.builderContext = new FOTreeBuilderContext();
        this.builderContext.setPropertyListMaker((PropertyListMaker)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    protected Locator getEffectiveLocator() {
        return this.userAgent.isLocatorEnabled() ? this.locator : null;
    }

    @Override
    public void characters(char[] data, int start, int length) throws SAXException {
        this.delegate.characters(data, start, length);
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.used) {
            throw new IllegalStateException("FOTreeBuilder (and the Fop class) cannot be reused. Please instantiate a new instance.");
        }
        this.used = true;
        this.empty = true;
        this.rootFObj = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Building formatting object tree");
        }
        this.foEventHandler.startDocument();
        this.mainFOHandler = new MainFOHandler(this, null);
        this.mainFOHandler.startDocument();
        this.delegate = this.mainFOHandler;
    }

    @Override
    public void endDocument() throws SAXException {
        this.delegate.endDocument();
        if (this.rootFObj == null && this.empty) {
            FOValidationEventProducer eventProducer = FOValidationEventProducer.Provider.get((EventBroadcaster)this.userAgent.getEventBroadcaster());
            eventProducer.emptyDocument((Object)this);
        }
        this.rootFObj = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Parsing of document complete");
        }
        this.foEventHandler.endDocument();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String rawName, Attributes attlist) throws SAXException {
        ++this.depth;
        this.errorinstart = false;
        try {
            this.delegate.startElement(namespaceURI, localName, rawName, attlist);
        }
        catch (SAXException e) {
            this.errorinstart = true;
            throw e;
        }
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        if (!this.errorinstart) {
            this.delegate.endElement(uri, localName, rawName);
            --this.depth;
            if (this.depth == 0 && this.delegate != this.mainFOHandler) {
                this.delegate.endDocument();
                this.delegate = this.mainFOHandler;
                this.delegate.endElement(uri, localName, rawName);
            }
        }
    }

    @Override
    public void warning(SAXParseException e) {
        LOG.warn((Object)e.getLocalizedMessage());
    }

    @Override
    public void error(SAXParseException e) {
        LOG.error((Object)e.toString());
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        LOG.error((Object)e.toString());
        throw e;
    }

    public FOEventHandler getEventHandler() {
        return this.foEventHandler;
    }

    public FormattingResults getResults() {
        return this.getEventHandler().getResults();
    }

    static /* synthetic */ boolean access$102(FOTreeBuilder x0, boolean x1) {
        x0.empty = x1;
        return x0.empty;
    }

    static /* synthetic */ FOUserAgent access$200(FOTreeBuilder x0) {
        return x0.userAgent;
    }

    static /* synthetic */ Locator access$300(FOTreeBuilder x0) {
        return x0.locator;
    }

    static /* synthetic */ FOTreeBuilderContext access$400(FOTreeBuilder x0) {
        return x0.builderContext;
    }

    static /* synthetic */ FOEventHandler access$500(FOTreeBuilder x0) {
        return x0.foEventHandler;
    }

    static /* synthetic */ int access$602(FOTreeBuilder x0, int x1) {
        x0.depth = x1;
        return x0.depth;
    }

    static /* synthetic */ Log access$700() {
        return LOG;
    }
}

