/* PropertiesRenderer.java

	Purpose:
		
	Description:
		
	History:
		Wed Apr 20 17:50:36 TST 2011, Created by tomyeh

Copyright (C) 2011 Potix Corporation. All Rights Reserved.

*/
package org.zkoss.zk.ui.sys;

import org.zkoss.zk.ui.Component;

/**
 * A renderer used to render custom properties for particular components.
 * It is a listener (a.k.a., a plugin) that an application can register
 * in zk.xml (or {@link org.zkoss.zk.ui.util.Configuration#addListener}),
 * and then used to customize component's behaviors.
 *
 * <p>The properties generated by {@link #renderProperties} will be part of
 * the content sent to the client. It usually requires the client-side code
 * to handle these properties.
 *
 * @author tomyeh
 * @since 5.0.7
 */
public interface PropertiesRenderer {
	/** Renders additional properties of the given component with
	 * the given {@link ContentRenderer}.
	 * If the generated properties have the same as the component's default
	 * properties, they will be both sent to the client and the default one
	 * will be evaluated first, and then the custom properties.
	 */
	public void renderProperties(Component comp, ContentRenderer render) throws java.io.IOException;
}
