/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.http.SourceMapInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceMapManager {
    static final Logger log = LoggerFactory.getLogger(SourceMapManager.class);
    private final SourceMapGeneratorV3 _generator = new SourceMapGeneratorV3();
    private final String _name;
    private final String _sourceRoot;
    private final String _sourceMappingURL;
    private final List<SourceMapInfo> _sourceMapInfoList;
    private String _generatedSourceMapContent;

    public SourceMapManager(String name, String sourceRoot, String id) {
        this._name = name;
        this._sourceRoot = sourceRoot;
        this._sourceMapInfoList = new ArrayList<SourceMapInfo>(16);
        this._sourceMappingURL = this._sourceRoot + "js/" + id + "/" + this._name + ".map";
    }

    public List<SourceMapInfo> getSourceMapInfoList() {
        return this._sourceMapInfoList;
    }

    public String getSourceMappingURL() {
        return this._sourceMappingURL;
    }

    public void appendEmptySourceMap(int jsLineCount) {
        this.insertEmptySourceMap(-1, jsLineCount);
    }

    public void insertEmptySourceMap(int index, int jsLineCount) {
        this.insertSourceMap(index, "", jsLineCount, null);
    }

    public void appendSourceMap(SourceMapManager newSourceMapManager) throws IOException {
        if (newSourceMapManager != null) {
            this._sourceMapInfoList.addAll(newSourceMapManager.getSourceMapInfoList());
        }
    }

    public void appendSourceMap(String sourceMapContent, int jsLineCount, String sourcePath) {
        this.insertSourceMap(-1, sourceMapContent, jsLineCount, sourcePath);
    }

    public void insertSourceMap(int index, String sourceMapContent, int jsLineCount, String sourcePath) {
        if (sourceMapContent == null || sourceMapContent.length() == 0) {
            sourceMapContent = this.getEmptySourceMap(jsLineCount);
        }
        if (index > -1) {
            this._sourceMapInfoList.add(index, new SourceMapInfo(sourceMapContent, jsLineCount, sourcePath));
        } else {
            this._sourceMapInfoList.add(new SourceMapInfo(sourceMapContent, jsLineCount, sourcePath));
        }
    }

    private String getEmptySourceMap(int lineCount) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n\"version\":3,\n\"file\":\"empty\",\n\"lineCount\":");
        sb.append(lineCount + "");
        sb.append(",\n\"mappings\":\"");
        sb.append("\",\n\"_sources\":[],\n\"names\":[]\n}");
        return sb.toString();
    }

    public String getSourceMapContent() throws IOException {
        String mapContentStr = this._generatedSourceMapContent;
        if (mapContentStr != null && mapContentStr.length() != 0) {
            return mapContentStr;
        }
        try {
            int lineCount = 0;
            ArrayList<String> sourcePathList = new ArrayList<String>(16);
            for (int i = 0; i < this._sourceMapInfoList.size(); ++i) {
                SourceMapInfo sourceMapInfo = this._sourceMapInfoList.get(i);
                String content = sourceMapInfo.getContent();
                if (content == null || content.length() == 0) continue;
                this._generator.mergeMapSection(lineCount, 0, content);
                lineCount += sourceMapInfo.getLineCount();
                String sourcePath = sourceMapInfo.getSourcePath();
                if (sourcePath == null || sourcePath.length() == 0) continue;
                sourcePathList.add(sourcePath);
            }
            StringBuilder mapContents = new StringBuilder();
            this._generator.appendTo((Appendable)mapContents, this._name + ".wpd");
            mapContentStr = mapContents.toString();
            StringBuilder sourcesBuilder = new StringBuilder();
            sourcesBuilder.append("\"sources\":[");
            int max = sourcePathList.size() - 1;
            for (int i = 0; i <= max; ++i) {
                sourcesBuilder.append("\"");
                sourcesBuilder.append((String)sourcePathList.get(i));
                sourcesBuilder.append("\"");
                if (i == max) continue;
                sourcesBuilder.append(",");
            }
            sourcesBuilder.append("],\"sourceRoot\":\"");
            sourcesBuilder.append(this._sourceRoot);
            sourcesBuilder.append("\",");
            this._generatedSourceMapContent = mapContentStr = mapContentStr.replaceAll("\"sources\".*\\]\\,", sourcesBuilder.toString());
        }
        catch (Exception e) {
            log.warn("Failed to parse source map file. " + e.getMessage());
        }
        return mapContentStr;
    }

    void addNonResolvedSourceMap() {
        this._sourceMapInfoList.add(new SourceMapInfo("", 0, null, false));
    }

    List<Integer> getUnresolvedSourceMapInfoIndexList() {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < this._sourceMapInfoList.size(); ++i) {
            if (this._sourceMapInfoList.get(i).isResolved()) continue;
            indexList.add(i);
        }
        return indexList;
    }

    void resolveSourceMapByIndex(int index, int jsLineCount) {
        SourceMapInfo info = this._sourceMapInfoList.remove(index);
        info.setContent(this.getEmptySourceMap(jsLineCount));
        info.setLineCount(jsLineCount);
        info.setResolved(true);
        this._sourceMapInfoList.add(index, info);
    }
}

