/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Generics;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.ext.Blockable;
import org.zkoss.zk.ui.sys.BooleanPropertyAccess;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.ComboitemRenderer;
import org.zkoss.zul.ComboitemRendererExt;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelMap;
import org.zkoss.zul.ListSubModel;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.SimpleConstraint;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.impl.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Combobox
extends Textbox {
    private static final Logger log = LoggerFactory.getLogger(Combobox.class);
    private boolean _autodrop;
    private boolean _autocomplete = true;
    private boolean _btnVisible = true;
    private boolean _open;
    private transient Comboitem _selItem;
    private transient String _lastCkVal;
    private ListModel<?> _model;
    private Object[] _subModel;
    private ComboitemRenderer<?> _renderer;
    private transient ListDataListener _dataListener;
    private transient EventListener<InputEvent> _eventListener;
    private boolean _syncItemIndicesLater;
    private String _popupWidth;
    private static final String ATTR_ON_INIT_RENDER = "org.zkoss.zul.Combobox.onInitRender";
    private int INVALIDATE_THRESHOLD = -1;
    private static final ComboitemRenderer _defRend;
    private static HashMap<String, PropertyAccess> _properties;

    public Combobox() {
    }

    public Combobox(String value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    @Override
    protected String coerceToString(Object value) {
        Constraint constr = this.getConstraint();
        String val = super.coerceToString(value);
        if (val.length() > 0 && constr != null && constr instanceof SimpleConstraint && (((SimpleConstraint)constr).getFlags() & 0x200) != 0) {
            Iterator<Comboitem> it = this.getItems().iterator();
            while (it.hasNext()) {
                String label = it.next().getLabel();
                if (!val.equalsIgnoreCase(label)) continue;
                return label;
            }
        }
        return val;
    }

    public <T> ListModel<T> getModel() {
        return this._model;
    }

    public void setModel(ListModel<?> model) {
        if (model != null) {
            if (!(model instanceof Selectable)) {
                throw new UiException(model.getClass() + " must implement " + Selectable.class);
            }
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                }
                if (this._model != null && !this._model.getClass().getName().equals("org.zkoss.zkplus.databind.BindingListModelList") && !this.getItems().isEmpty()) {
                    this.getItems().clear();
                }
                this._model = model;
                this._subModel = null;
                this.initDataListener();
                this.setAttribute("org.zkoss.zul.BeforeModelItemsRendered", Boolean.TRUE);
            }
            this.postOnInitRender(null);
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            if (this._model instanceof ListSubModel) {
                this.removeEventListener("onChanging", this._eventListener);
            }
            this._model = null;
            this._subModel = null;
            if (!this.getItems().isEmpty()) {
                this.getItems().clear();
            }
        }
    }

    private void initDataListener() {
        if (this.INVALIDATE_THRESHOLD == -1) {
            this.INVALIDATE_THRESHOLD = Utils.getIntAttribute((Component)this, "org.zkoss.zul.invalidateThreshold", 10, true);
        }
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onChange(ListDataEvent event) {
                    int type = event.getType();
                    if (Combobox.this.getAttribute("org.zkoss.zul.BeforeModelItemsRendered") != null && (type == 1 || type == 2)) {
                        return;
                    }
                    ListModel _model = Combobox.this.getModel();
                    int newsz = _model.getSize();
                    int oldsz = Combobox.this.getItemCount();
                    int min = event.getIndex0();
                    int max = event.getIndex1();
                    switch (type) {
                        case 4: {
                            Combobox.this.doSelectionChanged();
                            return;
                        }
                        case 6: {
                            return;
                        }
                        case 1: {
                            int cnt = newsz - oldsz;
                            if (cnt < 0) {
                                throw new UiException("Adding causes a smaller list?");
                            }
                            if (cnt == 0) {
                                return;
                            }
                            if (!(oldsz > 0 && cnt <= Combobox.this.INVALIDATE_THRESHOLD || Combobox.this.isOpen())) {
                                Combobox.this.invalidate();
                            }
                            if (min < 0) {
                                min = max < 0 ? 0 : max - cnt + 1;
                            }
                            if (min > oldsz) {
                                min = oldsz;
                            }
                            Renderer renderer = new Renderer();
                            Comboitem next = min < oldsz ? Combobox.this.getItemAtIndex(min) : null;
                            int index = min;
                            try {
                                ComboitemRenderer cirenderer = null;
                                while (--cnt >= 0) {
                                    if (cirenderer == null) {
                                        cirenderer = Combobox.this.getRealRenderer();
                                    }
                                    Comboitem item = Combobox.this.newUnloadedItem(cirenderer);
                                    Combobox.this.insertBefore((Component)item, (Component)next);
                                    renderer.render(item, _model.getElementAt(index), index++);
                                }
                                break;
                            }
                            catch (Throwable ex) {
                                renderer.doCatch(ex);
                                break;
                            }
                            finally {
                                renderer.doFinally();
                            }
                        }
                        case 2: {
                            int cnt = oldsz - newsz;
                            if (cnt < 0) {
                                throw new UiException("Removal causes a larger list?");
                            }
                            if (cnt == 0) {
                                return;
                            }
                            if (min >= 0) {
                                max = min + cnt - 1;
                            } else if (max < 0) {
                                max = cnt - 1;
                            }
                            if (max > oldsz - 1) {
                                max = oldsz - 1;
                            }
                            if (!(newsz > 0 && cnt <= Combobox.this.INVALIDATE_THRESHOLD || Combobox.this.isOpen())) {
                                Combobox.this.invalidate();
                            }
                            Comboitem comp = Combobox.this.getItemAtIndex(max);
                            while (--cnt >= 0) {
                                Component p = comp.getPreviousSibling();
                                comp.detach();
                                comp = p;
                            }
                            break;
                        }
                        default: {
                            Combobox.this.postOnInitRender(null);
                        }
                    }
                }
            };
        }
        if (this._eventListener == null) {
            this._eventListener = new EventListener<InputEvent>(){

                public void onEvent(InputEvent event) throws Exception {
                    if (Combobox.this.getModel() instanceof ListSubModel && !event.isChangingBySelectBack()) {
                        Combobox.this.postOnInitRender(event.getValue());
                    }
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
        if (this._model instanceof ListSubModel) {
            this.addEventListener("onChanging", this._eventListener);
        }
    }

    private void doSelectionChanged() {
        Selectable<Object> smodel = this.getSelectableModel();
        if (smodel.isSelectionEmpty()) {
            if (this._selItem != null) {
                this.setSelectedItem(null);
            }
            return;
        }
        if (this._selItem != null && smodel.isSelected(this.getElementAt(this._selItem.getIndex()))) {
            return;
        }
        int j = 0;
        for (Comboitem item : this.getItems()) {
            if (!smodel.isSelected(this.getElementAt(j++))) continue;
            this.setSelectedItem(item);
            return;
        }
        if (this._model instanceof ListSubModel) {
            Object selObj = smodel.getSelection().iterator().next();
            if (selObj instanceof String || selObj == null) {
                this.setValue((String)selObj);
                this.postOnInitRender(null);
            }
            return;
        }
    }

    private Object getElementAt(int index) {
        return this._subModel != null ? this._subModel[index] : this._model.getElementAt(index);
    }

    private Selectable<Object> getSelectableModel() {
        return (Selectable)((Object)this._model);
    }

    public <T> ComboitemRenderer<T> getItemRenderer() {
        return this._renderer;
    }

    public void setItemRenderer(ComboitemRenderer<?> renderer) {
        this._renderer = renderer;
    }

    public void setItemRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setItemRenderer((ComboitemRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    private ListModel<?> syncModel(Object index) {
        ComboitemRenderer renderer = null;
        ListModel<?> subset = this._model instanceof ListSubModel ? ((ListSubModel)((Object)this._model)).getSubModel(index, -1) : this._model;
        int newsz = subset.getSize();
        if (!this.getItems().isEmpty()) {
            this.getItems().clear();
        }
        for (int j = 0; j < newsz; ++j) {
            if (renderer == null) {
                renderer = this.getRealRenderer();
            }
            this.newUnloadedItem(renderer).setParent((Component)this);
        }
        return subset;
    }

    private Comboitem newUnloadedItem(ComboitemRenderer<?> renderer) {
        Comboitem item = null;
        if (renderer instanceof ComboitemRendererExt) {
            item = ((ComboitemRendererExt)((Object)renderer)).newComboitem(this);
        }
        if (item == null) {
            item = new Comboitem();
            item.applyProperties();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitRender(Event data) {
        this.removeAttribute(ATTR_ON_INIT_RENDER);
        Renderer renderer = new Renderer();
        ArrayList subModel = this._model instanceof ListSubModel ? new ArrayList() : null;
        ListModel<?> subset = this.syncModel(data.getData() != null ? data.getData() : this.getRawText());
        try {
            Comboitem item;
            int pgsz = subset.getSize();
            int ofs = 0;
            Comboitem comboitem = item = this.getItems().size() <= ofs ? null : this.getItems().get(ofs);
            for (int j = 0; j < pgsz && item != null; ++j) {
                Comboitem nxt = (Comboitem)item.getNextSibling();
                int index = j + ofs;
                Object value = subset.getElementAt(index);
                if (subModel != null) {
                    subModel.add(value);
                }
                renderer.render(item, value, index);
                item = nxt;
            }
            if (subModel != null) {
                this._subModel = subModel.toArray(new Object[subModel.size()]);
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
        Events.postEvent((String)"onInitRenderLater", (Component)this, null);
        Events.postEvent((String)"onAfterRender", (Component)this, null);
        this.removeAttribute("org.zkoss.zul.BeforeModelItemsRendered");
    }

    private void postOnInitRender(String idx) {
        if (this.getAttribute(ATTR_ON_INIT_RENDER) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, (Object)idx);
        }
    }

    private <T> ComboitemRenderer<T> getRealRenderer() {
        return this._renderer != null ? this._renderer : _defRend;
    }

    public boolean isAutodrop() {
        return this._autodrop;
    }

    public void setAutodrop(boolean autodrop) {
        if (this._autodrop != autodrop) {
            this._autodrop = autodrop;
            this.smartUpdate("autodrop", autodrop);
        }
    }

    public boolean isAutocomplete() {
        return this._autocomplete;
    }

    public void setAutocomplete(boolean autocomplete) {
        if (this._autocomplete != autocomplete) {
            this._autocomplete = autocomplete;
            this.smartUpdate("autocomplete", autocomplete);
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            if (this.isVisible()) {
                if (open) {
                    this.open();
                } else {
                    this.close();
                }
            }
        }
    }

    public void open() {
        this.response("open", (AuResponse)new AuInvoke((Component)this, "setOpen", true));
    }

    public void close() {
        this.response("open", (AuResponse)new AuInvoke((Component)this, "setOpen", false));
    }

    public boolean isButtonVisible() {
        return this._btnVisible;
    }

    public void setButtonVisible(boolean visible) {
        if (this._btnVisible != visible) {
            this._btnVisible = visible;
            this.smartUpdate("buttonVisible", visible);
        }
    }

    public List<Comboitem> getItems() {
        return Generics.cast((List)this.getChildren());
    }

    public int getItemCount() {
        return this.getItems().size();
    }

    public Comboitem getItemAtIndex(int index) {
        return this.getItems().get(index);
    }

    public Comboitem appendItem(String label) {
        Comboitem item = new Comboitem(label);
        item.setParent((Component)this);
        return item;
    }

    public Comboitem removeItemAt(int index) {
        Comboitem item = this.getItemAtIndex(index);
        this.removeChild((Component)item);
        return item;
    }

    public Comboitem getSelectedItem() {
        this.syncValueToSelection();
        return this._selItem;
    }

    public void setSelectedItem(Comboitem item) {
        if (item != null && item.getParent() != this) {
            throw new UiException("Not a child: " + (Object)((Object)item));
        }
        if (item != this._selItem) {
            this._selItem = item;
            if (item != null) {
                this.setValue(item.getLabel());
                this.smartUpdate("selectedItemUuid_", item.getUuid());
            } else if (this._value != null && !"".equals(this._value)) {
                this._value = "";
                this.smartUpdate("value", this.coerceToString(this._value));
            }
            this._lastCkVal = this.getValue();
        }
    }

    public void setSelectedIndex(int jsel) {
        if (jsel >= this.getItemCount()) {
            throw new UiException("Out of bound: " + jsel + " while size=" + this.getItemCount());
        }
        if (jsel < -1) {
            jsel = -1;
        }
        this.setSelectedItem(jsel >= 0 ? this.getItemAtIndex(jsel) : null);
    }

    public int getSelectedIndex() {
        this.syncValueToSelection();
        return this._selItem != null ? this._selItem.getIndex() : -1;
    }

    public String getPopupWidth() {
        return this._popupWidth;
    }

    public void setPopupWidth(String popupWidth) {
        if (popupWidth != this._popupWidth) {
            this._popupWidth = popupWidth;
            this.smartUpdate("popupWidth", popupWidth);
        }
    }

    @Override
    public void setMultiline(boolean multiline) {
        if (multiline) {
            throw new UnsupportedOperationException("Combobox doesn't support multiline");
        }
    }

    @Override
    public void setRows(int rows) {
        if (rows != 1) {
            throw new UnsupportedOperationException("Combobox doesn't support multiple rows, " + rows);
        }
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    private void syncSelectionToModel() {
        if (this._model != null) {
            ArrayList<Object> selObjs = new ArrayList<Object>();
            if (this._selItem != null) {
                selObjs.add(this.getElementAt(this._selItem.getIndex()));
            }
            this.getSelectableModel().setSelection(selObjs);
        }
    }

    @Override
    public String getZclass() {
        return this._zclass == null ? "z-combobox" : this._zclass;
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "autodrop", this._autodrop);
        if (!this._autocomplete) {
            renderer.render("autocomplete", false);
        }
        if (!this._btnVisible) {
            renderer.render("buttonVisible", false);
        }
        if (this._selItem != null) {
            renderer.render("selectedItemUuid_", this._selItem.getUuid());
        }
        if (this._popupWidth != null) {
            renderer.render("popupWidth", this._popupWidth);
        }
    }

    @Override
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onOpen")) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this._open = evt.isOpen();
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onSelect")) {
            final LinkedHashSet<Comboitem> prevSelectedItems = new LinkedHashSet<Comboitem>();
            Comboitem prevSeld = (Comboitem)request.getDesktop().getComponentByUuidIfAny((String)request.getData().get("prevSeld"));
            if (prevSeld != null) {
                prevSelectedItems.add(prevSeld);
            }
            SelectEvent evt = SelectEvent.getSelectEvent((AuRequest)request, (SelectEvent.SelectedObjectHandler)new SelectEvent.SelectedObjectHandler<Comboitem>(){

                public Set<Object> getObjects(Set<Comboitem> items) {
                    if (items == null || items.isEmpty() || Combobox.this._model == null) {
                        return null;
                    }
                    LinkedHashSet<Object> objs = new LinkedHashSet<Object>();
                    for (Comboitem i : items) {
                        objs.add(Combobox.this._model.getElementAt(i.getIndex()));
                    }
                    return objs;
                }

                public Set<Comboitem> getPreviousSelectedItems() {
                    return prevSelectedItems;
                }

                public Set<Comboitem> getUnselectedItems() {
                    return this.getPreviousSelectedItems();
                }

                public Set<Object> getPreviousSelectedObjects() {
                    Set<Comboitem> items = this.getPreviousSelectedItems();
                    if (Combobox.this._model == null || items.size() < 1) {
                        return null;
                    }
                    LinkedHashSet<Object> s = new LinkedHashSet<Object>();
                    s.add(Combobox.this._model.getElementAt(items.iterator().next().getIndex()));
                    return s;
                }

                public Set<Object> getUnselectedObjects() {
                    return this.getPreviousSelectedObjects();
                }
            });
            Comboitem oldSel = this._selItem;
            Set selItems = evt.getSelectedItems();
            this._selItem = selItems != null && !selItems.isEmpty() ? (Comboitem)((Object)selItems.iterator().next()) : null;
            this._lastCkVal = this.getValue();
            this.syncSelectionToModel();
            String val = this._lastCkVal;
            if (oldSel != null && !oldSel.equals((Object)this._selItem) && oldSel.getLabel().equals(val)) {
                Events.postEvent((Event)new InputEvent("onChange", (Component)this, val, (Object)val));
            }
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onChange")) {
            super.service(request, everError);
            this.syncValueToSelection();
        } else {
            super.service(request, everError);
        }
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (!(newChild instanceof Comboitem)) {
            throw new UiException("Unsupported child for Combobox: " + newChild);
        }
        super.beforeChildAdded(newChild, refChild);
    }

    @Override
    protected boolean isChildable() {
        return true;
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        this._syncItemIndicesLater = true;
        this.smartUpdate("repos", true);
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        this._syncItemIndicesLater = true;
        if (child == this._selItem) {
            this._selItem = null;
            this.schedSyncValueToSelection();
        }
        this.smartUpdate("repos", true);
    }

    void syncItemIndices() {
        if (this._syncItemIndicesLater) {
            this._syncItemIndicesLater = false;
            int j = 0;
            for (Comboitem item : this.getItems()) {
                item.setIndexDirectly(j++);
            }
        }
    }

    private void syncValueToSelection() {
        String value = this.getValue();
        if (!Objects.equals((Object)this._lastCkVal, (Object)value)) {
            this._lastCkVal = value;
            this._selItem = null;
            for (Comboitem item : this.getItems()) {
                if (!Objects.equals((Object)value, (Object)item.getLabel())) continue;
                this._selItem = item;
                break;
            }
            this.syncSelectionToModel();
        }
    }

    void schedSyncValueToSelection() {
        this._lastCkVal = null;
    }

    Comboitem getSelectedItemDirectly() {
        return this._selItem;
    }

    @Override
    public Object clone() {
        Combobox clone = (Combobox)super.clone();
        clone._selItem = null;
        clone.schedSyncValueToSelection();
        if (clone._model != null) {
            ListModel model;
            if (clone._model instanceof ComponentCloneListener && (model = (ListModel)((ComponentCloneListener)clone._model).willClone((Component)clone)) != null) {
                clone._model = model;
            }
            clone._dataListener = null;
            clone._eventListener = null;
            clone.initDataListener();
        }
        return clone;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.schedSyncValueToSelection();
        if (this._model != null) {
            this.initDataListener();
            if (this._model instanceof ListModelMap) {
                for (Comboitem item : this.getItems()) {
                    item.setValue(this.getElementAt(item.getIndex()));
                }
            }
        }
    }

    public void sessionWillPassivate(Page page) {
        super.sessionWillPassivate(page);
        this.willPassivate(this._model);
        this.willPassivate(this._renderer);
    }

    public void sessionDidActivate(Page page) {
        super.sessionDidActivate(page);
        this.didActivate(this._model);
        this.didActivate(this._renderer);
    }

    @Override
    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    static {
        Combobox.addClientEvent(Combobox.class, (String)"onOpen", (int)8192);
        Combobox.addClientEvent(Combobox.class, (String)"onSelect", (int)8193);
        _defRend = new ComboitemRenderer(){

            public void render(Comboitem item, final Object data, final int index) {
                final Combobox cb = (Combobox)item.getParent();
                Template tm = cb.getTemplate("model");
                if (tm == null) {
                    item.setLabel(Objects.toString((Object)data));
                    item.setValue(data);
                } else {
                    Component[] items = ShadowElementsCtrl.filterOutShadows((Component[])tm.create(item.getParent(), (Component)item, new VariableResolver(){

                        public Object resolveVariable(String name) {
                            if ("each".equals(name)) {
                                return data;
                            }
                            if ("forEachStatus".equals(name)) {
                                return new ForEachStatus(){

                                    public ForEachStatus getPrevious() {
                                        return null;
                                    }

                                    public Object getEach() {
                                        return this.getCurrent();
                                    }

                                    public int getIndex() {
                                        return index;
                                    }

                                    public Integer getBegin() {
                                        return 0;
                                    }

                                    public Integer getEnd() {
                                        return cb.getModel().getSize();
                                    }

                                    public Object getCurrent() {
                                        return data;
                                    }

                                    public boolean isFirst() {
                                        return this.getCount() == 1;
                                    }

                                    public boolean isLast() {
                                        return this.getIndex() + 1 == this.getEnd();
                                    }

                                    public Integer getStep() {
                                        return null;
                                    }

                                    public int getCount() {
                                        return this.getIndex() + 1;
                                    }
                                };
                            }
                            return null;
                        }
                    }, null));
                    if (items.length != 1) {
                        throw new UiException("The model template must have exactly one item, not " + items.length);
                    }
                    Comboitem nci = (Comboitem)items[0];
                    if (nci.getValue() == null) {
                        nci.setValue(data);
                    }
                    item.setAttribute("org.zkoss.zul.model.renderAs", (Object)nci);
                    item.detach();
                }
            }
        };
        _properties = new HashMap(3);
        _properties.put("buttonVisible", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean value) {
                ((Combobox)cmp).setButtonVisible(value);
            }

            public Boolean getValue(Component cmp) {
                return ((Combobox)cmp).isButtonVisible();
            }
        });
        _properties.put("autocomplete", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean value) {
                ((Combobox)cmp).setAutocomplete(value);
            }

            public Boolean getValue(Component cmp) {
                return ((Combobox)cmp).isAutocomplete();
            }
        });
        _properties.put("autodrop", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean value) {
                ((Combobox)cmp).setAutodrop(value);
            }

            public Boolean getValue(Component cmp) {
                return ((Combobox)cmp).isAutodrop();
            }
        });
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Blockable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Combobox.this);
        }

        public boolean shallBlock(AuRequest request) {
            String cmd = request.getCommand();
            if ("onOpen".equals(cmd)) {
                return false;
            }
            return Combobox.this.isDisabled() || Combobox.this.isReadonly() && "onChanging".equals(cmd) || !Components.isRealVisible((Component)Combobox.this);
        }
    }

    private class Renderer
    implements Serializable {
        private final ComboitemRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        private Renderer() {
            this._renderer = Combobox.this.getRealRenderer();
        }

        private void render(Comboitem item, Object value, int index) throws Throwable {
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            try {
                try {
                    this._renderer.render(item, value, index);
                }
                catch (AbstractMethodError ex) {
                    Method m = this._renderer.getClass().getMethod("render", Comboitem.class, Object.class);
                    m.setAccessible(true);
                    m.invoke((Object)this._renderer, new Object[]{item, value});
                }
                Object v = item.getAttribute("org.zkoss.zul.model.renderAs");
                if (v != null) {
                    item = (Comboitem)((Object)v);
                }
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error("", t);
                }
                throw ex;
            }
            if (Combobox.this.getSelectableModel().isSelected(value)) {
                Combobox.this.setSelectedItem(item);
            }
            this._rendered = true;
        }

        private void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        private void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }
}

