/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.fill.JRHorizontalFiller;
import net.sf.jasperreports.engine.fill.JRVerticalFiller;
import net.sf.jasperreports.engine.fill.JasperReportSource;
import net.sf.jasperreports.engine.fill.PartReportFiller;
import net.sf.jasperreports.engine.fill.ReportFiller;
import net.sf.jasperreports.engine.fill.SimpleJasperReportSource;
import net.sf.jasperreports.engine.type.SectionTypeEnum;

public final class JRFiller {
    public static final String EXCEPTION_MESSAGE_KEY_THREAD_INTERRUPTED = "fill.common.filler.thread.interrupted";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_REPORT_SECTION_TYPE = "fill.common.filler.unknown.report.section.type";
    public static final String PROPERTY_DEFAULT_LOCALE = "net.sf.jasperreports.default.locale";
    public static final String PROPERTY_DEFAULT_TIMEZONE = "net.sf.jasperreports.default.timezone";

    public static JasperPrint fill(JasperReportsContext jasperReportsContext, JasperReport jasperReport, Map<String, Object> parameters, Connection conn) throws JRException {
        return JRFiller.fill(jasperReportsContext, (JasperReportSource)SimpleJasperReportSource.from(jasperReport), parameters, conn);
    }

    public static JasperPrint fill(JasperReportsContext jasperReportsContext, JasperReportSource reportSource, Map<String, Object> parameters, Connection conn) throws JRException {
        ReportFiller filler = JRFiller.createReportFiller(jasperReportsContext, reportSource);
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = filler.fill(parameters, conn);
        }
        catch (JRFillInterruptedException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_THREAD_INTERRUPTED, null, e);
        }
        return jasperPrint;
    }

    public static JasperPrint fill(JasperReportsContext jasperReportsContext, JasperReport jasperReport, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        return JRFiller.fill(jasperReportsContext, (JasperReportSource)SimpleJasperReportSource.from(jasperReport), parameters, dataSource);
    }

    public static JasperPrint fill(JasperReportsContext jasperReportsContext, JasperReportSource reportSource, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        ReportFiller filler = JRFiller.createReportFiller(jasperReportsContext, reportSource);
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = filler.fill(parameters, dataSource);
        }
        catch (JRFillInterruptedException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_THREAD_INTERRUPTED, null, e);
        }
        return jasperPrint;
    }

    public static JasperPrint fill(JasperReportsContext jasperReportsContext, JasperReport jasperReport, Map<String, Object> parameters) throws JRException {
        return JRFiller.fill(jasperReportsContext, SimpleJasperReportSource.from(jasperReport), parameters);
    }

    public static JasperPrint fill(JasperReportsContext jasperReportsContext, JasperReportSource reportSource, Map<String, Object> parameters) throws JRException {
        ReportFiller filler = JRFiller.createReportFiller(jasperReportsContext, reportSource);
        try {
            JasperPrint jasperPrint = filler.fill(parameters);
            return jasperPrint;
        }
        catch (JRFillInterruptedException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_THREAD_INTERRUPTED, null, e);
        }
    }

    public static JRBaseFiller createFiller(JasperReportsContext jasperReportsContext, JasperReport jasperReport) throws JRException {
        return JRFiller.createBandReportFiller(jasperReportsContext, SimpleJasperReportSource.from(jasperReport));
    }

    protected static JRBaseFiller createBandReportFiller(JasperReportsContext jasperReportsContext, JasperReportSource reportSource) throws JRException {
        JRBaseFiller filler = null;
        switch (reportSource.getReport().getPrintOrderValue()) {
            case HORIZONTAL: {
                filler = new JRHorizontalFiller(jasperReportsContext, reportSource, null);
                break;
            }
            case VERTICAL: {
                filler = new JRVerticalFiller(jasperReportsContext, reportSource, null);
            }
        }
        return filler;
    }

    public static ReportFiller createReportFiller(JasperReportsContext jasperReportsContext, JasperReport jasperReport) throws JRException {
        return JRFiller.createReportFiller(jasperReportsContext, SimpleJasperReportSource.from(jasperReport));
    }

    public static ReportFiller createReportFiller(JasperReportsContext jasperReportsContext, JasperReportSource reportSource) throws JRException {
        BaseReportFiller filler;
        SectionTypeEnum sectionType = reportSource.getReport().getSectionType();
        sectionType = sectionType == null ? SectionTypeEnum.BAND : sectionType;
        switch (sectionType) {
            case BAND: {
                filler = JRFiller.createBandReportFiller(jasperReportsContext, reportSource);
                break;
            }
            case PART: {
                filler = new PartReportFiller(jasperReportsContext, reportSource, null);
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_REPORT_SECTION_TYPE, new Object[]{reportSource.getReport().getSectionType()});
            }
        }
        return filler;
    }

    private JRFiller() {
    }
}

