/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFReference;

public class BitmapImage
implements PDFImage {
    private int height;
    private int width;
    private int bitsPerComponent;
    private PDFDeviceColorSpace colorSpace;
    private byte[] bitmaps;
    private PDFReference maskRef;
    private PDFColor transparent;
    private String key;
    private PDFDocument pdfDoc;
    private PDFFilter pdfFilter;
    private boolean multipleFiltersAllowed = true;

    public BitmapImage(String k, int width, int height, byte[] data, PDFReference mask) {
        this.key = k;
        this.height = height;
        this.width = width;
        this.bitsPerComponent = 8;
        this.colorSpace = new PDFDeviceColorSpace(2);
        this.bitmaps = data;
        if (mask != null) {
            this.maskRef = mask;
        }
    }

    @Override
    public void setup(PDFDocument doc) {
        this.pdfDoc = doc;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setColorSpace(PDFDeviceColorSpace cs) {
        this.colorSpace = cs;
    }

    @Override
    public PDFDeviceColorSpace getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public int getBitsPerComponent() {
        return this.bitsPerComponent;
    }

    public void setTransparent(PDFColor t) {
        this.transparent = t;
    }

    @Override
    public boolean isTransparent() {
        return this.transparent != null;
    }

    @Override
    public PDFColor getTransparentColor() {
        return this.transparent;
    }

    @Override
    public String getMask() {
        return null;
    }

    @Override
    public PDFReference getSoftMaskReference() {
        return this.maskRef;
    }

    @Override
    public boolean isInverted() {
        return false;
    }

    @Override
    public void outputContents(OutputStream out) throws IOException {
        out.write(this.bitmaps);
    }

    @Override
    public void populateXObjectDictionary(PDFDictionary dict) {
    }

    @Override
    public PDFICCStream getICCStream() {
        return null;
    }

    @Override
    public boolean isPS() {
        return false;
    }

    @Override
    public String getFilterHint() {
        return "image";
    }

    @Override
    public PDFFilter getPDFFilter() {
        return this.pdfFilter;
    }

    public void setPDFFilter(PDFFilter pdfFilter) {
        this.pdfFilter = pdfFilter;
    }

    @Override
    public boolean multipleFiltersAllowed() {
        return this.multipleFiltersAllowed;
    }

    public void disallowMultipleFilters() {
        this.multipleFiltersAllowed = false;
    }
}

