/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.passay.MessageResolver;
import org.passay.PasswordData;
import org.passay.PropertiesMessageResolver;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.entropy.Entropy;
import org.passay.entropy.RandomPasswordEntropyFactory;
import org.passay.entropy.ShannonEntropyFactory;

public class PasswordValidator
implements Rule {
    private final List<? extends Rule> passwordRules;
    private final MessageResolver messageResolver;

    public PasswordValidator(Rule ... rules) {
        this((MessageResolver)new PropertiesMessageResolver(), Arrays.asList(rules));
    }

    public PasswordValidator(List<? extends Rule> rules) {
        this((MessageResolver)new PropertiesMessageResolver(), rules);
    }

    public PasswordValidator(MessageResolver resolver, Rule ... rules) {
        this(resolver, Arrays.asList(rules));
    }

    public PasswordValidator(MessageResolver resolver, List<? extends Rule> rules) {
        this.messageResolver = resolver;
        this.passwordRules = rules;
    }

    public List<? extends Rule> getRules() {
        return Collections.unmodifiableList(this.passwordRules);
    }

    public MessageResolver getMessageResolver() {
        return this.messageResolver;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        for (Rule rule : this.passwordRules) {
            RuleResult rr = rule.validate(passwordData);
            if (!rr.isValid()) {
                result.setValid(false);
                result.getDetails().addAll(rr.getDetails());
            }
            result.getMetadata().merge(rr.getMetadata());
        }
        return result;
    }

    public double estimateEntropy(PasswordData passwordData) {
        Entropy entropy;
        if (passwordData.getOrigin().equals((Object)PasswordData.Origin.Generated)) {
            entropy = RandomPasswordEntropyFactory.createEntropy(this.passwordRules, passwordData);
        } else if (passwordData.getOrigin().equals((Object)PasswordData.Origin.User)) {
            entropy = ShannonEntropyFactory.createEntropy(this.passwordRules, passwordData);
        } else {
            throw new IllegalArgumentException("Unknown password origin: " + passwordData);
        }
        return entropy.estimate();
    }

    public List<String> getMessages(RuleResult result) {
        List<String> messages = result.getDetails().stream().map(this.messageResolver::resolve).collect(Collectors.toList());
        return messages;
    }

    public String toString() {
        return String.format("%s@%h::passwordRules=%s,messageResolver=%s", this.getClass().getName(), this.hashCode(), this.passwordRules, this.messageResolver);
    }
}

