/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.zkoss.idom.Document;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.CCExecution;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.SuspendNotAllowedException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.xel.Evaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Executions {
    protected static final ThreadLocal<Execution> _exec = new ThreadLocal();

    public static final Execution getCurrent() {
        return _exec.get();
    }

    public static final Evaluator getEvaluator(Page page, Class<? extends ExpressionFactory> expfcls) {
        return Executions.getCurrent().getEvaluator(page, expfcls);
    }

    public static final Evaluator getEvaluator(Component comp, Class<? extends ExpressionFactory> expfcls) {
        return Executions.getCurrent().getEvaluator(comp, expfcls);
    }

    public static final Object evaluate(Component comp, String expr, Class expectedType) {
        return Executions.getCurrent().evaluate(comp, expr, expectedType);
    }

    public static final Object evaluate(Page page, String expr, Class expectedType) {
        return Executions.getCurrent().evaluate(page, expr, expectedType);
    }

    public static final String encodeURL(String uri) {
        return Executions.getCurrent().encodeURL(uri);
    }

    public static final URL encodeToURL(String uri) throws MalformedURLException {
        Execution exec = Executions.getCurrent();
        uri = exec.encodeURL(uri);
        if (uri.indexOf("://") < 0) {
            StringBuffer sb = new StringBuffer(256).append(exec.getScheme()).append("://").append(exec.getServerName());
            int port = exec.getServerPort();
            if (port != 80) {
                sb.append(':').append(port);
            }
            if (uri.length() > 0 && uri.charAt(0) != '/') {
                sb.append('/');
            }
            uri = sb.append(uri).toString();
        }
        return new URL(uri);
    }

    public static final Component createComponents(String uri, Component parent, Map<?, ?> arg) {
        return Executions.getCurrent().createComponents(uri, parent, arg);
    }

    public static final Component createComponents(PageDefinition pagedef, Component parent, Map<?, ?> arg) {
        return Executions.getCurrent().createComponents(pagedef, parent, arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component[] createComponents(WebApp wapp, PageDefinition pagedef, Map<?, ?> arg) {
        CCInfo cci = Executions.beforeCC(wapp);
        try {
            Component[] componentArray = cci.exec.createComponents(pagedef, arg);
            return componentArray;
        }
        finally {
            Executions.afterCC(cci);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component[] createComponents(WebApp wapp, String uri, Map<?, ?> arg) {
        CCInfo cci = Executions.beforeCC(wapp);
        try {
            Component[] componentArray = cci.exec.createComponents(uri, arg);
            return componentArray;
        }
        finally {
            Executions.afterCC(cci);
        }
    }

    public static Component[] createComponents(String uri, Page page, VariableResolver resolver, Map<?, ?> arg) {
        return Executions.getCurrent().createComponents(uri, page, resolver, arg);
    }

    public static final Component createComponentsDirectly(String content, String extension, Component parent, Map<?, ?> arg) {
        return Executions.getCurrent().createComponentsDirectly(content, extension, parent, arg);
    }

    public static final Component createComponentsDirectly(Document content, String extension, Component parent, Map<?, ?> arg) {
        return Executions.getCurrent().createComponentsDirectly(content, extension, parent, arg);
    }

    public static Component createComponentsDirectly(Reader reader, String extension, Component parent, Map<?, ?> arg) throws IOException {
        return Executions.getCurrent().createComponentsDirectly(reader, extension, parent, arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component[] createComponentsDirectly(WebApp wapp, String content, String extension, Map<?, ?> arg) {
        CCInfo cci = Executions.beforeCC(wapp);
        try {
            Component[] componentArray = cci.exec.createComponentsDirectly(content, extension, arg);
            return componentArray;
        }
        finally {
            Executions.afterCC(cci);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component[] createComponentsDirectly(WebApp wapp, Document content, String extension, Map<?, ?> arg) {
        CCInfo cci = Executions.beforeCC(wapp);
        try {
            Component[] componentArray = cci.exec.createComponentsDirectly(content, extension, arg);
            return componentArray;
        }
        finally {
            Executions.afterCC(cci);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component[] createComponentsDirectly(WebApp wapp, Reader reader, String extension, Map<?, ?> arg) throws IOException {
        CCInfo cci = Executions.beforeCC(wapp);
        try {
            Component[] componentArray = cci.exec.createComponentsDirectly(reader, extension, arg);
            return componentArray;
        }
        finally {
            Executions.afterCC(cci);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PageDefinition getPageDefinition(WebApp wapp, String uri) {
        CCInfo cci = Executions.beforeCC(wapp);
        try {
            PageDefinition pageDefinition = cci.exec.getPageDefinition(uri);
            return pageDefinition;
        }
        finally {
            Executions.afterCC(cci);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageDefinition getPageDefinitionDirectly(WebApp wapp, String content, String extension) {
        CCInfo cci = Executions.beforeCC(wapp);
        try {
            PageDefinition pageDefinition = cci.exec.getPageDefinitionDirectly(content, extension);
            return pageDefinition;
        }
        finally {
            Executions.afterCC(cci);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageDefinition getPageDefinitionDirectly(WebApp wapp, Document content, String extension) {
        CCInfo cci = Executions.beforeCC(wapp);
        try {
            PageDefinition pageDefinition = cci.exec.getPageDefinitionDirectly(content, extension);
            return pageDefinition;
        }
        finally {
            Executions.afterCC(cci);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageDefinition getPageDefinitionDirectly(WebApp wapp, Reader reader, String extension) throws IOException {
        CCInfo cci = Executions.beforeCC(wapp);
        try {
            PageDefinition pageDefinition = cci.exec.getPageDefinitionDirectly(reader, extension);
            return pageDefinition;
        }
        finally {
            Executions.afterCC(cci);
        }
    }

    private static final CCInfo beforeCC(WebApp wapp) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            return new CCInfo(exec, false);
        }
        exec = CCExecution.newInstance(wapp);
        ((WebAppCtrl)((Object)wapp)).getUiEngine().activate(exec);
        return new CCInfo(exec, true);
    }

    private static final void afterCC(CCInfo cci) {
        if (cci.created) {
            try {
                ((WebAppCtrl)((Object)cci.exec.getDesktop().getWebApp())).getUiEngine().deactivate(cci.exec);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void sendRedirect(String uri) {
        Executions.getCurrent().sendRedirect(uri);
    }

    public static void include(String page) throws IOException {
        Executions.getCurrent().include(page);
    }

    public static void forward(String page) throws IOException {
        Executions.getCurrent().forward(page);
    }

    public static final void wait(Object mutex) throws InterruptedException, SuspendNotAllowedException {
        Executions.getUiEngine().wait(mutex);
    }

    public static final void notify(Object mutex) {
        Executions.getUiEngine().notify(mutex);
    }

    public static final void notify(Desktop desktop, Object mutex) {
        Executions.getUiEngine(desktop).notify(desktop, mutex);
    }

    public static final void notifyAll(Object mutex) {
        Executions.getUiEngine().notifyAll(mutex);
    }

    public static final void notifyAll(Desktop desktop, Object mutex) {
        Executions.getUiEngine(desktop).notifyAll(desktop, mutex);
    }

    public static <T extends Event> void schedule(Desktop desktop, EventListener<T> task, T event) {
        ((DesktopCtrl)((Object)desktop)).scheduleServerPush(task, event);
    }

    public static final void activate(Desktop desktop) throws InterruptedException, DesktopUnavailableException {
        Executions.activate(desktop, 0L);
    }

    public static final boolean activate(Desktop desktop, long timeout) throws InterruptedException, DesktopUnavailableException {
        return ((DesktopCtrl)((Object)desktop)).activateServerPush(timeout);
    }

    public static final void deactivate(Desktop desktop) {
        ((DesktopCtrl)((Object)desktop)).deactivateServerPush();
    }

    private static final UiEngine getUiEngine(Desktop desktop) {
        if (desktop == null) {
            throw new IllegalArgumentException("desktop cannot be null");
        }
        return ((WebAppCtrl)((Object)desktop.getWebApp())).getUiEngine();
    }

    private static final UiEngine getUiEngine() {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("This method can be called only under an event listener");
        }
        return ((WebAppCtrl)((Object)exec.getDesktop().getWebApp())).getUiEngine();
    }

    private static class CCInfo {
        private final Execution exec;
        private final boolean created;

        private CCInfo(Execution exec, boolean created) {
            this.exec = exec;
            this.created = created;
        }
    }
}

