/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.servlet.BufferedResponse;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.dsp.DspContext;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.xel.RequestXelResolver;
import org.zkoss.web.util.resource.ServletContextLocator;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.VariableResolver;

public class ServletDspContext
implements DspContext {
    private final Locator _locator;
    private final ServletContext _ctx;
    final HttpServletRequest _request;
    final HttpServletResponse _response;
    Writer _out;
    private VariableResolver _resolver;
    private ExpressionFactory _expf;

    public ServletDspContext(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, Locator locator) {
        this(ctx, request, response, null, locator);
    }

    public ServletDspContext(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, Writer out, Locator locator) {
        this._locator = locator != null ? locator : new ServletContextLocator(ctx);
        this._ctx = ctx;
        this._request = request;
        this._response = response;
        this._out = out;
    }

    public Locator getLocator() {
        return this._locator;
    }

    public void setContentType(String ctype) {
        this._response.setContentType(ctype);
    }

    public void setOut(Writer out) {
        this._out = out;
    }

    public String encodeURL(String uri) throws ServletException, IOException {
        return Encodes.encodeURL(this._ctx, (ServletRequest)this._request, (ServletResponse)this._response, uri);
    }

    public void include(String uri, Map params) throws ServletException, IOException {
        Servlets.include(this._ctx, (ServletRequest)this._request, BufferedResponse.getInstance((ServletResponse)this._response, this._out), uri, params, 3);
    }

    public boolean isIncluded() {
        return Servlets.isIncluded((ServletRequest)this._request);
    }

    public Writer getOut() throws IOException {
        return this._out != null ? this._out : this._response.getWriter();
    }

    public ServletRequest getRequest() {
        return this._request;
    }

    public ServletResponse getResponse() {
        return this._response;
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    public VariableResolver getVariableResolver() {
        if (this._resolver == null) {
            this._resolver = new RequestXelResolver(this._ctx, (ServletRequest)this._request, (ServletResponse)this._response){

                public ExpressionFactory getExpressionFactory() {
                    return ServletDspContext.this.getExpressionFactory();
                }
            };
        }
        return this._resolver;
    }

    private ExpressionFactory getExpressionFactory() {
        if (this._expf == null) {
            this._expf = Expressions.newExpressionFactory();
        }
        return this._expf;
    }
}

