/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.io.Serializables;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Generics;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.Converter;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.au.out.AuClientInfo;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.ui.AbstractPage;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.EventListenerInfo;
import org.zkoss.zk.ui.EventListenerMapImpl;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlShadowElement;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Impls;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.ShadowElementCtrl;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.VirtualIdSpace;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Deferrable;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.Express;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zk.ui.ext.Macro;
import org.zkoss.zk.ui.ext.NonFellow;
import org.zkoss.zk.ui.ext.RawId;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.ScopeListener;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zk.ui.impl.SimpleScope;
import org.zkoss.zk.ui.impl.Utils;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.EventHandler;
import org.zkoss.zk.ui.metainfo.EventHandlerMap;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.ShadowInfo;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.sys.BooleanPropertyAccess;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentRedraws;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionInfo;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.sys.JSCumulativeContentRenderer;
import org.zkoss.zk.ui.sys.JsContentRenderer;
import org.zkoss.zk.ui.sys.Names;
import org.zkoss.zk.ui.sys.PropertiesRenderer;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.sys.StringPropertyAccess;
import org.zkoss.zk.ui.sys.StubComponent;
import org.zkoss.zk.ui.sys.StubsComponent;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.ComponentSerializationListener;
import org.zkoss.zk.ui.util.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractComponent
implements Component,
ComponentCtrl,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractComponent.class);
    private static final long serialVersionUID = 20100719L;
    private static final Map<Class<? extends Component>, Map<String, Integer>> _clientEvents = new ConcurrentHashMap<Class<? extends Component>, Map<String, Integer>>(128);
    private static final String DEFAULT = "default";
    private static final String ANONYMOUS_ID = "z__i";
    private static int _anonymousId;
    private static final String AUTO_REMOVE_NULL = "org.zkoss.zk.ui.component.autoRemoveNullAttribute.enabled";
    transient Page _page;
    private String _id = "";
    private String _uuid;
    private transient ComponentDefinition _def;
    transient AbstractComponent _parent;
    transient AbstractComponent _next;
    transient AbstractComponent _prev;
    transient ChildInfo _chdinf;
    private AuxInfo _auxinf;
    private Map<String, ShadowElement> _shadowIdMap;
    private Boolean hasInited = null;
    private boolean _variableSeeking = false;
    private static HashMap<String, PropertyAccess> _properties;
    private static final Converter<EventListenerInfo, EventListener<? extends Event>> _listenerInfoConverter;

    public AbstractComponent() {
        String mold = this.getDefaultMold(this.getClass());
        if (mold != null && mold.length() > 0 && !DEFAULT.equals(mold)) {
            this.initAuxInfo().mold = mold;
        }
        this.addSharedAnnotationMap(Impls.getClassAnnotationMap(this.getClass()));
        Execution exec = Executions.getCurrent();
        Object curInfo = ComponentsCtrl.getCurrentInfo();
        if (curInfo != null) {
            ComponentsCtrl.setCurrentInfo((ComponentInfo)null);
            if (curInfo instanceof ComponentInfo) {
                ComponentInfo compInfo = (ComponentInfo)curInfo;
                this._def = compInfo.getComponentDefinition();
                this.addSharedAnnotationMap(this._def.getAnnotationMap());
                this.addSharedAnnotationMap(compInfo.getAnnotationMap());
                if (compInfo.hasBindingAnnotation()) {
                    this.enableBindingAnnotation();
                }
            } else if (curInfo instanceof ShadowInfo) {
                ShadowInfo compInfo = (ShadowInfo)curInfo;
                this._def = compInfo.getComponentDefinition();
                this.addSharedAnnotationMap(this._def.getAnnotationMap());
                this.addSharedAnnotationMap(compInfo.getAnnotationMap());
                if (compInfo.hasBindingAnnotation()) {
                    this.enableBindingAnnotation();
                }
            } else {
                this._def = (ComponentDefinition)curInfo;
                this.addSharedAnnotationMap(this._def.getAnnotationMap());
            }
        } else {
            this._def = Impls.getDefinition(exec, this.getClass());
            if (this._def != null) {
                this.addSharedAnnotationMap(this._def.getAnnotationMap());
            } else {
                this._def = ComponentsCtrl.DUMMY;
            }
        }
        if (this instanceof IdSpace) {
            this.initAuxInfo().spaceInfo = new SpaceInfo();
        }
        this._def.applyAttributes(this);
    }

    protected AbstractComponent(boolean useless) {
        this._def = ComponentsCtrl.DUMMY;
    }

    private static void addToIdSpaces(Component comp) {
        String compId = comp.getId();
        if (comp instanceof NonFellow || AbstractComponent.isAutoId(compId)) {
            return;
        }
        if (comp instanceof IdSpace) {
            ((AbstractComponent)comp).bindToIdSpace(comp);
        }
        AbstractComponent.addFellow(comp, AbstractComponent.getSpaceOwnerOfParent(comp));
    }

    private static void addFellow(Component comp, IdSpace owner) {
        if (owner instanceof Component) {
            ((AbstractComponent)((Object)owner)).bindToIdSpace(comp);
        } else if (owner instanceof Page) {
            ((AbstractPage)owner).addFellow(comp);
        }
        if (owner == null && comp instanceof ShadowElement) {
            AbstractComponent.addToShadowIdMap(comp);
        }
    }

    private static void removeFellow(Component comp, IdSpace owner) {
        if (owner instanceof Component) {
            ((AbstractComponent)((Object)owner)).unbindFromIdSpace(comp.getId());
        } else if (owner instanceof Page) {
            ((AbstractPage)owner).removeFellow(comp);
        }
        if (owner == null && comp instanceof ShadowElement) {
            AbstractComponent.removeFromShadowIdMap(comp);
        }
    }

    private static IdSpace getSpaceOwnerOfParent(Component comp) {
        Component parent = comp.getParent();
        return parent != null ? AbstractComponent.spaceOwnerNoVirtual(parent) : comp.getPage();
    }

    private static void removeFromIdSpaces(Component comp) {
        String compId = comp.getId();
        if (comp instanceof NonFellow || AbstractComponent.isAutoId(compId)) {
            return;
        }
        if (comp instanceof IdSpace) {
            ((AbstractComponent)comp).unbindFromIdSpace(compId);
        }
        AbstractComponent.removeFellow(comp, AbstractComponent.getSpaceOwnerOfParent(comp));
    }

    private static void checkIdSpaces(AbstractComponent comp, String newId) {
        if (comp instanceof NonFellow) {
            return;
        }
        if (comp instanceof IdSpace && comp._auxinf.spaceInfo.fellows.containsKey(newId)) {
            throw new UiException("Not unique in the ID space of " + comp);
        }
        IdSpace is = AbstractComponent.getSpaceOwnerOfParent(comp);
        if (is instanceof Component ? ((AbstractComponent)((Object)is))._auxinf.spaceInfo.fellows.containsKey(newId) : is != null && is.hasFellow(newId)) {
            throw new UiException("Not unique in ID space " + is + ": " + newId);
        }
    }

    static boolean isAutoId(String compId) {
        return compId.length() == 0;
    }

    private static void addToIdSpacesDown(Component comp) {
        AbstractComponent.addToIdSpacesDown(comp, AbstractComponent.getSpaceOwnerOfParent(comp));
    }

    private static void addToIdSpacesDown(Component comp, IdSpace owner) {
        if (!(comp instanceof NonFellow) && !AbstractComponent.isAutoId(comp.getId())) {
            AbstractComponent.addFellow(comp, owner);
        }
        if (!(comp instanceof IdSpace)) {
            AbstractComponent ac = (AbstractComponent)comp.getFirstChild();
            while (ac != null) {
                AbstractComponent.addToIdSpacesDown(ac, owner);
                ac = ac._next;
            }
        }
        ((AbstractComponent)comp).notifyIdSpaceChanged(owner);
    }

    private void notifyIdSpaceChanged(IdSpace newIdSpace) {
        if (this._auxinf != null && this._auxinf.attrs != null) {
            this._auxinf.attrs.notifyIdSpaceChanged(newIdSpace);
        }
    }

    private static void removeFromIdSpacesDown(Component comp) {
        AbstractComponent.removeFromIdSpacesDown(comp, AbstractComponent.getSpaceOwnerOfParent(comp));
    }

    private static void removeFromIdSpacesDown(Component comp, IdSpace owner) {
        if (!(comp instanceof NonFellow) && !AbstractComponent.isAutoId(comp.getId())) {
            AbstractComponent.removeFellow(comp, owner);
        }
        if (!(comp instanceof IdSpace)) {
            AbstractComponent ac = (AbstractComponent)comp.getFirstChild();
            while (ac != null) {
                AbstractComponent.removeFromIdSpacesDown(ac, owner);
                ac = ac._next;
            }
        }
        ((AbstractComponent)comp).notifyIdSpaceChanged(null);
    }

    private static void checkIdSpacesDown(Component comp, Component newparent) {
        IdSpace is = AbstractComponent.spaceOwnerNoVirtual(newparent);
        if (is != null) {
            AbstractComponent.checkIdSpacesDown(comp, is);
        }
    }

    private static void checkIdSpacesDown(Component comp, IdSpace owner) {
        String compId = comp.getId();
        if (!(comp instanceof NonFellow) && !AbstractComponent.isAutoId(compId) && (owner instanceof Component ? ((AbstractComponent)((Object)owner))._auxinf.spaceInfo.fellows.containsKey(compId) : owner.hasFellow(compId))) {
            throw new UiException("Not unique in the ID space of " + owner + ": " + compId);
        }
        if (!(comp instanceof IdSpace)) {
            AbstractComponent ac = (AbstractComponent)comp.getFirstChild();
            while (ac != null) {
                AbstractComponent.checkIdSpacesDown((Component)ac, owner);
                ac = ac._next;
            }
        }
    }

    private void bindToIdSpace(Component comp) {
        this._auxinf.spaceInfo.fellows.put(comp.getId(), comp);
    }

    private void unbindFromIdSpace(String compId) {
        this._auxinf.spaceInfo.fellows.remove(compId);
    }

    private UiEngine getAttachedUiEngine() {
        return ((WebAppCtrl)((Object)this._page.getDesktop().getWebApp())).getUiEngine();
    }

    private UiEngine getCurrentUiEngine() {
        Execution exec = Executions.getCurrent();
        return exec != null ? ((WebAppCtrl)((Object)exec.getDesktop().getWebApp())).getUiEngine() : null;
    }

    @Override
    public Page getPage() {
        return this._page;
    }

    @Override
    public Desktop getDesktop() {
        return this._page != null ? this._page.getDesktop() : null;
    }

    @Override
    public void setPage(Page page) {
        if (page != this._page) {
            this.setPageBefore(page, null);
        }
    }

    @Override
    public void setPageBefore(Page page, Component refRoot) {
        boolean samepg;
        this.beforeComponentPageChanged(page);
        if (refRoot != null && (page == null || refRoot.getParent() != null || refRoot.getPage() != page)) {
            refRoot = null;
        }
        if (refRoot != null && (refRoot == this || refRoot == this._next)) {
            return;
        }
        if (this._parent != null) {
            throw new UiException("Only the parent of a root component can be changed: " + this);
        }
        Page oldpg = this._page;
        boolean bl = samepg = page == this._page;
        if (!samepg) {
            if (page != null) {
                if (this._page == null) {
                    this.clearVirtualIdSpace();
                } else if (this._page.getDesktop() != page.getDesktop()) {
                    throw new UiException("The new page must be in the same desktop: " + page);
                }
                AbstractComponent.checkIdSpacesDown((Component)this, page);
            } else {
                AbstractComponent.checkDetach(this._page);
            }
            if (this._page != null) {
                AbstractComponent.removeFromIdSpacesDown(this);
            }
        }
        this.addMoved(this._parent, this._page, page);
        if (!samepg) {
            this.setPage0(page);
        }
        if (page != null && (samepg || refRoot != null)) {
            ((AbstractPage)page).moveRoot(this, refRoot);
        }
        if (!samepg && this._page != null) {
            AbstractComponent.addToIdSpacesDown(this);
        }
        this.afterComponentPageChanged(page, oldpg);
    }

    private static void checkDetach(Page page) {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new UiException("You cannot access a desktop other than an event listener");
        }
        if (page.getDesktop() != exec.getDesktop()) {
            throw new UiException("You cannot access components belong to other desktop");
        }
    }

    protected void addMoved(Component oldparent, Page oldpg, Page newpg) {
        Desktop dt;
        if (oldpg != null) {
            dt = oldpg.getDesktop();
        } else if (newpg != null) {
            dt = newpg.getDesktop();
        } else {
            return;
        }
        ((WebAppCtrl)((Object)dt.getWebApp())).getUiEngine().addMoved(this, oldparent, oldpg, newpg);
    }

    private void setPage0(Page page) {
        if (page == this._page) {
            return;
        }
        boolean bRoot = this._parent == null;
        boolean resetUuid = false;
        if (this._page != null) {
            if (bRoot) {
                ((AbstractPage)this._page).removeRoot(this);
            }
            if (page == null && ((DesktopCtrl)((Object)this._page.getDesktop())).removeComponent(this, true) && !(this instanceof StubComponent)) {
                resetUuid = true;
            }
        }
        Page oldpage = this._page;
        this._page = page;
        if (this._page != null) {
            if (bRoot) {
                ((AbstractPage)this._page).addRoot(this);
            }
            Desktop desktop = this._page.getDesktop();
            if (oldpage == null) {
                if (this._uuid == null || this._uuid.startsWith(ANONYMOUS_ID) || desktop.getComponentByUuidIfAny(this._uuid) != null) {
                    this._uuid = this.nextUuid(desktop);
                }
                ((DesktopCtrl)((Object)desktop)).addComponent(this);
            }
            this.onPageAttached(this._page, oldpage);
        } else {
            this.onPageDetached(oldpage);
        }
        AbstractComponent p = (AbstractComponent)this.getFirstChild();
        while (p != null) {
            p.setPage0(page);
            p = p._next;
        }
        if (resetUuid) {
            this._uuid = null;
        }
    }

    private String nextUuid(Desktop desktop) {
        int count = 0;
        do {
            String uuid;
            if (desktop.getComponentByUuidIfAny(uuid = ((DesktopCtrl)((Object)desktop)).getNextUuid(this)) != null) continue;
            return uuid;
        } while (++count <= 10000);
        throw new UiException("It took too much time to look for unique UUID. Please check the implementation of IdGenerator.");
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setId(String id) {
        if (id == null) {
            id = "";
        }
        if (!id.equals(this._id)) {
            boolean rawId = this instanceof RawId;
            String newUuid = null;
            if (rawId) {
                newUuid = id;
            }
            if (id.length() > 0) {
                Component c;
                if (Names.isReserved(id)) {
                    throw new UiException("Invalid ID: " + id + ". Cause: reserved words not allowed: " + Names.getReservedNames());
                }
                if (rawId && this._page != null && (c = this._page.getDesktop().getComponentByUuidIfAny(newUuid)) != null && c != this) {
                    throw new UiException("Replicated UUID is not allowed for " + this.getClass() + ": " + newUuid);
                }
                AbstractComponent.checkIdSpaces(this, id);
            }
            AbstractComponent.removeFromIdSpaces(this);
            if (rawId) {
                if (this._page != null) {
                    Desktop dt = this._page.getDesktop();
                    ((DesktopCtrl)((Object)dt)).removeComponent(this, false);
                    if (newUuid.length() == 0) {
                        newUuid = this.nextUuid(dt);
                    }
                    if (!Objects.equals((Object)this._uuid, (Object)newUuid)) {
                        this.getAttachedUiEngine().addUuidChanged(this);
                    }
                }
                this._id = id;
                this._uuid = newUuid;
                if (this._page != null) {
                    ((DesktopCtrl)((Object)this._page.getDesktop())).addComponent(this);
                }
            } else {
                this._id = id;
            }
            AbstractComponent.addToIdSpaces(this);
            this.smartUpdate("id", this._id);
        }
    }

    @Override
    public String getUuid() {
        if (this._uuid == null) {
            Execution exec = null;
            for (Component comp = this; comp != null; comp = comp.getParent()) {
                if (comp.getPage() == null) continue;
                exec = Executions.getCurrent();
                break;
            }
            this._uuid = exec == null ? ANONYMOUS_ID + _anonymousId++ : this.nextUuid(exec.getDesktop());
        }
        return this._uuid;
    }

    @Override
    public IdSpace getSpaceOwner() {
        return AbstractComponent.spaceOwner(this, false);
    }

    private static IdSpace spaceOwnerNoVirtual(Component p) {
        return AbstractComponent.spaceOwner(p, true);
    }

    private static IdSpace spaceOwner(Component p, boolean ignoreVirtualIS) {
        Component top;
        do {
            if (p instanceof IdSpace) {
                return (IdSpace)((Object)p);
            }
            top = p;
        } while ((p = p.getParent()) != null);
        AbstractComponent ac = (AbstractComponent)top;
        return ac._page != null ? ac._page : (ignoreVirtualIS ? null : ac.getVirtualIdSpace());
    }

    private static Object spaceController(Component p) {
        Component top;
        do {
            if (p instanceof IdSpace) {
                return p;
            }
            top = p;
        } while ((p = p.getParent()) != null);
        AbstractComponent ac = (AbstractComponent)top;
        if (ac._page != null) {
            return ac._page;
        }
        ac.clearVirtualIdSpace();
        return ac;
    }

    private IdSpace getVirtualIdSpace() {
        if (this._chdinf != null) {
            if (this._chdinf.vispace == null) {
                this._chdinf.vispace = new VirtualIdSpace(this);
            }
            return this._chdinf.vispace;
        }
        return new VirtualIdSpace(this);
    }

    private void clearVirtualIdSpace() {
        if (this._chdinf != null) {
            this._chdinf.vispace = null;
        }
    }

    @Override
    public boolean hasFellow(String compId) {
        if (this instanceof IdSpace) {
            return this._auxinf.spaceInfo.fellows.containsKey(compId);
        }
        IdSpace idspace = this.getSpaceOwner();
        return idspace != null && idspace.hasFellow(compId);
    }

    @Override
    public boolean hasFellow(String compId, boolean recurse) {
        return this.getFellowIfAny(compId, recurse) != null;
    }

    @Override
    public Component getFellow(String compId) throws ComponentNotFoundException {
        if (this instanceof IdSpace) {
            Component comp = (Component)this._auxinf.spaceInfo.fellows.get(compId);
            if (comp == null) {
                throw new ComponentNotFoundException("Fellow component not found: " + compId);
            }
            return comp;
        }
        IdSpace idspace = this.getSpaceOwner();
        if (idspace == null) {
            throw new ComponentNotFoundException("This component doesn't belong to any ID space: " + this);
        }
        return idspace.getFellow(compId);
    }

    @Override
    public Component getFellow(String compId, boolean recurse) throws ComponentNotFoundException {
        Component comp = this.getFellowIfAny(compId, recurse);
        if (comp == null) {
            throw new ComponentNotFoundException("Fellow component not found: " + compId);
        }
        return comp;
    }

    @Override
    public Component getFellowIfAny(String compId) {
        if (this instanceof IdSpace) {
            return (Component)this._auxinf.spaceInfo.fellows.get(compId);
        }
        IdSpace idspace = this.getSpaceOwner();
        return idspace == null ? null : idspace.getFellowIfAny(compId);
    }

    @Override
    public Component getFellowIfAny(String compId, boolean recurse) {
        if (!recurse) {
            return this.getFellowIfAny(compId);
        }
        IdSpace idspace = this.getSpaceOwner();
        while (idspace != null) {
            Component f = idspace.getFellowIfAny(compId);
            if (f != null) {
                return f;
            }
            idspace = Components.getParentIdSpace(idspace);
        }
        return null;
    }

    @Override
    public Collection<Component> getFellows() {
        if (this instanceof IdSpace) {
            return Collections.unmodifiableCollection(this._auxinf.spaceInfo.fellows.values());
        }
        IdSpace idspace = this.getSpaceOwner();
        if (idspace != null) {
            return idspace.getFellows();
        }
        return Collections.emptyList();
    }

    @Override
    public Component getNextSibling() {
        return this._next;
    }

    @Override
    public Component getPreviousSibling() {
        return this._prev;
    }

    @Override
    public Component getFirstChild() {
        return this._chdinf != null ? this._chdinf.first : null;
    }

    @Override
    public Component getLastChild() {
        return this._chdinf != null ? this._chdinf.last : null;
    }

    final int nChild() {
        return this._chdinf != null ? this._chdinf.nChild : 0;
    }

    final void nChild(AbstractComponent first, AbstractComponent last, int nChild) {
        this._chdinf.first = first;
        this._chdinf.last = last;
        this._chdinf.nChild = nChild;
        while (first != null) {
            first._parent = this;
            first = first._next;
        }
    }

    int modCntChd() {
        return this._chdinf != null ? this._chdinf.modCntChd : 0;
    }

    @Override
    public String setWidgetListener(String evtnm, String script) {
        String old;
        if (evtnm == null) {
            throw new IllegalArgumentException();
        }
        if (script != null) {
            if (this.initAuxInfo().wgtlsns == null) {
                this._auxinf.wgtlsns = new LinkedHashMap(4);
            }
            old = this._auxinf.wgtlsns.put(evtnm, script);
        } else {
            String string = old = this._auxinf != null && this._auxinf.wgtlsns != null ? (String)this._auxinf.wgtlsns.remove(evtnm) : null;
        }
        if (!Objects.equals((Object)script, old)) {
            this.smartUpdateWidgetListener(evtnm, script);
        }
        return old;
    }

    @Override
    public String getWidgetListener(String evtnm) {
        return this._auxinf != null && this._auxinf.wgtlsns != null ? (String)this._auxinf.wgtlsns.get(evtnm) : null;
    }

    @Override
    public Set<String> getWidgetListenerNames() {
        if (this._auxinf != null && this._auxinf.wgtlsns != null) {
            return this._auxinf.wgtlsns.keySet();
        }
        return Collections.emptySet();
    }

    @Override
    public String setWidgetOverride(String name, String script) {
        String old;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (script != null) {
            if (this.initAuxInfo().wgtovds == null) {
                this._auxinf.wgtovds = new LinkedHashMap(4);
            }
            old = this._auxinf.wgtovds.put(name, script);
        } else {
            String string = old = this._auxinf != null && this._auxinf.wgtovds != null ? (String)this._auxinf.wgtovds.remove(name) : null;
        }
        if (!Objects.equals((Object)script, old)) {
            this.smartUpdateWidgetOverride(name, script);
        }
        return old;
    }

    @Override
    public String getWidgetOverride(String name) {
        return this._auxinf != null && this._auxinf.wgtovds != null ? (String)this._auxinf.wgtovds.get(name) : null;
    }

    @Override
    public Set<String> getWidgetOverrideNames() {
        if (this._auxinf != null && this._auxinf.wgtovds != null) {
            return this._auxinf.wgtovds.keySet();
        }
        return Collections.emptySet();
    }

    @Override
    public String setWidgetAttribute(String name, String value) {
        return this.setClientAttribute(name, value);
    }

    @Override
    public String setClientAttribute(String name, String value) {
        String old;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (value != null) {
            if (this.initAuxInfo().domattrs == null) {
                this._auxinf.domattrs = new LinkedHashMap(4);
            }
            old = this._auxinf.domattrs.put(name, value);
        } else {
            old = this._auxinf != null && this._auxinf.domattrs != null ? (String)this._auxinf.domattrs.remove(name) : null;
        }
        return old;
    }

    @Override
    public String getWidgetAttribute(String name) {
        return this.getClientAttribute(name);
    }

    @Override
    public String getClientAttribute(String name) {
        return this._auxinf != null && this._auxinf.domattrs != null ? (String)this._auxinf.domattrs.get(name) : null;
    }

    @Override
    public Set<String> getWidgetAttributeNames() {
        if (this._auxinf.domattrs != null) {
            return this._auxinf.domattrs.keySet();
        }
        return Collections.emptySet();
    }

    @Override
    public String setClientDataAttribute(String name, String value) {
        String old = this.setClientAttribute("data-" + name, value);
        if (old != null) {
            this.invalidate();
        }
        return old;
    }

    @Override
    public String getClientDataAttribute(String name) {
        return this.getClientAttribute("data-" + name);
    }

    @Override
    public Map<String, Object> getAttributes(int scope) {
        switch (scope) {
            case 1: {
                if (this instanceof IdSpace) {
                    return this.getAttributes();
                }
                IdSpace idspace = this.getSpaceOwner();
                if (idspace != null) {
                    return idspace.getAttributes();
                }
                return Collections.emptyMap();
            }
            case 2: {
                if (this._page != null) {
                    return this._page.getAttributes();
                }
                return Collections.emptyMap();
            }
            case 3: {
                if (this._page != null) {
                    return this._page.getDesktop().getAttributes();
                }
                return Collections.emptyMap();
            }
            case 4: {
                if (this._page != null) {
                    return this._page.getDesktop().getSession().getAttributes();
                }
                return Collections.emptyMap();
            }
            case 5: {
                if (this._page != null) {
                    return this._page.getDesktop().getWebApp().getAttributes();
                }
                return Collections.emptyMap();
            }
            case 0: {
                return this.getAttributes();
            }
            case 6: {
                Execution exec = this.getExecution();
                if (exec == null) break;
                return exec.getAttributes();
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attrs().getAttributes();
    }

    private SimpleScope attrs() {
        if (this.initAuxInfo().attrs == null) {
            this._auxinf.attrs = new SimpleScope(this);
        }
        return this._auxinf.attrs;
    }

    private Execution getExecution() {
        return this._page != null ? this._page.getDesktop().getExecution() : Executions.getCurrent();
    }

    @Override
    public Object getAttribute(String name, int scope) {
        return this.getAttributes(scope).get(name);
    }

    @Override
    public Object getAttribute(String name) {
        return this._auxinf != null && this._auxinf.attrs != null ? this._auxinf.attrs.getAttribute(name) : null;
    }

    @Override
    public Object getAttribute(String name, boolean recurse) {
        Object val = this.getAttribute(name);
        if (val != null || !recurse || this.hasAttribute(name)) {
            return val;
        }
        if (this._parent != null) {
            return this._parent.getAttribute(name, true);
        }
        if (this._page != null) {
            return this._page.getAttribute(name, true);
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String name, int scope) {
        return this.getAttributes(scope).containsKey(name);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this._auxinf != null && this._auxinf.attrs != null && this._auxinf.attrs.hasAttribute(name);
    }

    @Override
    public boolean hasAttribute(String name, boolean recurse) {
        if (this.hasAttribute(name)) {
            return true;
        }
        if (recurse) {
            if (this._parent != null) {
                return this._parent.hasAttribute(name, true);
            }
            if (this._page != null) {
                return this._page.hasAttribute(name, true);
            }
        }
        return false;
    }

    @Override
    public Object setAttribute(String name, Object value, int scope) {
        if (value == null && Boolean.parseBoolean(Library.getProperty((String)AUTO_REMOVE_NULL))) {
            return this.removeAttribute(name, scope);
        }
        Map<String, Object> attrs = this.getAttributes(scope);
        if (attrs == Collections.EMPTY_MAP) {
            throw new IllegalStateException("This component, " + this + ", doesn't belong to the " + Components.scopeToString(scope) + " scope");
        }
        return attrs.put(name, value);
    }

    @Override
    public Object setAttribute(String name, Object value) {
        if (value == null && this.shallAutoRemove()) {
            return this.removeAttribute(name);
        }
        return this.attrs().setAttribute(name, value);
    }

    @Override
    public Object setAttribute(String name, Object value, boolean recurse) {
        if (recurse && !this.hasAttribute(name)) {
            if (this._parent != null) {
                if (this._parent.hasAttribute(name, true)) {
                    return this._parent.setAttribute(name, value, true);
                }
            } else if (this._page != null && this._page.hasAttribute(name, true)) {
                return this._page.setAttribute(name, value, true);
            }
        }
        return this.setAttribute(name, value);
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        Map<String, Object> attrs = this.getAttributes(scope);
        if (attrs == Collections.emptyMap()) {
            throw new IllegalStateException("This component doesn't belong to any ID space: " + this);
        }
        return attrs.remove(name);
    }

    @Override
    public Object removeAttribute(String name) {
        return this._auxinf != null && this._auxinf.attrs != null ? this._auxinf.attrs.removeAttribute(name) : null;
    }

    @Override
    public Object removeAttribute(String name, boolean recurse) {
        if (recurse && !this.hasAttribute(name)) {
            if (this._parent != null) {
                if (this._parent.hasAttribute(name, true)) {
                    return this._parent.removeAttribute(name, true);
                }
            } else if (this._page != null && this._page.hasAttribute(name, true)) {
                return this._page.removeAttribute(name, true);
            }
            return null;
        }
        return this.removeAttribute(name);
    }

    private boolean shallAutoRemove() {
        if (this.hasInited == null) {
            this.hasInited = Boolean.parseBoolean(Library.getProperty((String)AUTO_REMOVE_NULL));
        }
        return this.hasInited;
    }

    @Override
    public Object getAttributeOrFellow(String name, boolean recurse) {
        Object val = this.getAttribute(name);
        if (val != null || this.hasAttribute(name)) {
            return val;
        }
        if (this instanceof IdSpace && (val = this.getFellowIfAny(name)) != null) {
            return val;
        }
        if (recurse) {
            Component shadowHost;
            if (this._parent != null) {
                return this._parent.getAttributeOrFellow(name, true);
            }
            if (this._page != null) {
                return this._page.getAttributeOrFellow(name, true);
            }
            if (this instanceof ShadowElement && (shadowHost = ((ShadowElement)((Object)this)).getShadowHost()) != null) {
                return shadowHost.getAttributeOrFellow(name, true);
            }
            if (!(this instanceof IdSpace)) {
                return this.getVirtualIdSpace().getFellowIfAny(name);
            }
        }
        return null;
    }

    @Override
    public Object getShadowVariable(String name, boolean recurse) {
        return this.getShadowVariable(this, name, recurse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getShadowVariable(Component baseChild, String name, boolean recurse) {
        try {
            this._variableSeeking = true;
            Object object = this.getShadowVariable0(baseChild, name, recurse);
            return object;
        }
        finally {
            this._variableSeeking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getShadowVariable0(Component baseChild, String name, boolean recurse) {
        try {
            Object ctrl;
            this._variableSeeking = true;
            Object val = this.getAttribute(name);
            if (val != null || this.hasAttribute(name)) {
                Object object = val;
                return object;
            }
            if (this instanceof ShadowElement) {
                Object value = ((ShadowElementCtrl)((Object)this)).resolveVariable(null, name, recurse);
                if (value != null) {
                    Object object = value;
                    return object;
                }
            } else {
                ctrl = this;
                List shadowRoots = ctrl.getShadowRoots();
                if (!shadowRoots.isEmpty()) {
                    Map<Component, Integer> indexCacheMap = this.getIndexCacheMap();
                    try {
                        if (indexCacheMap != null) {
                            this.destroyIndexCacheMap();
                        }
                        this.initIndexCacheMap();
                        Iterator iterator = shadowRoots.iterator();
                        while (true) {
                            if (iterator.hasNext()) {
                                HtmlShadowElement shadow = (HtmlShadowElement)iterator.next();
                                if (shadow.getShadowHost() != baseChild) {
                                    switch (HtmlShadowElement.inRange(shadow, baseChild)) {
                                        case IN_RANGE: 
                                        case FIRST: 
                                        case LAST: {
                                            HtmlShadowElement current = this.findNearestShadow(shadow, baseChild);
                                            Object object = current.resolveVariable(baseChild, name, recurse);
                                            return object;
                                        }
                                    }
                                    continue;
                                }
                                val = shadow.resolveVariable(baseChild, name, recurse);
                                if (val == null) continue;
                                Object object = val;
                                return object;
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        ShadowElementsCtrl.setDistributedIndexInfo(indexCacheMap);
                    }
                }
            }
            if (recurse) {
                AbstractComponent shadowHost;
                if (this._parent != null) {
                    ctrl = this._parent.getShadowVariable0(this, name, recurse);
                    return ctrl;
                }
                if (this instanceof ShadowElement && (shadowHost = (AbstractComponent)((ShadowElement)((Object)this)).getShadowHost()) != null) {
                    Object object;
                    if (shadowHost._variableSeeking) {
                        if (shadowHost.getParent() != null) {
                            object = ((AbstractComponent)shadowHost.getParent()).getShadowVariable0(shadowHost, name, recurse);
                            return object;
                        }
                        object = null;
                        return object;
                    }
                    object = shadowHost.getShadowVariable0(shadowHost, name, recurse);
                    return object;
                }
            }
            Object var5_6 = null;
            return var5_6;
        }
        finally {
            this._variableSeeking = false;
        }
    }

    private HtmlShadowElement findNearestShadow(HtmlShadowElement current, Component baseChild) {
        List list = Generics.cast(current.getChildren());
        for (ShadowElement sh : list) {
            if (!(sh instanceof HtmlShadowElement)) continue;
            HtmlShadowElement shadow0 = (HtmlShadowElement)sh;
            switch (HtmlShadowElement.inRange(shadow0, baseChild)) {
                case IN_RANGE: 
                case FIRST: 
                case LAST: {
                    return this.findNearestShadow(shadow0, baseChild);
                }
            }
        }
        return current;
    }

    @Override
    public boolean hasAttributeOrFellow(String name, boolean recurse) {
        if (this.hasAttribute(name) || this instanceof IdSpace && this.hasFellow(name)) {
            return true;
        }
        if (recurse) {
            Component shadowHost;
            if (this._parent != null) {
                return this._parent.hasAttributeOrFellow(name, true);
            }
            if (this._page != null) {
                return this._page.hasAttributeOrFellow(name, true);
            }
            if (this instanceof ShadowElement && (shadowHost = ((ShadowElement)((Object)this)).getShadowHost()) != null) {
                return shadowHost.hasAttributeOrFellow(name, true);
            }
            if (!(this instanceof IdSpace)) {
                return this.getVirtualIdSpace().hasFellow(name);
            }
        }
        return false;
    }

    @Override
    public boolean addScopeListener(ScopeListener listener) {
        return this.attrs().addScopeListener(listener);
    }

    @Override
    public boolean removeScopeListener(ScopeListener listener) {
        return this.attrs().removeScopeListener(listener);
    }

    @Override
    public String getAutag() {
        return this._auxinf != null ? this._auxinf.autag : null;
    }

    @Override
    public void setAutag(String tag) {
        if (tag != null && Strings.isEmpty((String)tag)) {
            tag = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.autag : null), (Object)tag)) {
            this.initAuxInfo().autag = tag;
            this.smartUpdate("autag", this.getAutag());
        }
    }

    @Override
    public Component getParent() {
        return this._parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParent(Component parent) {
        Desktop desktop;
        AbstractComponent op;
        if (this._parent == parent) {
            return;
        }
        AbstractComponent.checkParentChild(parent, this);
        this.beforeParentChanged(parent);
        this.triggerBeforeHostParentChanged(parent);
        boolean idSpaceChanged = (parent != null ? AbstractComponent.spaceController(parent) : null) != (this._parent != null ? AbstractComponent.spaceController(this._parent) : this._page);
        this.clearVirtualIdSpace();
        if (idSpaceChanged) {
            AbstractComponent.removeFromIdSpacesDown(this);
        }
        if ((op = this._parent) != null) {
            if (!op._chdinf.inRemoving(this)) {
                op._chdinf.markRemoving(this, true);
                try {
                    op.removeChild(this);
                }
                finally {
                    op._chdinf.markRemoving(this, false);
                }
            }
            this._parent = null;
        } else if (this._page != null) {
            ((AbstractPage)this._page).removeRoot(this);
        }
        if (parent != null) {
            AbstractComponent np = (AbstractComponent)parent;
            if (!np._chdinf.inAdding(this)) {
                np._chdinf.markAdding(this, true);
                try {
                    np.insertBefore(this, null);
                }
                finally {
                    np._chdinf.markAdding(this, false);
                }
            }
            this._parent = np;
        }
        Page newpg = this._parent != null ? this._parent.getPage() : null;
        Page oldpg = this._page;
        this.addMoved(op, this._page, newpg);
        try {
            ComponentsCtrl.setRootParent(parent != null ? parent : op);
            this.setPage0(newpg);
        }
        finally {
            ComponentsCtrl.setRootParent(null);
        }
        if (this._auxinf != null && this._auxinf.attrs != null) {
            this._auxinf.attrs.notifyParentChanged(this._parent != null ? this._parent : this._page);
        }
        if (idSpaceChanged) {
            AbstractComponent.addToIdSpacesDown(this);
        }
        this.afterComponentPageChanged(newpg, oldpg);
        if ((newpg != null || oldpg != null) && (desktop = (oldpg != null ? oldpg : newpg).getDesktop()) != null) {
            ((DesktopCtrl)((Object)desktop)).afterComponentMoved(parent, this, op);
            desktop.getWebApp().getConfiguration().afterComponentMoved(parent, this, op);
        }
    }

    private void beforeComponentPageChanged(Page page) {
        if (page == null) {
            WebApps.getCurrent().getConfiguration().invokeCallback("destroy", this);
        }
    }

    private void afterComponentPageChanged(Page newpg, Page oldpg) {
        if (newpg == oldpg) {
            return;
        }
        Desktop desktop = (oldpg != null ? oldpg : newpg).getDesktop();
        if (desktop == null) {
            return;
        }
        if (oldpg != null) {
            ((DesktopCtrl)((Object)desktop)).afterComponentDetached(this, oldpg);
            desktop.getWebApp().getConfiguration().afterComponentDetached(this, oldpg);
        } else {
            ((DesktopCtrl)((Object)desktop)).afterComponentAttached(this, newpg);
            desktop.getWebApp().getConfiguration().afterComponentAttached(this, newpg);
        }
    }

    private static void checkParentChild(Component parent, Component child) throws UiException {
        if (child == null) {
            throw new UiException("Child cannot be null");
        }
        if (parent != null) {
            AbstractComponent acp = (AbstractComponent)parent;
            if (acp.initChildInfo().inAdding(child)) {
                return;
            }
            if (Components.isAncestor(child, parent)) {
                throw new UiException("A child cannot be a parent of its ancestor: " + child);
            }
            if (!acp.isChildable()) {
                throw new UiException("Child not allowed in " + parent.getClass().getName());
            }
            Page parentpg = parent.getPage();
            Page childpg = child.getPage();
            if (parentpg != null && childpg != null && parentpg.getDesktop() != childpg.getDesktop()) {
                throw new UiException("The parent and child must be in the same desktop: " + parent);
            }
            Component oldparent = child.getParent();
            if (AbstractComponent.spaceOwnerNoVirtual(parent) != (oldparent != null ? AbstractComponent.spaceOwnerNoVirtual(oldparent) : childpg)) {
                AbstractComponent.checkIdSpacesDown(child, parent);
            }
        } else {
            Page childpg = child.getPage();
            if (childpg != null) {
                AbstractComponent.checkDetach(childpg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insertBefore(Component newChild, Component refChild) {
        boolean moved;
        if (newChild instanceof Macro && ((Macro)((Object)newChild)).isInline()) {
            return ((Macro)((Object)newChild)).setInlineParent(this, refChild);
        }
        AbstractComponent.checkParentChild(this, newChild);
        if (refChild != null && refChild.getParent() != this) {
            refChild = null;
        }
        if (newChild == refChild) {
            return false;
        }
        this.beforeChildAdded(newChild, refChild);
        this.triggerBeforeHostChildAdded(newChild, refChild);
        AbstractComponent nc = (AbstractComponent)newChild;
        boolean bl = moved = nc._parent == this;
        if (moved) {
            if (nc._next == refChild) {
                return false;
            }
            nc.addMoved(this, this._page, this._page);
            this.setNext(nc._prev, nc._next);
            this.setPrev(nc._next, nc._prev);
        } else if (!this._chdinf.inAdding(nc)) {
            this._chdinf.markAdding(nc, true);
            try {
                nc.setParent(this);
            }
            finally {
                this._chdinf.markAdding(nc, false);
            }
        } else {
            nc._parent = this;
        }
        if (refChild != null) {
            AbstractComponent ref = (AbstractComponent)refChild;
            this.setNext(nc, ref);
            this.setPrev(nc, ref._prev);
            this.setNext(ref._prev, nc);
            this.setPrev(ref, nc);
        } else if (this._chdinf.last == null) {
            this._chdinf.first = this._chdinf.last = nc;
            nc._prev = null;
            nc._next = null;
        } else {
            this._chdinf.last._next = nc;
            nc._prev = this._chdinf.last;
            nc._next = null;
            this._chdinf.last = nc;
        }
        ++this._chdinf.modCntChd;
        if (!moved) {
            ++this._chdinf.nChild;
            this.onChildAdded(nc);
            this.triggerAfterHostChildAdded(nc);
            this.updateSubBindingAnnotationCount(nc.initAuxInfo().subAnnotCnt);
        }
        return true;
    }

    final void setNext(AbstractComponent comp, AbstractComponent next) {
        if (comp != null) {
            comp._next = next;
        } else {
            this._chdinf.first = next;
        }
    }

    final void setPrev(AbstractComponent comp, AbstractComponent prev) {
        if (comp != null) {
            comp._prev = prev;
        } else {
            this._chdinf.last = prev;
        }
    }

    final void incNChild(int diff) {
        this._chdinf.nChild += diff;
    }

    protected void replace(Component comp, boolean bFellow, boolean bListener, boolean bChildren) {
        ((AbstractComponent)comp).replaceWith(this, bFellow, bListener, bChildren);
    }

    private final void replaceWith(AbstractComponent comp, boolean bFellow, boolean bListener, boolean bChildren) {
        if (this == comp || comp._parent != null || comp._next != null || comp._prev != null || comp._chdinf != null || comp._page != null) {
            throw new IllegalStateException();
        }
        comp._def = this._def;
        comp._uuid = this._uuid;
        AbstractComponent.removeFromIdSpaces(this);
        AbstractComponent p = comp._parent = this._parent;
        AbstractComponent q = comp._prev = this._prev;
        if (q != null) {
            q._next = comp;
        } else if (p != null) {
            p._chdinf.first = comp;
        }
        q = comp._next = this._next;
        if (q != null) {
            q._prev = comp;
        } else if (p != null) {
            p._chdinf.last = comp;
        }
        this._prev = null;
        this._next = null;
        this._parent = null;
        Page page = this._page;
        if (page != null) {
            comp._page = page;
            if (comp._parent == null) {
                ((AbstractPage)page).onReplaced(this, comp);
            }
            DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)page.getDesktop());
            desktopCtrl.mapComponent(this._uuid, comp);
            this._page = null;
        }
        comp._id = this._id;
        if (bFellow) {
            AbstractComponent.addToIdSpaces(comp);
        }
        if (this._auxinf != null) {
            comp._auxinf = this._auxinf.cloneStub(comp, bListener);
        }
        if (this._chdinf != null) {
            if (bChildren) {
                p = this._chdinf.first;
                while (p != null) {
                    p._parent = comp;
                    p = p._next;
                }
                comp._chdinf = this._chdinf;
                this._chdinf = null;
            } else if (comp instanceof StubsComponent) {
                ((StubsComponent)comp).onChildrenMerged(this, bListener);
            } else if (page != null) {
                AbstractComponent.childrenMerged((DesktopCtrl)((Object)page.getDesktop()), this._chdinf);
            }
        }
    }

    private static void childrenMerged(DesktopCtrl desktopCtrl, ChildInfo chdinf) {
        if (chdinf != null) {
            AbstractComponent p = chdinf.first;
            while (p != null) {
                desktopCtrl.removeComponent(p, false);
                AbstractComponent.childrenMerged(desktopCtrl, p._chdinf);
                p = p._next;
            }
        }
    }

    @Override
    public boolean appendChild(Component child) {
        return this.insertBefore(child, null);
    }

    @Override
    public boolean removeChild(Component child) {
        AbstractComponent oc = (AbstractComponent)child;
        if (oc._parent != this) {
            return false;
        }
        this.beforeChildRemoved(child);
        this.triggerBeforeHostChildRemoved(child);
        this.setNext(oc._prev, oc._next);
        this.setPrev(oc._next, oc._prev);
        oc._prev = null;
        oc._next = null;
        if (!this._chdinf.inRemoving(oc)) {
            this._chdinf.markRemoving(oc, true);
            try {
                oc.setParent(null);
            }
            finally {
                this._chdinf.markRemoving(oc, false);
            }
        } else {
            oc._parent = null;
        }
        ++this._chdinf.modCntChd;
        --this._chdinf.nChild;
        this.onChildRemoved(child);
        this.updateSubBindingAnnotationCount(-oc.initAuxInfo().subAnnotCnt);
        this.triggerAfterHostChildRemoved(child);
        return true;
    }

    protected boolean isChildable() {
        return true;
    }

    @Override
    public <T extends Component> List<T> getChildren() {
        return new Children();
    }

    @Override
    public Component getRoot() {
        Component comp = this;
        Component parent;
        while ((parent = comp.getParent()) != null) {
            comp = parent;
        }
        return comp;
    }

    @Override
    public boolean isVisible() {
        return this._auxinf == null || this._auxinf.visible;
    }

    @Override
    public boolean setVisible(boolean visible) {
        boolean old;
        boolean bl = old = this._auxinf == null || this._auxinf.visible;
        if (old != visible) {
            this.initAuxInfo().visible = visible;
            this.smartUpdate("visible", this._auxinf.visible);
        }
        return old;
    }

    protected void setVisibleDirectly(boolean visible) {
        this.initAuxInfo().visible = visible;
    }

    @Override
    public String getStubonly() {
        byte v;
        byte by = v = this._auxinf != null ? this._auxinf.stubonly : (byte)0;
        return v == 0 ? "inherit" : (v < 0 ? "false" : "true");
    }

    @Override
    public void setStubonly(String stubonly) {
        byte v;
        if ("false".equals(stubonly)) {
            v = -1;
        } else if ("true".equals(stubonly)) {
            v = 1;
        } else if ("inherit".equals(stubonly)) {
            v = 0;
        } else {
            throw new UiException("Not allowed: " + stubonly);
        }
        if ((this._auxinf != null ? this._auxinf.stubonly : (byte)0) != v) {
            this.initAuxInfo().stubonly = v;
        }
    }

    @Override
    public void setStubonly(boolean stubonly) {
        this.setStubonly(stubonly ? "true" : "false");
    }

    @Override
    public boolean isInvalidated() {
        return this._page == null || this.getAttachedUiEngine().isInvalidated(this);
    }

    @Override
    public void invalidate() {
        if (this._page != null) {
            this.getAttachedUiEngine().addInvalidate(this);
        }
    }

    protected void response(AuResponse response) {
        this.response(response.getOverrideKey(), response);
    }

    protected void response(String key, AuResponse response) {
        this.response(key, response, 0);
    }

    protected void response(String key, AuResponse response, int priority) {
        UiEngine uieng;
        if (this._page != null) {
            this.getAttachedUiEngine().addResponse(key, response, priority);
        } else if (response.getDepends() != this && (uieng = this.getCurrentUiEngine()) != null) {
            uieng.addResponse(key, response);
        }
    }

    protected void smartUpdate(String attr, Object value) {
        this.smartUpdate(attr, value, false);
    }

    protected void smartUpdate(String attr, Object value, boolean append) {
        if (this._page != null) {
            this.getAttachedUiEngine().addSmartUpdate((Component)this, attr, value, append);
        }
    }

    protected void smartUpdate(String attr, int value) {
        this.smartUpdate(attr, new Integer(value));
    }

    protected void smartUpdate(String attr, long value) {
        this.smartUpdate(attr, new Long(value));
    }

    protected void smartUpdate(String attr, byte value) {
        this.smartUpdate(attr, new Byte(value));
    }

    protected void smartUpdate(String attr, char value) {
        this.smartUpdate(attr, new Character(value));
    }

    protected void smartUpdate(String attr, boolean value) {
        this.smartUpdate(attr, (Object)value);
    }

    protected void smartUpdate(String attr, float value) {
        this.smartUpdate(attr, new Float(value));
    }

    protected void smartUpdate(String attr, double value) {
        this.smartUpdate(attr, new Double(value));
    }

    protected void smartUpdateWidgetListener(String evtnm, String script) {
        this.smartUpdate("listener", new String[]{evtnm, script}, true);
    }

    protected void smartUpdateWidgetOverride(String name, String script) {
        this.smartUpdate("override", new Object[]{name, new JavaScriptValue(script)}, true);
    }

    @Override
    public void detach() {
        if (this.getParent() != null) {
            this.setParent(null);
        } else {
            this.setPage(null);
        }
    }

    @Override
    public void beforeChildAdded(Component child, Component insertBefore) {
    }

    @Override
    public void beforeChildRemoved(Component child) {
    }

    @Override
    public void beforeParentChanged(Component parent) {
        if (parent == null) {
            WebApps.getCurrent().getConfiguration().invokeCallback("destroy", this);
        }
    }

    @Override
    public void onChildAdded(Component child) {
        this.processCallback("afterChildAdded");
    }

    @Override
    public void onChildRemoved(Component child) {
        this.processCallback("afterChildRemoved");
    }

    @Override
    public void onPageAttached(Page newpage, Page oldpage) {
        if (oldpage == null) {
            this.onListenerChange(newpage.getDesktop(), true);
        }
        this.processCallback("afterPageAttached");
    }

    @Override
    public void onPageDetached(Page page) {
        this.onListenerChange(page.getDesktop(), false);
        this.processCallback("afterPageDetached");
    }

    private void processCallback(String name) {
        Collection<Callback> callbacks = this.getCallback(name);
        for (Callback callback : new ArrayList<Callback>(callbacks)) {
            callback.call(this);
            this.removeCallback(name, callback);
        }
    }

    @Override
    public String getWidgetClass() {
        if (this._auxinf != null && this._auxinf.wgtcls != null) {
            return this._auxinf.wgtcls;
        }
        String widgetClass = this._def.getWidgetClass(this, this.getMold());
        return widgetClass != null ? widgetClass : this._def.getDefaultWidgetClass(this);
    }

    @Override
    public void setWidgetClass(String wgtcls) {
        if (wgtcls != null && wgtcls.length() > 0) {
            this.initAuxInfo().wgtcls = wgtcls;
        } else if (this._auxinf != null) {
            this._auxinf.wgtcls = null;
        }
    }

    @Override
    public String getMold() {
        String mold = this._auxinf != null ? this._auxinf.mold : null;
        return mold != null ? mold : DEFAULT;
    }

    @Override
    public void setMold(String mold) {
        if (mold != null && (DEFAULT.equals(mold) || mold.length() == 0)) {
            mold = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.mold : DEFAULT), (Object)mold)) {
            if (!this._def.hasMold(mold != null ? mold : DEFAULT)) {
                throw new UiException("Unknown mold: " + mold + "; allowed: " + this._def.getMoldNames());
            }
            String oldtype = this.getWidgetClass();
            this.initAuxInfo().mold = mold;
            if (Objects.equals((Object)oldtype, (Object)this.getWidgetClass())) {
                this.smartUpdate("mold", this.getMold());
            } else {
                this.invalidate();
            }
        }
    }

    protected String getSpecialRendererOutput(Component comp) throws IOException {
        if (this._page != null) {
            JsContentRenderer renderer = new JsContentRenderer();
            PropertiesRenderer[] prs = this._page.getDesktop().getWebApp().getConfiguration().getPropertiesRenderers();
            for (int j = 0; j < prs.length; ++j) {
                prs[j].renderProperties(comp, renderer);
            }
            return renderer.getBuffer().toString();
        }
        return "";
    }

    @Override
    public boolean disableClientUpdate(boolean disable) {
        UiEngine uieng = this._page != null ? this.getAttachedUiEngine() : this.getCurrentUiEngine();
        return uieng != null && uieng.disableClientUpdate(this, disable);
    }

    @Override
    public boolean addRedrawCallback(Callback<ContentRenderer> callback) {
        return this.addCallback("redraw", callback);
    }

    @Override
    public boolean removeRedrawCallback(Callback<ContentRenderer> callback) {
        return this.removeCallback("redraw", callback);
    }

    @Override
    public Collection<Callback<ContentRenderer>> getRedrawCallback() {
        return Generics.cast(this.getCallback("redraw"));
    }

    @Override
    public boolean addCallback(String name, Callback callback) {
        LinkedList<Callback> list;
        if (callback == null) {
            throw new IllegalArgumentException();
        }
        if (this.initAuxInfo().callbacks == null) {
            this._auxinf.callbacks = new LinkedHashMap(2);
        }
        if ((list = (LinkedList<Callback>)this._auxinf.callbacks.get(name)) == null) {
            list = new LinkedList<Callback>();
            this._auxinf.callbacks.put(name, list);
        }
        return list.add(callback);
    }

    @Override
    public boolean removeCallback(String name, Callback callback) {
        List list;
        if (this.initAuxInfo().callbacks != null && (list = (List)this._auxinf.callbacks.get(name)) != null) {
            return list.remove(callback);
        }
        return false;
    }

    @Override
    public Collection<Callback> getCallback(String name) {
        List list;
        if (this.initAuxInfo().callbacks != null && (list = (List)this._auxinf.callbacks.get(name)) != null) {
            return Generics.cast((List)list);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redraw(Writer out) throws IOException {
        String extra;
        int order = ComponentRedraws.beforeRedraw(false);
        boolean aupg = this.isAsyncUpdate();
        try {
            String wgtcls;
            if (order < 0) {
                if (aupg) {
                    out.write(91);
                } else {
                    out.write(HtmlPageRenders.outSpecialJS(this.getDesktop()));
                    out.write("zkx(");
                }
            } else if (order > 0) {
                out.write(44);
            }
            JsContentRenderer renderer = new JsContentRenderer();
            this.renderProperties(renderer);
            if (this._page != null) {
                PropertiesRenderer[] prs = this._page.getDesktop().getWebApp().getConfiguration().getPropertiesRenderers();
                for (int j = 0; j < prs.length; ++j) {
                    prs[j].renderProperties(this, renderer);
                }
            }
            JSCumulativeContentRenderer serenderer = null;
            Collection<Callback<ContentRenderer>> redrawCallback = this.getRedrawCallback();
            if (!redrawCallback.isEmpty()) {
                serenderer = new JSCumulativeContentRenderer();
                for (Callback<ContentRenderer> callback : redrawCallback) {
                    callback.call(serenderer);
                }
            }
            if ((wgtcls = this.getWidgetClass()) == null) {
                throw new UiException("Widget class required for " + this + " with " + this.getMold());
            }
            out.write("\n['");
            out.write(wgtcls);
            out.write("','");
            out.write(this.getUuid());
            out.write("',{");
            out.write(renderer.getBuffer().toString());
            out.write("},{");
            out.write(serenderer == null ? "" : serenderer.toString());
            out.write("},[");
            this.redrawChildren(out);
            out.write(93);
            String mold = this.getMold();
            if (!DEFAULT.equals(mold)) {
                out.write(",'");
                out.write(mold);
                out.write(39);
            }
            out.write(93);
        }
        finally {
            extra = ComponentRedraws.afterRedraw();
        }
        if (order < 0) {
            if (aupg) {
                if (extra.length() > 0) {
                    out.write(",0,null,'");
                    out.write(Strings.escape((String)extra, (String)"'\n\r\t\f\\/!"));
                    out.write(39);
                }
                out.write(93);
            } else {
                if (extra.length() > 0) {
                    out.write(",1");
                }
                out.write(");\n");
                out.write(extra);
            }
        }
    }

    private final boolean isAsyncUpdate() {
        Execution exec = Executions.getCurrent();
        return exec != null && exec.isAsyncUpdate(this._page);
    }

    protected void redrawChildren(Writer out) throws IOException {
        Set<? extends Component> crop;
        Object xc = this.getExtraCtrl();
        if (xc instanceof Cropper && (crop = ((Cropper)xc).getAvailableAtClient()) != null) {
            for (Component component : crop) {
                if (component.getParent() != this) continue;
                ((ComponentCtrl)((Object)component)).redraw(out);
            }
            return;
        }
        Component child = this.getFirstChild();
        while (child != null) {
            Component next = child.getNextSibling();
            ((ComponentCtrl)((Object)child)).redraw(out);
            child = next;
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Object o;
        this.render(renderer, "id", this._id);
        if (this._auxinf != null && !this._auxinf.visible) {
            renderer.render("visible", false);
        }
        this.render(renderer, "autag", this.getAutag());
        Desktop desktop = this.getDesktop();
        if (this instanceof IdSpace && this.getAttribute("z$is") == null) {
            renderer.render("z$is", true);
        }
        Boolean shallHandleImportant = null;
        for (Map.Entry<String, Integer> me : this.getClientEvents().entrySet()) {
            String evtnm = me.getKey();
            int flags = me.getValue();
            boolean isImportant = false;
            boolean isListened = false;
            if ((flags & 1) != 0) {
                if (shallHandleImportant == null) {
                    shallHandleImportant = Utils.markClientInfoPerDesktop(desktop, this.getWidgetClass());
                }
                if (shallHandleImportant.booleanValue()) {
                    renderer.render("$$" + evtnm, (flags & 2) != 0);
                }
                isImportant = true;
            }
            if (Events.isListened(this, evtnm, false)) {
                renderer.render('$' + evtnm, Events.isListened(this, evtnm, true));
                isListened = true;
            }
            if ((flags & 0x2000) != 0 && (isImportant || isListened)) {
                renderer.render("$$0" + evtnm, true);
            }
            if ((flags & 0x4000) == 0 || !isImportant && !isListened) continue;
            renderer.render("$$1" + evtnm, true);
        }
        if (this._auxinf != null) {
            this._auxinf.render(renderer);
        }
        if ((o = this.getAttribute("$composer")) != null) {
            renderer.render("$ZKAUS$", Boolean.TRUE);
        }
        if ((o = this.getAttribute("org.zkoss.zul.client.rod")) != null) {
            renderer.render("z$rod", o instanceof Boolean && (Boolean)o != false || !"false".equals(o));
        }
    }

    protected void render(ContentRenderer renderer, String name, String value) throws IOException {
        if (value != null && value.length() > 0) {
            renderer.render(name, value);
        }
    }

    protected void render(ContentRenderer renderer, String name, Object value) throws IOException {
        if (value instanceof String) {
            this.render(renderer, name, (String)value);
        } else if (value != null) {
            renderer.render(name, value);
        }
    }

    protected void render(ContentRenderer renderer, String name, boolean value) throws IOException {
        if (value) {
            renderer.render(name, true);
        }
    }

    @Override
    public Map<String, Integer> getClientEvents() {
        for (Class<?> cls = this.getClass(); cls != null; cls = cls.getSuperclass()) {
            Map<String, Integer> events = _clientEvents.get(cls);
            if (events == null) continue;
            return events;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addClientEvent(Class<? extends Component> cls, String evtnm, int flags) {
        Map<String, Integer> events = _clientEvents.get(cls);
        if (events == null) {
            Class<? extends Component> clazz = cls;
            synchronized (clazz) {
                events = _clientEvents.get(cls);
                if (events == null) {
                    events = new ConcurrentHashMap<String, Integer>(8);
                    for (Class<? extends Component> c = cls; c != null; c = c.getSuperclass()) {
                        Map<String, Integer> evts = _clientEvents.get(c);
                        if (evts == null) continue;
                        events.putAll(evts);
                        break;
                    }
                    _clientEvents.put(cls, events);
                }
            }
        }
        events.put(evtnm, new Integer(flags));
    }

    @Override
    public boolean addEventListener(String evtnm, EventListener<? extends Event> listener) {
        return this.addEventListener(listener instanceof Express ? 1000 : 0, evtnm, listener);
    }

    @Override
    public boolean addEventListener(int priority, String evtnm, EventListener<? extends Event> listener) {
        Desktop desktop;
        if (evtnm == null || listener == null) {
            throw new IllegalArgumentException("null");
        }
        if (!Events.isValid(evtnm)) {
            throw new IllegalArgumentException("Invalid event name: " + evtnm);
        }
        boolean oldasap = Events.isListened(this, evtnm, true);
        if (this.initAuxInfo().listeners == null) {
            this._auxinf.listeners = new HashMap(8);
        }
        boolean found = false;
        LinkedList<EventListenerInfo> lis = (LinkedList<EventListenerInfo>)this._auxinf.listeners.get(evtnm);
        EventListenerInfo listenerInfo = new EventListenerInfo(priority, listener);
        if (lis != null) {
            EventListenerInfo li;
            Iterator<EventListenerInfo> it;
            if (Impls.duplicateListenerIgnored()) {
                it = lis.iterator();
                while (it.hasNext()) {
                    li = (EventListenerInfo)it.next();
                    if (!li.listener.equals(listener)) continue;
                    if (li.priority == priority) {
                        return false;
                    }
                    it.remove();
                    found = true;
                    break;
                }
            }
            it = lis.listIterator(lis.size());
            do {
                EventListenerInfo eventListenerInfo = li = it.hasPrevious() ? (EventListenerInfo)it.previous() : null;
            } while (li != null && li.priority < priority);
            if (li != null) {
                it.next();
            }
            it.add(listenerInfo);
        } else {
            lis = new LinkedList<EventListenerInfo>();
            this._auxinf.listeners.put(evtnm, lis);
            lis.add(listenerInfo);
        }
        if (!found && (desktop = this.getDesktop()) != null) {
            if ("onClientInfo".equals(evtnm)) {
                desktop.setAttribute("org.zkoss.desktop.clientinfo.enabled", true);
                this.response(new AuClientInfo(desktop));
            } else if ("onPiggyback".equals(evtnm)) {
                ((DesktopCtrl)((Object)desktop)).onPiggybackListened(this, true);
            } else if ("onVisibilityChange".equals(evtnm)) {
                desktop.setAttribute("org.zkoss.desktop.visibilitychange.enabled", true);
            } else if (this.getClientEvents().containsKey(evtnm)) {
                boolean asap = Events.isListened(this, evtnm, true);
                if (lis.size() == 1 || oldasap != asap) {
                    this.smartUpdate("$" + evtnm, asap);
                }
            }
        }
        return !found;
    }

    @Override
    public boolean removeEventListener(String evtnm, EventListener<? extends Event> listener) {
        if (evtnm == null || listener == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._auxinf != null && this._auxinf.listeners != null) {
            boolean oldasap = Events.isListened(this, evtnm, true);
            List lis = (List)this._auxinf.listeners.get(evtnm);
            if (lis != null) {
                Iterator it = lis.iterator();
                while (it.hasNext()) {
                    Desktop desktop;
                    EventListenerInfo li = (EventListenerInfo)it.next();
                    if (!li.listener.equals(listener)) continue;
                    it.remove();
                    if (lis.isEmpty()) {
                        this._auxinf.listeners.remove(evtnm);
                    }
                    if ((desktop = this.getDesktop()) != null) {
                        this.onListenerChange(desktop, false);
                        if (this.getClientEvents().containsKey(evtnm)) {
                            if (lis.isEmpty() && !Events.isListened(this, evtnm, false)) {
                                this.smartUpdate("$" + evtnm, null);
                            } else if (oldasap != Events.isListened(this, evtnm, true)) {
                                this.smartUpdate("$" + evtnm, !oldasap);
                            }
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean addForward(String orgEvent, Component target, String targetEvent) {
        return this.addForward0(orgEvent, target, targetEvent, null);
    }

    @Override
    public boolean addForward(String orgEvent, String targetPath, String targetEvent) {
        return this.addForward0(orgEvent, targetPath, targetEvent, null);
    }

    @Override
    public boolean addForward(String orgEvent, Component target, String targetEvent, Object eventData) {
        return this.addForward0(orgEvent, target, targetEvent, eventData);
    }

    @Override
    public boolean addForward(String orgEvent, String targetPath, String targetEvent, Object eventData) {
        return this.addForward0(orgEvent, targetPath, targetEvent, eventData);
    }

    private boolean addForward0(String orgEvent, Object target, String targetEvent, Object eventData) {
        LinkedList<TargetInfo> tis;
        ForwardInfo info;
        if (orgEvent == null) {
            orgEvent = "onClick";
        } else if (!Events.isValid(orgEvent)) {
            throw new IllegalArgumentException("Illegal event name: " + orgEvent);
        }
        if (targetEvent == null) {
            targetEvent = orgEvent;
        } else if (!Events.isValid(targetEvent)) {
            throw new IllegalArgumentException("Illegal event name: " + targetEvent);
        }
        if (this.initAuxInfo().forwards == null) {
            this._auxinf.forwards = new HashMap(4);
        }
        if ((info = (ForwardInfo)this._auxinf.forwards.get(orgEvent)) != null) {
            tis = info.targets;
            for (TargetInfo ti : tis) {
                if (!Objects.equals((Object)ti.target, (Object)target) || !Objects.equals((Object)ti.event, (Object)targetEvent)) continue;
                if (Objects.equals((Object)ti.data, (Object)eventData)) {
                    return false;
                }
                ti.data = eventData;
                return true;
            }
        } else {
            ForwardListener listener = new ForwardListener(orgEvent);
            this.addEventListener(orgEvent, listener);
            tis = new LinkedList<TargetInfo>();
            info = new ForwardInfo(listener, tis);
            this._auxinf.forwards.put(orgEvent, info);
        }
        tis.add(new TargetInfo(target, targetEvent, eventData));
        return true;
    }

    @Override
    public boolean removeForward(String orgEvent, Component target, String targetEvent) {
        return this.removeForward0(orgEvent, target, targetEvent);
    }

    @Override
    public boolean removeForward(String orgEvent, String targetPath, String targetEvent) {
        return this.removeForward0(orgEvent, targetPath, targetEvent);
    }

    private boolean removeForward0(String orgEvent, Object target, String targetEvent) {
        ForwardInfo info;
        if (this._auxinf != null && this._auxinf.forwards != null && (info = (ForwardInfo)this._auxinf.forwards.get(orgEvent)) != null) {
            List tis = info.targets;
            Iterator it = tis.iterator();
            while (it.hasNext()) {
                TargetInfo ti = (TargetInfo)it.next();
                if (!Objects.equals((Object)ti.event, (Object)targetEvent) || !Objects.equals((Object)ti.target, (Object)target)) continue;
                it.remove();
                if (tis.isEmpty()) {
                    this._auxinf.forwards.remove(orgEvent);
                    this.removeEventListener(orgEvent, info.listener);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isListenerAvailable(String evtnm, boolean asap) {
        List lis;
        if (this._auxinf != null && this._auxinf.listeners != null && (lis = (List)this._auxinf.listeners.get(evtnm)) != null) {
            if (!asap) {
                return !lis.isEmpty();
            }
            for (EventListenerInfo li : lis) {
                if (li.listener instanceof Deferrable && ((Deferrable)((Object)li.listener)).isDeferrable()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<EventListener<? extends Event>> getListenerIterator(String evtnm) {
        List lis;
        if (this._auxinf != null && this._auxinf.listeners != null && (lis = (List)this._auxinf.listeners.get(evtnm)) != null) {
            return CollectionsX.comodifiableIterator((Collection)lis, _listenerInfoConverter);
        }
        return CollectionsX.emptyIterator();
    }

    @Override
    public Iterable<EventListener<? extends Event>> getEventListeners(String evtnm) {
        List lis;
        if (this._auxinf != null && this._auxinf.listeners != null && (lis = (List)this._auxinf.listeners.get(evtnm)) != null) {
            return new Iterable<EventListener<? extends Event>>(){

                @Override
                public Iterator<EventListener<? extends Event>> iterator() {
                    return CollectionsX.comodifiableIterator((Collection)lis, (Converter)_listenerInfoConverter);
                }
            };
        }
        return CollectionsX.emptyIterable();
    }

    @Override
    public void applyProperties() {
        this._def.applyProperties(this);
    }

    @Override
    public ComponentDefinition getDefinition() {
        return this._def;
    }

    @Override
    public void setDefinition(ComponentDefinition compdef) {
        if (compdef == null) {
            throw new IllegalArgumentException("null");
        }
        if (!compdef.isInstance(this)) {
            throw new IllegalArgumentException("Incompatible " + compdef + " for " + this);
        }
        this._def = compdef;
    }

    @Override
    public void setDefinition(String name) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            ComponentDefinition compdef;
            ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
            PageDefinition pgdef = execCtrl.getCurrentPageDefinition();
            Page page = execCtrl.getCurrentPage();
            ComponentDefinition componentDefinition = pgdef != null ? pgdef.getComponentDefinition(name, true) : (compdef = page != null ? page.getComponentDefinition(name, true) : null);
            if (compdef == null) {
                compdef = Impls.getDefinitionByDeviceType(this, exec.getDesktop().getDeviceType(), name);
            }
            if (compdef != null) {
                this.setDefinition(compdef);
                return;
            }
        } else {
            for (String deviceType : LanguageDefinition.getDeviceTypes()) {
                ComponentDefinition compdef = Impls.getDefinitionByDeviceType(this, deviceType, name);
                if (compdef == null) continue;
                this.setDefinition(compdef);
                return;
            }
        }
        throw new ComponentNotFoundException(name + " not found");
    }

    @Override
    public ZScript getEventHandler(String evtnm) {
        EventHandler evthd = this._auxinf != null && this._auxinf.evthds != null ? this._auxinf.evthds.get(this, evtnm) : null;
        return evthd != null ? evthd.getZScript() : null;
    }

    @Override
    public void addSharedEventHandlerMap(EventHandlerMap evthds) {
        if (evthds != null && !evthds.isEmpty()) {
            this.unshareEventHandlerMap(false);
            if (this.initAuxInfo().evthds == null) {
                this._auxinf.evthds = evthds;
                this._auxinf.evthdsShared = true;
            } else {
                this._auxinf.evthds.addAll(evthds);
            }
            Desktop desktop = this.getDesktop();
            if (desktop != null) {
                this.onListenerChange(desktop, true);
            }
        }
    }

    @Override
    public Set<String> getEventHandlerNames() {
        if (this._auxinf != null && this._auxinf.evthds != null) {
            return this._auxinf.evthds.getEventNames();
        }
        return Collections.emptySet();
    }

    private void onListenerChange(Desktop desktop, boolean listen) {
        if (listen) {
            if (Events.isListened(this, "onClientInfo", false)) {
                this.response(new AuClientInfo(desktop));
                this.getDesktop().setAttribute("org.zkoss.desktop.clientinfo.enabled", true);
            }
            if (Events.isListened(this, "onPiggyback", false)) {
                ((DesktopCtrl)((Object)desktop)).onPiggybackListened(this, true);
            }
            if (Events.isListened(this, "onVisibilityChange", false)) {
                this.getDesktop().setAttribute("org.zkoss.desktop.visibilitychange.enabled", true);
            }
        } else if (!Events.isListened(this, "onPiggyback", false)) {
            ((DesktopCtrl)((Object)desktop)).onPiggybackListened(this, false);
        }
    }

    @Override
    public void addEventHandler(String name, EventHandler evthd) {
        if (name == null || evthd == null) {
            throw new IllegalArgumentException("name and evthd required");
        }
        this.unshareEventHandlerMap(true);
        this._auxinf.evthds.add(name, evthd);
    }

    private void unshareEventHandlerMap(boolean autocreate) {
        if (this._auxinf != null && this._auxinf.evthdsShared) {
            this._auxinf.evthds = (EventHandlerMap)this._auxinf.evthds.clone();
            this._auxinf.evthdsShared = false;
        } else if (autocreate && this.initAuxInfo().evthds == null) {
            this._auxinf.evthds = new EventHandlerMap();
        }
    }

    @Override
    public Annotation getAnnotation(String annotName) {
        return this.getAnnotation(null, annotName);
    }

    @Override
    public Annotation getAnnotation(String propName, String annotName) {
        return this._auxinf != null && this._auxinf.annots != null ? this._auxinf.annots.getAnnotation(propName, annotName) : null;
    }

    @Override
    public Collection<Annotation> getAnnotations(String propName, String annotName) {
        if (this._auxinf != null && this._auxinf.annots != null) {
            return this._auxinf.annots.getAnnotations(propName, annotName);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return this.getAnnotations(null);
    }

    @Override
    public Collection<Annotation> getAnnotations(String propName) {
        if (this._auxinf != null && this._auxinf.annots != null) {
            return this._auxinf.annots.getAnnotations(propName);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAnnotatedPropertiesBy(String annotName) {
        if (this._auxinf != null && this._auxinf.annots != null) {
            return this._auxinf.annots.getAnnotatedPropertiesBy(annotName);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAnnotatedProperties() {
        if (this._auxinf != null && this._auxinf.annots != null) {
            return this._auxinf.annots.getAnnotatedProperties();
        }
        return Collections.emptyList();
    }

    private void addSharedAnnotationMap(AnnotationMap annots) {
        if (annots != null && !annots.isEmpty()) {
            this.unshareAnnotationMap(false);
            if (this.initAuxInfo().annots == null) {
                this._auxinf.annots = annots;
                this._auxinf.annotsShared = true;
            } else {
                this._auxinf.annots.addAll(annots);
            }
        }
    }

    @Override
    public void addAnnotation(String annotName, Map<String, String[]> annotAttrs) {
        this.addAnnotation(null, annotName, annotAttrs);
    }

    @Override
    public void addAnnotation(String propName, String annotName, Map<String, String[]> annotAttrs) {
        this.unshareAnnotationMap(true);
        this._auxinf.annots.addAnnotation(propName, annotName, this.fixAttrValues(annotAttrs), null);
    }

    private Map<String, String[]> fixAttrValues(Map<?, ?> attrs) {
        if (attrs == null) {
            return null;
        }
        for (Map.Entry<?, ?> m0 : attrs.entrySet()) {
            Object key = m0.getKey();
            Object val = m0.getValue();
            if ((key == null || key instanceof String) && (val == null || val instanceof String[])) continue;
            LinkedHashMap<String, String[]> as = new LinkedHashMap<String, String[]>(4);
            for (Map.Entry<?, ?> me : attrs.entrySet()) {
                key = me.getKey();
                if (key != null && !(key instanceof String)) {
                    throw new UiException("Illegal attribute name, " + key);
                }
                val = me.getValue();
                if (val == null || val instanceof String[]) {
                    as.put((String)key, (String[])val);
                    continue;
                }
                if (val instanceof String) {
                    as.put((String)key, new String[]{(String)val});
                    continue;
                }
                throw new UiException("Illegagl attribute value, " + val);
            }
            return as;
        }
        return Generics.cast(attrs);
    }

    private void unshareAnnotationMap(boolean autocreate) {
        if (this._auxinf != null && this._auxinf.annotsShared) {
            this._auxinf.annots = (AnnotationMap)this._auxinf.annots.clone();
            this._auxinf.annotsShared = false;
        } else if (autocreate && this.initAuxInfo().annots == null) {
            this._auxinf.annots = new AnnotationMap();
        }
    }

    @Override
    public void sessionWillPassivate(Page page) {
        LinkedHashSet<Object> uniqueAttrs = new LinkedHashSet<Object>();
        if (this._auxinf != null && this._auxinf.attrs != null) {
            uniqueAttrs.addAll(this._auxinf.attrs.getAttributes().values());
            this.willPassivate(uniqueAttrs);
            this.willPassivate(this._auxinf.attrs.getListeners());
        }
        if (this._auxinf != null && this._auxinf.listeners != null) {
            Iterator it = CollectionsX.comodifiableIterator(this._auxinf.listeners.values());
            while (it.hasNext()) {
                for (EventListenerInfo li : (List)it.next()) {
                    if (!uniqueAttrs.add(li.listener)) continue;
                    this.willPassivate(li.listener);
                }
            }
        }
        AbstractComponent p = (AbstractComponent)this.getFirstChild();
        while (p != null) {
            p.sessionWillPassivate(page);
            p = p._next;
        }
    }

    @Override
    public void sessionDidActivate(Page page) {
        this._page = page;
        LinkedHashSet<Object> uniqueAttrs = new LinkedHashSet<Object>();
        if (this._auxinf != null && this._auxinf.attrs != null) {
            uniqueAttrs.addAll(this._auxinf.attrs.getAttributes().values());
            this.didActivate(uniqueAttrs);
            this.didActivate(this._auxinf.attrs.getListeners());
            if (this._parent == null) {
                this._auxinf.attrs.notifyParentChanged(this._page);
            }
        }
        if (this._auxinf != null && this._auxinf.listeners != null) {
            Iterator it = CollectionsX.comodifiableIterator(this._auxinf.listeners.values());
            while (it.hasNext()) {
                Iterator itli = CollectionsX.comodifiableIterator((Collection)((Collection)it.next()));
                while (itli.hasNext()) {
                    EventListenerInfo li = (EventListenerInfo)itli.next();
                    if (!uniqueAttrs.add(li.listener)) continue;
                    this.didActivate(li.listener);
                }
            }
        }
        AbstractComponent p = (AbstractComponent)this.getFirstChild();
        while (p != null) {
            p.sessionDidActivate(page);
            p = p._next;
        }
    }

    protected void willPassivate(Collection<?> c) {
        if (c != null) {
            Iterator<?> it = new ArrayList(c).iterator();
            while (it.hasNext()) {
                this.willPassivate(it.next());
            }
        }
    }

    protected void willPassivate(Object o) {
        if (o instanceof ComponentActivationListener) {
            ((ComponentActivationListener)o).willPassivate(this);
        }
    }

    protected void didActivate(Collection<?> c) {
        if (c != null) {
            Iterator<?> it = new ArrayList(c).iterator();
            while (it.hasNext()) {
                this.didActivate(it.next());
            }
        }
    }

    protected void didActivate(Object o) {
        if (o instanceof ComponentActivationListener) {
            ((ComponentActivationListener)o).didActivate(this);
        }
    }

    @Override
    public Object getExtraCtrl() {
        return null;
    }

    @Override
    public PropertyAccess getPropertyAccess(String prop) {
        return _properties.get(prop);
    }

    @Override
    public WrongValueException onWrongValue(WrongValueException ex) {
        return ex;
    }

    @Override
    public AuService getAuService() {
        return this._auxinf != null ? this._auxinf.ausvc : null;
    }

    @Override
    public void setAuService(AuService ausvc) {
        if (ausvc != null) {
            this.initAuxInfo().ausvc = ausvc;
        } else if (this._auxinf != null) {
            this._auxinf.ausvc = null;
        }
    }

    @Override
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("echo".equals(cmd)) {
            List data2 = (List)request.getData().get("");
            Events.postEvent(new Event((String)data2.get(0), this, data2.size() > 1 ? AuEcho.getData(this, data2.get(1)) : null));
        } else if ("setAttr".equals(cmd)) {
            List data2 = (List)request.getData().get("");
            this.updateByClient((String)data2.get(0), data2.get(1));
        } else {
            Events.postEvent(Event.getEvent(request));
        }
    }

    @Override
    public void service(Event event, Scope scope) throws Exception {
        String evtnm = event.getName();
        Method mtd = ComponentsCtrl.getEventMethod(this.getClass(), evtnm);
        if (this._auxinf != null) {
            this.service(event, scope, this._auxinf.listeners != null ? (List)this._auxinf.listeners.get(evtnm) : null, this._auxinf.evthds != null ? this._auxinf.evthds.get(this, evtnm) : null, mtd, false);
        } else {
            this.service(event, scope, null, null, mtd, false);
        }
    }

    void service(Event event, Scope scope, List<EventListenerInfo> listeners, EventHandler evthd, Method mtd, boolean skipPageListener) throws Exception {
        Page page;
        Execution exec = Executions.getCurrent();
        Desktop desktop = exec.getDesktop();
        Page page2 = page = this._page != null ? this._page : desktop.getFirstPage();
        if (page == null || !page.isAlive()) {
            String msg = page == null ? "No page is available in " + desktop : "Page " + page + " was destroyed";
            msg = desktop.isAlive() ? msg + " (but desktop is alive)" : msg + " because desktop was destroyed.\nIt is usually caused by invalidating the native session directly. If it is required, please set Attributes.RENEW_NATIVE_SESSION first.";
            log.warn(msg);
        }
        ExecInfo execinf = new ExecInfo(event);
        ((ExecutionCtrl)((Object)exec)).setExecutionInfo(execinf);
        if (listeners != null) {
            for (EventListenerInfo li : new LinkedList<EventListenerInfo>(listeners)) {
                if (li.priority < 1000) break;
                execinf.update(null, li.listener, null);
                AbstractComponent.onEvent(li.listener, event);
                if (event.isPropagatable()) continue;
                return;
            }
        }
        if (page != null && this.getDesktop() != null) {
            ZScript zscript;
            ZScript zScript = zscript = evthd != null ? evthd.getZScript() : null;
            if (zscript != null) {
                execinf.update(null, null, zscript);
                page.interpret(zscript.getLanguage(), zscript.getContent(page, this), scope);
                if (!event.isPropagatable()) {
                    return;
                }
            }
        }
        if (listeners != null) {
            for (EventListenerInfo li : new LinkedList<EventListenerInfo>(listeners)) {
                if (li.priority >= 1000) continue;
                execinf.update(null, li.listener, null);
                AbstractComponent.onEvent(li.listener, event);
                if (event.isPropagatable()) continue;
                return;
            }
        }
        if (mtd != null) {
            execinf.update(mtd, null, null);
            if (mtd.getParameterTypes().length == 0) {
                mtd.invoke((Object)this, (Object[])null);
            } else {
                mtd.invoke((Object)this, event);
            }
            if (!event.isPropagatable()) {
                return;
            }
        }
        if (!skipPageListener && page != null) {
            for (EventListener<? extends Event> el : page.getEventListeners(event.getName())) {
                execinf.update(null, el, null);
                AbstractComponent.onEvent(el, event);
                if (event.isPropagatable()) continue;
                return;
            }
        }
    }

    private static void onEvent(EventListener listener, Event event) throws Exception {
        listener.onEvent(event);
    }

    @Override
    public EventListenerMap getEventListenerMap() {
        return new EventListenerMapImpl(this._auxinf != null ? this._auxinf.listeners : null, this._auxinf != null ? this._auxinf.evthds : null);
    }

    protected void updateByClient(String name, Object value) {
        Method m;
        Object o = this.getAttribute("org.zkoss.zk.ui.updateByClient");
        if (!(o instanceof Boolean && ((Boolean)o).booleanValue() || o instanceof String && "true".equals(o))) {
            log.warn("Ignore update of " + name + "=" + value + " from client for " + this.getClass());
            return;
        }
        String mtdnm = Classes.toMethodName((String)name, (String)"set");
        Object[] args = new Object[]{value};
        try {
            m = Classes.getMethodByObject(this.getClass(), (String)mtdnm, (Object[])args);
        }
        catch (NoSuchMethodException ex) {
            try {
                m = Classes.getCloseMethod(this.getClass(), (String)mtdnm, (Class[])new Class[]{String.class});
            }
            catch (NoSuchMethodException e2) {
                try {
                    m = Classes.getCloseMethod(this.getClass(), (String)mtdnm, (Class[])new Class[]{null});
                }
                catch (NoSuchMethodException e3) {
                    log.warn("setter not found", (Throwable)ex);
                    return;
                }
            }
            try {
                args[0] = Classes.coerce(m.getParameterTypes()[0], (Object)value);
            }
            catch (Throwable e2) {
                log.warn(m + " requires " + m.getParameterTypes()[0] + ", not " + value);
                return;
            }
        }
        this.disableClientUpdate(true);
        try {
            m.invoke((Object)this, args);
        }
        catch (Throwable ex) {
            throw UiException.Aide.wrap(ex);
        }
        finally {
            this.disableClientUpdate(false);
        }
    }

    public String toString() {
        String clsnm = this.getClass().getName();
        int j = clsnm.lastIndexOf(46);
        return "<" + clsnm.substring(j + 1) + ' ' + this._uuid + (Strings.isEmpty((String)this._id) ? "" : "#" + this._id) + '>';
    }

    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public Object clone() {
        AbstractComponent clone;
        try {
            clone = (AbstractComponent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._page = null;
        clone._parent = null;
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)clone._auxinf.clone();
        }
        if (this._chdinf != null) {
            clone._chdinf = this._chdinf.clone(clone);
            AbstractComponent p = clone._chdinf.first;
            while (p != null) {
                if (p._auxinf != null && p._auxinf.attrs != null) {
                    p._auxinf.attrs.notifyParentChanged(clone);
                }
                p = p._next;
            }
        }
        if (this._auxinf != null) {
            this._auxinf.initClone(clone, clone._auxinf);
        }
        return clone;
    }

    private void cloneSpaceInfoFrom(SpaceInfo from) {
        if (!AbstractComponent.isAutoId(this._id)) {
            this.bindToIdSpace(this);
        }
        AbstractComponent p = (AbstractComponent)this.getFirstChild();
        while (p != null) {
            AbstractComponent.addToIdSpacesDown(p, (IdSpace)((Object)this));
            p = p._next;
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this._def == ComponentsCtrl.DUMMY) {
            s.writeObject(null);
        } else {
            LanguageDefinition langdef = this._def.getLanguageDefinition();
            if (langdef != null) {
                s.writeObject(langdef.getName());
                s.writeObject(this._def.getName());
            } else {
                s.writeObject(this._def);
            }
        }
        AbstractComponent p = (AbstractComponent)this.getFirstChild();
        while (p != null) {
            s.writeObject(p);
            p = p._next;
        }
        s.writeObject(null);
        if (this._auxinf == null) {
            return;
        }
        if (this._auxinf.attrs != null) {
            Map<String, Object> attrmap = this._auxinf.attrs.getAttributes();
            this.willSerialize(attrmap.values());
            List<ScopeListener> attrlns = this._auxinf.attrs.getListeners();
            this.willSerialize(attrlns);
            Serializables.smartWrite((ObjectOutputStream)s, attrmap);
            Serializables.smartWrite((ObjectOutputStream)s, attrlns);
        } else {
            Serializables.smartWrite((ObjectOutputStream)s, (Map)null);
            Serializables.smartWrite((ObjectOutputStream)s, (Collection)null);
        }
        EventListenerInfo.write(s, this, this._auxinf.listeners);
        this.willSerialize(this._auxinf.ausvc);
        Serializables.smartWrite((ObjectOutputStream)s, (Object)this._auxinf.ausvc);
    }

    protected void willSerialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.willSerialize(it.next());
            }
        }
    }

    protected void willSerialize(Object o) {
        if (o instanceof ComponentSerializationListener) {
            ((ComponentSerializationListener)o).willSerialize(this);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object def = s.readObject();
        if (def instanceof String) {
            LanguageDefinition langdef = null;
            try {
                langdef = LanguageDefinition.lookup((String)def);
            }
            catch (DefinitionNotFoundException definitionNotFoundException) {
                // empty catch block
            }
            if (langdef != null) {
                this._def = langdef.getComponentDefinitionIfAny((String)s.readObject());
            } else {
                s.readObject();
                this._def = null;
            }
        } else {
            this._def = (ComponentDefinition)def;
        }
        if (this._def == null) {
            this._def = ComponentsCtrl.DUMMY;
        }
        AbstractComponent q = null;
        while (true) {
            AbstractComponent child;
            if ((child = (AbstractComponent)s.readObject()) == null) {
                if (this._chdinf == null) break;
                this._chdinf.last = q;
                break;
            }
            ++this.initChildInfo().nChild;
            if (q != null) {
                q._next = child;
            } else {
                this._chdinf.first = child;
            }
            child._prev = q;
            child._parent = this;
            q = child;
        }
        if (this._auxinf == null) {
            return;
        }
        this.attrs();
        Map<String, Object> attrmap = this._auxinf.attrs.getAttributes();
        Serializables.smartRead((ObjectInputStream)s, attrmap);
        List<ScopeListener> attrlns = this._auxinf.attrs.getListeners();
        Serializables.smartRead((ObjectInputStream)s, attrlns);
        if (attrmap.isEmpty() && attrlns.isEmpty()) {
            this._auxinf.attrs = null;
        } else if (this._parent != null) {
            this._auxinf.attrs.notifyParentChanged(this._parent);
        }
        this._auxinf.listeners = EventListenerInfo.read(s, this);
        if (this instanceof IdSpace) {
            this._auxinf.spaceInfo = new SpaceInfo();
            if (!AbstractComponent.isAutoId(this._id)) {
                this.bindToIdSpace(this);
            }
            AbstractComponent ac = (AbstractComponent)this.getFirstChild();
            while (ac != null) {
                AbstractComponent.addToIdSpacesDown(ac, (IdSpace)((Object)this));
                ac = ac._next;
            }
        }
        this.didDeserialize(attrmap.values());
        this.didDeserialize(attrlns);
        this.didDeserialize(this._auxinf.ausvc = (AuService)s.readObject());
    }

    protected void didDeserialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.didDeserialize(it.next());
            }
        }
    }

    protected void didDeserialize(Object o) {
        if (o instanceof ComponentSerializationListener) {
            ((ComponentSerializationListener)o).didDeserialize(this);
        }
    }

    private Component resolveForwardTarget(Object target) {
        return target instanceof String ? Components.pathToComponent((String)target, this) : (Component)target;
    }

    protected String getDefaultMold(Class<? extends Component> klass) {
        return Impls.defaultMold(klass);
    }

    private final AuxInfo initAuxInfo() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    @Override
    public Template getTemplate(String name) {
        return this._auxinf != null && this._auxinf.templates != null ? (Template)this._auxinf.templates.get(name) : null;
    }

    @Override
    public Template setTemplate(String name, Template template) {
        if (template == null) {
            return this._auxinf != null && this._auxinf.templates != null ? (Template)this._auxinf.templates.remove(name) : null;
        }
        AuxInfo auxinf = this.initAuxInfo();
        if (auxinf.templates == null) {
            auxinf.templates = new HashMap(4);
        }
        return auxinf.templates.put(name, template);
    }

    @Override
    public Set<String> getTemplateNames() {
        if (this._auxinf != null && this._auxinf.templates != null) {
            return this._auxinf.templates.keySet();
        }
        return Collections.emptySet();
    }

    @Override
    public Component query(String selector) {
        Iterator<Component> found = Selectors.iterable(this, selector).iterator();
        return found.hasNext() ? found.next() : null;
    }

    @Override
    public Iterable<Component> queryAll(String selector) {
        return Selectors.iterable(this, selector);
    }

    private final ChildInfo initChildInfo() {
        if (this._chdinf == null) {
            this._chdinf = new ChildInfo();
        }
        return this._chdinf;
    }

    Map<Component, Integer> initIndexCacheMap() {
        Map<Component, Integer> distributedIndexInfo = this.getIndexCacheMap();
        if (distributedIndexInfo == null) {
            distributedIndexInfo = new HashMap<Component, Integer>(this.getChildren().size());
            ShadowElementsCtrl.setDistributedIndexInfo(distributedIndexInfo);
        }
        return distributedIndexInfo;
    }

    Map<Component, Integer> getIndexCacheMap() {
        return (Map)ShadowElementsCtrl.getDistributedIndexInfo();
    }

    void destroyIndexCacheMap() {
        ShadowElementsCtrl.setDistributedIndexInfo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerBeforeHostParentChanged(Component parent) {
        List shadowRoots = this.getShadowRoots();
        if (!shadowRoots.isEmpty()) {
            try {
                this.initIndexCacheMap();
                for (ShadowElement se : new LinkedList(shadowRoots)) {
                    if (!(se instanceof ShadowElementCtrl)) continue;
                    ((ShadowElementCtrl)((Object)se)).beforeHostParentChanged(parent);
                }
            }
            finally {
                this.destroyIndexCacheMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerBeforeHostChildRemoved(Component child) {
        List shadowRoots = this.getShadowRoots();
        if (!shadowRoots.isEmpty()) {
            try {
                this.initIndexCacheMap();
                int indexOf = this.getChildren().indexOf(child);
                for (ShadowElement se : new LinkedList(shadowRoots)) {
                    if (!(se instanceof ShadowElementCtrl)) continue;
                    ((ShadowElementCtrl)((Object)se)).beforeHostChildRemoved(child, indexOf);
                }
            }
            finally {
                this.destroyIndexCacheMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerAfterHostChildRemoved(Component child) {
        List shadowRoots = this.getShadowRoots();
        if (!shadowRoots.isEmpty()) {
            try {
                this.initIndexCacheMap();
                for (ShadowElement se : new LinkedList(shadowRoots)) {
                    if (!(se instanceof ShadowElementCtrl)) continue;
                    ((ShadowElementCtrl)((Object)se)).afterHostChildRemoved(child);
                }
            }
            finally {
                this.destroyIndexCacheMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerBeforeHostChildAdded(Component child, Component insertBefore) {
        List shadowRoots = this.getShadowRoots();
        if (!shadowRoots.isEmpty()) {
            try {
                this.initIndexCacheMap();
                int indexOfInsertBefore = insertBefore == null ? -1 : this.getChildren().indexOf(insertBefore);
                for (ShadowElement se : new LinkedList(shadowRoots)) {
                    if (!(se instanceof ShadowElementCtrl)) continue;
                    ((ShadowElementCtrl)((Object)se)).beforeHostChildAdded(child, insertBefore, indexOfInsertBefore);
                }
            }
            finally {
                this.destroyIndexCacheMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerAfterHostChildAdded(Component child) {
        List shadowRoots = this.getShadowRoots();
        if (!shadowRoots.isEmpty()) {
            try {
                this.initIndexCacheMap();
                int indexOf = this.getChildren().indexOf(child);
                for (ShadowElement se : new LinkedList(shadowRoots)) {
                    if (!(se instanceof ShadowElementCtrl)) continue;
                    ((ShadowElementCtrl)((Object)se)).afterHostChildAdded(child, indexOf);
                }
            }
            finally {
                this.destroyIndexCacheMap();
            }
        }
    }

    @Override
    public <T extends ShadowElement> List<T> getShadowRoots() {
        return this._auxinf != null && this._auxinf.seRoots != null ? this._auxinf.seRoots : Collections.EMPTY_LIST;
    }

    @Override
    public boolean removeShadowRoot(ShadowElement shadow) {
        if (this._auxinf != null && this._auxinf.seRoots != null && this._auxinf.seRoots.remove(shadow)) {
            shadow.detach();
            AbstractComponent.removeFromShadowIdMap(this, (Component)((Object)shadow));
            return true;
        }
        return false;
    }

    @Override
    public boolean addShadowRoot(ShadowElement shadow) {
        if (shadow == null) {
            throw new IllegalArgumentException("Shadow element cannot be null!");
        }
        if (shadow.getShadowHost() == null) {
            ((ShadowElementCtrl)((Object)shadow)).setShadowHost(this, null);
        } else if (shadow.getShadowHost() != this) {
            throw new IllegalAccessError("The shadow element is not belonged to this host: [" + this + "]");
        }
        AuxInfo auxinf = this.initAuxInfo();
        if (auxinf.seRoots == null) {
            auxinf.seRoots = new LinkedList();
        }
        if (this._shadowIdMap == null) {
            this._shadowIdMap = new HashMap<String, ShadowElement>(4);
        }
        if (!auxinf.seRoots.contains(shadow)) {
            return auxinf.seRoots.add(shadow);
        }
        return false;
    }

    @Override
    public boolean addShadowRootBefore(ShadowElement shadow, ShadowElement insertBefore) {
        if (shadow == null) {
            throw new IllegalArgumentException("Shadow element cannot be null!");
        }
        if (insertBefore == null) {
            return this.addShadowRoot(shadow);
        }
        if (insertBefore.getShadowHost() != this) {
            throw new UiException("Wrong shadow host [" + insertBefore + "]");
        }
        AuxInfo auxinf = this.initAuxInfo();
        if (!auxinf.seRoots.contains(shadow)) {
            auxinf.seRoots.add(auxinf.seRoots.indexOf(insertBefore), shadow);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBindingAnnotation() {
        return this._auxinf != null && this._auxinf.hasBindingAnnot;
    }

    @Override
    public boolean hasSubBindingAnnotation() {
        return this._auxinf != null && this._auxinf.subAnnotCnt > 0;
    }

    @Override
    public int getSubBindingAnnotationCount() {
        return this._auxinf == null ? 0 : this._auxinf.subAnnotCnt;
    }

    protected void updateSubBindingAnnotationCount(int diff) {
        for (AbstractComponent node = this; node != null; node = (AbstractComponent)node.getParent()) {
            this.setSubBindingAnnotationCount(diff, node);
        }
    }

    protected void setSubBindingAnnotationCount(int diff, AbstractComponent node) {
        AuxInfo auxInfo = node.initAuxInfo();
        auxInfo.subAnnotCnt = auxInfo.subAnnotCnt + diff;
    }

    @Override
    public void enableBindingAnnotation() {
        this.setBindingAnnotation0(true);
    }

    @Override
    public void disableBindingAnnotation() {
        this.setBindingAnnotation0(false);
    }

    private void setBindingAnnotation0(boolean hasBindingAnnot) {
        AuxInfo auxinf = this.initAuxInfo();
        boolean old = auxinf.hasBindingAnnot;
        if (old != hasBindingAnnot) {
            int diff = hasBindingAnnot ? 1 : -1;
            auxinf.hasBindingAnnot = hasBindingAnnot;
            this.updateSubBindingAnnotationCount(diff);
        }
    }

    private static void addToShadowIdMap(Component comp) {
        Component host;
        if (comp instanceof ShadowElementCtrl && (host = ((ShadowElementCtrl)((Object)comp)).getShadowHostIfAny()) != null) {
            String id = comp.getId();
            AbstractComponent ac = (AbstractComponent)host;
            if (ac._shadowIdMap != null) {
                if (ac._shadowIdMap.get(id) != null) {
                    throw new InternalError("Caller shall prevent duplicated ID for shadow hosts");
                }
                ac._shadowIdMap.put(id, (ShadowElement)((Object)comp));
            }
        }
    }

    @Override
    public ShadowElement getShadowFellowIfAny(String id) {
        return this._shadowIdMap == null ? null : this._shadowIdMap.get(id);
    }

    private static void removeFromShadowIdMap(Component comp) {
        Component host;
        if (comp instanceof ShadowElementCtrl && (host = ((ShadowElementCtrl)((Object)comp)).getShadowHostIfAny()) != null) {
            AbstractComponent.removeFromShadowIdMap(host, comp);
        }
    }

    private static void removeFromShadowIdMap(Component host, Component comp) {
        if (host != null && comp instanceof ShadowElement) {
            String id = comp.getId();
            AbstractComponent ac = (AbstractComponent)host;
            if (ac._shadowIdMap != null) {
                ac._shadowIdMap.remove(id);
            }
        }
    }

    static {
        _properties = new HashMap(3);
        _properties.put("id", new StringPropertyAccess(){

            public void setValue(Component cmp, String id) {
                cmp.setId(id);
            }

            public String getValue(Component cmp) {
                return cmp.getId();
            }
        });
        _properties.put("mold", new StringPropertyAccess(){

            public void setValue(Component cmp, String mold) {
                cmp.setMold(mold);
            }

            public String getValue(Component cmp) {
                return cmp.getMold();
            }
        });
        _properties.put("visible", new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean visible) {
                cmp.setVisible(visible);
            }

            public Boolean getValue(Component cmp) {
                return cmp.isVisible();
            }
        });
        _listenerInfoConverter = new Converter<EventListenerInfo, EventListener<? extends Event>>(){

            public EventListener<? extends Event> convert(EventListenerInfo o) {
                return o.listener;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecInfo
    implements ExecutionInfo {
        private final Thread _thread = Thread.currentThread();
        private final Event _event;
        private Method _method;
        private EventListener<? extends Event> _listener;
        private ZScript _zscript;

        private ExecInfo(Event event) {
            this._event = event;
        }

        @Override
        public Thread getThread() {
            return this._thread;
        }

        @Override
        public Event getEvent() {
            return this._event;
        }

        @Override
        public Method getEventMethod() {
            return this._method;
        }

        @Override
        public EventListener<? extends Event> getEventListener() {
            return this._listener;
        }

        @Override
        public ZScript getEventZScript() {
            return this._zscript;
        }

        public void update(Method mtd, EventListener<? extends Event> ln, ZScript zs) {
            this._method = mtd;
            this._listener = ln;
            this._zscript = zs;
        }
    }

    private static class TargetInfo
    implements Serializable {
        private final Object target;
        private final String event;
        private Object data;

        private TargetInfo(Object target, String event, Object data) {
            this.target = target;
            this.event = event;
            this.data = data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardInfo
    implements Serializable {
        private final EventListener<? extends Event> listener;
        private final List<TargetInfo> targets;

        private ForwardInfo(EventListener<? extends Event> listener, List<TargetInfo> targets) {
            this.listener = listener;
            this.targets = targets;
        }
    }

    static class ChildInfo
    implements Cloneable {
        AbstractComponent first;
        AbstractComponent last;
        int nChild;
        private Set<Component>[] _aring;
        int modCntChd;
        private IdSpace vispace;

        private ChildInfo() {
        }

        public Object clone() {
            try {
                Object o = super.clone();
                ((ChildInfo)o).vispace = null;
                return o;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        private ChildInfo clone(AbstractComponent owner) {
            ChildInfo clone = (ChildInfo)this.clone();
            AbstractComponent q = null;
            AbstractComponent p = this.first;
            while (p != null) {
                AbstractComponent child = (AbstractComponent)p.clone();
                if (q != null) {
                    q._next = child;
                } else {
                    clone.first = child;
                }
                child._prev = q;
                q = child;
                child._parent = owner;
                p = p._next;
            }
            clone.last = q;
            return clone;
        }

        private boolean inRemoving(Component child) {
            return this._aring != null && this._aring[1] != null && this._aring[1].contains(child);
        }

        private void markRemoving(Component child, boolean set) {
            this.markARing(child, set, 1);
        }

        private boolean inAdding(Component child) {
            return this._aring != null && this._aring[0] != null && this._aring[0].contains(child);
        }

        private void markAdding(Component child, boolean set) {
            this.markARing(child, set, 0);
        }

        private void markARing(Component child, boolean set, int which) {
            if (set) {
                if (this._aring == null) {
                    this._aring = new Set[2];
                }
                if (this._aring[which] == null) {
                    this._aring[which] = new HashSet<Component>(2);
                }
                this._aring[which].add(child);
            } else if (this._aring != null && this._aring[which] != null && this._aring[which].remove(child) && this._aring[which].isEmpty()) {
                if (this._aring[which == 0 ? 1 : 0] == null) {
                    this._aring = null;
                } else {
                    this._aring[which] = null;
                }
            }
        }
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private List<ShadowElement> seRoots;
        private String mold;
        private transient SpaceInfo spaceInfo;
        private transient SimpleScope attrs;
        private transient Map<String, List<EventListenerInfo>> listeners;
        private AnnotationMap annots;
        private EventHandlerMap evthds;
        private Map<String, ForwardInfo> forwards;
        private transient AuService ausvc;
        private String wgtcls;
        private Map<String, String> wgtlsns;
        private Map<String, String> wgtovds;
        private Map<String, String> domattrs;
        private Map<String, List<Callback<?>>> callbacks;
        private String autag;
        private Map<String, Template> templates;
        private byte stubonly;
        private transient boolean annotsShared;
        private transient boolean evthdsShared;
        private boolean visible = true;
        private boolean hasBindingAnnot = false;
        private int subAnnotCnt = 0;

        private AuxInfo() {
        }

        public Object clone() {
            AuxInfo clone;
            try {
                clone = (AuxInfo)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
            if (this.wgtlsns != null) {
                clone.wgtlsns = new LinkedHashMap<String, String>(this.wgtlsns);
            }
            if (this.wgtovds != null) {
                clone.wgtovds = new LinkedHashMap<String, String>(this.wgtovds);
            }
            if (this.domattrs != null) {
                clone.domattrs = new LinkedHashMap<String, String>(this.domattrs);
            }
            if (this.callbacks != null) {
                clone.callbacks = new LinkedHashMap(this.callbacks);
            }
            if (!this.annotsShared && this.annots != null) {
                clone.annots = (AnnotationMap)this.annots.clone();
            }
            if (!this.evthdsShared && this.evthds != null) {
                clone.evthds = (EventHandlerMap)this.evthds.clone();
            }
            return clone;
        }

        private AuxInfo cloneStub(AbstractComponent owner, boolean bListener) {
            if (bListener && (this.evthds != null || this.listeners != null)) {
                AuxInfo clone = new AuxInfo();
                clone.evthdsShared = this.evthdsShared;
                clone.evthds = this.evthds;
                clone.listeners = this.listeners;
                return clone;
            }
            return null;
        }

        private void initClone(AbstractComponent owner, AuxInfo clone) {
            if (this.spaceInfo != null) {
                AbstractComponent abstractComponent = owner;
                abstractComponent.getClass();
                clone.spaceInfo = abstractComponent.new SpaceInfo();
                owner.cloneSpaceInfoFrom(this.spaceInfo);
            }
            if (this.attrs != null) {
                clone.attrs = this.attrs.clone(owner);
            }
            this.cloneListeners(owner, clone);
            if (this.forwards != null) {
                clone.forwards = null;
                for (Map.Entry<String, ForwardInfo> me : this.forwards.entrySet()) {
                    String orgEvent = me.getKey();
                    ForwardInfo info = me.getValue();
                    List tis = info.targets;
                    for (TargetInfo ti : tis) {
                        owner.addForward0(orgEvent, ti.target, ti.event, ti.data);
                    }
                }
            }
            if (this.ausvc instanceof ComponentCloneListener) {
                clone.ausvc = (AuService)((ComponentCloneListener)((Object)this.ausvc)).willClone(owner);
            }
        }

        private void cloneListeners(AbstractComponent owner, AuxInfo clone) {
            if (this.listeners != null) {
                clone.listeners = new HashMap<String, List<EventListenerInfo>>(4);
                for (Map.Entry<String, List<EventListenerInfo>> me : this.listeners.entrySet()) {
                    LinkedList<EventListenerInfo> list = new LinkedList<EventListenerInfo>();
                    for (EventListenerInfo li : me.getValue()) {
                        if (li.listener instanceof ComponentCloneListener) {
                            Object val = ((ComponentCloneListener)((Object)li.listener)).willClone(owner);
                            if (val == null) continue;
                            li = new EventListenerInfo(li.priority, (EventListener)val);
                        }
                        list.add(li);
                    }
                    if (list.isEmpty()) continue;
                    clone.listeners.put(me.getKey(), list);
                }
            }
        }

        private void render(ContentRenderer renderer) throws IOException {
            renderer.renderWidgetListeners(this.wgtlsns);
            renderer.renderWidgetOverrides(this.wgtovds);
            renderer.renderClientAttributes(this.domattrs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ForwardListener
    implements EventListener<Event>,
    ComponentCloneListener,
    Serializable {
        private final String _orgEvent;

        private ForwardListener(String orgEvent) {
            this._orgEvent = orgEvent;
        }

        @Override
        public void onEvent(Event event) {
            ForwardInfo info = (ForwardInfo)AbstractComponent.this._auxinf.forwards.get(this._orgEvent);
            if (info != null) {
                for (TargetInfo ti : new ArrayList(info.targets)) {
                    Component target = AbstractComponent.this.resolveForwardTarget(ti.target);
                    if (target == null) {
                        IdSpace owner = AbstractComponent.this.getSpaceOwner();
                        if (owner instanceof Component) {
                            target = (Component)((Object)owner);
                        } else {
                            Component p;
                            target = AbstractComponent.this;
                            while ((p = target.getParent()) != null) {
                                target = p;
                            }
                        }
                    }
                    Events.sendEvent(new ForwardEvent(ti.event, target, event, ti.data));
                }
            }
        }

        @Override
        public Object willClone(Component comp) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChildIter
    implements ListIterator<Component> {
        private AbstractComponent _p;
        private AbstractComponent _lastRet;
        private int _j;
        private int _modCntSnap;

        private ChildIter(int index) {
            int nChild;
            if (index < 0 || index > (nChild = AbstractComponent.this.nChild())) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + AbstractComponent.this.nChild());
            }
            if (index < nChild >> 1) {
                this._p = AbstractComponent.this._chdinf.first;
                this._j = 0;
                while (this._j < index) {
                    this._p = this._p._next;
                    ++this._j;
                }
            } else {
                this._p = null;
                this._j = nChild;
                while (this._j > index) {
                    this._p = this._p != null ? this._p._prev : AbstractComponent.this._chdinf.last;
                    --this._j;
                }
            }
            this._modCntSnap = AbstractComponent.this.modCntChd();
        }

        @Override
        public boolean hasNext() {
            return this._j < AbstractComponent.this.nChild();
        }

        @Override
        public Component next() {
            if (this._j >= AbstractComponent.this.nChild()) {
                throw new NoSuchElementException();
            }
            this.checkComodification();
            this._lastRet = this._p;
            this._p = this._p._next;
            ++this._j;
            return this._lastRet;
        }

        @Override
        public boolean hasPrevious() {
            return this._j > 0;
        }

        @Override
        public Component previous() {
            if (this._j <= 0) {
                throw new NoSuchElementException();
            }
            this.checkComodification();
            this._p = this._p != null ? this._p._prev : AbstractComponent.this._chdinf.last;
            this._lastRet = this._p;
            --this._j;
            return this._lastRet;
        }

        private void checkComodification() {
            if (AbstractComponent.this.modCntChd() != this._modCntSnap) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int nextIndex() {
            return this._j;
        }

        @Override
        public int previousIndex() {
            return this._j - 1;
        }

        @Override
        public void add(Component newChild) {
            if (newChild.getParent() == AbstractComponent.this) {
                throw new UnsupportedOperationException("Unable to add component with the same parent: " + newChild);
            }
            this.checkComodification();
            AbstractComponent.this.insertBefore(newChild, this._p);
            ++this._j;
            this._lastRet = null;
            ++this._modCntSnap;
        }

        @Override
        public void remove() {
            if (this._lastRet == null) {
                throw new IllegalStateException();
            }
            this.checkComodification();
            if (this._p == this._lastRet) {
                this._p = this._lastRet._next;
            } else {
                --this._j;
            }
            AbstractComponent.this.removeChild(this._lastRet);
            this._lastRet = null;
            ++this._modCntSnap;
        }

        @Override
        public void set(Component o) {
            throw new UnsupportedOperationException();
        }
    }

    private class SpaceInfo {
        private Map<String, Component> fellows = new HashMap<String, Component>(32);

        private SpaceInfo() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Children
    extends AbstractSequentialList<Component> {
        protected Children() {
        }

        @Override
        public int size() {
            return AbstractComponent.this.nChild();
        }

        @Override
        public ListIterator<Component> listIterator(int index) {
            return new ChildIter(index);
        }
    }
}

