/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.AnnotateBinder;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Validator;
import org.zkoss.bind.annotation.AfterCompose;
import org.zkoss.bind.annotation.HistoryPopState;
import org.zkoss.bind.annotation.ToServerCommand;
import org.zkoss.bind.impl.AbstractAnnotatedMethodInvoker;
import org.zkoss.bind.impl.AnnotationUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.bind.impl.ValidationMessagesImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.bind.sys.debugger.BindingAnnotationInfoChecker;
import org.zkoss.bind.sys.debugger.DebuggerFactory;
import org.zkoss.bind.tracker.impl.BindUiLifeCycle;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.util.CacheMap;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.HistoryPopStateEvent;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;
import org.zkoss.zk.ui.util.ConventionWires;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindComposer<T extends Component>
implements Composer<T>,
ComposerExt<T>,
Serializable,
AuService,
ComponentActivationListener {
    private static final long serialVersionUID = 1463169907348730644L;
    private static final Logger _log = LoggerFactory.getLogger(BindComposer.class);
    public static final String VM_ID = "$VM_ID$";
    public static final String BINDER_ID = "$BINDER_ID$";
    private Object _viewModel;
    private AnnotateBinder _binder;
    private final Map<String, Converter> _converters;
    private final Map<String, Validator> _validators;
    private final BindEvaluatorX evalx;
    protected static final String ID_ANNO = "id";
    protected static final String INIT_ANNO = "init";
    protected static final String VALUE_ANNO_ATTR = "value";
    protected static final String VIEW_MODEL_ATTR = "viewModel";
    protected static final String BINDER_ATTR = "binder";
    protected static final String VALIDATION_MESSAGES_ATTR = "validationMessages";
    protected static final String QUEUE_NAME_ANNO_ATTR = "queueName";
    protected static final String QUEUE_SCOPE_ANNO_ATTR = "queueScope";
    private static final Map<Class<?>, List<Method>> _afterComposeMethodCache = new CacheMap(600, 1800000);
    private static final Map<Class<?>, List<Method>> _historyPopStateMethodCache = new CacheMap(600, 1800000);

    public BindComposer() {
        this.setViewModel(this);
        this._converters = new HashMap<String, Converter>(8);
        this._validators = new HashMap<String, Validator>(8);
        this.evalx = BindEvaluatorXUtil.createEvaluator(null);
    }

    public Binder getBinder() {
        return this._binder;
    }

    public void setViewModel(Object viewModel) {
        this._viewModel = viewModel;
        if (this._binder != null) {
            Object vm = this._binder.createViewModelProxyIfEnabled(this._viewModel);
            this._binder.setViewModel(vm);
            this._viewModel = vm;
        }
    }

    public Object getViewModel() {
        return this._viewModel;
    }

    public Converter getConverter(String name) {
        Converter conv = this._converters.get(name);
        return conv;
    }

    public Validator getValidator(String name) {
        Validator validator = this._validators.get(name);
        return validator;
    }

    public void addConverter(String name, Converter converter) {
        this._converters.put(name, converter);
    }

    public void addValidator(String name, Validator validator) {
        this._validators.put(name, validator);
    }

    public ComponentInfo doBeforeCompose(Page page, Component parent, ComponentInfo compInfo) throws Exception {
        return compInfo;
    }

    public void doBeforeComposeChildren(final Component comp) throws Exception {
        Object vmProxy;
        if (comp.getPage() == null) {
            final Map currentArg = Executions.getCurrent().getArg();
            ((ComponentCtrl)comp).addCallback("afterPageAttached", new Callback(){

                public void call(Object data) {
                    try {
                        Executions.getCurrent().pushArg(currentArg);
                        BindComposer.this.doBeforeComposeChildren(comp);
                    }
                    catch (Exception e) {
                        throw UiException.Aide.wrap((Throwable)e);
                    }
                    finally {
                        Executions.getCurrent().popArg();
                    }
                }
            });
            return;
        }
        this._viewModel = this.initViewModel(this.evalx, comp);
        this._binder = this.initBinder(this.evalx, comp);
        if (!this.equals(this._viewModel) && (vmProxy = this._binder.createViewModelProxyIfEnabled(this._viewModel)) != null) {
            this._viewModel = vmProxy;
            comp.setAttribute((String)comp.getAttribute(VM_ID), vmProxy);
        }
        ValidationMessages _vmsgs = this.initValidationMessages(this.evalx, comp, this._binder);
        Selectors.wireVariables((Component)comp, (Object)this._viewModel, (List)Selectors.newVariableResolvers(BindUtils.getViewModelClass(this._viewModel), null));
        if (_vmsgs != null) {
            this._binder.setValidationMessages(_vmsgs);
        }
        try {
            BinderKeeper keeper = BinderKeeper.getInstance(comp);
            keeper.book(this._binder, comp);
            this._binder.init(comp, this._viewModel, this.getViewModelInitArgs(this.evalx, comp));
        }
        catch (Exception x) {
            throw MiscUtil.mergeExceptionInfo(x, comp);
        }
        ConventionWires.wireController((Component)comp, (Object)this);
    }

    public void doAfterCompose(T comp) throws Exception {
        Page page;
        if (comp.getPage() == null) {
            final Map currentArg = Executions.getCurrent().getArg();
            ((ComponentCtrl)comp).addCallback("afterPageAttached", new Callback((Component)comp){
                final /* synthetic */ Component val$comp;
                {
                    this.val$comp = component;
                }

                public void call(Object data) {
                    try {
                        Executions.getCurrent().pushArg(currentArg);
                        BindComposer.this.doAfterCompose(this.val$comp);
                    }
                    catch (Exception e) {
                        throw UiException.Aide.wrap((Throwable)e);
                    }
                    finally {
                        Executions.getCurrent().popArg();
                    }
                }
            });
            return;
        }
        this._binder.initAnnotatedBindings();
        new AbstractAnnotatedMethodInvoker<AfterCompose>(AfterCompose.class, _afterComposeMethodCache){

            @Override
            protected boolean shouldLookupSuperclass(AfterCompose annotation) {
                return annotation.superclass();
            }
        }.invokeMethod(this._binder, this.getViewModelInitArgs(this.evalx, (Component)comp));
        BinderKeeper keeper = BinderKeeper.getInstance(comp);
        if (keeper.isRootBinder(this._binder)) {
            keeper.loadComponentForAllBinders();
        }
        comp.setAuService((AuService)this);
        final AbstractAnnotatedMethodInvoker<HistoryPopState> historyPopStateInvoker = new AbstractAnnotatedMethodInvoker<HistoryPopState>(HistoryPopState.class, _historyPopStateMethodCache){

            @Override
            protected boolean shouldLookupSuperclass(HistoryPopState annotation) {
                return false;
            }
        };
        if (historyPopStateInvoker.hasAnnotatedMethod(this._binder) && (page = comp.getPage()) != null) {
            page.addEventListener("onHistoryPopState", (EventListener)new SerializableEventListener<HistoryPopStateEvent>(){
                private HistoryPopStateEvent _handling = null;

                public void onEvent(HistoryPopStateEvent event) throws Exception {
                    if (event != this._handling) {
                        this._handling = event;
                        historyPopStateInvoker.invokeMethod(BindComposer.this.getBinder(), null, (Event)event, true);
                    }
                }
            });
        }
    }

    private Map<String, Object> getViewModelInitArgs(BindEvaluatorX evalx, Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Collection anncol = compCtrl.getAnnotations(VIEW_MODEL_ATTR, INIT_ANNO);
        if (anncol.size() == 0) {
            return null;
        }
        Annotation ann = (Annotation)anncol.iterator().next();
        Map attrs = ann.getAttributes();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : attrs.entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if (VALUE_ANNO_ATTR.equals(tag)) continue;
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        return args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
    }

    private Object initViewModel(BindEvaluatorX evalx, Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation idanno = compCtrl.getAnnotation(VIEW_MODEL_ATTR, ID_ANNO);
        Annotation initanno = compCtrl.getAnnotation(VIEW_MODEL_ATTR, INIT_ANNO);
        String vmname = null;
        Object vm = null;
        BindingAnnotationInfoChecker checker = this.getBindingAnnotationInfoChecker();
        if (checker != null) {
            checker.checkViewModel(comp);
        }
        if (idanno == null && initanno == null) {
            return this._viewModel;
        }
        if (idanno == null) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("you have to use @id to assign the name of view model", comp));
        }
        if (initanno == null) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("you have to use @init to assign the view model", comp));
        }
        vmname = BindEvaluatorXUtil.eval(evalx, comp, AnnotationUtil.testString(idanno.getAttributeValues(VALUE_ANNO_ATTR), idanno), String.class);
        vm = BindEvaluatorXUtil.eval(evalx, comp, AnnotationUtil.testString(initanno.getAttributeValues(VALUE_ANNO_ATTR), initanno), Object.class);
        if (Strings.isEmpty((String)vmname)) {
            throw new UiException(MiscUtil.formatLocationMessage("name of view model is empty", idanno));
        }
        try {
            if (vm instanceof String) {
                Page page = comp.getPage();
                if (page == null) {
                    throw new UiException(MiscUtil.formatLocationMessage("can't find Page to resolve a view model class :'" + vm + "'", initanno));
                }
                vm = comp.getPage().resolveClass((String)vm);
            }
            if (vm instanceof Class) {
                vm = ((Class)vm).newInstance();
            }
        }
        catch (Exception e) {
            throw MiscUtil.mergeExceptionInfo(e, initanno);
        }
        if (vm == null) {
            throw new UiException(MiscUtil.formatLocationMessage("view model of '" + vmname + "' is null", initanno));
        }
        if (vm.getClass().isPrimitive()) {
            throw new UiException(MiscUtil.formatLocationMessage("view model '" + vmname + "' is a primitive type, is " + vm, initanno));
        }
        comp.setAttribute(vmname, vm);
        comp.setAttribute(VM_ID, (Object)vmname);
        return vm;
    }

    private AnnotateBinder initBinder(BindEvaluatorX evalx, Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation idanno = compCtrl.getAnnotation(BINDER_ATTR, ID_ANNO);
        Annotation initanno = compCtrl.getAnnotation(BINDER_ATTR, INIT_ANNO);
        Object binder = null;
        String bname = null;
        BindingAnnotationInfoChecker checker = this.getBindingAnnotationInfoChecker();
        if (checker != null) {
            checker.checkBinder(comp);
        }
        if (idanno != null) {
            bname = BindEvaluatorXUtil.eval(evalx, comp, AnnotationUtil.testString(idanno.getAttributeValues(VALUE_ANNO_ATTR), idanno), String.class);
            if (Strings.isEmpty((String)bname)) {
                throw new UiException(MiscUtil.formatLocationMessage("name of binder is empty", idanno));
            }
        } else {
            bname = BINDER_ATTR;
        }
        if (initanno != null) {
            String expr;
            binder = AnnotationUtil.testString(initanno.getAttributeValues(VALUE_ANNO_ATTR), initanno);
            String name = AnnotationUtil.testString(initanno.getAttributeValues(QUEUE_NAME_ANNO_ATTR), initanno);
            String scope = AnnotationUtil.testString(initanno.getAttributeValues(QUEUE_SCOPE_ANNO_ATTR), initanno);
            if (name != null && Strings.isBlank((String)(name = BindEvaluatorXUtil.eval(evalx, comp, expr = name, String.class)))) {
                throw new UiException(MiscUtil.formatLocationMessage("evaluated queue name is empty, expression is " + expr, initanno));
            }
            if (scope != null && Strings.isBlank((String)(scope = BindEvaluatorXUtil.eval(evalx, comp, expr = scope, String.class)))) {
                throw new UiException(MiscUtil.formatLocationMessage("evaluated queue scope is empty, expression is " + expr, initanno));
            }
            if (binder != null) {
                binder = BindEvaluatorXUtil.eval(evalx, comp, (String)binder, Object.class);
                try {
                    if (binder instanceof String) {
                        binder = comp.getPage().resolveClass((String)binder);
                    }
                    if (binder instanceof Class) {
                        binder = ((Class)binder).getDeclaredConstructor(String.class, String.class).newInstance(name, scope);
                    }
                }
                catch (Exception e) {
                    throw UiException.Aide.wrap((Throwable)e, (String)e.getMessage());
                }
                if (!(binder instanceof AnnotateBinder)) {
                    throw new UiException(MiscUtil.formatLocationMessage("evaluated binder is not a binder is " + binder, initanno));
                }
            } else {
                binder = this.newAnnotateBinder(name, scope);
            }
        } else {
            binder = this.newAnnotateBinder(null, null);
        }
        comp.setAttribute(bname, binder);
        comp.setAttribute(BINDER_ID, (Object)bname);
        return (AnnotateBinder)binder;
    }

    private AnnotateBinder newAnnotateBinder(String name, String scope) {
        String clznm = Library.getProperty((String)"org.zkoss.bind.AnnotateBinder.class");
        if (clznm != null) {
            try {
                return (AnnotateBinder)Classes.newInstanceByThread((String)clznm, (Class[])new Class[]{String.class, String.class}, (Object[])new String[]{name, scope});
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e, (String)"Can't initialize binder");
            }
        }
        return new AnnotateBinder(name, scope);
    }

    private ValidationMessages initValidationMessages(BindEvaluatorX evalx, Component comp, Binder binder) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation idanno = compCtrl.getAnnotation(VALIDATION_MESSAGES_ATTR, ID_ANNO);
        Annotation initanno = compCtrl.getAnnotation(VALIDATION_MESSAGES_ATTR, INIT_ANNO);
        Object vmessages = null;
        String vname = null;
        BindingAnnotationInfoChecker checker = this.getBindingAnnotationInfoChecker();
        if (checker != null) {
            checker.checkValidationMessages(comp);
        }
        if (idanno != null) {
            vname = BindEvaluatorXUtil.eval(evalx, comp, AnnotationUtil.testString(idanno.getAttributeValues(VALUE_ANNO_ATTR), idanno), String.class);
            if (Strings.isEmpty((String)vname)) {
                throw new UiException(MiscUtil.formatLocationMessage("name of ValidationMessages is empty", idanno));
            }
        } else {
            return null;
        }
        if (initanno != null) {
            vmessages = BindEvaluatorXUtil.eval(evalx, comp, AnnotationUtil.testString(initanno.getAttributeValues(VALUE_ANNO_ATTR), initanno), Object.class);
            try {
                if (vmessages instanceof String) {
                    vmessages = comp.getPage().resolveClass((String)vmessages);
                }
                if (vmessages instanceof Class) {
                    vmessages = ((Class)vmessages).newInstance();
                }
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e, (String)MiscUtil.formatLocationMessage(e.getMessage(), initanno));
            }
            if (!(vmessages instanceof ValidationMessages)) {
                throw new UiException(MiscUtil.formatLocationMessage("evaluated validationMessages is not a ValidationMessages is " + vmessages, initanno));
            }
        } else {
            vmessages = new ValidationMessagesImpl();
        }
        comp.setAttribute(vname, vmessages);
        return (ValidationMessages)vmessages;
    }

    public boolean doCatch(Throwable ex) throws Exception {
        return false;
    }

    public void doFinally() throws Exception {
    }

    public void notifyChange(Object bean, String property) {
        this.getBinder().notifyChange(bean, property);
    }

    public void didActivate(Component comp) {
        Selectors.rewireVariablesOnActivate((Component)comp, (Object)this.getViewModel(), (List)Selectors.newVariableResolvers(BindUtils.getViewModelClass(this._viewModel), null));
    }

    public void willPassivate(Component comp) {
    }

    private BindingAnnotationInfoChecker getBindingAnnotationInfoChecker() {
        DebuggerFactory factory = DebuggerFactory.getInstance();
        return factory == null ? null : factory.getAnnotationInfoChecker();
    }

    public boolean service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.startsWith("onBindCommand$") || cmd.startsWith("onBindGlobalCommand$")) {
            Map<String, Method> mmv;
            Map data = request.getData();
            String vcmd = data.get("cmd").toString();
            ToServerCommand ccmd = BindUtils.getViewModelClass(this._viewModel).getAnnotation(ToServerCommand.class);
            ArrayList<String> asList = new ArrayList<String>();
            if (ccmd != null) {
                asList.addAll(Arrays.asList(ccmd.value()));
            }
            if (!(mmv = this._binder.getMatchMediaValue()).isEmpty()) {
                asList.addAll(mmv.keySet());
            }
            if (asList != null && (asList.contains("*") || asList.contains(vcmd))) {
                if (cmd.startsWith("onBindCommand$")) {
                    this._binder.postCommand(vcmd, (Map)data.get("args"));
                } else if (cmd.startsWith("onBindGlobalCommand$")) {
                    BindUtils.postGlobalCommand(this._binder.getQueueName(), this._binder.getQueueScope(), vcmd, (Map)data.get("args"));
                }
            }
            return true;
        }
        return false;
    }

    private static class BinderKeeper {
        private static final String KEY_BINDER_KEEPER = "$BinderKeeper$";
        private final LinkedList<Loader> _queue;
        private Component _host;

        static BinderKeeper getInstance(Component comp) {
            BinderKeeper keeper = (BinderKeeper)comp.getAttribute(KEY_BINDER_KEEPER, true);
            if (keeper == null) {
                keeper = new BinderKeeper(comp);
                comp.setAttribute(KEY_BINDER_KEEPER, (Object)keeper);
            }
            return keeper;
        }

        public BinderKeeper(Component comp) {
            this._host = comp;
            this._queue = new LinkedList();
            Events.postEvent((String)"onRootBinderHostDone", (Component)comp, null);
            comp.addEventListener("onRootBinderHostDone", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    BinderKeeper.this._host.removeEventListener("onRootBinderHostDone", (EventListener)this);
                    BinderKeeper keeper = (BinderKeeper)BinderKeeper.this._host.getAttribute(BinderKeeper.KEY_BINDER_KEEPER);
                    if (keeper != null) {
                        BinderKeeper.this._host.removeAttribute(BinderKeeper.KEY_BINDER_KEEPER);
                    }
                }
            });
        }

        public void book(Binder binder, Component comp) {
            this._queue.add(new Loader(binder, comp));
        }

        public boolean isRootBinder(Binder binder) {
            return this._queue.getFirst().binder == binder;
        }

        public void loadComponentForAllBinders() {
            this._host.removeAttribute(KEY_BINDER_KEEPER);
            for (Loader loader : this._queue) {
                loader.load();
            }
        }

        private static class Loader {
            Binder binder;
            Component comp;

            public Loader(Binder _binder, Component comp) {
                this.binder = _binder;
                this.comp = comp;
            }

            public void load() {
                BindUiLifeCycle.markLifeCycleHandling(this.comp);
                this.binder.loadComponent(this.comp, true);
            }
        }
    }
}

