/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.zkoss.util.ArraysX;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zul.AbstractGroupsModel;
import org.zkoss.zul.ext.GroupsSortableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleGroupsModel<D, H, F, E>
extends AbstractGroupsModel<D, Object, F, E>
implements GroupsSortableModel<D>,
ComponentCloneListener,
Cloneable {
    protected List<List<D>> _data;
    protected List<H> _heads;
    protected List<F> _foots;
    protected boolean[] _opens;

    public SimpleGroupsModel(D[][] data) {
        this(data, null, (Object[])null);
    }

    public SimpleGroupsModel(D[][] data, H[] heads) {
        this(data, heads, (Object[])null);
    }

    public SimpleGroupsModel(D[][] data, H[] heads, F[] foots) {
        this(data != null ? ArraysX.asList((Object[][])data) : (List)null, heads != null ? ArraysX.asList((Object[])heads) : (List)null, foots != null ? ArraysX.asList((Object[])foots) : (List)null);
    }

    public SimpleGroupsModel(D[][] data, H[] heads, F[] foots, boolean[] closes) {
        this(data != null ? ArraysX.asList((Object[][])data) : (List)null, heads != null ? ArraysX.asList((Object[])heads) : (List)null, foots != null ? ArraysX.asList((Object[])foots) : (List)null, closes);
    }

    public SimpleGroupsModel(List<List<D>> data) {
        this(data, null, null);
    }

    public SimpleGroupsModel(List<List<D>> data, List<H> heads) {
        this(data, heads, null);
    }

    public SimpleGroupsModel(List<List<D>> data, List<H> heads, List<F> foots) {
        if (data == null) {
            throw new NullPointerException();
        }
        this._data = data;
        this._heads = heads;
        this._foots = foots;
    }

    public SimpleGroupsModel(List<List<D>> data, List<H> heads, List<F> foots, boolean[] closes) {
        if (data == null) {
            throw new NullPointerException();
        }
        this._data = data;
        this._heads = heads;
        this._foots = foots;
        if (closes != null) {
            int i;
            int length = this._data.size();
            int paramLen = Math.min(closes.length, length);
            this._opens = new boolean[length];
            for (i = 0; i < paramLen; ++i) {
                this._opens[i] = closes[i];
            }
            for (i = paramLen; i < length; ++i) {
                this._opens[i] = true;
            }
        }
    }

    @Override
    public D getChild(int groupIndex, int index) {
        return this._data.get(groupIndex).get(index);
    }

    @Override
    public int getChildCount(int groupIndex) {
        return this._data.get(groupIndex).size();
    }

    @Override
    public Object getGroup(int groupIndex) {
        return this._heads == null ? this._data.get(groupIndex) : this._heads.get(groupIndex);
    }

    @Override
    public int getGroupCount() {
        return this._data.size();
    }

    @Override
    public F getGroupfoot(int groupIndex) {
        return this._foots == null ? null : (F)this._foots.get(groupIndex);
    }

    @Override
    public boolean hasGroupfoot(int groupIndex) {
        return this._foots != null && groupIndex > -1 && groupIndex < this._foots.size() && this._foots.get(groupIndex) != null;
    }

    public boolean isClose(int groupIndex) {
        return !this.isGroupOpened(groupIndex);
    }

    public void setClose(int groupIndex, boolean close) {
        this.setOpenGroup0(groupIndex, !close);
    }

    @Override
    public boolean isGroupOpened(int groupIndex) {
        return this._opens == null || this._opens[groupIndex];
    }

    @Override
    public boolean addOpenGroup(int groupIndex) {
        return this.setOpenGroup0(groupIndex, true);
    }

    @Override
    public boolean removeOpenGroup(int groupIndex) {
        return this.setOpenGroup0(groupIndex, false);
    }

    public boolean setOpenGroup0(int groupIndex, boolean open) {
        if (this._opens == null) {
            if (open) {
                return true;
            }
            int length = this.getGroupCount();
            this._opens = new boolean[length];
            for (int i = 0; i < length; ++i) {
                this._opens[i] = true;
            }
        }
        if (this._opens[groupIndex] != open) {
            this._opens[groupIndex] = open;
            this.fireEvent(10, groupIndex, -1, -1);
            return true;
        }
        return false;
    }

    @Override
    public void group(Comparator<D> cmpr, boolean ascending, int colIndex) {
    }

    @Override
    public void sort(Comparator<D> cmpr, boolean ascending, int colIndex) {
        int j = this._data.size();
        for (int i = 0; i < j; ++i) {
            List<D> d = this._data.get(i);
            this.sortGroupData(this._heads == null ? d : this._heads.get(i), d, cmpr, ascending, colIndex);
        }
        this.fireEvent(3, -1, -1, -1);
    }

    protected void sortGroupData(Object group, D[] groupdata, Comparator<D> cmpr, boolean ascending, int colIndex) {
        this.sortGroupData(group, ArraysX.asList((Object[])groupdata), cmpr, ascending, colIndex);
    }

    protected void sortGroupData(Object group, List<D> groupdata, Comparator<D> cmpr, boolean ascending, int colIndex) {
        Collections.sort(groupdata, cmpr);
    }

    @Override
    public Object clone() {
        SimpleGroupsModel clone = (SimpleGroupsModel)super.clone();
        if (this._data != null) {
            clone._data = new ArrayList<List<D>>(this._data);
        }
        if (this._heads != null) {
            clone._heads = new ArrayList<H>(this._heads);
        }
        if (this._foots != null) {
            clone._foots = new ArrayList<F>(this._foots);
        }
        if (this._opens != null) {
            clone._opens = (boolean[])ArraysX.duplicate((Object)this._opens);
        }
        return clone;
    }

    public Object willClone(Component comp) {
        return this.clone();
    }
}

