/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.PageableModel;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.event.PagingListener;
import org.zkoss.zul.event.TreeDataEvent;
import org.zkoss.zul.event.TreeDataListener;
import org.zkoss.zul.ext.Openable;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.ext.SelectionControl;
import org.zkoss.zul.ext.TreeOpenableModel;
import org.zkoss.zul.ext.TreeSelectableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeModel<E>
implements TreeModel<E>,
TreeSelectableModel,
TreeOpenableModel,
Selectable<E>,
Openable<E>,
Serializable,
PageableModel {
    private static final Logger log = LoggerFactory.getLogger(AbstractTreeModel.class);
    private E _root;
    private transient List<TreeDataListener> _listeners = new LinkedList<TreeDataListener>();
    private transient List<PagingListener> _pagingListeners = new ArrayList<PagingListener>();
    protected Set<Path> _selection = new LinkedHashSet<Path>();
    protected Set<Path> _opens = new LinkedHashSet<Path>();
    private boolean _multiple;
    private SelectionControl<E> _ctrl;
    private int _pageSize = -1;
    private int _activePage = -1;
    private int _pageCount = -1;

    @Override
    public void setSelectionControl(SelectionControl ctrl) {
        this._ctrl = ctrl;
    }

    @Override
    public SelectionControl getSelectionControl() {
        return this._ctrl;
    }

    public AbstractTreeModel(E root) {
        this._root = root;
        this.addTreeDataListener(new TreeDataListener(){

            public void onChange(TreeDataEvent event) {
                AbstractTreeModel.this.updatePath(event);
                AbstractTreeModel.this.invalidatePageCount();
            }
        });
        this._ctrl = new DefaultSelectionControl(this);
    }

    private void updatePath(TreeDataEvent event) {
        int type = event.getType();
        int[] affectedPath = event.getAffectedPath();
        if (affectedPath == null || affectedPath.length < 1) {
            return;
        }
        switch (type) {
            case 2: {
                this.internalDataChange(this._opens, affectedPath, true);
                this.internalDataChange(this._selection, affectedPath, true);
                break;
            }
            case 1: {
                this.internalDataChange(this._opens, affectedPath, false);
                this.internalDataChange(this._selection, affectedPath, false);
            }
        }
    }

    private void internalDataChange(Set<Path> openOrSelect, int[] affectedPath, boolean isRemoved) {
        LinkedList<Path> list = new LinkedList<Path>(openOrSelect);
        int update = isRemoved ? -1 : 1;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Path p = (Path)it.next();
            if (!p.verifyPrefix(affectedPath, update) || !isRemoved) continue;
            it.remove();
        }
        openOrSelect.clear();
        openOrSelect.addAll(list);
    }

    @Override
    public E getRoot() {
        return this._root;
    }

    void setRootDirectly(E root) {
        this._root = root;
    }

    public void fireEvent(E node, int indexFrom, int indexTo, int evtType) {
        this.fireEvent(evtType, this.getPath(node), indexFrom, indexTo);
    }

    public void fireEvent(int evtType, int[] path, int indexFrom, int indexTo) {
        TreeDataEvent evt = new TreeDataEvent(this, evtType, path, indexFrom, indexTo);
        for (TreeDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    public void fireEvent(int evtType, int[] path, int indexFrom, int indexTo, int[] affectedPath) {
        TreeDataEvent evt = new TreeDataEvent(this, evtType, path, indexFrom, indexTo, affectedPath);
        for (TreeDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    protected void fireSelectionChanged(int[] path) {
        TreeDataEvent evt = new TreeDataEvent(this, 4, path, 0, 1);
        for (TreeDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    protected void fireOpenChanged(int[] path) {
        TreeDataEvent evt = new TreeDataEvent(this, 5, path, 0, 1);
        for (TreeDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    @Override
    public int getIndexOfChild(E parent, E child) {
        int cnt = this._childCount(parent);
        for (int j = 0; j < cnt; ++j) {
            if (!Objects.equals(child, this.getChild(parent, j))) continue;
            return j;
        }
        return -1;
    }

    @Override
    public E getChild(int[] path) {
        E node = this.getRoot();
        int childCount = 0;
        for (int i = 0; i < path.length && node != null; ++i) {
            if (path[i] < 0 || path[i] > (childCount = this._childCount(node))) {
                return null;
            }
            node = this.getChild(node, path[i]);
        }
        return node;
    }

    private int _childCount(E parent) {
        return this.isLeaf(parent) ? 0 : this.getChildCount(parent);
    }

    @Override
    public int[] getPath(E child) {
        ArrayList<Integer> path = new ArrayList<Integer>();
        this.dfSearch(path, this.getRoot(), child);
        int[] ipath = new int[path.size()];
        for (int j = 0; j < ipath.length; ++j) {
            ipath[j] = (Integer)path.get(j);
        }
        return ipath;
    }

    private boolean dfSearch(List<Integer> path, E node, E target) {
        if (node.equals(target)) {
            return true;
        }
        int size = this._childCount(node);
        for (int i = 0; i < size; ++i) {
            if (!this.dfSearch(path, this.getChild(node, i), target)) continue;
            path.add(0, new Integer(i));
            return true;
        }
        return false;
    }

    @Override
    public void addTreeDataListener(TreeDataListener l) {
        this._listeners.add(l);
    }

    @Override
    public void removeTreeDataListener(TreeDataListener l) {
        this._listeners.remove(l);
    }

    @Override
    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            this.fireEvent(6, null, -1, -1);
            if (!multiple && this._selection.size() > 1) {
                LinkedList<Path> sels = new LinkedList<Path>();
                sels.addAll(this._selection);
                Path sel = (Path)sels.remove(0);
                this._selection.clear();
                this._selection.add(sel);
                for (Path path : sels) {
                    this.fireSelectionChanged(path.path);
                }
            }
        }
    }

    @Override
    public boolean isMultiple() {
        return this._multiple;
    }

    @Override
    public boolean addSelectionPath(int[] path) {
        if (path != null && path.length > 0) {
            int[][] paths = new int[1][path.length];
            paths[0] = path;
            return this.addSelectionPaths(paths);
        }
        return false;
    }

    @Override
    public boolean addSelectionPaths(int[][] paths) {
        boolean added = false;
        int len = paths != null ? paths.length : 0;
        boolean multiple = this.isMultiple();
        for (int j = 0; j < len; ++j) {
            if (paths[j] == null) continue;
            Path path = new Path(paths[j]);
            if (multiple) {
                if (!this._selection.add(path)) continue;
                added = true;
                this.fireSelectionChanged(path.path);
                continue;
            }
            if (this._selection.contains(path)) break;
            added = true;
            this.clearSelection();
            this._selection.add(path);
            this.fireSelectionChanged(path.path);
            break;
        }
        return added;
    }

    @Override
    public boolean removeSelectionPath(int[] path) {
        if (path != null && path.length > 0) {
            int[][] paths = new int[1][path.length];
            paths[0] = path;
            return this.removeSelectionPaths(paths);
        }
        return false;
    }

    @Override
    public boolean removeSelectionPaths(int[][] paths) {
        boolean found = false;
        int len = paths != null ? paths.length : 0;
        for (int j = 0; j < len && !this._selection.isEmpty(); ++j) {
            Path path = new Path(paths[j]);
            if (this._selection.remove(path)) {
                found = true;
                this.fireSelectionChanged(path.path);
            }
            if (!this.isMultiple()) break;
        }
        return found;
    }

    @Override
    public boolean isPathSelected(int[] path) {
        return path != null && this._selection.contains(new Path(path));
    }

    @Override
    public int[] getSelectionPath() {
        return this._selection.isEmpty() ? null : this._selection.iterator().next().path;
    }

    @Override
    public int[][] getSelectionPaths() {
        if (this._selection.isEmpty()) {
            return null;
        }
        int[][] paths = new int[this._selection.size()][];
        int j = 0;
        for (Path path : this._selection) {
            paths[j++] = path.path;
        }
        return paths;
    }

    @Override
    public int getSelectionCount() {
        return this._selection.size();
    }

    @Override
    public boolean isSelectionEmpty() {
        return this._selection.isEmpty();
    }

    @Override
    public void clearSelection() {
        int[][] paths;
        if (!this._selection.isEmpty() && (paths = this.getSelectionPaths()) != null) {
            this._selection.clear();
            for (int j = 0; j < paths.length; ++j) {
                this.fireSelectionChanged(paths[j]);
            }
        }
    }

    @Override
    public boolean addOpenPath(int[] path) {
        if (path != null && path.length > 0) {
            int[][] paths = new int[1][path.length];
            paths[0] = path;
            return this.addOpenPaths(paths);
        }
        return false;
    }

    @Override
    public boolean addOpenPaths(int[][] paths) {
        boolean added = false;
        int len = paths != null ? paths.length : 0;
        for (int j = 0; j < len; ++j) {
            Path path;
            if (paths[j] == null || !this._opens.add(path = new Path(paths[j]))) continue;
            added = true;
            this.fireOpenChanged(path.path);
        }
        return added;
    }

    @Override
    public boolean removeOpenPath(int[] path) {
        if (path != null && path.length > 0) {
            int[][] paths = new int[1][path.length];
            paths[0] = path;
            return this.removeOpenPaths(paths);
        }
        return false;
    }

    @Override
    public boolean removeOpenPaths(int[][] paths) {
        boolean found = false;
        int len = paths != null ? paths.length : 0;
        for (int j = 0; j < len && !this._opens.isEmpty(); ++j) {
            Path path = new Path(paths[j]);
            if (!this._opens.remove(path)) continue;
            found = true;
            this.fireOpenChanged(path.path);
        }
        return found;
    }

    @Override
    public boolean isPathOpened(int[] path) {
        return path != null && this._opens.contains(new Path(path));
    }

    @Override
    public int[] getOpenPath() {
        return this._opens.isEmpty() ? null : this._opens.iterator().next().path;
    }

    @Override
    public int[][] getOpenPaths() {
        if (this._opens.isEmpty()) {
            return null;
        }
        int[][] paths = new int[this._opens.size()][];
        int j = 0;
        for (Path path : this._opens) {
            paths[j++] = path.path;
        }
        return paths;
    }

    @Override
    public int getOpenCount() {
        return this._opens.size();
    }

    @Override
    public boolean isOpenEmpty() {
        return this._opens.isEmpty();
    }

    @Override
    public void clearOpen() {
        int[][] paths;
        if (!this._opens.isEmpty() && (paths = this.getOpenPaths()) != null) {
            this._opens.clear();
            for (int j = 0; j < paths.length; ++j) {
                this.fireOpenChanged(paths[j]);
            }
        }
    }

    protected Object beforeSort() {
        States states = new States();
        for (Path path : this._selection) {
            states.selection.add(this.getChild(path.path));
        }
        for (Path path : this._opens) {
            states.opens.add(this.getChild(path.path));
        }
        return states;
    }

    protected void afterSort(Object ctx) {
        if (ctx instanceof States) {
            States states = (States)ctx;
            this._selection.clear();
            for (Object node : states.selection) {
                this._selection.add(new Path(this.getPath(node)));
            }
            this._opens.clear();
            for (Object node : states.opens) {
                this._opens.add(new Path(this.getPath(node)));
            }
        }
    }

    @Override
    public Set<E> getSelection() {
        LinkedHashSet<E> selected = new LinkedHashSet<E>();
        int[][] paths = this.getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                selected.add(this.getChild(paths[i]));
            }
        }
        return selected;
    }

    @Override
    public void setSelection(Collection<? extends E> selection) {
        if (this.isSelectionChanged(selection)) {
            this.clearSelection();
            for (E node : selection) {
                this.addToSelection(node);
            }
        }
    }

    private boolean isSelectionChanged(Collection<? extends E> selection) {
        if (this._selection.size() != selection.size()) {
            return true;
        }
        for (E e : selection) {
            if (this._selection.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelected(Object child) {
        int[] path = this.getPath(child);
        if (path != null && path.length > 0) {
            return this.isPathSelected(path);
        }
        return false;
    }

    @Override
    public boolean addToSelection(E child) {
        int[] path = this.getPath(child);
        if (path != null && path.length > 0) {
            return this.addSelectionPath(path);
        }
        return false;
    }

    @Override
    public boolean removeFromSelection(Object child) {
        int[] path = this.getPath(child);
        if (path != null && path.length > 0) {
            return this.removeSelectionPath(path);
        }
        return false;
    }

    @Override
    public Set<E> getOpenObjects() {
        LinkedHashSet<E> opened = new LinkedHashSet<E>();
        int[][] paths = this.getOpenPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                opened.add(this.getChild(paths[i]));
            }
        }
        return opened;
    }

    @Override
    public void setOpenObjects(Collection<? extends E> opened) {
        this.clearOpen();
        for (E node : opened) {
            this.addOpenObject(node);
        }
    }

    @Override
    public boolean isObjectOpened(Object child) {
        int[] path = this.getPath(child);
        if (path != null && path.length > 0) {
            return this.isPathOpened(path);
        }
        return false;
    }

    @Override
    public boolean addOpenObject(E child) {
        int[] path = this.getPath(child);
        if (path != null && path.length > 0) {
            return this.addOpenPath(path);
        }
        return false;
    }

    @Override
    public boolean removeOpenObject(Object child) {
        int[] path = this.getPath(child);
        if (path != null && path.length > 0) {
            return this.removeOpenPath(path);
        }
        return false;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, this._listeners);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList<TreeDataListener>();
        Serializables.smartRead((ObjectInputStream)s, this._listeners);
    }

    public Object clone() {
        AbstractTreeModel clone;
        try {
            clone = (AbstractTreeModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._listeners = new LinkedList<TreeDataListener>();
        clone._opens = new LinkedHashSet<Path>(this._opens);
        clone._selection = new LinkedHashSet<Path>(this._selection);
        return clone;
    }

    @Override
    public int getPageSize() {
        return this._pageSize;
    }

    @Override
    public void setPageSize(int size) throws WrongValueException {
        int maxPageIndex;
        if (size < 0) {
            throw new WrongValueException("expecting positive non zero value, got: " + size);
        }
        if (this._pageSize == size) {
            return;
        }
        int oldPageSize = this._pageSize;
        this._pageSize = size;
        this.invalidatePageCount();
        if (size > oldPageSize && this._activePage > 0 && this._activePage > (maxPageIndex = this.getPageCount() - 1)) {
            this._activePage = maxPageIndex;
        }
        for (PagingListener p : this._pagingListeners) {
            try {
                p.onEvent(new PagingEvent("internalModelEvent", null, this, this._activePage));
            }
            catch (Exception e) {
                log.warn("Failed to publish internal paging event", (Throwable)e);
            }
        }
    }

    @Override
    public int getPageCount() {
        if (this._pageCount < 1) {
            if (this._root != null) {
                int count = this.getChildNodeCount(this._root);
                if (count <= 0 || this._pageSize < 0) {
                    this._pageCount = 1;
                } else {
                    int pageCount = count / this._pageSize;
                    this._pageCount = count % this._pageSize == 0 ? pageCount : pageCount + 1;
                }
            } else {
                this._pageCount = 1;
            }
        }
        return this._pageCount;
    }

    private int getChildNodeCount(E node) {
        int c;
        int count = c = this.getChildCount(node);
        for (int i = 0; i < c; ++i) {
            E child = this.getChild(node, i);
            if (!this.isPathOpened(this.getPath(child))) continue;
            count += this.getChildNodeCount(child);
        }
        return count;
    }

    private void invalidatePageCount() {
        this._pageCount = -1;
    }

    @Override
    public int getActivePage() {
        return this._activePage;
    }

    @Override
    public void setActivePage(int pg) throws WrongValueException {
        if (pg < 0) {
            throw new WrongValueException("expecting positive non zero value, got: " + pg);
        }
        if (pg > 0) {
            int pc;
            int n = pc = this._pageCount == -1 ? this.getPageCount() : this._pageCount;
            if (pg >= pc) {
                pg = pc - 1;
            }
        }
        if (this._activePage == pg) {
            return;
        }
        this._activePage = pg;
        for (PagingListener p : this._pagingListeners) {
            try {
                p.onEvent(new PagingEvent("internalModelEvent", null, this, pg));
            }
            catch (Exception e) {
                log.warn("Failed to publish internal paging event", (Throwable)e);
            }
        }
    }

    private List<E> getAllNodes() {
        E root = this.getRoot();
        LinkedList all = new LinkedList();
        if (root != null) {
            this.getChildNodes(all, root);
        }
        return all;
    }

    private void getChildNodes(List<E> all, E parent) {
        int j = this.getChildNodeCount(parent);
        for (int i = 0; i < j; ++i) {
            E child = this.getChild(parent, i);
            if (child == null) continue;
            all.add(child);
            this.getChildNodes(all, child);
        }
    }

    @Override
    public void addPagingEventListener(PagingListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this._pagingListeners.add(listener);
    }

    @Override
    public void removePagingEventListener(PagingListener listener) {
        this._pagingListeners.remove(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultSelectionControl<E>
    implements SelectionControl<E> {
        private AbstractTreeModel model;

        public DefaultSelectionControl(AbstractTreeModel model) {
            this.model = model;
        }

        @Override
        public boolean isSelectable(E e) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSelectAll(boolean selectAll) {
            if (selectAll) {
                LinkedList all = new LinkedList();
                List allNodes = this.model.getAllNodes();
                for (Object o : allNodes) {
                    if (!this.isSelectable(o)) continue;
                    all.add(o);
                }
                this.model.fireEvent(11, null, -1, -1);
                if (this.model instanceof AbstractTreeModel) {
                    try {
                        this.model.setSelection(all);
                    }
                    finally {
                        this.model.fireEvent(12, null, -1, -1);
                    }
                }
            } else {
                this.model.clearSelection();
            }
        }

        @Override
        public boolean isSelectAll() {
            List allNodes = this.model.getAllNodes();
            for (Object o : allNodes) {
                if (!this.isSelectable(o) || this.model.isSelected(o)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class States<E> {
        private final Set<E> selection = new LinkedHashSet();
        private final Set<E> opens = new LinkedHashSet();

        private States() {
        }
    }

    protected static class Path
    implements Serializable,
    Comparable {
        public final int[] path;

        protected Path(int[] path) {
            this.path = path;
        }

        protected Path(Path p) {
            int length = p.path.length;
            this.path = new int[length];
            for (int i = 0; i < length; ++i) {
                this.path[i] = p.path[i];
            }
        }

        public int hashCode() {
            return Objects.hashCode((int[])this.path);
        }

        public boolean equals(Object o) {
            return o instanceof Path && Objects.equals((Object)this.path, (Object)((Path)o).path);
        }

        public int compareTo(Object o) {
            if (!(o instanceof Path)) {
                throw new WrongValueException(o + " is not Path object");
            }
            int length = this.path.length;
            Path toCompared = (Path)o;
            int[] toPath = toCompared.path;
            int toLength = toCompared.path.length;
            int smaller = length < toLength ? length : toLength;
            for (int i = 0; i < smaller; ++i) {
                if (this.path[i] == toPath[i]) continue;
                return this.path[i] - toPath[i];
            }
            return length - toLength;
        }

        private boolean verifyPrefix(int[] path) {
            return this.verifyPrefix(path, 0);
        }

        private boolean verifyPrefix(int[] path, int update) {
            int i;
            if (path.length > this.path.length) {
                return false;
            }
            for (i = 0; i < path.length && path[i] == this.path[i]; ++i) {
            }
            if (i == path.length) {
                if (update == 1) {
                    int n = i - 1;
                    this.path[n] = this.path[n] + update;
                }
                return true;
            }
            if (i == path.length - 1) {
                if (this.path[i] > path[i]) {
                    int n = i;
                    this.path[n] = this.path[n] + update;
                }
                return false;
            }
            return false;
        }

        public String toString() {
            String result = "[";
            for (int i = 0; i < this.path.length; ++i) {
                result = result + this.path[i] + ", ";
            }
            result = result.substring(0, result.length() - 2) + "]";
            return result;
        }
    }
}

