/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ReflectionUtils {
    private static final Log log = LogFactory.getLog(ReflectionUtils.class);
    private static Indexer defaultIndexer = new DefaultIndexer();
    private static Matcher defaultMatcher = new DefaultMatcher();

    public static Map<String, Object> discoverFields(Class<?> pClazz, Matcher pMatcher) {
        return ReflectionUtils.discoverFields(pClazz, pMatcher, defaultIndexer);
    }

    public static Map<String, Object> discoverFields(Class<?> pClazz) {
        return ReflectionUtils.discoverFields(pClazz, defaultMatcher, defaultIndexer);
    }

    public static Map<String, Object> discoverFields(Class<?> pClazz, Matcher pMatcher, Indexer pIndexer) {
        log.debug((Object)("discovering fields on " + pClazz.getName()));
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> current = pClazz;
        do {
            for (Field field : current.getDeclaredFields()) {
                String fname = field.getName();
                if (!pMatcher.matches(fname)) continue;
                pIndexer.put(result, fname, field);
                log.debug((Object)("discovered field " + fname + " -> " + field));
            }
        } while ((current = current.getSuperclass()) != null);
        return result;
    }

    public static Map<String, Object> discoverMethods(Class<?> pClazz, Matcher pMatcher) {
        return ReflectionUtils.discoverMethods(pClazz, pMatcher, defaultIndexer);
    }

    public static Map<String, Object> discoverMethods(Class<?> pClazz) {
        return ReflectionUtils.discoverMethods(pClazz, defaultMatcher, defaultIndexer);
    }

    public static Map<String, Object> discoverMethods(Class<?> pClazz, Matcher pMatcher, Indexer pIndexer) {
        log.debug((Object)("discovering methods on " + pClazz.getName()));
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> current = pClazz;
        do {
            for (Method method : current.getDeclaredMethods()) {
                String mname = method.getName();
                if (!pMatcher.matches(mname)) continue;
                pIndexer.put(result, mname, method);
                log.debug((Object)("discovered method " + mname + " -> " + method));
            }
        } while ((current = current.getSuperclass()) != null);
        return result;
    }

    public static Object cast(Object o) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(buffer);
        oos.writeObject(o);
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        return ois.readObject();
    }

    public static String getClassName(Object o) {
        if (o == null) {
            return "unknown";
        }
        return o.getClass().getName() + "@" + o.hashCode();
    }

    public static String getClassLoaderName(Object o) {
        if (o == null) {
            return "unknown";
        }
        return ReflectionUtils.getClassName(o.getClass().getClassLoader());
    }

    public static class DefaultIndexer
    implements Indexer {
        @Override
        public void put(Map<String, Object> pMap, String pKey, Object pObject) {
            pMap.put(pKey, pObject);
        }
    }

    public static class DefaultMatcher
    implements Matcher {
        @Override
        public boolean matches(String pName) {
            return true;
        }
    }

    public static interface Indexer {
        public void put(Map<String, Object> var1, String var2, Object var3);
    }

    public static interface Matcher {
        public boolean matches(String var1);
    }
}

