/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public class IllegalRegexRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_MATCH";
    protected final Pattern pattern;
    protected boolean reportAllFailures;

    public IllegalRegexRule(String regex) {
        this(regex, true);
    }

    public IllegalRegexRule(String regex, boolean reportAll) {
        this.pattern = Pattern.compile(regex);
        this.reportAllFailures = reportAll;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        Matcher m = this.pattern.matcher(passwordData.getPassword());
        HashSet<String> matches = new HashSet<String>();
        while (m.find()) {
            String match = m.group();
            if (matches.contains(match)) continue;
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(match)));
            if (!this.reportAllFailures) break;
            matches.add(match);
        }
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(String match) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("match", match);
        m.put("pattern", this.pattern);
        return m;
    }

    public String toString() {
        return String.format("%s@%h::pattern=%s", this.getClass().getName(), this.hashCode(), this.pattern);
    }
}

