/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

public enum MatchBehavior {
    StartsWith,
    EndsWith,
    Contains;


    public boolean match(String text, char c) {
        return this.match(text, String.valueOf(c));
    }

    public boolean match(String text, String s) {
        boolean match;
        switch (this) {
            case StartsWith: {
                match = text.startsWith(s);
                break;
            }
            case EndsWith: {
                match = text.endsWith(s);
                break;
            }
            case Contains: {
                match = text.contains(s);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown match type: " + (Object)((Object)this));
            }
        }
        return match;
    }

    public String toString() {
        String s;
        switch (this) {
            case StartsWith: {
                s = "starts with";
                break;
            }
            case EndsWith: {
                s = "ends with";
                break;
            }
            case Contains: {
                s = "contains";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown match type: " + (Object)((Object)this));
            }
        }
        return s;
    }
}

