/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Expectable;
import org.zkoss.lang.Library;
import org.zkoss.mesg.Messages;
import org.zkoss.web.portlet.Portlets;
import org.zkoss.web.portlet.RenderHttpServletRequest;
import org.zkoss.web.portlet.RenderHttpServletResponse;
import org.zkoss.web.portlet.ResourceHttpServletRequest;
import org.zkoss.web.portlet.ResourceHttpServletResponse;
import org.zkoss.zk.au.http.DHtmlUpdateServlet;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.OperationException;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.DHtmlLayoutServlet;
import org.zkoss.zk.ui.http.DesktopRecycles;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.Utils;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.sys.PageRenderPatch;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.DesktopRecycle;

public class DHtmlLayoutPortlet
extends GenericPortlet {
    private static final Logger log = LoggerFactory.getLogger(DHtmlLayoutPortlet.class);
    private static final String ATTR_PAGE = "zk_page";
    private static final String ATTR_RICHLET = "zk_richlet";
    private String _defpage;
    private boolean isJSR286 = true;
    private static volatile PageRenderPatch _prpatch;

    public void init() throws PortletException {
        this._defpage = this.getPortletConfig().getInitParameter(ATTR_PAGE);
        try {
            Class.forName("javax.portlet.ResourceURL");
        }
        catch (ClassNotFoundException e) {
            this.isJSR286 = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        block14: {
            Session sess;
            PortletPreferences prefs;
            boolean bRichlet = false;
            String path = request.getParameter(ATTR_PAGE);
            if (path == null && (path = (String)request.getAttribute(ATTR_PAGE)) == null && (path = (prefs = request.getPreferences()).getValue(ATTR_PAGE, null)) == null) {
                path = request.getParameter(ATTR_RICHLET);
                boolean bl = bRichlet = path != null;
                if (!bRichlet) {
                    path = (String)request.getAttribute(ATTR_RICHLET);
                    boolean bl2 = bRichlet = path != null;
                    if (!bRichlet) {
                        path = prefs.getValue(ATTR_RICHLET, null);
                        boolean bl3 = bRichlet = path != null;
                        if (!bRichlet) {
                            path = this._defpage;
                        }
                    }
                }
            }
            if (!SessionsCtrl.requestEnter(sess = this.getSession(request, true))) {
                this.handleError(sess, request, response, path, null, Messages.get((int)MZk.TOO_MANY_REQUESTS));
                return;
            }
            SessionsCtrl.setCurrent(sess);
            try {
                Object old;
                HttpServletRequest httpreq;
                block13: {
                    httpreq = RenderHttpServletRequest.getInstance((RenderRequest)request);
                    HttpServletResponse httpres = RenderHttpServletResponse.getInstance((RenderResponse)response);
                    old = I18Ns.setup(httpreq.getSession(), (ServletRequest)httpreq, (ServletResponse)httpres, sess.getWebApp().getConfiguration().getResponseCharset());
                    try {
                        if (this.process(sess, request, response, path, bRichlet)) break block13;
                        this.handleError(sess, request, response, path, null, null);
                    }
                    catch (Throwable ex) {
                        try {
                            this.handleError(sess, request, response, path, ex, null);
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            I18Ns.cleanup((ServletRequest)httpreq, old);
                        }
                    }
                }
                I18Ns.cleanup((ServletRequest)httpreq, old);
            }
            finally {
                SessionsCtrl.requestExit(sess);
                SessionsCtrl.setCurrent((Session)null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        WebManager webman = this.getWebManager();
        WebApp wapp = webman.getWebApp();
        HttpServletRequest httpreq = ResourceHttpServletRequest.getInstance((ResourceRequest)request);
        HttpServletResponse httpres = ResourceHttpServletResponse.getInstance((ResourceResponse)response);
        Session sess = this.getSession(request, false);
        DHtmlUpdateServlet updateServlet = DHtmlUpdateServlet.getUpdateServlet(wapp);
        boolean compress = false;
        String sid = httpreq.getHeader("ZK-SID");
        if (sid != null) {
            response.setProperty("ZK-SID", sid);
        }
        if (sess == null) {
            try {
                updateServlet.denoteSessionTimeout(wapp, httpreq, httpres, compress);
            }
            catch (ServletException e) {
                log.warn("", (Throwable)e);
            }
            return;
        }
        Object old = I18Ns.setup(httpreq.getSession(), (ServletRequest)httpreq, (ServletResponse)httpres, "UTF-8");
        SessionsCtrl.setCurrent(sess);
        try {
            response.setProperty("Pragma", "no-cache");
            response.setProperty("Cache-Control", "no-cache");
            response.setProperty("Cache-Control", "no-store");
            response.setProperty("Expires", "-1");
            updateServlet.process(sess, httpreq, httpres, compress);
        }
        catch (ServletException e) {
            log.warn("", (Throwable)e);
        }
        finally {
            I18Ns.cleanup((ServletRequest)httpreq, old);
            SessionsCtrl.requestExit(sess);
            SessionsCtrl.setCurrent((Session)null);
        }
    }

    private Session getSession(Object request, boolean create) throws PortletException {
        WebApp wapp = this.getWebManager().getWebApp();
        PortletSession psess = null;
        if (request instanceof RenderRequest) {
            psess = ((RenderRequest)request).getPortletSession();
        } else if (request instanceof ResourceRequest) {
            psess = ((ResourceRequest)request).getPortletSession();
        }
        Session sess = SessionsCtrl.getSession(wapp, psess);
        if (sess == null && create) {
            sess = SessionsCtrl.newSession(wapp, psess, request);
        }
        return sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(Session sess, RenderRequest request, RenderResponse response, String path, boolean bRichlet) throws PortletException, IOException {
        WebManager webman = this.getWebManager();
        WebApp wapp = webman.getWebApp();
        WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
        HttpServletRequest httpreq = RenderHttpServletRequest.getInstance((RenderRequest)request);
        HttpServletResponse httpres = RenderHttpServletResponse.getInstance((RenderResponse)response);
        ServletContext svlctx = wapp.getServletContext();
        DesktopRecycle dtrc = wapp.getConfiguration().getDesktopRecycle();
        Desktop desktop = dtrc != null ? DesktopRecycles.beforeService(dtrc, svlctx, sess, httpreq, httpres, path) : null;
        try {
            if (desktop != null) {
                Page page2 = Utils.getMainPage(desktop);
                if (page2 != null) {
                    ExecutionImpl exec = new ExecutionImpl(svlctx, httpreq, httpres, desktop, page2);
                    DHtmlLayoutPortlet.fixContentType(response);
                    wappc.getUiEngine().recycleDesktop(exec, page2, response.getWriter());
                } else {
                    desktop = null;
                }
            }
            if (desktop == null) {
                Page page;
                desktop = webman.getDesktop(sess, (ServletRequest)httpreq, (ServletResponse)httpres, path, true);
                if (desktop == null) {
                    boolean page2 = true;
                    return page2;
                }
                RequestInfoImpl ri = new RequestInfoImpl(wapp, sess, desktop, httpreq, PageDefinitions.getLocator(wapp, path));
                ((SessionCtrl)((Object)sess)).notifyClientRequest(true);
                PageRenderPatch patch = DHtmlLayoutPortlet.getRenderPatch();
                Writer out = patch.beforeRender(ri);
                UiFactory uf = wappc.getUiFactory();
                if (uf.isRichlet(ri, bRichlet)) {
                    Richlet richlet = uf.getRichlet(ri, path);
                    if (richlet == null) {
                        boolean bl = false;
                        return bl;
                    }
                    page = WebManager.newPage(uf, (RequestInfo)ri, richlet, (ServletResponse)httpres, path);
                    ExecutionImpl exec = new ExecutionImpl(svlctx, httpreq, httpres, desktop, page);
                    DHtmlLayoutPortlet.fixContentType(response);
                    if (this.isJSR286) {
                        ResourceURL url = response.createResourceURL();
                        page.setAttribute("org.zkoss.portlet2.resourceURL", (Object)response.encodeURL(url.toString()), 2);
                        page.setAttribute("org.zkoss.portlet2.namespace", (Object)this.getNamespace(response), 2);
                    }
                    wappc.getUiEngine().execNewPage((Execution)exec, richlet, page, out != null ? out : response.getWriter());
                } else if (path != null) {
                    PageDefinition pagedef = uf.getPageDefinition(ri, path);
                    if (pagedef == null) {
                        boolean exec = false;
                        return exec;
                    }
                    page = WebManager.newPage(uf, (RequestInfo)ri, pagedef, (ServletResponse)httpres, path);
                    ExecutionImpl exec = new ExecutionImpl(svlctx, httpreq, httpres, desktop, page);
                    DHtmlLayoutPortlet.fixContentType(response);
                    if (this.isJSR286) {
                        ResourceURL url = response.createResourceURL();
                        page.setAttribute("org.zkoss.portlet2.resourceURL", (Object)response.encodeURL(url.toString()), 2);
                        page.setAttribute("org.zkoss.portlet2.namespace", (Object)this.getNamespace(response), 2);
                    }
                    wappc.getUiEngine().execNewPage((Execution)exec, pagedef, page, out != null ? out : response.getWriter());
                } else {
                    boolean bl = true;
                    return bl;
                }
                if (out != null) {
                    patch.patchRender(ri, page, out, response.getWriter());
                }
            }
        }
        finally {
            if (dtrc != null) {
                DesktopRecycles.afterService(dtrc, desktop);
            }
        }
        return true;
    }

    protected String getNamespace(RenderResponse response) {
        String s = Library.getProperty((String)"org.zkoss.zk.portlet2.namespacedParameter.enabled");
        if (s == null || "false".equals(s)) {
            return "";
        }
        return response.getNamespace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PageRenderPatch getRenderPatch() {
        if (_prpatch != null) {
            return _prpatch;
        }
        Class<DHtmlLayoutPortlet> clazz = DHtmlLayoutPortlet.class;
        synchronized (DHtmlLayoutPortlet.class) {
            PageRenderPatch patch;
            if (_prpatch != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return _prpatch;
            }
            String clsnm = Library.getProperty((String)"org.zkoss.zk.portlet.PageRenderPatch.class");
            if (clsnm == null) {
                patch = new PageRenderPatch(){

                    public Writer beforeRender(RequestInfo reqInfo) {
                        return null;
                    }

                    public void patchRender(RequestInfo reqInfo, Page page, Writer result, Writer out) throws IOException {
                    }
                };
            } else {
                try {
                    patch = (PageRenderPatch)Classes.newInstanceByThread((String)clsnm);
                }
                catch (ClassCastException ex) {
                    throw new UiException(clsnm + " must implement " + PageRenderPatch.class.getName());
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex, "Unable to instantiate");
                }
            }
            _prpatch = patch;
            // ** MonitorExit[var0] (shouldn't be in output)
            return _prpatch;
        }
    }

    private static void fixContentType(RenderResponse response) {
        if (response.getContentType() == null) {
            response.setContentType("text/html;charset=UTF-8");
        }
    }

    private final WebManager getWebManager() throws PortletException {
        WebManager webman = (WebManager)this.getPortletContext().getAttribute("javax.zkoss.zk.ui.WebManager");
        if (webman == null) {
            throw new PortletException("The Layout Servlet not found. Make sure <load-on-startup> is specified for " + DHtmlLayoutServlet.class.getName());
        }
        return webman;
    }

    private void handleError(Session sess, RenderRequest request, RenderResponse response, String path, Throwable err, String msg) throws PortletException, IOException {
        Throwable cause;
        if (err instanceof OperationException && (cause = err.getCause()) instanceof Expectable) {
            err = cause;
        }
        if (err != null) {
            String errpg = sess.getWebApp().getConfiguration().getErrorPage(sess.getDeviceType(), err);
            if (errpg != null) {
                try {
                    request.setAttribute("javax.servlet.error.message", (Object)Exceptions.getMessage((Throwable)err));
                    request.setAttribute("javax.servlet.error.exception", (Object)err);
                    request.setAttribute("javax.servlet.error.exception_type", err.getClass());
                    request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
                    if (this.process(sess, request, response, errpg, false)) {
                        return;
                    }
                    log.warn("The error page not found: " + errpg);
                }
                catch (IOException iOException) {
                }
                catch (Throwable ex) {
                    log.warn("Failed to load the error page: " + errpg, ex);
                }
            }
            if (msg == null) {
                msg = Messages.get((int)MZk.PAGE_FAILED, (Object[])new Object[]{path, Exceptions.getMessage((Throwable)err), Exceptions.formatStackTrace(null, (Throwable)err, null, (int)6)});
            }
        } else if (msg == null) {
            msg = path != null ? Messages.get((int)MZk.PAGE_NOT_FOUND, (Object[])new Object[]{path}) : Messages.get((int)MZk.PORTLET_PAGE_REQUIRED);
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("px_alert_type", "error");
        attrs.put("px_alert", msg);
        Portlets.include((PortletContext)this.getPortletContext(), (RenderRequest)request, (RenderResponse)response, (String)"~./html/alert.dsp", attrs, (int)0);
    }
}

