/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.lang.SystemException;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.util.CacheMap;
import org.zkoss.util.media.Media;
import org.zkoss.util.resource.Labels;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.au.out.AuBookmark;
import org.zkoss.zk.au.out.AuClientInfo;
import org.zkoss.zk.au.out.AuHistoryState;
import org.zkoss.zk.device.Device;
import org.zkoss.zk.device.DeviceNotFoundException;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.BookmarkEvent;
import org.zkoss.zk.ui.event.ClientInfoEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.HistoryPopStateEvent;
import org.zkoss.zk.ui.event.VisibilityChangeEvent;
import org.zkoss.zk.ui.ext.RawId;
import org.zkoss.zk.ui.ext.ScopeListener;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.impl.AbortByRemoveDesktop;
import org.zkoss.zk.ui.impl.EventInterceptors;
import org.zkoss.zk.ui.impl.PhantomExecution;
import org.zkoss.zk.ui.impl.RequestQueueImpl;
import org.zkoss.zk.ui.impl.SimpleScope;
import org.zkoss.zk.ui.impl.SynchronizedScope;
import org.zkoss.zk.ui.impl.Utils;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.EventProcessingThread;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.IdGenerator;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.sys.RequestQueue;
import org.zkoss.zk.ui.sys.Scheduler;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.Storage;
import org.zkoss.zk.ui.sys.StubComponent;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.Visualizer;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.DesktopActivationListener;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zk.ui.util.DesktopSerializationListener;
import org.zkoss.zk.ui.util.EventInterceptor;
import org.zkoss.zk.ui.util.ExecutionCleanup;
import org.zkoss.zk.ui.util.ExecutionInit;
import org.zkoss.zk.ui.util.ExecutionMonitor;
import org.zkoss.zk.ui.util.Monitor;
import org.zkoss.zk.ui.util.UiLifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesktopImpl
implements Desktop,
DesktopCtrl,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(DesktopImpl.class);
    private static final long serialVersionUID = 20101123L;
    private static final String DOWNLOAD_PREFIX = "dwnmed-";
    private static final String ATTR_PUSH_COUNT = "org.zkoss.zk.ui.pushes.count";
    private static final String ON_SCHEDULE = "onSchedule";
    private static final String FILENAME_HOLDER = "$zk_fn$";
    private transient WebApp _wapp;
    private transient Session _sess;
    private String _id;
    private String _dir = "";
    private final String _path;
    private final String _qs;
    private final String _updateURI;
    private final List<Page> _pages = new LinkedList<Page>();
    private transient Map<String, Component> _comps;
    private transient SimpleScope _attrs;
    private transient Execution _exec;
    private final List<ScheduleInfo<? extends Event>> _schedInfos = new LinkedList<ScheduleInfo<? extends Event>>();
    private Component _dummyTarget = null;
    private int _nextKey;
    private int _nextUuid;
    private String _uuidPrefix;
    private transient RequestQueue _rque;
    private String _bookmark = "";
    private String _devType = "ajax";
    private transient Device _dev;
    private CacheMap<String, Media> _meds;
    private int _medId;
    private transient ServerPush _spush;
    private transient ServerPush _spushTemp;
    private final EventInterceptors _eis = new EventInterceptors();
    private transient List<DesktopCleanup> _dtCleans;
    private transient List<ExecutionInit> _execInits;
    private transient List<ExecutionCleanup> _execCleans;
    private transient List<UiLifeCycle> _uiCycles;
    private transient List<AuService> _ausvcs;
    private transient Visualizer _uv;
    private transient Object _uvLock;
    private final Lock _storageLock = new ReentrantLock();
    private transient List<RecycleInfo> _uuidRecycle;
    private transient ReqResult _lastRes;
    private transient List<AuResponse> _piggyRes;
    private transient Set<String> _clientPerDesktops;
    private static final int MAX_RESPONSE_ID = 999;
    private int _resId;
    private boolean _piggybackListened;
    private boolean _spushShallStop;
    private Set<Serializable> enablers = Collections.synchronizedSet(new HashSet());
    private static final String DESKTOP_ID_PREFIX = "z_";
    private static int _keyWithoutDC;
    private static Boolean _recycleUuidDisabled;
    private static final String ATTR_PIGGYBACK_POSTED = "org.zkoss.zk.ui.impl.piggyback.posted";
    private static Long _maxSchedTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DesktopImpl(WebApp wapp, String updateURI, String path, String deviceType, Object request) {
        if (updateURI == null || wapp == null) {
            throw new IllegalArgumentException("null");
        }
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            ((ExecutionCtrl)((Object)exec)).setDesktop(this);
        }
        this._wapp = wapp;
        this._updateURI = updateURI;
        this.init();
        this._sess = Sessions.getCurrent();
        String dir = null;
        if (path != null) {
            this._path = path;
            int j = path.lastIndexOf(47);
            if (j >= 0) {
                dir = path.substring(0, j + 1);
            }
        } else {
            this._path = "";
        }
        this.setCurrentDirectory(dir);
        this._qs = DesktopImpl.getQueryString(request);
        if (deviceType != null && deviceType.length() != 0) {
            this.setDeviceType(deviceType);
        }
        Configuration config = this._wapp.getConfiguration();
        this._exec = exec;
        try {
            Monitor monitor;
            WebAppCtrl wappc = (WebAppCtrl)((Object)this._wapp);
            DesktopCache dc = this._sess != null ? wappc.getDesktopCache(this._sess) : null;
            IdGenerator idgen = wappc.getIdGenerator();
            if (idgen != null) {
                this._id = idgen.nextDesktopId(this);
            }
            if (this._id == null) {
                this._id = DesktopImpl.nextDesktopId(dc);
            } else if (idgen != null) {
                ComponentsCtrl.checkUuid(this._id);
            }
            this.updateUuidPrefix();
            this.resetLabels();
            config.invokeDesktopInits(this, request);
            if (exec != null && exec.isVoided()) {
                return;
            }
            if (dc != null) {
                dc.addDesktop(this);
            }
            if ((monitor = config.getMonitor()) != null) {
                try {
                    monitor.desktopCreated(this);
                }
                catch (Throwable ex) {
                    log.error("", ex);
                }
            }
        }
        finally {
            this._exec = null;
        }
    }

    private static String getQueryString(Object request) {
        try {
            if (request instanceof HttpServletRequest) {
                return ((HttpServletRequest)request).getQueryString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getQueryString() {
        return this._qs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String nextDesktopId(DesktopCache dc) {
        if (dc != null) {
            return ComponentsCtrl.encodeId(new StringBuffer(12).append(DESKTOP_ID_PREFIX), dc.getNextKey()).toString();
        }
        Class<DesktopImpl> clazz = DesktopImpl.class;
        synchronized (DesktopImpl.class) {
            int v = _keyWithoutDC++;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return ComponentsCtrl.encodeId(new StringBuffer(12).append("_g"), v).toString();
        }
    }

    private void init() {
        this._uvLock = new Object();
        this._rque = this.newRequestQueue();
        this._comps = new HashMap<String, Component>(64);
        this._attrs = new SynchronizedScope(this);
    }

    private void updateUuidPrefix() {
        StringBuffer sb = new StringBuffer();
        int val = this._id.hashCode();
        if (val < 0 && (val -= Integer.MIN_VALUE) < 0) {
            val = -val;
        }
        int v = val % 26 + 36;
        sb.append(DesktopImpl.toLetter(v));
        v = (val /= 26) % 36;
        sb.append(DesktopImpl.toLetter(v));
        v = (val /= 36) % 62;
        sb.append(DesktopImpl.toLetter(v));
        this._uuidPrefix = sb.append(DesktopImpl.toLetter((val /= 62) % 26 + 10)).toString();
    }

    private static final char toLetter(int v) {
        if (v < 10) {
            return (char)(48 + v);
        }
        if (v < 36) {
            return (char)(v + 55);
        }
        return (char)(v + 61);
    }

    private void resetLabels() {
        if (!Boolean.valueOf(Library.getProperty((String)"org.zkoss.util.label.cache", (String)"true")).booleanValue()) {
            Labels.reset();
        }
    }

    @Override
    public String getId() {
        return this._id;
    }

    protected RequestQueue newRequestQueue() {
        return new RequestQueueImpl();
    }

    @Override
    public String getDeviceType() {
        return this._devType;
    }

    @Override
    public Device getDevice() {
        if (this._dev == null) {
            this._dev = Devices.getDevice(this._devType);
        }
        return this._dev;
    }

    @Override
    public void setDeviceType(String deviceType) {
        if (!this._devType.equals(deviceType)) {
            if (deviceType == null || deviceType.length() == 0) {
                throw new IllegalArgumentException("empty");
            }
            if (!Devices.exists(deviceType)) {
                throw new DeviceNotFoundException(deviceType, MZk.NOT_FOUND, deviceType);
            }
            if (!this._comps.isEmpty()) {
                throw new UiException("Unable to change the device type since some components are attached.");
            }
            this._devType = deviceType;
            this._dev = null;
            if (this._sess != null) {
                ((SessionCtrl)((Object)this._sess)).setDeviceType(this._devType);
            }
        }
    }

    @Override
    public Execution getExecution() {
        return this._exec;
    }

    @Override
    public final Session getSession() {
        return this._sess;
    }

    @Override
    public String getUpdateURI(String pathInfo) {
        String uri;
        if (pathInfo == null || pathInfo.length() == 0) {
            uri = this._updateURI;
        } else {
            if (pathInfo.charAt(0) != '/') {
                pathInfo = '/' + pathInfo;
            }
            uri = this._updateURI + pathInfo;
        }
        return this._exec.encodeURL(uri);
    }

    @Override
    public String getDynamicMediaURI(Component comp, String pathInfo) {
        if (!(((ComponentCtrl)((Object)comp)).getExtraCtrl() instanceof DynamicMedia)) {
            throw new UiException(DynamicMedia.class + " not implemented by getExtraCtrl() of " + comp);
        }
        StringBuffer sb = new StringBuffer(64).append("/view/").append(this.getId()).append('/').append(comp.getUuid()).append('/');
        Strings.encode((StringBuffer)sb, (int)(System.identityHashCode(comp) & 0xFFFF));
        if (pathInfo != null && pathInfo.length() > 0) {
            if (pathInfo.charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(pathInfo);
        }
        return this.getUpdateURI(sb.toString());
    }

    @Override
    public String getDownloadMediaURI(Media media, String pathInfo) {
        if (media == null) {
            throw new IllegalArgumentException("null media");
        }
        if (this._meds == null) {
            this._meds = new CacheMap();
            this._meds.setMaxSize(500);
            this._meds.setLifetime(900000);
        } else {
            this.housekeep();
        }
        String medId = Strings.encode((StringBuffer)new StringBuffer(12).append(DOWNLOAD_PREFIX), (int)this._medId++).toString();
        this._meds.put((Object)medId, (Object)media);
        StringBuffer sb = new StringBuffer(64).append("/view/").append(this.getId()).append('/').append(medId).append('/');
        Strings.encode((StringBuffer)sb, (int)(System.identityHashCode(media) & 0xFFFF));
        if (pathInfo != null && pathInfo.length() > 0) {
            sb.append('/').append(FILENAME_HOLDER);
            if (pathInfo.charAt(0) == '/') {
                pathInfo = pathInfo.substring(1);
            }
            String uri = this.getUpdateURI(sb.toString());
            int holderPos = uri.lastIndexOf(FILENAME_HOLDER);
            return uri.substring(0, holderPos) + this.encodeFilename(pathInfo) + uri.substring(holderPos + FILENAME_HOLDER.length());
        }
        return this.getUpdateURI(sb.toString());
    }

    private String encodeFilename(String filename) {
        if (filename == null) {
            return "";
        }
        try {
            return Encodes.encodeURIComponent((String)filename);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    @Override
    public Media getDownloadMedia(String medId, boolean reserved) {
        return this._meds != null ? (Media)this._meds.get((Object)medId) : null;
    }

    private void housekeep() {
        if (this._meds != null) {
            this._meds.expunge();
        }
    }

    @Override
    public Page getPage(String pageId) {
        Page page = this.getPageIfAny(pageId);
        if (page == null) {
            throw new ComponentNotFoundException("Page not found: " + pageId);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getPageIfAny(String pageId) {
        Page page = null;
        List<Page> list = this._pages;
        synchronized (list) {
            for (Page pg : this._pages) {
                if (Objects.equals((Object)pageId, (Object)pg.getId())) {
                    return pg;
                }
                if (!Objects.equals((Object)pageId, (Object)pg.getUuid())) continue;
                page = pg;
            }
        }
        return page;
    }

    @Override
    public boolean hasPage(String pageId) {
        return this.getPageIfAny(pageId) != null;
    }

    @Override
    public Collection<Page> getPages() {
        return Collections.unmodifiableCollection(this._pages);
    }

    @Override
    public Page getFirstPage() {
        return this._pages.isEmpty() ? null : this._pages.get(0);
    }

    @Override
    public String getBookmark() {
        return this._bookmark;
    }

    @Override
    public void setBookmark(String name) {
        this.setBookmark(name, false);
    }

    @Override
    public void setBookmark(String name, boolean replace) {
        if (this._exec == null) {
            throw new IllegalStateException("Not the current desktop: " + this);
        }
        this._bookmark = name;
        this.addResponse(new AuBookmark(name, replace));
    }

    private void addResponse(AuResponse response) {
        ((WebAppCtrl)((Object)this._wapp)).getUiEngine().addResponse(response);
    }

    @Override
    public Collection<Component> getComponents() {
        return this._comps.values();
    }

    @Override
    public Component getComponentByUuid(String uuid) {
        Component comp = this._comps.get(uuid);
        if (comp == null) {
            throw new ComponentNotFoundException("Component not found: " + uuid);
        }
        return comp;
    }

    @Override
    public Component getComponentByUuidIfAny(String uuid) {
        return this._comps.get(uuid);
    }

    @Override
    public void addComponent(Component comp) {
        LanguageDefinition langdef = comp.getDefinition().getLanguageDefinition();
        if (langdef != null && !this._devType.equals(langdef.getDeviceType())) {
            throw new UiException("Component, " + comp + ", does not belong to the same device type of the desktop, " + this._devType);
        }
        String uuid = comp.getUuid();
        Component old = this._comps.put(uuid, comp);
        if (old != comp && old != null) {
            this._comps.put(uuid, old);
            throw new InternalError("Caller shall prevent it: Register a component twice: " + comp);
        }
    }

    @Override
    public boolean removeComponent(Component comp, boolean recycleAllowed) {
        String uuid = comp.getUuid();
        if (this._comps.remove(uuid) == null || !recycleAllowed || DesktopImpl.recycleUuidDisabled() || comp instanceof StubComponent) {
            return false;
        }
        if (comp instanceof RawId && (!ComponentsCtrl.isAutoUuid(uuid) || ((WebAppCtrl)((Object)this._wapp)).getIdGenerator() != null)) {
            return false;
        }
        int execId = DesktopImpl.getExecId();
        RecycleInfo ri = null;
        if (this._uuidRecycle == null) {
            this._uuidRecycle = new LinkedList<RecycleInfo>();
        } else {
            for (RecycleInfo r : this._uuidRecycle) {
                if (r.execId != execId) continue;
                ri = r;
                break;
            }
        }
        if (ri == null) {
            ri = new RecycleInfo(execId);
            this._uuidRecycle.add(ri);
        }
        ri.uuids.add(uuid);
        return true;
    }

    @Override
    public Component mapComponent(String uuid, Component comp) {
        if (uuid == null) {
            throw new IllegalArgumentException("null");
        }
        return comp != null ? this._comps.put(uuid, comp) : this._comps.remove(uuid);
    }

    private static int getExecId() {
        Execution exec = Executions.getCurrent();
        return exec != null ? System.identityHashCode(exec) : 0;
    }

    private static boolean recycleUuidDisabled() {
        if (_recycleUuidDisabled == null) {
            _recycleUuidDisabled = "true".equals(Library.getProperty((String)"org.zkoss.zk.ui.uuidRecycle.disabled"));
        }
        return _recycleUuidDisabled;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this._attrs.getAttributes();
    }

    @Override
    public Object getAttribute(String name) {
        return this._attrs.getAttribute(name);
    }

    @Override
    public Object getAttribute(String name, boolean recurse) {
        Object val = this.getAttribute(name);
        if (val != null || !recurse || this.hasAttribute(name)) {
            return val;
        }
        if (this._sess != null) {
            return this._sess.getAttribute(name, true);
        }
        if (this._wapp != null) {
            return this._wapp.getAttribute(name, true);
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this._attrs.hasAttribute(name);
    }

    @Override
    public boolean hasAttribute(String name, boolean recurse) {
        if (this.hasAttribute(name)) {
            return true;
        }
        if (recurse) {
            if (this._sess != null) {
                return this._sess.hasAttribute(name, true);
            }
            if (this._wapp != null) {
                return this._wapp.hasAttribute(name, true);
            }
        }
        return false;
    }

    @Override
    public Object setAttribute(String name, Object value) {
        return this._attrs.setAttribute(name, value);
    }

    @Override
    public Object setAttribute(String name, Object value, boolean recurse) {
        if (recurse && !this.hasAttribute(name)) {
            if (this._sess != null) {
                if (this._sess.hasAttribute(name, true)) {
                    return this._sess.setAttribute(name, value, true);
                }
            } else if (this._wapp != null && this._wapp.hasAttribute(name, true)) {
                return this._wapp.setAttribute(name, value, true);
            }
        }
        return this.setAttribute(name, value);
    }

    @Override
    public Object removeAttribute(String name) {
        return this._attrs.removeAttribute(name);
    }

    @Override
    public Object removeAttribute(String name, boolean recurse) {
        if (recurse && !this.hasAttribute(name)) {
            if (this._sess != null) {
                if (this._sess.hasAttribute(name, true)) {
                    return this._sess.removeAttribute(name, true);
                }
            } else if (this._wapp != null && this._wapp.hasAttribute(name, true)) {
                return this._wapp.removeAttribute(name, true);
            }
            return null;
        }
        return this.removeAttribute(name);
    }

    @Override
    public boolean addScopeListener(ScopeListener listener) {
        return this._attrs.addScopeListener(listener);
    }

    @Override
    public boolean removeScopeListener(ScopeListener listener) {
        return this._attrs.removeScopeListener(listener);
    }

    @Override
    public WebApp getWebApp() {
        return this._wapp;
    }

    @Override
    public String getRequestPath() {
        return this._path;
    }

    @Override
    public String getCurrentDirectory() {
        return this._dir;
    }

    @Override
    public void setCurrentDirectory(String dir) {
        if (dir == null) {
            dir = "";
        } else {
            int len = dir.length() - 1;
            if (len >= 0 && dir.charAt(len) != '/') {
                dir = dir + '/';
            }
        }
        this._dir = dir;
    }

    @Override
    public RequestQueue getRequestQueue() {
        this.housekeep();
        return this._rque;
    }

    @Override
    public void setExecution(Execution exec) {
        this._exec = exec;
    }

    @Override
    public void service(AuRequest request, boolean everError) {
        Component comp;
        if (this._ausvcs != null) {
            Iterator it = new LinkedList<AuService>(this._ausvcs).iterator();
            while (it.hasNext()) {
                if (!((AuService)it.next()).service(request, everError)) continue;
                return;
            }
        }
        if ((comp = request.getComponent()) != null) {
            AuService svc = comp.getAuService();
            if (!(svc != null && svc.service(request, everError) || comp.getDesktop() == null)) {
                ((ComponentCtrl)((Object)comp)).service(request, everError);
            }
            return;
        }
        String cmd = request.getCommand();
        if ("onBookmarkChange".equals(cmd)) {
            BookmarkEvent evt = BookmarkEvent.getBookmarkEvent(request);
            this._bookmark = evt.getBookmark();
            Events.postEvent(evt);
        } else if ("onClientInfo".equals(cmd)) {
            Events.postEvent(ClientInfoEvent.getClientInfoEvent(request));
        } else if ("onVisibilityChange".equals(cmd)) {
            Events.postEvent(VisibilityChangeEvent.getVisibilityChangeEvent(request));
        } else if ("onHistoryPopState".equals(cmd)) {
            Events.postEvent(HistoryPopStateEvent.getHistoryPopStateEvent(request));
        } else if ("rmDesktop".equals(cmd)) {
            ((WebAppCtrl)((Object)request.getDesktop().getWebApp())).getUiEngine().setAbortingReason(new AbortByRemoveDesktop());
        } else if ("redraw".equals(cmd)) {
            this.invalidate();
        } else if ("error".equals(cmd)) {
            Map<String, Object> data = request.getData();
            if (data != null) {
                log.error(this + " client error: " + data.get("message"));
            }
        } else if ("fallbackServerPushClass".equals(cmd)) {
            try {
                this.getDevice().setServerPushClass(Classes.forNameByThread((String)"org.zkoss.zkex.ui.comet.CometServerPush"));
            }
            catch (ClassNotFoundException e) {
                throw new UiException("Class not found: org.zkoss.zkex.ui.comet.CometServerPush");
            }
        } else {
            Events.postEvent(Event.getEvent(request));
        }
    }

    @Override
    public Visualizer getVisualizer() {
        return this._uv;
    }

    @Override
    public void setVisualizer(Visualizer uv) {
        this._uv = uv;
    }

    @Override
    public Object getActivationLock() {
        return this._uvLock;
    }

    @Override
    public int getNextKey() {
        return this._nextKey++;
    }

    @Override
    public String getNextUuid(Page page) {
        String uuid;
        IdGenerator idgen = ((WebAppCtrl)((Object)this._wapp)).getIdGenerator();
        String string = uuid = idgen != null ? idgen.nextPageUuid(page) : null;
        if (uuid == null) {
            return this.nextUuid();
        }
        ComponentsCtrl.checkUuid(uuid);
        return uuid;
    }

    @Override
    public String getNextUuid(Component comp) {
        if (this._uuidRecycle != null && !this._uuidRecycle.isEmpty()) {
            int execId = DesktopImpl.getExecId();
            Iterator<RecycleInfo> it = this._uuidRecycle.iterator();
            while (it.hasNext()) {
                RecycleInfo ri = it.next();
                if (ri.execId == execId) continue;
                String uuid = (String)ri.uuids.remove(0);
                if (ri.uuids.isEmpty()) {
                    it.remove();
                }
                return uuid;
            }
        }
        IdGenerator idgen = ((WebAppCtrl)((Object)this._wapp)).getIdGenerator();
        String uuid = null;
        if (idgen != null) {
            try {
                uuid = idgen.nextComponentUuid(this, comp, Utils.getComponentInfo(comp));
            }
            catch (AbstractMethodError ex) {
                try {
                    Method method = idgen.getClass().getMethod("nextComponentUuid", Desktop.class, Component.class);
                    Fields.setAccessible((AccessibleObject)method, (boolean)true);
                    uuid = (String)method.invoke((Object)idgen, this, comp);
                }
                catch (Exception e) {
                    throw UiException.Aide.wrap(e);
                }
            }
        }
        if (uuid == null) {
            return this.nextUuid();
        }
        ComponentsCtrl.checkUuid(uuid);
        return uuid;
    }

    private String nextUuid() {
        return ComponentsCtrl.toAutoId(this._uuidPrefix, this._nextUuid++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPage(Page page) {
        List<Page> list = this._pages;
        synchronized (list) {
            this._pages.add(page);
            if (log.isDebugEnabled()) {
                log.debug("After added, pages: {}", this._pages);
            }
        }
        this.afterPageAttached(page, this);
        this._wapp.getConfiguration().afterPageAttached(page, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePage(Page page) {
        List<Page> list = this._pages;
        synchronized (list) {
            if (!this._pages.remove(page)) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("After removed, pages: {}", this._pages);
            }
        }
        this.removeComponents(page.getRoots());
        this.afterPageDetached(page, this);
        ((PageCtrl)((Object)page)).destroy();
        this._wapp.getConfiguration().afterPageDetached(page, this);
    }

    private void removeComponents(Collection<Component> comps) {
        for (Component comp : comps) {
            this.removeComponents(comp.getChildren());
            this.removeComponent(comp, true);
        }
    }

    @Override
    public void setId(String id) {
        DesktopCache dc;
        if (!((ExecutionCtrl)((Object)this._exec)).isRecovering()) {
            throw new IllegalStateException("Callable only in recovring");
        }
        if (id == null || id.length() <= 1 || id.charAt(0) != 'g') {
            throw new IllegalArgumentException("Invalid desktop ID. You have to recover to the original value, not creating a new value: " + id);
        }
        DesktopCache desktopCache = dc = this._sess != null ? ((WebAppCtrl)((Object)this._wapp)).getDesktopCache(this._sess) : null;
        if (dc != null) {
            dc.removeDesktop(this);
        }
        this._id = id;
        this.updateUuidPrefix();
        if (dc != null) {
            dc.addDesktop(this);
        }
    }

    @Override
    public void recoverDidFail(Throwable ex) {
        ((WebAppCtrl)((Object)this._wapp)).getDesktopCache(this._sess).removeDesktop(this);
    }

    @Override
    public void recycle() {
        this._clientPerDesktops = null;
    }

    boolean markClientInfoPerDesktop(String key) {
        if (this._clientPerDesktops == null) {
            this._clientPerDesktops = new HashSet<String>(32);
        }
        return this._clientPerDesktops.add(key);
    }

    @Override
    public boolean isAlive() {
        return this._rque != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ExecutionMonitor execmon = this._wapp != null ? this._wapp.getConfiguration().getExecutionMonitor() : null;
        this._rque = null;
        ServerPush sp = this._spush;
        if (sp != null) {
            this._spush = null;
            try {
                sp.stop();
            }
            catch (Throwable ex) {
                log.warn("Failed to stop server-push, " + sp, ex);
            }
        }
        try {
            ArrayList<Page> pages = new ArrayList<Page>(this._pages);
            for (Page page : pages) {
                try {
                    ((PageCtrl)((Object)page)).destroy();
                }
                catch (Throwable ex) {
                    log.warn("Failed to destroy " + page, ex);
                }
            }
            this._pages.clear();
        }
        catch (Throwable ex) {
            log.warn("Failed to clean up pages of " + this, ex);
        }
        if (execmon != null) {
            execmon.desktopDestroy(this);
        }
        this._attrs.getAttributes().clear();
        this._comps = new HashMap<String, Component>(2);
        this._meds = null;
        Object lock = this.getActivationLock();
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
            }
        }
    }

    @Override
    public Collection<EventProcessingThread> getSuspendedThreads() {
        return ((WebAppCtrl)((Object)this._wapp)).getUiEngine().getSuspendedThreads(this);
    }

    @Override
    public boolean ceaseSuspendedThread(EventProcessingThread evtthd, String cause) {
        return ((WebAppCtrl)((Object)this._wapp)).getUiEngine().ceaseSuspendedThread(this, evtthd, cause);
    }

    public String toString() {
        return "[Desktop " + this._id + ':' + this._path + ']';
    }

    @Override
    public void sessionWillPassivate(Session sess) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            this.sessWillPassivate();
        } else {
            exec = new PhantomExecution(this);
            this.safeActivate(exec);
            try {
                this.sessWillPassivate();
            }
            finally {
                this.safeDeactivate(exec);
            }
        }
    }

    @Override
    public void sessionDidActivate(Session sess) {
        this._sess = sess;
        this._wapp = sess.getWebApp();
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            this.sessDidActivate();
        } else {
            exec = new PhantomExecution(this);
            this.safeActivate(exec);
            try {
                this.sessDidActivate();
                if (this._spushTemp != null) {
                    this.enableServerPush0(this._spushTemp, true);
                }
            }
            finally {
                this.safeDeactivate(exec);
                this._spushTemp = null;
            }
        }
    }

    private void safeActivate(Execution exec) {
        UiEngine uieng = ((WebAppCtrl)((Object)this._wapp)).getUiEngine();
        if (uieng != null) {
            uieng.activate(exec);
        } else {
            this._exec = exec;
            ExecutionsCtrl.setCurrent(exec);
        }
    }

    private void safeDeactivate(Execution exec) {
        UiEngine uieng = ((WebAppCtrl)((Object)this._wapp)).getUiEngine();
        if (uieng != null) {
            uieng.deactivate(exec);
        } else {
            this._exec = null;
            ExecutionsCtrl.setCurrent(null);
        }
    }

    private void sessWillPassivate() {
        for (Page page : this._pages) {
            ((PageCtrl)((Object)page)).sessionWillPassivate(this);
        }
        if (this._dev != null) {
            this._dev.sessionWillPassivate(this);
        }
        this.willPassivate(this._attrs.getAttributes().values());
        this.willPassivate(this._attrs.getListeners());
        this.willPassivate(this._dtCleans);
        this.willPassivate(this._execInits);
        this.willPassivate(this._execCleans);
        this.willPassivate(this._uiCycles);
    }

    private void sessDidActivate() {
        if (this._dev != null) {
            this._dev.sessionDidActivate(this);
        }
        for (Page page : this._pages) {
            ((PageCtrl)((Object)page)).sessionDidActivate(this);
        }
        this.didActivate(this._attrs.getAttributes().values());
        this.didActivate(this._attrs.getListeners());
        this.didActivate(this._dtCleans);
        this.didActivate(this._execInits);
        this.didActivate(this._execCleans);
        this.didActivate(this._uiCycles);
    }

    private void willPassivate(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.willPassivate(it.next());
            }
        }
    }

    private void willPassivate(Object o) {
        if (o instanceof DesktopActivationListener) {
            ((DesktopActivationListener)o).willPassivate(this);
        }
    }

    private void didActivate(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.didActivate(it.next());
            }
        }
    }

    private void didActivate(Object o) {
        if (o instanceof DesktopActivationListener) {
            ((DesktopActivationListener)o).didActivate(this);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Map<String, Object> attrs = this._attrs.getAttributes();
        this.willSerialize(attrs.values());
        Serializables.smartWrite((ObjectOutputStream)s, attrs);
        List<ScopeListener> lns = this._attrs.getListeners();
        this.willSerialize(lns);
        Serializables.smartWrite((ObjectOutputStream)s, lns);
        this.willSerialize(this._dtCleans);
        Serializables.smartWrite((ObjectOutputStream)s, this._dtCleans);
        this.willSerialize(this._execInits);
        Serializables.smartWrite((ObjectOutputStream)s, this._execInits);
        this.willSerialize(this._execCleans);
        Serializables.smartWrite((ObjectOutputStream)s, this._execCleans);
        this.willSerialize(this._uiCycles);
        Serializables.smartWrite((ObjectOutputStream)s, this._uiCycles);
        this.willSerialize(this._ausvcs);
        Serializables.smartWrite((ObjectOutputStream)s, this._ausvcs);
        if (this._spush == null || this._spush instanceof Serializable || this._spush instanceof Externalizable) {
            s.writeObject(this._spush);
        } else {
            s.writeObject(this._spush.getClass());
        }
    }

    private void willSerialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.willSerialize(it.next());
            }
        }
    }

    private void willSerialize(Object o) {
        if (o instanceof DesktopSerializationListener) {
            ((DesktopSerializationListener)o).willSerialize(this);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        for (Page page : this._pages) {
            for (Component root = page.getFirstRoot(); root != null; root = root.getNextSibling()) {
                this.addAllComponents(root);
            }
        }
        Map<String, Object> attrs = this._attrs.getAttributes();
        Serializables.smartRead((ObjectInputStream)s, attrs);
        List<ScopeListener> lns = this._attrs.getListeners();
        Serializables.smartRead((ObjectInputStream)s, lns);
        this._dtCleans = Serializables.smartRead((ObjectInputStream)s, this._dtCleans);
        this._execInits = Serializables.smartRead((ObjectInputStream)s, this._execInits);
        this._execCleans = Serializables.smartRead((ObjectInputStream)s, this._execCleans);
        this._uiCycles = Serializables.smartRead((ObjectInputStream)s, this._uiCycles);
        this._ausvcs = Serializables.smartRead((ObjectInputStream)s, this._ausvcs);
        this.didDeserialize(attrs.values());
        this.didDeserialize(lns);
        this.didDeserialize(this._dtCleans);
        this.didDeserialize(this._execInits);
        this.didDeserialize(this._execCleans);
        this.didDeserialize(this._uiCycles);
        this.didDeserialize(this._ausvcs);
        Object o = s.readObject();
        if (o != null) {
            ServerPush sp = null;
            if (o instanceof Class) {
                try {
                    sp = (ServerPush)((Class)o).newInstance();
                }
                catch (Throwable throwable) {}
            } else {
                sp = (ServerPush)o;
            }
            this._spushTemp = sp;
        }
    }

    private void didDeserialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.didDeserialize(it.next());
            }
        }
    }

    private void didDeserialize(Object o) {
        if (o instanceof DesktopSerializationListener) {
            ((DesktopSerializationListener)o).didDeserialize(this);
        }
    }

    private void addAllComponents(Component comp) {
        this.addComponent(comp);
        for (Component child : comp.getChildren()) {
            this.addAllComponents(child);
        }
    }

    @Override
    public void addListener(Object listener) {
        boolean added = false;
        if (listener instanceof EventInterceptor) {
            this._eis.addEventInterceptor((EventInterceptor)listener);
            added = true;
        }
        if (listener instanceof DesktopCleanup) {
            this._dtCleans = this.addListener0(this._dtCleans, (DesktopCleanup)listener);
            added = true;
        }
        if (listener instanceof ExecutionInit) {
            this._execInits = this.addListener0(this._execInits, (ExecutionInit)listener);
            added = true;
        }
        if (listener instanceof ExecutionCleanup) {
            this._execCleans = this.addListener0(this._execCleans, (ExecutionCleanup)listener);
            added = true;
        }
        if (listener instanceof UiLifeCycle) {
            this._uiCycles = this.addListener0(this._uiCycles, (UiLifeCycle)listener);
            added = true;
        }
        if (listener instanceof AuService) {
            this._ausvcs = this.addListener0(this._ausvcs, (AuService)listener);
            added = true;
        }
        if (!added) {
            throw new IllegalArgumentException("Unknown listener: " + listener);
        }
    }

    private <T> List<T> addListener0(List<T> list, T listener) {
        if (list == null) {
            list = new LinkedList<T>();
        }
        list.add(listener);
        return list;
    }

    @Override
    public boolean removeListener(Object listener) {
        boolean found = false;
        if (listener instanceof EventInterceptor && this._eis.removeEventInterceptor((EventInterceptor)listener)) {
            found = true;
        }
        if (listener instanceof DesktopCleanup && this.removeListener0(this._dtCleans, listener)) {
            found = true;
        }
        if (listener instanceof ExecutionInit && this.removeListener0(this._execInits, listener)) {
            found = true;
        }
        if (listener instanceof ExecutionCleanup && this.removeListener0(this._execCleans, listener)) {
            found = true;
        }
        if (listener instanceof UiLifeCycle && this.removeListener0(this._uiCycles, listener)) {
            found = true;
        }
        if (listener instanceof AuService && this.removeListener0(this._ausvcs, listener)) {
            found = true;
        }
        return found;
    }

    private boolean removeListener0(List list, Object listener) {
        if (list != null && listener != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                if (!it.next().equals(listener)) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public Event beforeSendEvent(Event event) {
        if ((event = this._eis.beforeSendEvent(event)) != null) {
            event = this._wapp.getConfiguration().beforeSendEvent(event);
        }
        return event;
    }

    @Override
    public Event beforePostEvent(Event event) {
        if ((event = this._eis.beforePostEvent(event)) != null) {
            event = this._wapp.getConfiguration().beforePostEvent(event);
        }
        return event;
    }

    @Override
    public Event beforeProcessEvent(Event event) throws Exception {
        if ((event = this._eis.beforeProcessEvent(event)) != null) {
            event = this._wapp.getConfiguration().beforeProcessEvent(event);
        }
        return event;
    }

    @Override
    public void afterProcessEvent(Event event) throws Exception {
        this._eis.afterProcessEvent(event);
        this._wapp.getConfiguration().afterProcessEvent(event);
        if ("onDesktopRecycle".equals(event.getName())) {
            Component root;
            if (this._bookmark.length() > 0) {
                this.addResponse(new AuBookmark(this._bookmark));
            }
            block0: for (Page page : this._pages) {
                for (root = page.getFirstRoot(); root != null; root = root.getNextSibling()) {
                    if (!Events.isListened(root, "onClientInfo", false)) continue;
                    this.setAttribute("org.zkoss.desktop.clientinfo.enabled", true);
                    this.addResponse(new AuClientInfo(this));
                    break block0;
                }
            }
            block2: for (Page page : this._pages) {
                for (root = page.getFirstRoot(); root != null; root = root.getNextSibling()) {
                    if (!Events.isListened(root, "onVisibilityChange", false)) continue;
                    this.setAttribute("org.zkoss.desktop.visibilitychange.enabled", true);
                    break block2;
                }
            }
        }
    }

    @Override
    public void invokeDesktopCleanups() {
        if (this._dtCleans != null) {
            for (DesktopCleanup listener : new LinkedList<DesktopCleanup>(this._dtCleans)) {
                try {
                    listener.cleanup(this);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                }
            }
        }
    }

    @Override
    public void invokeExecutionInits(Execution exec, Execution parent) throws UiException {
        if (this._execInits != null) {
            Iterator it = new LinkedList<ExecutionInit>(this._execInits).iterator();
            while (it.hasNext()) {
                try {
                    ((ExecutionInit)it.next()).init(exec, parent);
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
    }

    @Override
    public void invokeExecutionCleanups(Execution exec, Execution parent, List<Throwable> errs) {
        if (this._execCleans != null) {
            for (ExecutionCleanup listener : new LinkedList<ExecutionCleanup>(this._execCleans)) {
                try {
                    listener.cleanup(exec, parent, errs);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                    if (errs == null) continue;
                    errs.add(ex);
                }
            }
        }
    }

    @Override
    public void afterComponentAttached(Component comp, Page page) {
        if (this._uiCycles != null) {
            for (UiLifeCycle listener : new LinkedList<UiLifeCycle>(this._uiCycles)) {
                try {
                    listener.afterComponentAttached(comp, page);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                }
            }
        }
    }

    @Override
    public void afterComponentDetached(Component comp, Page prevpage) {
        if (this._uiCycles != null) {
            for (UiLifeCycle listener : new LinkedList<UiLifeCycle>(this._uiCycles)) {
                try {
                    listener.afterComponentDetached(comp, prevpage);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                }
            }
        }
    }

    @Override
    public void afterComponentMoved(Component parent, Component child, Component prevparent) {
        if (this._uiCycles != null) {
            for (UiLifeCycle listener : new LinkedList<UiLifeCycle>(this._uiCycles)) {
                try {
                    listener.afterComponentMoved(parent, child, prevparent);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                }
            }
        }
    }

    private void afterPageAttached(Page page, Desktop desktop) {
        if (this._uiCycles != null) {
            for (UiLifeCycle listener : new LinkedList<UiLifeCycle>(this._uiCycles)) {
                try {
                    listener.afterPageAttached(page, desktop);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                }
            }
        }
    }

    private void afterPageDetached(Page page, Desktop prevdesktop) {
        if (this._uiCycles != null) {
            for (UiLifeCycle listener : new LinkedList<UiLifeCycle>(this._uiCycles)) {
                try {
                    listener.afterPageDetached(page, prevdesktop);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + listener, ex);
                }
            }
        }
    }

    @Override
    public boolean enableServerPush(boolean enable) {
        return this.enableServerPush(enable, null);
    }

    @Override
    public boolean enableServerPush(boolean enable, Serializable enabler) {
        return this.enableServerPush(null, enable, enabler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enableServerPush(ServerPush serverPush, boolean enable, Serializable enabler) {
        Set<Serializable> set = this.enablers;
        synchronized (set) {
            boolean enablersEmptyBefore = this.enablers.isEmpty();
            if (enable) {
                if (enabler != null && !this.enablers.add(enabler)) {
                    log.debug("trying to enable already enabled serverpush by: " + enabler);
                    return false;
                }
                if (enablersEmptyBefore) {
                    return this.enableServerPush0(serverPush, enable);
                }
            } else {
                if (enabler != null && !this.enablers.remove(enabler)) {
                    log.debug("trying to disable already disabled serverpush by: " + enabler);
                    return false;
                }
                if (this.enablers.isEmpty()) {
                    return this.enableServerPush0(serverPush, enable);
                }
            }
        }
        return false;
    }

    @Override
    public boolean enableServerPush(ServerPush serverpush) {
        boolean enable;
        boolean serverPushAlreadyExists = this._spush != null;
        boolean bl = enable = serverpush != null;
        if (serverPushAlreadyExists != enable || serverpush != this._spush) {
            if (serverPushAlreadyExists) {
                this.enableServerPush(false, null);
            }
            if (enable) {
                this.enableServerPush(serverpush, true, null);
            }
        }
        return serverPushAlreadyExists;
    }

    private boolean enableServerPush0(ServerPush sp, boolean enable) {
        boolean serverPushAlreadyExists;
        if (this._sess == null) {
            throw new IllegalStateException("Server push cannot be enabled in a working thread");
        }
        boolean bl = serverPushAlreadyExists = this._spush != null;
        if (serverPushAlreadyExists != enable) {
            int cnt;
            Integer icnt = (Integer)this._sess.getAttribute(ATTR_PUSH_COUNT);
            int n = cnt = icnt != null ? icnt : 0;
            if (enable) {
                if (Executions.getCurrent() == null) {
                    throw new IllegalStateException("Server Push cannot be started without execution");
                }
                int maxcnt = this._wapp.getConfiguration().getSessionMaxPushes();
                if (maxcnt >= 0 && cnt >= maxcnt) {
                    throw new UiException(cnt > 0 ? "Too many concurrent push connections per session: " + cnt : "Server push is disabled");
                }
                if (sp != null) {
                    this._spush = sp;
                } else {
                    Class cls = this.getDevice().getServerPushClass();
                    if (cls == null) {
                        throw new UiException("No server push defined. Make sure you are using ZK PE or EE, or you have configured your own implementation");
                    }
                    this._spush = ((WebAppCtrl)((Object)this._wapp)).getUiFactory().newServerPush(this, cls);
                }
                this._spush.start(this);
                this._spushShallStop = false;
                ++cnt;
            } else if (this._spush.isActive()) {
                if (this.enablers.isEmpty()) {
                    this._spushShallStop = true;
                    --cnt;
                }
            } else {
                this._spush.stop();
                this._spush = null;
                --cnt;
            }
            this._sess.setAttribute(ATTR_PUSH_COUNT, new Integer(cnt));
        } else if (enable) {
            this._spushShallStop = false;
        }
        return serverPushAlreadyExists;
    }

    @Override
    public boolean isServerPushEnabled() {
        return this._spush != null;
    }

    @Override
    public ServerPush getServerPush() {
        return this._spush;
    }

    @Override
    public <T extends Event> void scheduleServerPush(EventListener<T> listener, T event) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.checkSeverPush("schedule");
        this._spush.schedule(listener, event, new Scheduler<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void schedule(EventListener<T> listener, T event) {
                if (log.isDebugEnabled()) {
                    log.debug("scheduleServerPush: [{}]", event);
                }
                List list = DesktopImpl.this._schedInfos;
                synchronized (list) {
                    if (DesktopImpl.this._dummyTarget == null) {
                        DesktopImpl.this._dummyTarget = new AbstractComponent();
                        DesktopImpl.this._dummyTarget.addEventListener(DesktopImpl.ON_SCHEDULE, new ScheduleListener());
                    }
                    DesktopImpl.this._schedInfos.add(new ScheduleInfo(listener, (Event)event, null));
                }
            }
        });
    }

    @Override
    public boolean scheduledServerPush() {
        return !this._schedInfos.isEmpty();
    }

    private void checkSeverPush(String what) {
        if (this._spush == null) {
            if (this.isAlive()) {
                throw new IllegalStateException("Before calling Executions." + what + "(), the server push must be enabled for " + this);
            }
            throw new DesktopUnavailableException("Stopped");
        }
    }

    @Override
    public boolean activateServerPush(long timeout) throws InterruptedException {
        this.checkSeverPush("activate");
        if (Events.inEventListener() && Executions.getCurrent().getDesktop() == this) {
            throw new IllegalStateException("No need to invoke Executions.activate() in an event listener");
        }
        if (log.isDebugEnabled()) {
            log.debug("activateServerPush, timeout is [{}]", (Object)timeout);
        }
        return this._spush.activate(timeout);
    }

    @Override
    public void deactivateServerPush() {
        if (log.isDebugEnabled()) {
            log.debug("activateServerPush, _spush's activation is [{}]", (Object)this._spush.isActive());
        }
        if (this._spush != null && this._spush.deactivate(this._spushShallStop)) {
            this._spushShallStop = false;
            this._spush = null;
        }
    }

    @Override
    public void onPiggybackListened(Component comp, boolean listen) {
        if (listen) {
            this._piggybackListened = true;
        }
    }

    @Override
    public void onPiggyback() {
        if (this._piggybackListened && Executions.getCurrent().getAttribute(ATTR_PIGGYBACK_POSTED) == null) {
            for (Page page : this._pages) {
                if (!Executions.getCurrent().isAsyncUpdate(page)) continue;
                for (Component root = page.getFirstRoot(); root != null; root = root.getNextSibling()) {
                    if (!Events.isListened(root, "onPiggyback", false)) continue;
                    Events.postEvent(new Event("onPiggyback", root));
                    Executions.getCurrent().setAttribute(ATTR_PIGGYBACK_POSTED, Boolean.TRUE);
                }
            }
        }
        if (!this._schedInfos.isEmpty()) {
            Events.postEvent(ON_SCHEDULE, this._dummyTarget, null);
        }
        if (this._spush != null) {
            this._spush.onPiggyback();
        }
    }

    @Override
    public void responseSent(String reqId, Object response) {
        if (reqId != null) {
            this._lastRes = new ReqResult(reqId, response);
        }
    }

    @Override
    public Object getLastResponse(String reqId) {
        return this._lastRes != null && this._lastRes.id.equals(reqId) ? this._lastRes.response : null;
    }

    @Override
    public int getResponseId(boolean advance) {
        if (advance && ++this._resId > 999) {
            this._resId = 1;
        }
        return this._resId;
    }

    @Override
    public void setResponseId(int resId) {
        if (resId > 999) {
            throw new IllegalArgumentException("Invalid response ID: " + resId);
        }
        this._resId = resId < 0 ? 0 : resId;
    }

    @Override
    public List<AuResponse> piggyResponse(Collection<AuResponse> response, boolean reset) {
        if (response != null) {
            if (this._piggyRes == null) {
                this._piggyRes = new LinkedList<AuResponse>();
            }
            this._piggyRes.addAll(response);
        }
        List<AuResponse> l = this._piggyRes;
        if (reset) {
            this._piggyRes = null;
        }
        return l;
    }

    @Override
    public void invalidate() {
        for (Page page : this._pages) {
            if (((PageCtrl)((Object)page)).getOwner() != null) continue;
            page.invalidate();
        }
    }

    @Override
    public Storage getStorage() {
        this._storageLock.lock();
        try {
            Storage storage = (Storage)this.getAttribute(this.getClass().getName());
            if (storage == null) {
                storage = new Storage(){
                    private ConcurrentHashMap<String, Object> _cache = new ConcurrentHashMap();

                    @Override
                    public <T> T getItem(String key) {
                        return (T)this._cache.get(key);
                    }

                    @Override
                    public <T> void setItem(String key, T value) {
                        this._cache.put(key, value);
                    }

                    @Override
                    public <T> T removeItem(String key) {
                        return (T)this._cache.remove(key);
                    }
                };
                this.setAttribute(this.getClass().getName(), storage);
            }
            Storage storage2 = storage;
            return storage2;
        }
        finally {
            this._storageLock.unlock();
        }
    }

    @Override
    public void pushHistoryState(Object state, String title, String url) {
        this.addResponse(new AuHistoryState(false, state, title, url));
    }

    @Override
    public void replaceHistoryState(Object state, String title, String url) {
        this.addResponse(new AuHistoryState(true, state, title, url));
    }

    private static long getMaxSchedTime() {
        if (_maxSchedTime == null) {
            String PROP = "org.zkoss.zk.ui.maxScheduleTime";
            String val = Library.getProperty((String)"org.zkoss.zk.ui.maxScheduleTime");
            if (val != null) {
                try {
                    int v = Integer.parseInt(val);
                    if (v > 0) {
                        _maxSchedTime = (long)v * 1000L;
                    }
                }
                catch (Throwable t) {
                    log.warn("Ignored library property, org.zkoss.zk.ui.maxScheduleTime: not a number, " + val);
                }
            }
            if (_maxSchedTime == null) {
                _maxSchedTime = 5000L;
            }
        }
        return _maxSchedTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScheduleListener
    implements EventListener<Event>,
    Serializable {
        private ScheduleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(Event event) throws Exception {
            long max = System.currentTimeMillis() + DesktopImpl.getMaxSchedTime();
            if (log.isDebugEnabled()) {
                log.debug("Handling schedule server push, _schedInfos is empty: [{}]", (Object)DesktopImpl.this._schedInfos.isEmpty());
            }
            while (!DesktopImpl.this._schedInfos.isEmpty()) {
                ArrayList schedInfos;
                List list = DesktopImpl.this._schedInfos;
                synchronized (list) {
                    schedInfos = new ArrayList(DesktopImpl.this._schedInfos);
                    DesktopImpl.this._schedInfos.clear();
                }
                Iterator it = schedInfos.iterator();
                while (it.hasNext()) {
                    ScheduleInfo si = (ScheduleInfo)it.next();
                    try {
                        si.invoke();
                    }
                    catch (Throwable t) {
                        List list2 = DesktopImpl.this._schedInfos;
                        synchronized (list2) {
                            int j = 0;
                            while (it.hasNext()) {
                                DesktopImpl.this._schedInfos.add(j++, it.next());
                            }
                        }
                        if (t instanceof Exception) {
                            throw (Exception)t;
                        }
                        throw (Error)t;
                    }
                }
                if (System.currentTimeMillis() <= max) continue;
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScheduleInfo<T extends Event>
    implements Serializable {
        private final EventListener<T> _listener;
        private final T _event;

        private ScheduleInfo(EventListener<T> listener, T event) {
            this._listener = listener;
            this._event = event;
        }

        private void invoke() throws Exception {
            if (log.isDebugEnabled()) {
                log.debug("Handling schedule info, the event is [{}]", this._event);
            }
            this._listener.onEvent(this._event);
        }

        /* synthetic */ ScheduleInfo(EventListener x0, Event x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static class RecycleInfo
    implements Serializable {
        private final int execId;
        private final List<String> uuids = new LinkedList<String>();

        private RecycleInfo(int execId) {
            this.execId = execId;
        }

        public String toString() {
            return 91 + this.execId + ": " + this.uuids + ']';
        }
    }

    private static class ReqResult {
        private final String id;
        private final Object response;

        private ReqResult(String id, Object response) {
            this.id = id;
            this.response = response;
        }
    }
}

