/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind;

import java.util.Map;
import org.zkoss.bind.GlobalCommandEvent;
import org.zkoss.bind.PropertyChangeEvent;
import org.zkoss.bind.proxy.ViewModelProxyObject;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindUtils {
    public static void postGlobalCommand(String queueName, String queueScope, String cmdName, Map<String, Object> args) {
        EventQueue que = EventQueues.lookup((String)(queueName == null ? "$ZKBIND_DEFQUE$" : queueName), (String)(queueScope == null ? "desktop" : queueScope), (boolean)false);
        if (Strings.isEmpty((String)cmdName)) {
            throw new IllegalArgumentException("cmdName is empty");
        }
        if (que != null) {
            que.publish((Event)new GlobalCommandEvent(null, cmdName, args));
        }
    }

    public static void postNotifyChange(String queueName, String queueScope, Object bean, String property) {
        EventQueue que = EventQueues.lookup((String)(queueName == null ? "$ZKBIND_DEFQUE$" : queueName), (String)(queueScope == null ? "desktop" : queueScope), (boolean)false);
        if (Strings.isEmpty((String)property)) {
            throw new IllegalArgumentException("property is empty");
        }
        if (que != null) {
            que.publish((Event)new PropertyChangeEvent(null, bean, property));
        }
    }

    public static void postNotifyChange(String queueName, String queueScope, Object bean, String ... properties) {
        for (String property : properties) {
            BindUtils.postNotifyChange(queueName, queueScope, bean, property);
        }
    }

    public static Class<?> getViewModelClass(Object viewModel) {
        if (viewModel instanceof ViewModelProxyObject) {
            return ((ViewModelProxyObject)viewModel).getOriginClass();
        }
        return viewModel.getClass();
    }
}

