/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.memoryusage.internal;

import java.io.File;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.felix.webconsole.plugins.memoryusage.internal.MemoryUsageConstants;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MemoryUsageSupport
implements NotificationListener,
ServiceListener {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private final BundleContext context;
    private final File defaultDumpLocation;
    private final int defaultThreshold;
    private long minDumpInterval;
    private File dumpLocation;
    private int threshold;
    private long nextDumpTime = -1L;
    private ServiceReference logServiceReference;
    private Object logService;

    MemoryUsageSupport(BundleContext context) {
        int interval;
        int defaultThreshold;
        File bundleDumps;
        File dumps;
        this.context = context;
        try {
            context.addServiceListener((ServiceListener)this, "(objectClass=org.osgi.service.log.LogService)");
            this.logServiceReference = context.getServiceReference("org.osgi.service.log.LogService");
            if (this.logServiceReference != null) {
                this.logService = context.getService(this.logServiceReference);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        String propDumps = context.getProperty("felix.memoryusage.dump.location");
        if (propDumps == null) {
            propDumps = "dumps";
        }
        if (!(dumps = new File(propDumps)).isAbsolute() && (bundleDumps = context.getDataFile(propDumps)) != null) {
            dumps = bundleDumps;
        }
        this.defaultDumpLocation = dumps.getAbsoluteFile();
        this.setDumpLocation(null);
        NotificationEmitter memEmitter = (NotificationEmitter)((Object)this.getMemory());
        memEmitter.addNotificationListener(this, null, null);
        String propThreshold = context.getProperty("felix.memoryusage.dump.threshold");
        if (propThreshold != null) {
            try {
                defaultThreshold = Integer.parseInt(propThreshold);
                this.setThreshold(defaultThreshold);
            }
            catch (Exception e) {
                defaultThreshold = -1;
            }
        } else {
            defaultThreshold = -1;
        }
        if (defaultThreshold < 0) {
            defaultThreshold = 0;
            this.setThreshold(defaultThreshold);
        }
        this.defaultThreshold = defaultThreshold;
        String propInterval = context.getProperty("felix.memoryusage.dump.interval");
        if (propInterval != null) {
            try {
                interval = Integer.parseInt(propInterval);
            }
            catch (Exception e) {
                interval = -1;
            }
        } else {
            interval = -1;
        }
        this.setInterval(interval);
    }

    void dispose() {
        NotificationEmitter memEmitter = (NotificationEmitter)((Object)this.getMemory());
        try {
            memEmitter.removeNotificationListener(this);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
        this.context.removeServiceListener((ServiceListener)this);
        if (this.logServiceReference != null) {
            this.context.ungetService(this.logServiceReference);
            this.logServiceReference = null;
            this.logService = null;
        }
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    final void setThreshold(int percentage) {
        TreeSet<String> noThresholdPools;
        TreeSet<String> thresholdPools;
        if (percentage < 0) {
            percentage = this.defaultThreshold;
        }
        if (MemoryUsageConstants.isThresholdValid(percentage)) {
            thresholdPools = new TreeSet<String>();
            noThresholdPools = new TreeSet<String>();
            List<MemoryPoolMXBean> pools = this.getMemoryPools();
            for (MemoryPoolMXBean pool : pools) {
                if (pool.isUsageThresholdSupported()) {
                    long threshold = pool.getUsage().getMax() * (long)percentage / 100L;
                    pool.setUsageThreshold(threshold);
                    thresholdPools.add(pool.getName());
                    continue;
                }
                noThresholdPools.add(pool.getName());
            }
        } else {
            throw new IllegalArgumentException(String.valueOf(percentage));
        }
        this.threshold = percentage;
        this.log(3, "Setting Automatic Memory Dump Threshold to %d%% for pools %s", this.threshold, thresholdPools);
        this.log(3, "Automatic Memory Dump cannot be set for pools %s", noThresholdPools);
    }

    final int getThreshold() {
        return this.threshold;
    }

    final void setInterval(long interval) {
        interval = interval < 0L ? 21600000L : 1000L * interval;
        this.minDumpInterval = interval;
        this.log(3, "Setting Automatic Memory Dump Interval to %d seconds", this.getInterval());
    }

    final long getInterval() {
        return this.minDumpInterval / 1000L;
    }

    final void printMemory(PrintHelper pw) {
        pw.title("Overall Memory Use", 0);
        pw.keyVal("Heap Dump Threshold", this.getThreshold() + "%");
        pw.keyVal("Heap Dump Interval", this.getInterval() + " seconds");
        this.printOverallMemory(pw);
        pw.title("Memory Pools", 0);
        this.printMemoryPools(pw);
        pw.title("Heap Dumps", 0);
        this.listDumpFiles(pw);
    }

    final void printOverallMemory(PrintHelper pw) {
        MemoryMXBean mem = this.getMemory();
        pw.keyVal("Verbose Memory Output", mem.isVerbose() ? "yes" : "no");
        pw.keyVal("Pending Finalizable Objects", mem.getObjectPendingFinalizationCount());
        pw.keyVal("Overall Heap Memory Usage", mem.getHeapMemoryUsage());
        pw.keyVal("Overall Non-Heap Memory Usage", mem.getNonHeapMemoryUsage());
    }

    final void printMemoryPools(PrintHelper pw) {
        List<MemoryPoolMXBean> pools = this.getMemoryPools();
        for (MemoryPoolMXBean pool : pools) {
            String title = String.format("%s (%s, %s)", new Object[]{pool.getName(), pool.getType(), pool.isValid() ? "valid" : "invalid"});
            pw.title(title, 1);
            pw.keyVal("Memory Managers", Arrays.asList(pool.getMemoryManagerNames()));
            pw.keyVal("Peak Usage", pool.getPeakUsage());
            pw.keyVal("Usage", pool.getUsage());
            if (pool.isUsageThresholdSupported()) {
                pw.keyVal("Usage Threshold", String.format("%d, %s, #exceeded=%d", pool.getUsageThreshold(), pool.isUsageThresholdExceeded() ? "exceeded" : "not exceeded", pool.getUsageThresholdCount()));
            } else {
                pw.val("Usage Threshold: not supported");
            }
            pw.keyVal("Collection Usage", pool.getCollectionUsage());
            if (pool.isCollectionUsageThresholdSupported()) {
                pw.keyVal("Collection Usage Threshold", String.format("%d, %s, #exceeded=%d", pool.getCollectionUsageThreshold(), pool.isCollectionUsageThresholdExceeded() ? "exceeded" : "not exceeded", pool.getCollectionUsageThresholdCount()));
                continue;
            }
            pw.val("Collection Usage Threshold: not supported");
        }
    }

    final String getMemoryPoolsJson() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        long usedTotal = 0L;
        long initTotal = 0L;
        long committedTotal = 0L;
        long maxTotal = 0L;
        List<MemoryPoolMXBean> pools = this.getMemoryPools();
        for (MemoryPoolMXBean pool : pools) {
            long score;
            buf.append("{");
            buf.append("'name':'").append(pool.getName()).append('\'');
            buf.append(",'type':'").append((Object)pool.getType()).append('\'');
            MemoryUsage usage = pool.getUsage();
            long used = usage.getUsed();
            this.formatNumber(buf, "used", used);
            if (used > -1L) {
                usedTotal += used;
            }
            long init = usage.getInit();
            this.formatNumber(buf, "init", init);
            if (init > -1L) {
                initTotal += init;
            }
            long committed = usage.getCommitted();
            this.formatNumber(buf, "committed", committed);
            committedTotal += committed;
            long max = usage.getMax();
            this.formatNumber(buf, "max", usage.getMax());
            if (max == -1L || used == -1L) {
                score = 100L;
            } else {
                maxTotal += max;
                score = 100L * used / max;
            }
            buf.append(",'score':'").append(score).append("%'");
            buf.append("},");
        }
        buf.append("{");
        buf.append("'name':'Total','type':'TOTAL'");
        this.formatNumber(buf, "used", usedTotal);
        this.formatNumber(buf, "init", initTotal);
        this.formatNumber(buf, "committed", committedTotal);
        this.formatNumber(buf, "max", maxTotal);
        long score = 100L * usedTotal / maxTotal;
        buf.append(",'score':'").append(score).append("%'");
        buf.append("}");
        buf.append("]");
        return buf.toString();
    }

    void formatNumber(StringBuilder buf, String title, long value) {
        String suffix;
        BigDecimal KB = new BigDecimal(1000L);
        BigDecimal MB = new BigDecimal(1000000L);
        BigDecimal bd = new BigDecimal(value);
        BigDecimal GB = new BigDecimal(1000000000L);
        if (bd.compareTo(GB) > 0) {
            bd = bd.divide(GB);
            suffix = "GB";
        } else if (bd.compareTo(MB) > 0) {
            bd = bd.divide(MB);
            suffix = "MB";
        } else if (bd.compareTo(KB) > 0) {
            bd = bd.divide(KB);
            suffix = "kB";
        } else {
            suffix = value >= 0L ? "B" : null;
        }
        buf.append(",'").append(title).append("':'");
        if (suffix == null) {
            buf.append("unknown");
        } else {
            bd = bd.setScale(2, RoundingMode.UP);
            buf.append(bd).append(suffix);
        }
        buf.append('\'');
    }

    final String getDefaultDumpLocation() {
        return this.defaultDumpLocation.getAbsolutePath();
    }

    final void setDumpLocation(String dumpLocation) {
        this.dumpLocation = dumpLocation == null || dumpLocation.length() == 0 ? this.defaultDumpLocation : new File(dumpLocation).getAbsoluteFile();
        this.log(3, "Storing Memory Dumps in %s", this.dumpLocation);
    }

    final File getDumpLocation() {
        return this.dumpLocation;
    }

    final void listDumpFiles(PrintHelper pw) {
        pw.title(this.dumpLocation.getAbsolutePath(), 1);
        File[] dumps = this.getDumpFiles();
        if (dumps == null || dumps.length == 0) {
            pw.keyVal("-- None", null);
        } else {
            long totalSize = 0L;
            for (File dump : dumps) {
                pw.val(String.format("%10d %tF %2$tR %s", dump.length(), new Date(dump.lastModified()), dump.getName()));
                totalSize += dump.length();
            }
            pw.val(String.format("%d files, %d bytes", dumps.length, totalSize));
        }
    }

    final File getDumpFile(String name) {
        if (name == null || name.length() == 0 || name.indexOf(47) >= 0) {
            return null;
        }
        File dumpFile = new File(this.dumpLocation, name);
        if (dumpFile.isFile()) {
            return dumpFile;
        }
        return null;
    }

    final File[] getDumpFiles() {
        return this.dumpLocation.listFiles();
    }

    final boolean rmDumpFile(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        File dumpFile = new File(this.dumpLocation, name);
        if (!dumpFile.exists()) {
            return false;
        }
        dumpFile.delete();
        return true;
    }

    final File dumpHeap(String name, boolean live) {
        this.dumpLocation.mkdirs();
        File dump = this.dumpSunMBean(name, live);
        if (dump == null) {
            dump = this.dumpIbmDump(name);
        }
        if (dump == null) {
            throw new NoSuchElementException();
        }
        return dump;
    }

    final MemoryMXBean getMemory() {
        return ManagementFactory.getMemoryMXBean();
    }

    final List<MemoryPoolMXBean> getMemoryPools() {
        return ManagementFactory.getMemoryPoolMXBeans();
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String notifType = notification.getType();
        if (notifType.equals("java.management.memory.threshold.exceeded")) {
            if (System.currentTimeMillis() >= this.nextDumpTime) {
                this.log(2, "Received Memory Threshold Exceeded Notification, dumping Heap", new Object[0]);
                try {
                    File file = this.dumpHeap(null, true);
                    this.log(2, "Heap dumped to " + file, new Object[0]);
                    this.nextDumpTime = System.currentTimeMillis() + this.minDumpInterval;
                }
                catch (NoSuchElementException e) {
                    this.log(1, "Failed dumping the heap, JVM does not provide known mechanism to create a Heap Dump", new Object[0]);
                }
            } else {
                this.log(2, "Ignoring Memory Threshold Exceeded Notification, minimum dump interval since last dump has not passed yet", new Object[0]);
            }
        }
    }

    private File dumpSunMBean(String name, boolean live) {
        if (name == null) {
            name = "heap." + System.currentTimeMillis() + ".hprof";
        }
        File tmpFile = new File(this.dumpLocation, name);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.invoke(new ObjectName(HOTSPOT_BEAN_NAME), "dumpHeap", new Object[]{tmpFile.getAbsolutePath(), live}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
            this.log(4, "dumpSunMBean: Dumped Heap to %s using Sun HotSpot MBean", tmpFile);
            return tmpFile;
        }
        catch (Throwable t) {
            this.log(4, "dumpSunMBean: Dump by Sun HotSpot MBean not working", t);
            tmpFile.delete();
            return null;
        }
    }

    private File dumpIbmDump(String name) {
        try {
            long minFileTime = System.currentTimeMillis();
            Class<?> c = ClassLoader.getSystemClassLoader().loadClass("com.ibm.jvm.Dump");
            Method m = c.getDeclaredMethod("HeapDump", null);
            m.invoke(null, (Object[])null);
            File dir = new File("").getAbsoluteFile();
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile() || file.lastModified() <= minFileTime) continue;
                    if (name == null) {
                        name = file.getName();
                    }
                    File target = new File(this.dumpLocation, name);
                    file.renameTo(target);
                    this.log(4, "dumpSunMBean: Dumped Heap to %s using IBM Dump.HeapDump()", target);
                    return target;
                }
                this.log(4, "dumpIbmDump: None of %d files '%s' is younger than %d", files.length, dir, minFileTime);
            } else {
                this.log(4, "dumpIbmDump: Hmm '%s' does not seem to be a directory; isdir=%b ??", dir, dir.isDirectory());
            }
            this.log(2, "dumpIbmDump: Heap Dump has been created but cannot be located", new Object[0]);
            return this.dumpLocation;
        }
        catch (Throwable t) {
            this.log(4, "dumpIbmDump: Dump by IBM Dump class not working", t);
            return null;
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1 && this.logServiceReference == null) {
            this.logServiceReference = event.getServiceReference();
            this.logService = this.context.getService(event.getServiceReference());
        } else if (event.getType() == 4 && this.logServiceReference == event.getServiceReference()) {
            this.logServiceReference = null;
            this.logService = null;
            this.context.ungetService(event.getServiceReference());
        }
    }

    void log(int level, String format, Object ... args) {
        this.log(level, null, format, args);
    }

    void log(int level, Throwable t, String format, Object ... args) {
        Object logService = this.logService;
        String message = String.format(format, args);
        if (logService != null) {
            try {
                Method m = logService.getClass().getDeclaredMethod("log", Integer.TYPE, String.class, Throwable.class);
                m.setAccessible(true);
                m.invoke(logService, level, message, t);
            }
            catch (Exception e) {
                this.logSTD(2, e, "Unable to log with the given log service");
                this.logSTD(level, t, message);
            }
        } else {
            this.logSTD(level, t, message);
        }
    }

    private void logSTD(int level, Throwable t, String message) {
        PrintStream out = level <= 1 ? System.err : System.out;
        out.printf("%s: %s (%d): %s%n", this.toLevelString(level), this.context.getBundle().getSymbolicName(), this.context.getBundle().getBundleId(), message);
        if (t != null) {
            t.printStackTrace(out);
        }
    }

    private String toLevelString(int level) {
        switch (level) {
            case 4: {
                return "DEBUG";
            }
            case 3: {
                return "INFO ";
            }
            case 2: {
                return "WARN ";
            }
            case 1: {
                return "ERROR";
            }
        }
        return "unknown(" + level + ")";
    }

    static interface PrintHelper {
        public void title(String var1, int var2);

        public void val(String var1);

        public void keyVal(String var1, Object var2);
    }
}

