/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.util.resource.Location;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.BranchInfo;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.Property;
import org.zkoss.zk.ui.metainfo.TemplateInfo;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.util.ConditionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadowInfo
extends BranchInfo {
    private ComponentDefinition _compdef;
    private List<Property> _props;
    private final String _tag;
    private AnnotationMap _annots;
    private boolean _hasBindingAnnotation = false;
    private boolean _isAnnotationNamespacedRoot = false;

    public ShadowInfo(NodeInfo parent, ComponentDefinition compdef, String tag, ConditionImpl cond) {
        super(parent, cond);
        this._tag = tag;
        if (compdef == null) {
            throw new IllegalArgumentException();
        }
        this._compdef = compdef;
    }

    public AnnotationMap getAnnotationMap() {
        return this._annots;
    }

    public void applyProperties(Component comp) {
        this._compdef.applyProperties(comp);
    }

    public void addAnnotation(String propName, String annotName, Map<String, String[]> annotAttrs, Location loc) {
        if (this._annots == null) {
            this._annots = new AnnotationMap();
        }
        this._annots.addAnnotation(propName, annotName, annotAttrs, loc);
    }

    public void apply(Component comp) {
        if (this._props != null && this.isEffective(comp)) {
            for (Property prop : this._props) {
                prop.assign(comp);
            }
        }
    }

    public Component newInstance(Page page) {
        return this.newInstance(page, null);
    }

    public Component newInstance(Page page, Component parent) {
        Component comp;
        ComponentsCtrl.setCurrentInfo(this);
        try {
            comp = this._compdef.newInstance(page, null);
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
        finally {
            ComponentsCtrl.setCurrentInfo((ComponentInfo)null);
        }
        return comp;
    }

    public LanguageDefinition getLanguageDefinition() {
        return this._compdef.getLanguageDefinition();
    }

    public ComponentDefinition getComponentDefinition() {
        return this._compdef;
    }

    public List<Property> getProperties() {
        if (this._props != null) {
            return this._props;
        }
        return Collections.emptyList();
    }

    public void addProperty(String name, String value, ConditionImpl cond) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        this._props.add(new Property(this._evalr, name, value, cond));
    }

    @Override
    public void appendChild(NodeInfo child) {
        if (!(child instanceof ShadowInfo) && !(child instanceof TemplateInfo)) {
            throw new IllegalStateException("Only accept template and shadow element to be a child of " + this);
        }
        super.appendChild(child);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(40).append("[shadow element(").append(this._tag).append(")");
        if (this._props != null) {
            for (Property name : this._props) {
                sb.append(' ').append(name.getName());
            }
        }
        return sb.append(']').toString();
    }

    public boolean hasBindingAnnotation() {
        return this._hasBindingAnnotation;
    }

    public void enableBindingAnnotation() {
        this._hasBindingAnnotation = true;
    }

    public void disableBindingAnnotation() {
        this._hasBindingAnnotation = false;
    }

    public boolean isAnnotationNamespacedRoot() {
        return this._isAnnotationNamespacedRoot;
    }

    public void setAnnotationNamespacedRoot(boolean annotationNamespacedRoot) {
        this._isAnnotationNamespacedRoot = annotationNamespacedRoot;
    }
}

