/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.HtmlMacroComponent;
import org.zkoss.zk.ui.HtmlNativeComponent;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.GenericAutowireComposer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConventionWire {
    private final Object _controller;
    private final Set<String> _injected;
    private final Map<String, Field> _fldMaps;
    private final char _separator;
    private final boolean _ignoreZScript;
    private final boolean _ignoreXel;
    private static final Set<String> _ignoreWires = new HashSet<String>(16);

    public ConventionWire(Object controller) {
        this(controller, '$', false, false);
    }

    public ConventionWire(Object controller, char separator) {
        this(controller, separator, false, false);
    }

    public ConventionWire(Object controller, char separator, boolean ignoreZScript, boolean ignoreXel) {
        this._controller = controller;
        this._separator = separator;
        this._ignoreZScript = ignoreZScript;
        this._ignoreXel = ignoreXel;
        this._injected = new HashSet<String>();
        this._fldMaps = new LinkedHashMap<String, Field>(64);
        for (Class<?> cls = this._controller.getClass(); cls != null && !ConventionWire.ignoreFromWire(cls); cls = cls.getSuperclass()) {
            Field[] flds = cls.getDeclaredFields();
            for (int j = 0; j < flds.length; ++j) {
                Field fd = flds[j];
                String fdname = fd.getName();
                if (this._fldMaps.containsKey(fdname)) continue;
                this._fldMaps.put(fdname, fd);
            }
        }
    }

    public void wireFellows(IdSpace idspace) {
        block5: {
            Collection<Component> fellows = idspace.getFellows();
            for (Component xcomp : fellows) {
                this.injectFellow(xcomp);
            }
            if (idspace instanceof Component) {
                IdSpace is = idspace;
                while (true) {
                    Component parent;
                    Component component = parent = is instanceof Component ? ((Component)((Object)is)).getParent() : null;
                    if (parent == null) {
                        Page page = ((Component)((Object)idspace)).getPage();
                        if (page != null) {
                            this.injectFellow(page);
                        }
                        break block5;
                    }
                    is = parent.getSpaceOwner();
                    this.injectFellow(is);
                }
            }
            this.injectFellow((Page)idspace);
        }
    }

    public void wireVariables(Page page) {
        this.myWireVariables(page);
    }

    public void wireVariables(Component comp) {
        this.myWireVariables(comp);
    }

    private void myWireVariables(Object x) {
        this.wireImplicit(x);
        this.wireOthers(x);
    }

    public void wireImplicit(Object x) {
        if (ConventionWire.ignoreFromWire(this._controller.getClass())) {
            return;
        }
        for (String fdname : Components.getImplicitNames()) {
            if ("event".equals(fdname)) continue;
            HashMap arg = this.myGetImplicit(x, fdname);
            if ("param".equals(fdname) && arg != null) {
                arg = new HashMap(arg);
            }
            this.injectByName(arg, fdname, x instanceof Component && "page".equals(fdname));
        }
    }

    private void wireOthers(Object x) {
        Class<?> cls = this._controller.getClass();
        Method[] mtds = cls.getMethods();
        for (int j = 0; j < mtds.length; ++j) {
            Object arg;
            Class<?>[] parmcls;
            String fdname;
            Method md = mtds[j];
            String mdname = md.getName();
            if ((md.getModifiers() & 8) != 0 || mdname.length() <= 3 || !mdname.startsWith("set") || !Character.isUpperCase(mdname.charAt(3)) || ConventionWire.ignoreFromWire(md.getDeclaringClass()) || this._injected.contains(fdname = Classes.toAttributeName((String)mdname)) || (parmcls = md.getParameterTypes()).length != 1) continue;
            if (this.containsVariable(x, fdname)) {
                Object arg2;
                arg = this.getVariable(x, fdname);
                if (this.injectByMethod(md, parmcls[0], arg == null ? null : arg.getClass(), arg, fdname) || (arg2 = this.getFellow(x, fdname)) == arg || arg2 == null) continue;
                this.injectByMethod(md, parmcls[0], arg2.getClass(), arg2, fdname);
                continue;
            }
            if (!(x instanceof Component) && !(x instanceof Page) || fdname.indexOf(this._separator) < 0 || (arg = this.getFellowByPath(x, fdname)) == null) continue;
            this.injectByMethod(md, parmcls[0], arg.getClass(), arg, fdname);
        }
        for (Map.Entry<String, Field> entry : this._fldMaps.entrySet()) {
            Object arg;
            String fdname = entry.getKey();
            Field fd = entry.getValue();
            if ((fd.getModifiers() & 8) != 0 || this._injected.contains(fdname)) continue;
            if (this.containsVariable(x, fdname)) {
                Object arg2;
                if (this.injectField(arg, (arg = this.getVariable(x, fdname)) == null ? null : arg.getClass(), fd) || (arg2 = this.getFellow(x, fdname)) == arg || arg2 == null) continue;
                this.injectField(arg2, arg2.getClass(), fd);
                continue;
            }
            if (!(x instanceof Component) && !(x instanceof Page) || fdname.indexOf(this._separator) < 0 || (arg = this.getFellowByPath(x, fdname)) == null) continue;
            this.injectField(arg, arg.getClass(), fd);
        }
    }

    private Object getFellowByPath(Object x, String name) {
        return Path.getComponent(x instanceof Page ? (Page)x : ((Component)x).getSpaceOwner(), name.replace(this._separator, '/'));
    }

    private boolean containsVariable(Object x, String fdname) {
        if (x instanceof Page) {
            Page page = (Page)x;
            return !this._ignoreZScript && page.getZScriptVariable(fdname) != null || page.hasAttributeOrFellow(fdname, true) || !this._ignoreXel && page.getXelVariable(null, null, fdname, true) != null;
        }
        Component cmp = (Component)x;
        Page page = Components.getCurrentPage(cmp);
        return !this._ignoreZScript && page != null && page.getZScriptVariable(cmp, fdname) != null || cmp.hasAttributeOrFellow(fdname, true) || !this._ignoreXel && page != null && page.getXelVariable(null, null, fdname, true) != null;
    }

    private Object getVariable(Object x, String fdname) {
        Object arg;
        if (x instanceof Page) {
            Object arg2;
            Page page = (Page)x;
            Object object = arg2 = this._ignoreZScript ? null : page.getZScriptVariable(fdname);
            if (arg2 == null) {
                arg2 = page.getAttributeOrFellow(fdname, true);
                if (!this._ignoreXel && arg2 == null) {
                    arg2 = page.getXelVariable(null, null, fdname, true);
                }
            }
            return arg2;
        }
        Component cmp = (Component)x;
        Page page = Components.getCurrentPage(cmp);
        Object object = arg = !this._ignoreZScript && page != null ? page.getZScriptVariable(cmp, fdname) : null;
        if (arg == null) {
            arg = cmp.getAttributeOrFellow(fdname, true);
            if (!this._ignoreXel && arg == null && page != null) {
                arg = page.getXelVariable(null, null, fdname, true);
            }
        }
        return arg;
    }

    private Object getFellow(Object x, String fdname) {
        return x instanceof Page ? ((Page)x).getFellowIfAny(fdname, true) : (x instanceof Component ? ((Component)x).getFellowIfAny(fdname, true) : null);
    }

    private void injectFellow(Object arg) {
        String fdname;
        String string = fdname = arg instanceof Page ? ((Page)arg).getId() : ((Component)arg).getId();
        if (fdname.length() > 0) {
            this.injectByName(arg, fdname, false);
        }
    }

    private void injectByName(Object arg, String fdname, boolean fieldOnly) {
        if (arg != null) {
            String mdname = Classes.toMethodName((String)fdname, (String)"set");
            Class<?> parmcls = arg.getClass();
            Class<?> tgtcls = this._controller.getClass();
            try {
                Method md;
                Method method = md = fieldOnly ? null : Classes.getCloseMethod(tgtcls, (String)mdname, (Class[])new Class[]{parmcls});
                if (fieldOnly || !this.injectByMethod(md, parmcls, parmcls, arg, fdname)) {
                    this.injectFieldByName(arg, tgtcls, parmcls, fdname);
                }
            }
            catch (NoSuchMethodException ex) {
                this.injectFieldByName(arg, tgtcls, parmcls, fdname);
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    private void injectFieldByName(Object arg, Class tgtcls, Class parmcls, String fdname) {
        try {
            Field fd = Classes.getAnyField((Class)tgtcls, (String)fdname);
            this.injectField(arg, parmcls, fd);
        }
        catch (NoSuchFieldException fd) {
        }
        catch (Exception ex2) {
            throw UiException.Aide.wrap(ex2);
        }
    }

    private boolean injectByMethod(Method md, Class<?> parmcls, Class<?> argcls, Object arg, String fdname) {
        if (argcls == null || parmcls.isAssignableFrom(argcls)) {
            Field fd = this._fldMaps.get(fdname);
            if (fd != null && fd.getType().equals(parmcls)) {
                boolean old = fd.isAccessible();
                try {
                    fd.setAccessible(true);
                    Object value = fd.get(this._controller);
                    if (value == null) {
                        md.invoke(this._controller, arg);
                        if (fd.get(this._controller) == arg) {
                            this._injected.add(fdname);
                        }
                    }
                    boolean bl = true;
                    Object var11_12 = null;
                    fd.setAccessible(old);
                    return bl;
                }
                catch (Exception ex) {
                    try {
                        throw UiException.Aide.wrap(ex);
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        fd.setAccessible(old);
                        throw throwable;
                    }
                }
            }
            try {
                md.invoke(this._controller, arg);
                this._injected.add(fdname);
                return true;
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return false;
    }

    private boolean injectField(Object arg, Class<?> argcls, Field fd) {
        boolean old;
        block6: {
            old = fd.isAccessible();
            fd.setAccessible(true);
            Class<?> fdcls = fd.getType();
            if (argcls == null || !fdcls.isAssignableFrom(argcls)) break block6;
            Object value = fd.get(this._controller);
            if (value == null) {
                fd.set(this._controller, arg);
                this._injected.add(fd.getName());
            }
            boolean bl = true;
            Object var9_10 = null;
            fd.setAccessible(old);
            return bl;
        }
        try {
            boolean bl = false;
            Object var9_11 = null;
            fd.setAccessible(old);
            return bl;
        }
        catch (Exception e) {
            try {
                throw UiException.Aide.wrap(e);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                fd.setAccessible(old);
                throw throwable;
            }
        }
    }

    private Object myGetImplicit(Object x, String fdname) {
        return x instanceof Page ? Components.getImplicit((Page)x, fdname) : Components.getImplicit((Component)x, fdname);
    }

    private static boolean ignoreFromWire(Class<?> cls) {
        Package pkg;
        return cls != null && (_ignoreWires.contains(cls.getName()) || (pkg = cls.getPackage()) != null && _ignoreWires.contains(pkg.getName()));
    }

    static {
        Class[] clses = new Class[]{HtmlBasedComponent.class, HtmlMacroComponent.class, HtmlNativeComponent.class, AbstractComponent.class, GenericAutowireComposer.class, Object.class};
        for (int j = 0; j < clses.length; ++j) {
            _ignoreWires.add(clses[j].getName());
        }
        if (!"true".equals(Library.getProperty((String)"org.zkoss.zk.ui.wire.zul.enabled"))) {
            _ignoreWires.add("org.zkoss.zul");
            _ignoreWires.add("org.zkoss.zkex.zul");
            _ignoreWires.add("org.zkoss.zkmax.zul");
            _ignoreWires.add("org.zkoss.zhtml");
        }
    }
}

