/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.PrintBookmark;
import net.sf.jasperreports.engine.base.BasePrintBookmark;

public class BookmarkIterator {
    private Deque<BasePrintBookmark> stack = new LinkedList<BasePrintBookmark>();

    public BookmarkIterator(BasePrintBookmark root) {
        this.pushChildren(root);
    }

    private void pushChildren(BasePrintBookmark bookmark) {
        List<PrintBookmark> children = bookmark.getBookmarks();
        if (children != null) {
            ListIterator<PrintBookmark> it = children.listIterator(children.size());
            while (it.hasPrevious()) {
                BasePrintBookmark child = (BasePrintBookmark)it.previous();
                this.stack.push(child);
            }
        }
    }

    public boolean hasBookmark() {
        return !this.stack.isEmpty();
    }

    public BasePrintBookmark bookmark() {
        return this.stack.peek();
    }

    public void next() {
        BasePrintBookmark bookmark = this.stack.pop();
        this.pushChildren(bookmark);
    }
}

