/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.asm;

import org.apache.commons.javaflow.bytecode.Continuable;
import org.apache.commons.javaflow.bytecode.transformation.asm.ContinuationMethodAnalyzer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class ContinuationClassAdapter
extends ClassVisitor {
    private String className;

    public ContinuationClassAdapter(ClassVisitor cv) {
        super(327680, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        String[] newInterfaces = new String[interfaces.length + 1];
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].equals(Type.getInternalName(Continuable.class))) {
                throw new RuntimeException(this.className + " has already been instrumented");
            }
            newInterfaces[i] = interfaces[i];
        }
        newInterfaces[newInterfaces.length - 1] = Type.getInternalName(Continuable.class);
        this.cv.visit(version, access, name, signature, superName, newInterfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (!"<init>".equals(name) && mv != null) {
            return new ContinuationMethodAnalyzer(this.className, this.cv, mv, access, name, desc, signature, exceptions);
        }
        return mv;
    }
}

