/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.AfterSizeEvent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zk.ui.event.MoveEvent;
import org.zkoss.zk.ui.event.SizeEvent;
import org.zkoss.zk.ui.event.SwipeEvent;
import org.zkoss.zk.ui.event.ZIndexEvent;
import org.zkoss.zk.ui.ext.DragControl;
import org.zkoss.zk.ui.ext.render.PrologAllowed;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.IntPropertyAccess;
import org.zkoss.zk.ui.sys.IntegerPropertyAccess;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zk.ui.sys.StringPropertyAccess;

public abstract class HtmlBasedComponent
extends AbstractComponent {
    protected String _zclass;
    private String _prolog;
    private AuxInfo _auxinf;
    private static HashMap<String, PropertyAccess> _properties;

    protected HtmlBasedComponent() {
    }

    public String getLeft() {
        return this._auxinf != null ? this._auxinf.left : null;
    }

    public void setLeft(String left) {
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.left : null), (Object)left)) {
            this.initAuxInfo().left = left;
            this.smartUpdate("left", left);
        }
    }

    public String getTop() {
        return this._auxinf != null ? this._auxinf.top : null;
    }

    public void setTop(String top) {
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.top : null), (Object)top)) {
            this.initAuxInfo().top = top;
            this.smartUpdate("top", top);
        }
    }

    public int getZIndex() {
        return this._auxinf != null ? this._auxinf.zIndex : -1;
    }

    public void setZIndex(int zIndex) {
        if (zIndex < -1) {
            zIndex = -1;
        }
        if ((this._auxinf != null ? this._auxinf.zIndex : -1) != zIndex) {
            this.initAuxInfo().zIndex = zIndex;
            if (zIndex < 0) {
                this.smartUpdate("zIndex", null);
            } else {
                this.smartUpdate("zIndex", zIndex);
            }
        }
    }

    public int getZindex() {
        return this.getZIndex();
    }

    public void setZindex(int zIndex) {
        this.setZIndex(zIndex);
    }

    public String getHeight() {
        return this._auxinf != null ? this._auxinf.height : null;
    }

    public void setHeight(String height) {
        if (this.getVflex() != null && height != null && !this.getVflex().equals("min")) {
            throw new UiException("Not allowed to set vflex and height at the same time except vflex=\"min\"");
        }
        this.setHeight0(height);
    }

    protected void setHeight0(String height) {
        if (height != null && height.length() == 0) {
            height = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.height : null), (Object)height)) {
            this.initAuxInfo().height = height;
            this.smartUpdate("height", height);
        }
    }

    public String getWidth() {
        return this._auxinf != null ? this._auxinf.width : null;
    }

    public void setWidth(String width) {
        if (this.getHflex() != null && width != null && !this.getHflex().equals("min")) {
            throw new UiException("Not allowed to set hflex and width at the same time except hflex=\"min\"");
        }
        this.setWidth0(width);
    }

    protected void setWidth0(String width) {
        if (width != null && width.length() == 0) {
            width = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.width : null), (Object)width)) {
            this.initAuxInfo().width = width;
            this.smartUpdate("width", width);
        }
    }

    protected void setWidthDirectly(String width) {
        this.initAuxInfo().width = width;
    }

    protected void setHeightDirectly(String height) {
        this.initAuxInfo().height = height;
    }

    protected void setLeftDirectly(String left) {
        this.initAuxInfo().left = left;
    }

    protected void setTopDirectly(String top) {
        this.initAuxInfo().top = top;
    }

    protected void setZIndexDirectly(int zIndex) {
        this.initAuxInfo().zIndex = zIndex;
    }

    protected void setHflexDirectly(String hflex) {
        this.initAuxInfo().hflex = hflex;
    }

    protected void setVflexDirectly(String vflex) {
        this.initAuxInfo().vflex = vflex;
    }

    public String getTooltiptext() {
        return this._auxinf != null ? this._auxinf.tooltiptext : null;
    }

    public void setTooltiptext(String tooltiptext) {
        if (tooltiptext != null && tooltiptext.length() == 0) {
            tooltiptext = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.tooltiptext : null), (Object)tooltiptext)) {
            this.initAuxInfo().tooltiptext = tooltiptext;
            this.smartUpdate("tooltiptext", tooltiptext);
        }
    }

    public String getZclass() {
        return this._zclass;
    }

    public void setZclass(String zclass) {
        if (zclass != null && zclass.length() == 0) {
            zclass = null;
        }
        if (!Objects.equals((Object)this._zclass, (Object)zclass)) {
            this._zclass = zclass;
            this.smartUpdate("zclass", this._zclass);
        }
    }

    public String getSclass() {
        return this._auxinf != null ? this._auxinf.sclass : null;
    }

    public void setSclass(String sclass) {
        if (sclass != null && sclass.length() == 0) {
            sclass = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.sclass : null), (Object)sclass)) {
            this.initAuxInfo().sclass = sclass;
            this.smartUpdate("sclass", sclass);
        }
    }

    public void setClass(String sclass) {
        this.setSclass(sclass);
    }

    public String getStyle() {
        return this._auxinf != null ? this._auxinf.style : null;
    }

    public void setStyle(String style) {
        if (style != null && style.length() == 0) {
            style = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.style : null), (Object)style)) {
            this.initAuxInfo().style = style;
            this.smartUpdate("style", style);
        }
    }

    public void setDraggable(String draggable) {
        if (draggable != null && draggable.length() == 0) {
            draggable = "false";
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.draggable : null), (Object)draggable)) {
            this.initAuxInfo().draggable = draggable;
            this.smartUpdate("draggable", draggable);
        }
    }

    public String getDraggable() {
        return this._auxinf != null && this._auxinf.draggable != null ? this._auxinf.draggable : (this.getParent() instanceof DragControl ? "true" : "false");
    }

    public void setDroppable(String droppable) {
        if (droppable != null && (droppable.length() == 0 || "false".equals(droppable))) {
            droppable = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.droppable : null), (Object)droppable)) {
            this.initAuxInfo().droppable = droppable;
            this.smartUpdate("droppable", droppable);
        }
    }

    public String getDroppable() {
        return this._auxinf != null && this._auxinf.droppable != null ? this._auxinf.droppable : "false";
    }

    public void focus() {
        this.response(new AuFocus(this));
    }

    public void setFocus(boolean focus) {
        if (focus) {
            this.focus();
        }
    }

    public void setVflex(String flex) {
        if (this.getHeight() != null && flex != null && !"min".equals(flex)) {
            throw new UiException("Not allowed to set vflex and height at the same time except vflex=\"min\"");
        }
        this.setVflex0(flex);
    }

    protected void setVflex0(String flex) {
        if (flex != null && flex.length() == 0) {
            flex = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.vflex : null), (Object)flex)) {
            this.initAuxInfo().vflex = flex;
            this.smartUpdate("vflex", flex);
        }
    }

    public String getVflex() {
        return this._auxinf != null ? this._auxinf.vflex : null;
    }

    public void setHflex(String flex) {
        if (this.getWidth() != null && flex != null && !"min".equals(flex)) {
            throw new UiException("Not allowed to set hflex and width at the same time except hflex=\"min\"");
        }
        this.setHflex0(flex);
    }

    protected void setHflex0(String flex) {
        if (flex != null && flex.length() == 0) {
            flex = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.hflex : null), (Object)flex)) {
            this.initAuxInfo().hflex = flex;
            this.smartUpdate("hflex", flex);
        }
    }

    public String getHflex() {
        return this._auxinf != null ? this._auxinf.hflex : null;
    }

    public int getRenderdefer() {
        return this._auxinf != null ? this._auxinf.renderdefer : -1;
    }

    public void setRenderdefer(int ms) {
        this.initAuxInfo().renderdefer = ms;
    }

    public String getAction() {
        return this._auxinf != null ? this._auxinf.action : null;
    }

    public void setAction(String action) {
        if (action != null && action.length() == 0) {
            action = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.action : null), (Object)action)) {
            this.initAuxInfo().action = action;
            this.smartUpdate("action", action);
        }
    }

    public int getTabindex() {
        return this._auxinf != null && this._auxinf.tabindex != null ? this._auxinf.tabindex : 0;
    }

    public Integer getTabindexInteger() {
        return this._auxinf != null && this._auxinf.tabindex != null ? this._auxinf.tabindex : null;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        this.setTabindex((Integer)tabindex);
    }

    public void setTabindex(Integer tabindex) {
        if ((this._auxinf != null ? this._auxinf.tabindex : null) != tabindex) {
            this.initAuxInfo().tabindex = tabindex;
            this.smartUpdate("tabindex", tabindex);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._auxinf != null) {
            String draggable;
            this.render(renderer, "width", this._auxinf.width);
            this.render(renderer, "height", this._auxinf.height);
            this.render(renderer, "left", this._auxinf.left);
            this.render(renderer, "top", this._auxinf.top);
            this.render(renderer, "vflex", this._auxinf.vflex);
            this.render(renderer, "hflex", this._auxinf.hflex);
            this.render(renderer, "sclass", this._auxinf.sclass);
            this.render(renderer, "style", this._auxinf.style);
            this.render(renderer, "tooltiptext", this._auxinf.tooltiptext);
            if (this._auxinf.zIndex >= 0) {
                renderer.render("zIndex", this._auxinf.zIndex);
            }
            if (this._auxinf.renderdefer >= 0) {
                renderer.render("renderdefer", this._auxinf.renderdefer);
            }
            if (this._auxinf.tabindex != null) {
                renderer.render("tabindex", this._auxinf.tabindex);
            }
            if ((draggable = this._auxinf.draggable) != null && (this.getParent() instanceof DragControl || !draggable.equals("false"))) {
                this.render(renderer, "draggable", draggable);
            }
            this.render(renderer, "droppable", this._auxinf.droppable);
            this.render(renderer, "action", this._auxinf.action);
        }
        this.render(renderer, "zclass", this._zclass);
        this.render(renderer, "prolog", this._prolog);
    }

    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onClick") || cmd.equals("onDoubleClick") || cmd.equals("onRightClick") || cmd.equals("onMouseOver") || cmd.equals("onMouseOut")) {
            Events.postEvent(MouseEvent.getMouseEvent(request));
        } else if (cmd.equals("onOK") || cmd.equals("onCancel") || cmd.equals("onCtrlKey")) {
            Events.postEvent(KeyEvent.getKeyEvent(request));
        } else if (cmd.equals("onMove")) {
            MoveEvent evt = MoveEvent.getMoveEvent(request);
            this.setLeftDirectly(evt.getLeft());
            this.setTopDirectly(evt.getTop());
            Events.postEvent(evt);
        } else if (cmd.equals("onSize")) {
            SizeEvent evt = SizeEvent.getSizeEvent(request);
            this.setWidthDirectly(evt.getWidth());
            this.setHeightDirectly(evt.getHeight());
            this.setHflexDirectly(null);
            this.setVflexDirectly(null);
            Events.postEvent(evt);
        } else if (cmd.equals("onAfterSize")) {
            AfterSizeEvent evt = AfterSizeEvent.getAfterSizeEvent(request);
            Events.postEvent(evt);
        } else if (cmd.equals("onZIndex")) {
            ZIndexEvent evt = ZIndexEvent.getZIndexEvent(request);
            this.setZIndexDirectly(evt.getZIndex());
            Events.postEvent(evt);
        } else if (cmd.equals("onDrop")) {
            DropEvent evt = DropEvent.getDropEvent(request);
            Events.postEvent(evt);
        } else if (cmd.equals("onSwipe")) {
            SwipeEvent evt = SwipeEvent.getSwipeEvent(request);
            Events.postEvent(evt);
        } else {
            super.service(request, everError);
        }
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    public Object clone() {
        HtmlBasedComponent clone = (HtmlBasedComponent)super.clone();
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)this._auxinf.clone();
        }
        return clone;
    }

    private final AuxInfo initAuxInfo() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    static {
        HtmlBasedComponent.addClientEvent(HtmlBasedComponent.class, "onClick", 0);
        HtmlBasedComponent.addClientEvent(HtmlBasedComponent.class, "onDoubleClick", 0);
        HtmlBasedComponent.addClientEvent(HtmlBasedComponent.class, "onRightClick", 0);
        HtmlBasedComponent.addClientEvent(HtmlBasedComponent.class, "onOK", 0);
        HtmlBasedComponent.addClientEvent(HtmlBasedComponent.class, "onCancel", 0);
        HtmlBasedComponent.addClientEvent(HtmlBasedComponent.class, "onCtrlKey", 0);
        HtmlBasedComponent.addClientEvent(HtmlBasedComponent.class, "onDrop", 0);
        HtmlBasedComponent.addClientEvent(HtmlBasedComponent.class, "onMouseOver", 0);
        HtmlBasedComponent.addClientEvent(HtmlBasedComponent.class, "onMouseOut", 0);
        HtmlBasedComponent.addClientEvent(HtmlBasedComponent.class, "onSwipe", 8192);
        HtmlBasedComponent.addClientEvent(HtmlBasedComponent.class, "onAfterSize", 8192);
        _properties = new HashMap(20);
        _properties.put("width", new StringPropertyAccess(){

            public void setValue(Component cmp, String width) {
                ((HtmlBasedComponent)cmp).setWidth(width);
            }

            public String getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getWidth();
            }
        });
        _properties.put("height", new StringPropertyAccess(){

            public void setValue(Component cmp, String height) {
                ((HtmlBasedComponent)cmp).setHeight(height);
            }

            public String getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getHeight();
            }
        });
        _properties.put("sclass", new StringPropertyAccess(){

            public void setValue(Component cmp, String sclass) {
                ((HtmlBasedComponent)cmp).setSclass(sclass);
            }

            public String getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getSclass();
            }
        });
        _properties.put("zclass", new StringPropertyAccess(){

            public void setValue(Component cmp, String zclass) {
                ((HtmlBasedComponent)cmp).setZclass(zclass);
            }

            public String getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getZclass();
            }
        });
        _properties.put("style", new StringPropertyAccess(){

            public void setValue(Component cmp, String style) {
                ((HtmlBasedComponent)cmp).setStyle(style);
            }

            public String getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getStyle();
            }
        });
        _properties.put("left", new StringPropertyAccess(){

            public void setValue(Component cmp, String left) {
                ((HtmlBasedComponent)cmp).setLeft(left);
            }

            public String getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getLeft();
            }
        });
        _properties.put("top", new StringPropertyAccess(){

            public void setValue(Component cmp, String top) {
                ((HtmlBasedComponent)cmp).setTop(top);
            }

            public String getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getTop();
            }
        });
        _properties.put("draggable", new StringPropertyAccess(){

            public void setValue(Component cmp, String draggable) {
                ((HtmlBasedComponent)cmp).setDraggable(draggable);
            }

            public String getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getDraggable();
            }
        });
        _properties.put("droppable", new StringPropertyAccess(){

            public void setValue(Component cmp, String droppable) {
                ((HtmlBasedComponent)cmp).setDroppable(droppable);
            }

            public String getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getDroppable();
            }
        });
        _properties.put("tooltiptext", new StringPropertyAccess(){

            public void setValue(Component cmp, String tooltiptext) {
                ((HtmlBasedComponent)cmp).setTooltiptext(tooltiptext);
            }

            public String getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getTooltiptext();
            }
        });
        _properties.put("zindex", new IntPropertyAccess(){

            public void setValue(Component cmp, Integer zindex) {
                ((HtmlBasedComponent)cmp).setZindex(zindex);
            }

            public Integer getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getZIndex();
            }
        });
        _properties.put("renderdefer", new IntPropertyAccess(){

            public void setValue(Component cmp, Integer renderdefer) {
                ((HtmlBasedComponent)cmp).setRenderdefer(renderdefer);
            }

            public Integer getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getRenderdefer();
            }
        });
        _properties.put("action", new StringPropertyAccess(){

            public void setValue(Component cmp, String action) {
                ((HtmlBasedComponent)cmp).setAction(action);
            }

            public String getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getAction();
            }
        });
        _properties.put("hflex", new StringPropertyAccess(){

            public void setValue(Component cmp, String hflex) {
                ((HtmlBasedComponent)cmp).setHflex(hflex);
            }

            public String getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getHflex();
            }
        });
        _properties.put("vflex", new StringPropertyAccess(){

            public void setValue(Component cmp, String vflex) {
                ((HtmlBasedComponent)cmp).setVflex(vflex);
            }

            public String getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getVflex();
            }
        });
        _properties.put("tabindex", new IntegerPropertyAccess(){

            public void setValue(Component cmp, Integer tabindex) {
                ((HtmlBasedComponent)cmp).setTabindex(tabindex);
            }

            public Integer getValue(Component cmp) {
                return ((HtmlBasedComponent)cmp).getTabindexInteger();
            }
        });
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private String width;
        private String height;
        private String left;
        private String top;
        private String vflex;
        private String hflex;
        private String sclass;
        private String style;
        private String tooltiptext;
        private String draggable;
        private String droppable;
        private String action;
        private int zIndex = -1;
        private int renderdefer = -1;
        private Integer tabindex;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }

    protected class ExtraCtrl
    implements PrologAllowed {
        protected ExtraCtrl() {
        }

        public void setPrologContent(String prolog) {
            HtmlBasedComponent.this._prolog = prolog;
        }
    }
}

