/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtil {
    public static final String ZKBIND_PREFIX = "ZKBIND$";

    public static Annotation getOverrideAnnotation(ComponentCtrl compCtrl, String propName, String annoName) {
        Collection annos = compCtrl.getAnnotations(propName, annoName);
        if (annos.size() <= 0) {
            return null;
        }
        if (annos instanceof List) {
            return (Annotation)((List)annos).get(((List)annos).size() - 1);
        }
        Iterator it = annos.iterator();
        Annotation anno = (Annotation)it.next();
        while (it.hasNext()) {
            anno = (Annotation)it.next();
        }
        return anno;
    }

    public static Annotation getSystemAnnotation(ComponentCtrl compCtrl, String propName) {
        Collection annos = compCtrl.getAnnotations(propName, "ZKBIND");
        if (annos.size() <= 0) {
            if (propName == null) {
                return null;
            }
            annos = compCtrl.getAnnotations(ZKBIND_PREFIX + propName, "ZKBIND");
            if (annos.size() <= 0) {
                return null;
            }
        }
        if (annos instanceof List) {
            return (Annotation)((List)annos).get(0);
        }
        Iterator it = annos.iterator();
        Annotation anno = (Annotation)it.next();
        while (it.hasNext()) {
            anno = (Annotation)it.next();
        }
        return anno;
    }

    public static List<String> getNonSystemProperties(Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        List props = compCtrl.getAnnotatedProperties();
        if (props == null || props.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> propsList = new ArrayList<String>(props.size());
        for (String p : props) {
            if (p.startsWith(ZKBIND_PREFIX)) continue;
            propsList.add(p);
        }
        return propsList;
    }

    public static String testString(String[] string, Annotation anno) {
        if (string == null || string.length == 0) {
            return null;
        }
        if (string.length == 1) {
            return string[0];
        }
        throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("only allow one string of @" + anno.getName() + ",but contains " + Arrays.toString(string), anno));
    }
}

