/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Phase;
import org.zkoss.bind.impl.AbstractBindingHandler;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindingKey;
import org.zkoss.bind.impl.InitChildrenBindingImpl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.InitChildrenBinding;
import org.zkoss.bind.sys.LoadChildrenBinding;
import org.zkoss.zk.ui.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChildrenBindingHandler
extends AbstractBindingHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger _log = LoggerFactory.getLogger(ChildrenBindingHandler.class);
    private final Map<BindingKey, List<InitChildrenBinding>> _initBindings = new HashMap<BindingKey, List<InitChildrenBinding>>();
    private final Map<BindingKey, List<LoadChildrenBinding>> _loadPromptBindings = new HashMap<BindingKey, List<LoadChildrenBinding>>();
    private final Map<String, List<LoadChildrenBinding>> _loadAfterBindings = new HashMap<String, List<LoadChildrenBinding>>();
    private final Map<String, List<LoadChildrenBinding>> _loadBeforeBindings = new HashMap<String, List<LoadChildrenBinding>>();

    ChildrenBindingHandler() {
    }

    void addLoadPromptBinding(Component comp, BindingKey bkey, LoadChildrenBinding binding) {
        this.addBinding(this._loadPromptBindings, bkey, binding);
    }

    void addInitBinding(BindingKey bkey, InitChildrenBinding binding) {
        this.addBinding(this._initBindings, bkey, binding);
    }

    void addLoadBeforeBinding(String command, LoadChildrenBinding binding) {
        this.addBinding(this._loadBeforeBindings, command, binding);
    }

    void addLoadAfterBinding(String command, LoadChildrenBinding binding) {
        this.addBinding(this._loadAfterBindings, command, binding);
    }

    List<LoadChildrenBinding> getLoadPromptBindings(BindingKey bkey) {
        return this._loadPromptBindings.get(bkey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadBinding(Component comp, LoadChildrenBinding binding, String command) {
        BindContext ctx = BindContextUtil.newBindContext(this._binder, binding, false, command, binding.getComponent(), null);
        if (binding instanceof InitChildrenBindingImpl) {
            ctx.setAttribute("$IGNORE_TRACKER$", Boolean.TRUE);
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug("doLoadChildrenBinding:binding.load(),component=[{}],binding=[{}],context=[{}],command=[{}]", new Object[]{comp, binding, ctx, command});
            }
            this.doPrePhase(Phase.LOAD_BINDING, ctx);
            binding.load(ctx);
        }
        finally {
            this.doPostPhase(Phase.LOAD_BINDING, ctx);
        }
    }

    void doLoadBefore(Component comp, String command) {
        List<LoadChildrenBinding> bindings = this._loadBeforeBindings.get(command);
        if (bindings != null) {
            for (LoadChildrenBinding binding : bindings) {
                this.doLoadBinding(comp, binding, command);
            }
        }
    }

    void doLoadAfter(Component comp, String command) {
        List<LoadChildrenBinding> bindings = this._loadAfterBindings.get(command);
        if (bindings != null) {
            for (LoadChildrenBinding binding : bindings) {
                this.doLoadBinding(comp, binding, command);
            }
        }
    }

    void removeBindings(BindingKey bkey, Set<Binding> removed) {
        List<LoadChildrenBinding> bindingx = this._initBindings.remove(bkey);
        if (bindingx != null) {
            removed.addAll(bindingx);
        }
        if ((bindingx = this._loadPromptBindings.remove(bkey)) != null) {
            removed.addAll(bindingx);
        }
    }

    void removeBindings(Collection<Binding> removes) {
        for (List<LoadChildrenBinding> bindings : this._loadAfterBindings.values()) {
            bindings.removeAll(removes);
        }
        for (List<LoadChildrenBinding> bindings : this._loadBeforeBindings.values()) {
            bindings.removeAll(removes);
        }
    }

    void doLoad(Component comp, BindingKey bkey) {
        List<LoadChildrenBinding> bindings = this._loadPromptBindings.get(bkey);
        if (bindings != null) {
            for (LoadChildrenBinding binding : bindings) {
                this.doLoadBinding(comp, binding, null);
            }
        }
    }

    void doInit(Component comp, BindingKey bkey) {
        List<InitChildrenBinding> initBindings = this._initBindings.get(bkey);
        if (initBindings != null) {
            for (InitChildrenBinding binding : initBindings) {
                this.doLoadBinding(comp, binding, null);
            }
        }
    }

    public boolean hasLoadBinding(BindingKey bkey) {
        return this._initBindings.size() > 0 || this._loadPromptBindings.size() > 0 || this._loadAfterBindings.size() > 0 || this._loadBeforeBindings.size() > 0;
    }
}

