/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.databind;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zkplus.databind.Binding;
import org.zkoss.zkplus.databind.DataBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BindingNode
implements Serializable {
    private static final long serialVersionUID = 200808191424L;
    private LinkedHashSet<Binding> _bindingSet = new LinkedHashSet();
    private Map<String, BindingNode> _kids = new LinkedHashMap<String, BindingNode>(8);
    private String _path;
    private Set<Object> _sameNodes = new HashSet<Object>();
    private boolean _var;
    private String _nodeId;
    private boolean _root;
    private boolean _innerCollectionNode;

    public BindingNode(String path, boolean var, String id, boolean root) {
        this._path = path;
        this._sameNodes.add(this);
        this._var = var;
        this._nodeId = id;
        this._root = root;
    }

    public LinkedHashSet<Binding> getBindings() {
        return this._bindingSet;
    }

    public LinkedHashSet<Binding> getAllBindings() {
        HashSet<BindingNode> walkedNodes = new HashSet<BindingNode>(23);
        LinkedHashSet<Binding> all = new LinkedHashSet<Binding>(46);
        this.myGetAllBindings(all, walkedNodes);
        return all;
    }

    private void myGetAllBindings(LinkedHashSet<Binding> all, Set<BindingNode> walkedNodes) {
        if (walkedNodes.contains(this)) {
            return;
        }
        walkedNodes.add(this);
        for (BindingNode bn : this._kids.values()) {
            bn.myGetAllBindings(all, walkedNodes);
        }
        for (Object obj : this._sameNodes) {
            if (!(obj instanceof BindingNode)) continue;
            ((BindingNode)obj).myGetAllBindings(all, walkedNodes);
        }
        all.addAll(this.getBindings());
    }

    public String getPath() {
        return this._path;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public boolean isVar() {
        return this._var;
    }

    public boolean isRoot() {
        return this._root;
    }

    public void addBinding(String path, Binding binding, Set varnameSet) {
        List<String> nodeids = DataBinder.parseExpression(path, ".");
        if (nodeids.size() <= 0) {
            throw new UiException("Incorrect bean expression: " + path);
        }
        boolean var = varnameSet.contains(nodeids.get(0));
        BindingNode currentNode = this;
        for (String nodeid : nodeids) {
            if (nodeid == null) {
                throw new UiException("Incorrect bean expression: " + path);
            }
            BindingNode kidNode = currentNode.getKidNode(nodeid);
            if (kidNode == null) {
                kidNode = "/".equals(currentNode._path) ? new BindingNode(nodeid, var, nodeid, true) : new BindingNode(currentNode._path + "." + nodeid, var, nodeid, false);
                currentNode.addKidNode(nodeid, kidNode);
            } else {
                var = var || kidNode._var;
            }
            currentNode = kidNode;
        }
        if (currentNode == this) {
            throw new UiException("Incorrect bean expression: " + path);
        }
        currentNode.addBinding(binding);
        if ("_var".equals(binding.getAttr())) {
            currentNode._innerCollectionNode = DataBinder.hasTemplateOwner(binding.getComponent());
        }
    }

    public void addBinding(Binding binding) {
        this._bindingSet.add(binding);
    }

    public boolean isInnerCollectionNode() {
        return this._innerCollectionNode;
    }

    public BindingNode locate(String path) {
        BindingNode currentNode = this;
        List<String> nodeids = DataBinder.parseExpression(path, ".");
        for (String nodeid : nodeids) {
            if (nodeid == null) {
                throw new UiException("Incorrect format of bean expression: " + path);
            }
            if ((currentNode = currentNode.getKidNode(nodeid)) != null) continue;
            return null;
        }
        return currentNode == this ? null : currentNode;
    }

    public BindingNode getRootNode(BindingNode superNode) {
        if (this.isRoot()) {
            return this;
        }
        int j = this.getPath().indexOf(".");
        String path = j < 0 ? this.getPath() : this.getPath().substring(0, j);
        return superNode.locate(path);
    }

    public Set<Object> getSameNodes() {
        return this._sameNodes;
    }

    public void mergeAndSetSameNodes(Set<Object> other) {
        if (other == this._sameNodes) {
            return;
        }
        if (this._sameNodes != null) {
            other.addAll(this._sameNodes);
        }
        this._sameNodes = other;
    }

    public String toString() {
        return this._path;
    }

    Collection<BindingNode> getKidNodes() {
        return this._kids.values();
    }

    BindingNode getKidNode(String nodeid) {
        return this._kids.get(nodeid);
    }

    private void addKidNode(String nodeid, BindingNode kid) {
        this._kids.put(nodeid, kid);
    }
}

