/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.theme;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Strings;
import org.zkoss.web.fn.ThemeFns;
import org.zkoss.web.theme.StandardTheme;
import org.zkoss.web.theme.Theme;
import org.zkoss.web.theme.ThemeRegistry;
import org.zkoss.web.theme.ThemeResolver;
import org.zkoss.zk.ui.Execution;

public class Themes {
    public static final String BREEZE_NAME = "breeze";
    public static final String BREEZE_DISPLAY = "Breeze";
    public static final int BREEZE_PRIORITY = 500;

    public static void setTheme(Execution exe, String themeName) {
        ThemeResolver themeResolver = ThemeFns.getThemeResolver();
        themeResolver.setTheme((HttpServletRequest)exe.getNativeRequest(), (HttpServletResponse)exe.getNativeResponse(), themeName);
    }

    public static String getTheme(Execution exe) {
        ThemeResolver themeResolver = ThemeFns.getThemeResolver();
        return themeResolver.getTheme((HttpServletRequest)exe.getNativeRequest());
    }

    public static String getCurrentTheme() {
        return ThemeFns.getCurrentTheme();
    }

    public static boolean hasTheme(String themeName) {
        ThemeRegistry themeRegistry = ThemeFns.getThemeRegistry();
        return themeRegistry.hasTheme(themeName);
    }

    public static String[] getThemes() {
        ThemeRegistry themeRegistry = ThemeFns.getThemeRegistry();
        Theme[] themes = themeRegistry.getThemes();
        String[] themeNames = new String[themes.length];
        for (int i = 0; i < themes.length; ++i) {
            themeNames[i] = themes[i].getName();
        }
        return themeNames;
    }

    public static void register(String themeName) {
        ThemeRegistry themeRegistry = ThemeFns.getThemeRegistry();
        themeRegistry.register((Theme)new StandardTheme(themeName));
    }

    public static void register(String themeName, StandardTheme.ThemeOrigin origin) {
        ThemeRegistry themeRegistry = ThemeFns.getThemeRegistry();
        themeRegistry.register((Theme)new StandardTheme(themeName, origin));
    }

    public static void register(String themeName, String displayName, int priority) {
        ThemeRegistry themeRegistry = ThemeFns.getThemeRegistry();
        themeRegistry.register((Theme)new StandardTheme(themeName, displayName, priority));
    }

    public static void register(String themeName, String displayName, int priority, StandardTheme.ThemeOrigin origin) {
        ThemeRegistry themeRegistry = ThemeFns.getThemeRegistry();
        themeRegistry.register((Theme)new StandardTheme(themeName, displayName, priority, origin));
    }

    public static void setDisplayName(String themeName, String displayName) {
        ThemeRegistry themeRegistry = ThemeFns.getThemeRegistry();
        Theme theme = themeRegistry.getTheme(themeName);
        if (theme instanceof StandardTheme) {
            ((StandardTheme)theme).setDisplayName(displayName);
        }
    }

    public static String getDisplayName(String themeName) {
        ThemeRegistry themeRegistry = ThemeFns.getThemeRegistry();
        Theme theme = themeRegistry.getTheme(themeName);
        String displayName = "";
        if (theme instanceof StandardTheme) {
            displayName = ((StandardTheme)theme).getDisplayName();
        }
        return Strings.isEmpty((String)displayName) ? Themes.capitalize(themeName) : displayName;
    }

    public static void setPriority(String themeName, int priority) {
        ThemeRegistry themeRegistry = ThemeFns.getThemeRegistry();
        Theme theme = themeRegistry.getTheme(themeName);
        if (theme instanceof StandardTheme) {
            ((StandardTheme)theme).setPriority(priority);
        }
    }

    public static int getPriority(String themeName) {
        ThemeRegistry themeRegistry = ThemeFns.getThemeRegistry();
        Theme theme = themeRegistry.getTheme(themeName);
        if (theme instanceof StandardTheme) {
            return ((StandardTheme)theme).getPriority();
        }
        return Integer.MAX_VALUE;
    }

    private static String capitalize(String str) {
        if (Strings.isEmpty((String)str)) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }
}

