/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.security.Principal;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.idom.Document;
import org.zkoss.lang.Objects;
import org.zkoss.util.CollectionsX;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.ext.ScopeListener;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ConventionWires;
import org.zkoss.zk.xel.Evaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Components {
    private static final Logger log = LoggerFactory.getLogger(Components.class);
    private static final Logger _zklog = LoggerFactory.getLogger((String)"org.zkoss.zk.log");
    private static final Set<String> IMPLICIT_NAMES = new HashSet<String>();
    public static final Exec EXECUTION_PROXY;
    public static final RequestScope REQUEST_SCOPE_PROXY;

    protected Components() {
    }

    public static IdSpace getParentIdSpace(IdSpace idspace) {
        if (idspace instanceof Component) {
            Component c = (Component)((Object)idspace);
            Component p = c.getParent();
            return p != null ? p.getSpaceOwner() : c.getPage();
        }
        return null;
    }

    public static void sort(List<? extends Component> list, Comparator<? super Component> cpr) {
        Components.sort(list, 0, list.size(), cpr);
    }

    public static void sort(List<? extends Component> list, int from, int to, Comparator<? super Component> cpr) {
        Component[] ary = (Component[])CollectionsX.toArray(list, (Object[])new Component[0], (int)from, (int)to);
        Arrays.sort(ary, cpr);
        ListIterator<? extends Component> it = list.listIterator(from);
        int j = 0;
        int k = to - from;
        while (it.hasNext() && --k >= 0) {
            if (it.next() != ary[j]) {
                it.remove();
                if (!it.hasNext() || --k < 0) break;
                if (it.next() != ary[j]) {
                    it.previous();
                    ++k;
                    break;
                }
            }
            ++j;
        }
        while (it.hasNext() && --k >= 0) {
            it.next();
            it.remove();
        }
        while (j < ary.length) {
            Components.add(list, from + j, ary[j]);
            ++j;
        }
    }

    public static void replace(Component oldc, Component newc) {
        Component p = oldc.getParent();
        Component sib = oldc.getNextSibling();
        if (p != null) {
            oldc.detach();
            p.insertBefore(newc, sib);
        } else {
            Page page = oldc.getPage();
            if (page == null) {
                throw new IllegalArgumentException("Neither child nor attached, " + oldc);
            }
            oldc.detach();
            if (newc.getParent() != null) {
                newc.detach();
            }
            newc.setPageBefore(page, sib);
        }
    }

    public static void replaceChildren(Component parent, Collection<Component> newChildren) {
        List children = parent.getChildren();
        children.clear();
        children.addAll(newChildren);
    }

    private static void add(List list, int index, Object o) {
        list.add(index, o);
    }

    public static Component getRoot(Component comp) {
        if (comp == null) {
            return null;
        }
        Component p;
        while ((p = comp.getParent()) != null) {
            comp = p;
        }
        return comp;
    }

    public static boolean isAncestor(Component node1, Component node2) {
        while (node2 != null) {
            if (node1 == node2) {
                return true;
            }
            node2 = node2.getParent();
        }
        return false;
    }

    public static void removeAllChildren(Component comp) {
        comp.getChildren().clear();
    }

    public static final ComponentDefinition getDefinitionByDeviceType(String deviceType, Class cls) {
        for (LanguageDefinition ld : LanguageDefinition.getByDeviceType(deviceType)) {
            try {
                return ld.getComponentDefinition(cls);
            }
            catch (DefinitionNotFoundException definitionNotFoundException) {
            }
        }
        return null;
    }

    public static boolean isRealVisible(Component comp) {
        while (comp != null) {
            if (!comp.isVisible()) {
                return false;
            }
            comp = comp.getParent();
        }
        return true;
    }

    public static Collection<Component> getVisibleChildren(Component comp) {
        final List children = comp.getChildren();
        return new AbstractCollection<Component>(){

            @Override
            public int size() {
                int size = 0;
                for (Component c : children) {
                    if (!c.isVisible()) continue;
                    ++size;
                }
                return size;
            }

            @Override
            public Iterator<Component> iterator() {
                return new Iterator<Component>(){
                    final Iterator<Component> _it;
                    Component _next;
                    {
                        this._it = children.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this._next != null) {
                            return true;
                        }
                        this._next = this.getNextVisible(false);
                        return this._next != null;
                    }

                    @Override
                    public Component next() {
                        if (this._next != null) {
                            Component c = this._next;
                            this._next = null;
                            return c;
                        }
                        return this.getNextVisible(true);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private Component getNextVisible(boolean blind) {
                        while (blind || this._it.hasNext()) {
                            Component c = this._it.next();
                            if (!c.isVisible()) continue;
                            return c;
                        }
                        return null;
                    }
                };
            }
        };
    }

    public static final int getScope(String scope) {
        if ("component".equals(scope)) {
            return 0;
        }
        if ("space".equals(scope)) {
            return 1;
        }
        if ("page".equals(scope)) {
            return 2;
        }
        if ("desktop".equals(scope)) {
            return 3;
        }
        if ("session".equals(scope)) {
            return 4;
        }
        if ("application".equals(scope)) {
            return 5;
        }
        if ("request".equals(scope)) {
            return 6;
        }
        throw new IllegalArgumentException("Unknown scope: " + scope);
    }

    public static final String scopeToString(int scope) {
        switch (scope) {
            case 0: {
                return "component";
            }
            case 1: {
                return "space";
            }
            case 2: {
                return "page";
            }
            case 3: {
                return "desktop";
            }
            case 4: {
                return "session";
            }
            case 5: {
                return "application";
            }
            case 6: {
                return "request";
            }
        }
        throw new IllegalArgumentException("Unknown scope: " + scope);
    }

    public static final String componentToPath(Component comp, Component ref) {
        if (comp == null) {
            return null;
        }
        if (comp == ref) {
            return ".";
        }
        String id = comp.getId();
        if (!(comp instanceof IdSpace) && id.length() == 0) {
            throw new UnsupportedOperationException("comp must be assigned with ID or a space owner: " + comp);
        }
        StringBuffer sb = new StringBuffer(128);
        IdSpace space = ref.getSpaceOwner();
        while (comp != space) {
            Component parent;
            if (space.getFellowIfAny(id) == comp) {
                if (sb.length() > 0) {
                    sb.append('/');
                }
                return sb.append(id).toString();
            }
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append("..");
            Component component = parent = space instanceof Component ? ((Component)((Object)space)).getParent() : null;
            if (parent == null) {
                throw new UnsupportedOperationException("Unable to locate " + comp + " from " + ref);
            }
            space = parent.getSpaceOwner();
        }
        return sb.toString();
    }

    public static final Component pathToComponent(String path, Component ref) {
        if (path == null) {
            return null;
        }
        if (".".equals(path)) {
            return ref;
        }
        if ("".equals(path)) {
            IdSpace owner = ref.getSpaceOwner();
            if (!(owner instanceof Component)) {
                throw new IllegalStateException("The component is moved after serialized: " + ref);
            }
            return (Component)((Object)owner);
        }
        return Path.getComponent(ref.getSpaceOwner(), path);
    }

    public static final void wireFellows(IdSpace idspace, Object controller) {
        ConventionWires.wireFellows(idspace, controller);
    }

    public static final void wireFellows(IdSpace idspace, Object controller, char separator) {
        ConventionWires.wireFellows(idspace, controller, separator);
    }

    public static final void wireFellows(IdSpace idspace, Object controller, char separator, boolean ignoreZScript, boolean ignoreXel) {
        ConventionWires.wireFellows(idspace, controller, separator, ignoreZScript, ignoreXel);
    }

    public static final void wireVariables(Component comp, Object controller) {
        ConventionWires.wireVariables(comp, controller);
    }

    public static final void wireVariables(Component comp, Object controller, char separator) {
        ConventionWires.wireVariables(comp, controller, separator);
    }

    public static final void wireVariables(Component comp, Object controller, char separator, boolean ignoreZScript, boolean ignoreXel) {
        ConventionWires.wireVariables(comp, controller, separator, ignoreZScript, ignoreXel);
    }

    public static final void wireVariables(Page page, Object controller) {
        ConventionWires.wireVariables(page, controller);
    }

    public static final void wireVariables(Page page, Object controller, char separator) {
        ConventionWires.wireVariables(page, controller, separator);
    }

    public static final void wireVariables(Page page, Object controller, char separator, boolean ignoreZScript, boolean ignoreXel) {
        ConventionWires.wireVariables(page, controller, separator, ignoreZScript, ignoreXel);
    }

    public static final void wireController(Component comp, Object controller) {
        ConventionWires.wireController(comp, controller);
    }

    public static final void wireController(Component comp, Object controller, char separator) {
        ConventionWires.wireController(comp, controller, separator);
    }

    public static final void wireController(Component comp, Object controller, char separator, boolean ignoreZScript, boolean ignoreXel) {
        ConventionWires.wireController(comp, controller, separator);
    }

    public static final void wireImplicit(Component comp, Object controller) {
        ConventionWires.wireImplicit(comp, controller);
    }

    public static void addForwards(Component comp, Object controller) {
        ConventionWires.addForwards(comp, controller);
    }

    public static void addForwards(Component comp, Object controller, char separator) {
        ConventionWires.addForwards(comp, controller, separator);
    }

    public static boolean isImplicit(String id) {
        return IMPLICIT_NAMES.contains(id);
    }

    public static Collection<String> getImplicitNames() {
        return IMPLICIT_NAMES;
    }

    public static Object getImplicit(Page page, Component comp, String name) {
        if (comp != null && page == null) {
            page = Components.getCurrentPage(comp);
        }
        if ("log".equals(name)) {
            return _zklog;
        }
        if ("self".equals(name)) {
            return comp != null ? comp : page;
        }
        if ("spaceOwner".equals(name)) {
            return comp != null ? comp.getSpaceOwner() : page;
        }
        if ("page".equals(name)) {
            return page;
        }
        if ("desktop".equals(name)) {
            return comp != null ? Components.getDesktop(comp) : page.getDesktop();
        }
        if ("session".equals(name)) {
            return comp != null ? Components.getSession(comp) : page.getDesktop().getSession();
        }
        if ("application".equals(name)) {
            return comp != null ? Components.getWebApp(comp) : page.getDesktop().getWebApp();
        }
        if ("componentScope".equals(name)) {
            return comp != null ? comp.getAttributes() : Collections.EMPTY_MAP;
        }
        if ("spaceScope".equals(name)) {
            IdSpace scope = comp != null ? comp.getSpaceOwner() : page;
            return scope != null ? scope.getAttributes() : Collections.EMPTY_MAP;
        }
        if ("pageScope".equals(name)) {
            return page != null ? page.getAttributes() : Collections.EMPTY_MAP;
        }
        if ("desktopScope".equals(name)) {
            Desktop dt = comp != null ? Components.getDesktop(comp) : page.getDesktop();
            return dt != null ? dt.getAttributes() : Collections.EMPTY_MAP;
        }
        if ("sessionScope".equals(name)) {
            Session sess = comp != null ? Components.getSession(comp) : page.getDesktop().getSession();
            return sess != null ? sess.getAttributes() : Collections.EMPTY_MAP;
        }
        if ("applicationScope".equals(name)) {
            WebApp app = comp != null ? Components.getWebApp(comp) : page.getDesktop().getWebApp();
            return app != null ? app.getAttributes() : Collections.EMPTY_MAP;
        }
        if ("executionScope".equals(name)) {
            Execution exec = Executions.getCurrent();
            return exec != null ? exec.getAttributes() : Collections.EMPTY_MAP;
        }
        if ("requestScope".equals(name)) {
            return REQUEST_SCOPE_PROXY;
        }
        if ("execution".equals(name)) {
            return EXECUTION_PROXY;
        }
        if ("arg".equals(name)) {
            Execution exec = Executions.getCurrent();
            return exec != null ? exec.getArg() : null;
        }
        if ("param".equals(name)) {
            Execution exec = Executions.getCurrent();
            return exec != null ? exec.getParameterMap() : null;
        }
        return null;
    }

    public static Object getImplicit(Component comp, String name) {
        return Components.getImplicit(null, comp, name);
    }

    public static Object getImplicit(Page page, String name) {
        return Components.getImplicit(page, null, name);
    }

    public static Composer getComposer(Component comp) {
        if (comp != null) {
            Object onm = comp.getAttribute("composerName");
            if (onm instanceof String && ((String)onm).length() > 0) {
                return (Composer)comp.getAttribute((String)onm);
            }
            Composer result = (Composer)comp.getAttribute("_$composer$_");
            if (result == null) {
                result = (Composer)comp.getAttribute("$composer");
            }
            return result;
        }
        return null;
    }

    public static void smartUpdate(Component comp, String key, Object value, boolean append) {
        if (comp instanceof AbstractComponent) {
            ((AbstractComponent)comp).smartUpdate(key, value, append);
        }
    }

    private static Desktop getDesktop(Component comp) {
        Desktop dt = comp.getDesktop();
        if (dt != null) {
            return dt;
        }
        Execution exec = Executions.getCurrent();
        return exec != null ? exec.getDesktop() : null;
    }

    private static WebApp getWebApp(Component comp) {
        Desktop dt = Components.getDesktop(comp);
        return dt != null ? dt.getWebApp() : null;
    }

    private static Session getSession(Component comp) {
        Desktop dt = Components.getDesktop(comp);
        return dt != null ? dt.getSession() : null;
    }

    public static Page getCurrentPage(Component comp) {
        Page page;
        if (comp != null && (page = comp.getPage()) != null) {
            return page;
        }
        Execution exec = Executions.getCurrent();
        return exec != null ? ((ExecutionCtrl)((Object)exec)).getCurrentPage() : null;
    }

    static {
        String[] names = new String[]{"application", "applicationScope", "arg", "componentScope", "desktop", "desktopScope", "execution", "event", "self", "session", "sessionScope", "spaceOwner", "spaceScope", "page", "pageScope", "requestScope", "param"};
        for (int j = 0; j < names.length; ++j) {
            IMPLICIT_NAMES.add(names[j]);
        }
        EXECUTION_PROXY = new Exec();
        REQUEST_SCOPE_PROXY = new RequestScope();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestScope
    implements Map<String, Object> {
        private RequestScope() {
        }

        protected Map<String, Object> req() {
            return Executions.getCurrent().getAttributes();
        }

        @Override
        public void clear() {
            this.req().clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.req().containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.req().containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.req().entrySet();
        }

        @Override
        public Object get(Object key) {
            return this.req().get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.req().isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.req().keySet();
        }

        @Override
        public Object put(String key, Object value) {
            return this.req().put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> arg0) {
            this.req().putAll(arg0);
        }

        @Override
        public Object remove(Object key) {
            return this.req().remove(key);
        }

        @Override
        public int size() {
            return this.req().size();
        }

        @Override
        public Collection<Object> values() {
            return this.req().values();
        }

        public String toString() {
            return Objects.toString(this.req());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.req());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof RequestScope) {
                return Objects.equals(this.req(), ((RequestScope)o).req());
            }
            return Objects.equals(this.req(), (Object)o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Exec
    implements Execution {
        private Exec() {
        }

        private static final Execution exec() {
            return Executions.getCurrent();
        }

        @Override
        public void addAuResponse(AuResponse response) {
            Exec.exec().addAuResponse(response);
        }

        @Override
        public void addAuResponse(String key, AuResponse response) {
            Exec.exec().addAuResponse(key, response);
        }

        @Override
        public Component createComponents(PageDefinition pagedef, Component parent, Map<?, ?> arg) {
            return Exec.exec().createComponents(pagedef, parent, arg);
        }

        @Override
        public Component createComponents(String uri, Component parent, Map<?, ?> arg) {
            return Exec.exec().createComponents(uri, parent, arg);
        }

        @Override
        public Component createComponents(PageDefinition pagedef, Component parent, Component insertBefore, VariableResolver resolver) {
            return Exec.exec().createComponents(pagedef, parent, insertBefore, resolver);
        }

        @Override
        public Component createComponents(String uri, Component parent, Component insertBefore, VariableResolver resolver) {
            return Exec.exec().createComponents(uri, parent, insertBefore, resolver);
        }

        @Override
        public Component[] createComponents(PageDefinition pagedef, Map<?, ?> arg) {
            return Exec.exec().createComponents(pagedef, arg);
        }

        @Override
        public Component[] createComponents(String uri, Map<?, ?> arg) {
            return Exec.exec().createComponents(uri, arg);
        }

        @Override
        public Component[] createComponents(String uri, Page page, VariableResolver resolver, Map<?, ?> arg) {
            return Exec.exec().createComponents(uri, page, resolver, arg);
        }

        @Override
        public Component[] createComponents(String uri, Component parent, Component insertBefore, VariableResolver resolver, Map<?, ?> arg) {
            return Exec.exec().createComponents(uri, parent, insertBefore, resolver, arg);
        }

        @Override
        public Component createComponentsDirectly(String content, String extension, Component parent, Map<?, ?> arg) {
            return Exec.exec().createComponentsDirectly(content, extension, parent, arg);
        }

        @Override
        public Component createComponentsDirectly(Document content, String extension, Component parent, Map<?, ?> arg) {
            return Exec.exec().createComponentsDirectly(content, extension, parent, arg);
        }

        @Override
        public Component createComponentsDirectly(Reader reader, String extension, Component parent, Map<?, ?> arg) throws IOException {
            return Exec.exec().createComponentsDirectly(reader, extension, parent, arg);
        }

        @Override
        public Component createComponentsDirectly(String content, String extension, Component parent, Component insertBefore, VariableResolver resolver) {
            return Exec.exec().createComponentsDirectly(content, extension, parent, insertBefore, resolver);
        }

        @Override
        public Component createComponentsDirectly(Document content, String extension, Component parent, Component insertBefore, VariableResolver resolver) {
            return Exec.exec().createComponentsDirectly(content, extension, parent, insertBefore, resolver);
        }

        @Override
        public Component createComponentsDirectly(Reader reader, String extension, Component parent, Component insertBefore, VariableResolver resolver) throws IOException {
            return Exec.exec().createComponentsDirectly(reader, extension, parent, insertBefore, resolver);
        }

        @Override
        public Component[] createComponentsDirectly(String content, String extension, Map<?, ?> arg) {
            return Exec.exec().createComponentsDirectly(content, extension, arg);
        }

        @Override
        public Component[] createComponentsDirectly(Document content, String extension, Map<?, ?> arg) {
            return Exec.exec().createComponentsDirectly(content, extension, arg);
        }

        @Override
        public Component[] createComponentsDirectly(Reader reader, String extension, Map<?, ?> arg) throws IOException {
            return Exec.exec().createComponentsDirectly(reader, extension, arg);
        }

        @Override
        public String encodeURL(String uri) {
            return Exec.exec().encodeURL(uri);
        }

        public Object evaluate(Component comp, String expr, Class expectedType) {
            return Exec.exec().evaluate(comp, expr, expectedType);
        }

        public Object evaluate(Page page, String expr, Class expectedType) {
            return Exec.exec().evaluate(page, expr, expectedType);
        }

        @Override
        public void forward(Writer writer, String page, Map<String, ?> params, int mode) throws IOException {
            Exec.exec().forward(writer, page, params, mode);
        }

        @Override
        public void forward(String page) throws IOException {
            Exec.exec().forward(page);
        }

        @Override
        public Map<?, ?> getArg() {
            return Exec.exec().getArg();
        }

        @Override
        public Object getAttribute(String name) {
            return Exec.exec().getAttribute(name);
        }

        @Override
        public Object getAttribute(String name, boolean recurse) {
            return Exec.exec().getAttribute(name, recurse);
        }

        @Override
        public boolean hasAttribute(String name) {
            return Exec.exec().hasAttribute(name);
        }

        @Override
        public boolean hasAttribute(String name, boolean recurse) {
            return Exec.exec().hasAttribute(name, recurse);
        }

        @Override
        public Object setAttribute(String name, Object value, boolean recurse) {
            return Exec.exec().setAttribute(name, value, recurse);
        }

        @Override
        public Object setAttribute(String name, Object value) {
            return Exec.exec().setAttribute(name, value);
        }

        @Override
        public Object removeAttribute(String name, boolean recurse) {
            return Exec.exec().removeAttribute(name, recurse);
        }

        @Override
        public Object removeAttribute(String name) {
            return Exec.exec().removeAttribute(name);
        }

        @Override
        public boolean addScopeListener(ScopeListener listener) {
            return Exec.exec().addScopeListener(listener);
        }

        @Override
        public boolean removeScopeListener(ScopeListener listener) {
            return Exec.exec().removeScopeListener(listener);
        }

        @Override
        public Map<String, Object> getAttributes() {
            return Exec.exec().getAttributes();
        }

        @Override
        public String getContextPath() {
            return Exec.exec().getContextPath();
        }

        @Override
        public Desktop getDesktop() {
            return Exec.exec().getDesktop();
        }

        @Override
        public Evaluator getEvaluator(Page page, Class<? extends ExpressionFactory> expfcls) {
            return Exec.exec().getEvaluator(page, expfcls);
        }

        @Override
        public Evaluator getEvaluator(Component comp, Class<? extends ExpressionFactory> expfcls) {
            return Exec.exec().getEvaluator(comp, expfcls);
        }

        @Override
        public String getLocalAddr() {
            return Exec.exec().getLocalAddr();
        }

        @Override
        public String getLocalName() {
            return Exec.exec().getLocalName();
        }

        @Override
        public int getLocalPort() {
            return Exec.exec().getLocalPort();
        }

        @Override
        public Object getNativeRequest() {
            return Exec.exec().getNativeRequest();
        }

        @Override
        public Object getNativeResponse() {
            return Exec.exec().getNativeResponse();
        }

        @Override
        public PageDefinition getPageDefinition(String uri) {
            return Exec.exec().getPageDefinition(uri);
        }

        @Override
        public PageDefinition getPageDefinitionDirectly(String content, String extension) {
            return Exec.exec().getPageDefinitionDirectly(content, extension);
        }

        @Override
        public PageDefinition getPageDefinitionDirectly(Document content, String extension) {
            return Exec.exec().getPageDefinitionDirectly(content, extension);
        }

        @Override
        public PageDefinition getPageDefinitionDirectly(Reader reader, String extension) throws IOException {
            return Exec.exec().getPageDefinitionDirectly(reader, extension);
        }

        @Override
        public String getParameter(String name) {
            return Exec.exec().getParameter(name);
        }

        @Override
        public Map<String, String[]> getParameterMap() {
            return Exec.exec().getParameterMap();
        }

        @Override
        public String[] getParameterValues(String name) {
            return Exec.exec().getParameterValues(name);
        }

        @Override
        public String getRemoteAddr() {
            return Exec.exec().getRemoteAddr();
        }

        @Override
        public String getRemoteHost() {
            return Exec.exec().getRemoteHost();
        }

        @Override
        public String getRemoteUser() {
            return Exec.exec().getRemoteUser();
        }

        @Override
        public String getServerName() {
            return Exec.exec().getServerName();
        }

        @Override
        public int getServerPort() {
            return Exec.exec().getServerPort();
        }

        @Override
        public String getScheme() {
            return Exec.exec().getScheme();
        }

        @Override
        public String getUserAgent() {
            return Exec.exec().getUserAgent();
        }

        @Override
        public Principal getUserPrincipal() {
            return Exec.exec().getUserPrincipal();
        }

        @Override
        public VariableResolver getVariableResolver() {
            return Exec.exec().getVariableResolver();
        }

        @Override
        public void include(Writer writer, String page, Map<String, ?> params, int mode) throws IOException {
            Exec.exec().include(writer, page, params, mode);
        }

        @Override
        public void include(String page) throws IOException {
            Exec.exec().include(page);
        }

        @Override
        public boolean isAsyncUpdate(Page page) {
            return Exec.exec().isAsyncUpdate(page);
        }

        @Override
        public Double getBrowser(String name) {
            return Exec.exec().getBrowser(name);
        }

        @Override
        public String getBrowser() {
            return Exec.exec().getBrowser();
        }

        @Override
        public boolean isBrowser() {
            return Exec.exec().isBrowser();
        }

        @Override
        public boolean isBrowser(String type) {
            return Exec.exec().isBrowser(type);
        }

        @Override
        public boolean isExplorer() {
            return Exec.exec().isExplorer();
        }

        @Override
        public boolean isExplorer7() {
            return Exec.exec().isExplorer7();
        }

        @Override
        public boolean isOpera() {
            return Exec.exec().isOpera();
        }

        @Override
        public boolean isGecko() {
            return Exec.exec().isGecko();
        }

        @Override
        public boolean isGecko3() {
            return Exec.exec().isGecko3();
        }

        @Override
        public boolean isHilDevice() {
            return Exec.exec().isHilDevice();
        }

        @Override
        public boolean isSafari() {
            return Exec.exec().isSafari();
        }

        @Override
        public boolean isRobot() {
            return Exec.exec().isRobot();
        }

        @Override
        public boolean isForwarded() {
            return Exec.exec().isForwarded();
        }

        @Override
        public boolean isIncluded() {
            return Exec.exec().isIncluded();
        }

        @Override
        public boolean isUserInRole(String role) {
            return Exec.exec().isUserInRole(role);
        }

        @Override
        public boolean isVoided() {
            return Exec.exec().isVoided();
        }

        @Override
        public void popArg() {
            Exec.exec().popArg();
        }

        @Override
        public void postEvent(Event evt) {
            Exec.exec().postEvent(evt);
        }

        @Override
        public void postEvent(int priority, Event evt) {
            Exec.exec().postEvent(priority, evt);
        }

        @Override
        public void postEvent(int priority, Component realTarget, Event evt) {
            Exec.exec().postEvent(priority, realTarget, evt);
        }

        @Override
        public void pushArg(Map<?, ?> arg) {
            Exec.exec().pushArg(arg);
        }

        @Override
        public void sendRedirect(String uri) {
            Exec.exec().sendRedirect(uri);
        }

        @Override
        public void sendRedirect(String uri, String target) {
            Exec.exec().sendRedirect(uri, target);
        }

        @Override
        public void sendRedirect(String uri, boolean respRedirect) {
            Exec.exec().sendRedirect(uri, respRedirect);
        }

        @Override
        public void setVoided(boolean voided) {
            Exec.exec().setVoided(voided);
        }

        @Override
        public String toAbsoluteURI(String uri, boolean skipInclude) {
            return Exec.exec().toAbsoluteURI(uri, skipInclude);
        }

        @Override
        public void addResponseHeader(String name, String value) {
            Exec.exec().addResponseHeader(name, value);
        }

        @Override
        public void addResponseHeader(String name, Date value) {
            Exec.exec().addResponseHeader(name, value);
        }

        @Override
        public boolean containsResponseHeader(String name) {
            return Exec.exec().containsResponseHeader(name);
        }

        @Override
        public String getHeader(String name) {
            return Exec.exec().getHeader(name);
        }

        @Override
        public Iterable<String> getHeaderNames() {
            return Exec.exec().getHeaderNames();
        }

        @Override
        public Iterable<String> getHeaders(String name) {
            return Exec.exec().getHeaders(name);
        }

        @Override
        public void setResponseHeader(String name, String value) {
            Exec.exec().setResponseHeader(name, value);
        }

        @Override
        public void setResponseHeader(String name, Date value) {
            Exec.exec().setResponseHeader(name, value);
        }

        @Override
        public Session getSession() {
            return Exec.exec().getSession();
        }

        @Override
        public String locate(String path) {
            return Exec.exec().locate(path);
        }

        @Override
        public boolean addVariableResolver(VariableResolver resolver) {
            return Exec.exec().addVariableResolver(resolver);
        }

        @Override
        public boolean removeVariableResolver(VariableResolver resolver) {
            return Exec.exec().removeVariableResolver(resolver);
        }

        @Override
        public boolean hasVariableResolver(VariableResolver resolver) {
            return Exec.exec().hasVariableResolver(resolver);
        }

        @Override
        public boolean hasVariableResolver(Class<? extends VariableResolver> cls) {
            return Exec.exec().hasVariableResolver(cls);
        }

        public String toString() {
            return Objects.toString((Object)Exec.exec());
        }

        public int hashCode() {
            return Objects.hashCode((Object)Exec.exec());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Exec) {
                Exec cfr_ignored_0 = (Exec)o;
                return Objects.equals((Object)Exec.exec(), (Object)Exec.exec());
            }
            return Objects.equals((Object)Exec.exec(), (Object)o);
        }

        @Override
        public void log(String msg) {
            Exec.exec().log(msg);
        }

        @Override
        public void log(String msg, Throwable ex) {
            Exec.exec().log(msg, ex);
        }
    }
}

