/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.proxy;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.annotation.ImmutableElements;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.ProxyHelper;
import org.zkoss.bind.proxy.ProxyNode;
import org.zkoss.bind.proxy.ProxyNodeImpl;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.lang.Objects;
import org.zkoss.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionProxy<E>
implements Collection<E>,
Proxy,
FormProxyObject,
Serializable {
    private Collection<E> _cache;
    private static final long serialVersionUID = 20141225142801L;
    private Object _origin;
    protected boolean _dirty;
    protected boolean isImmutableElements;
    private ProxyNode _node;

    public AbstractCollectionProxy(Collection<E> origin, Annotation[] callerAnnots) {
        this._origin = origin;
        this._cache = this.initCache();
        if (callerAnnots != null) {
            for (Annotation annot : callerAnnots) {
                if (!annot.annotationType().isAssignableFrom(ImmutableElements.class)) continue;
                this.isImmutableElements = true;
                break;
            }
        }
    }

    protected abstract Collection<E> initCache();

    protected <T extends Collection<E>> T getCache() {
        return (T)this._cache;
    }

    @Override
    public Object getOriginObject() {
        return this._origin;
    }

    protected Object replaceOrigin(Object origin) {
        Object old = this._origin;
        this._origin = origin;
        return old;
    }

    public void onDirtyChange() {
        ProxyHelper.callOnDirtyChange(this._node);
    }

    public void onDataChange(Object o) {
        ProxyHelper.callOnDataChange(this._node, new Object[]{o, "."});
    }

    protected void setDirty(boolean d) {
        if (this._dirty != d) {
            this._dirty = d;
            this.onDirtyChange();
        }
        if (d) {
            this.onDataChange(this);
        }
    }

    public void setHandler(MethodHandler mi) {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public int size() {
        return this._cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this._cache.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        Iterator<E> e = this.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (!AbstractCollectionProxy.testEquals(e.next(), null)) continue;
                return true;
            }
        } else {
            while (e.hasNext()) {
                if (!AbstractCollectionProxy.testEquals(o, e.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.setDirty(true);
        this._cache.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this._cache.iterator();
    }

    @Override
    public Object[] toArray() {
        return this._cache.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._cache.toArray(a);
    }

    @Override
    public boolean add(E e) {
        if (this._cache.add(this.createProxyObject(e))) {
            this.setDirty(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this._cache.remove(this.createProxyObject(o))) {
            this.setDirty(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        Iterator<E> e = c.iterator();
        while (e.hasNext()) {
            if (!this.add(e.next())) continue;
            modified = true;
        }
        if (modified) {
            this.setDirty(true);
        }
        return modified;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> e = this.iterator();
        c = this.createProxyObject(c);
        while (e.hasNext()) {
            if (!c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        if (modified) {
            this.setDirty(true);
        }
        return modified;
    }

    @Override
    public boolean isFormDirty() {
        if (this._dirty) {
            return true;
        }
        for (E o : this) {
            if (!(o instanceof FormProxyObject) || !((FormProxyObject)o).isFormDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> e = this.iterator();
        c = this.createProxyObject(c);
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        if (modified) {
            this.setDirty(true);
        }
        return modified;
    }

    @Override
    public void resetFromOrigin() {
        this.getCache().clear();
        this.setDirty(false);
        for (Object e : (Collection)this.getOriginObject()) {
            this.getCache().add(this.createProxyObject(e));
        }
    }

    @Override
    public void submitToOrigin(BindContext ctx) {
        Collection origin = (Collection)this.getOriginObject();
        origin.clear();
        for (Object e : this.getCache()) {
            if (e instanceof FormProxyObject) {
                FormProxyObject proxy = (FormProxyObject)e;
                proxy.submitToOrigin(ctx);
                origin.add(proxy.getOriginObject());
                continue;
            }
            origin.add(e);
        }
    }

    protected static boolean testEquals(Object e, Object o) {
        if (e == o) {
            return true;
        }
        if (e instanceof FormProxyObject) {
            Object eo = ((FormProxyObject)e).getOriginObject();
            Object oo = o;
            if (o instanceof FormProxyObject) {
                oo = ((FormProxyObject)o).getOriginObject();
            }
            if (Objects.equals((Object)eo, (Object)oo)) {
                return true;
            }
        } else if (o instanceof FormProxyObject ? Objects.equals((Object)e, (Object)((FormProxyObject)o).getOriginObject()) : Objects.equals((Object)e, (Object)o)) {
            return true;
        }
        return false;
    }

    @Override
    public void setFormOwner(Object owner, FormBinding binding) {
        throw new IllegalAccessError("Not supported");
    }

    private <T> T createProxyObject(T t) {
        T p;
        T t2 = p = this.isImmutableElements ? t : ProxyHelper.createProxyIfAny(t);
        if (p instanceof FormProxyObject) {
            ((FormProxyObject)p).setPath("[$INDEX$]", this._node);
        }
        return p;
    }

    @Override
    public void cacheSavePropertyBinding(String property, SavePropertyBinding s) {
        ProxyHelper.cacheSavePropertyBinding(this._node, this._node.getProperty() + property, s);
    }

    @Override
    public Set<Pair<String, SavePropertyBinding>> collectCachedSavePropertyBinding() {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public void setPath(String property, ProxyNode parent) {
        if (property == null && this._node != null) {
            this._node.setParent(parent);
        } else {
            this._node = new ProxyNodeImpl(property, parent);
            for (E e : this._cache) {
                if (!(e instanceof FormProxyObject)) continue;
                ((FormProxyObject)e).setPath("[$INDEX$]", this._node);
            }
        }
    }
}

