/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chrome;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.util.ConcurrentMapping;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceIdentityMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceManager {
    private static final Log log = LogFactory.getLog(ResourceManager.class);
    public static final String PROPERTY_TEMPDIR_PATH = "net.sf.jasperreports.chrome.tempdir.path";
    private static final String TEMP_FILE_PREFIX = "jr_res_";
    private static final int COPY_BUFFER_SIZE = 16384;
    private static final ResourceManager INSTANCE = new ResourceManager();
    private final Map<JasperReportsContext, ContextMappings> contextMappings = new ReferenceIdentityMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);

    public static ResourceManager instance() {
        return INSTANCE;
    }

    public File getTempFolder(JasperReportsContext jasperReportsContext) {
        ContextMappings mappings = this.contextMappings(jasperReportsContext);
        return mappings.tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContextMappings contextMappings(JasperReportsContext jasperReportsContext) {
        ContextMappings mappings;
        Map<JasperReportsContext, ContextMappings> map = this.contextMappings;
        synchronized (map) {
            mappings = this.contextMappings.get(jasperReportsContext);
            if (mappings == null) {
                mappings = new ContextMappings(jasperReportsContext);
                this.contextMappings.put(jasperReportsContext, mappings);
            }
        }
        return mappings;
    }

    public String getResourceLocation(String resourceLocation, JasperReportsContext jasperReportsContext) {
        File resourceMapping = this.resourceMapping(resourceLocation, jasperReportsContext);
        if (resourceMapping == null) {
            throw new JRRuntimeException("repo.input.stream.not.found", new Object[]{resourceLocation});
        }
        return resourceMapping.toURI().toString();
    }

    public String copyDataResource(String resourceName, JasperReportsContext jasperReportsContext, InputStream data) {
        ContextMappings mappings = this.contextMappings(jasperReportsContext);
        File resourceFile = mappings.dataResourceMapping(resourceName, data, jasperReportsContext);
        return resourceFile.toURI().toString();
    }

    public String getDataResourceLocation(String resourceName, JasperReportsContext jasperReportsContext) {
        ContextMappings mappings = this.contextMappings(jasperReportsContext);
        File resourceFile = mappings.dataResourceMapping(resourceName, jasperReportsContext);
        if (resourceFile == null) {
            throw new JRRuntimeException("repo.input.stream.not.found", new Object[]{resourceName});
        }
        return resourceFile.toURI().toString();
    }

    protected File resourceMapping(String resourceLocation, JasperReportsContext jasperReportsContext) {
        File parentMapping;
        JasperReportsContext parentContext;
        if (jasperReportsContext instanceof SimpleJasperReportsContext && (parentContext = ((SimpleJasperReportsContext)jasperReportsContext).getParent()) != null && (parentMapping = this.resourceMapping(resourceLocation, parentContext)) != null) {
            return parentMapping;
        }
        ContextMappings mappings = this.contextMappings(jasperReportsContext);
        File resourceFile = mappings.resourceMapping(resourceLocation, jasperReportsContext);
        return resourceFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File copyResource(String resourceLocation, JasperReportsContext jasperReportsContext, File tempFolder) {
        try (InputStream input = RepositoryUtil.getInstance(jasperReportsContext).getInputStreamFromLocation(resourceLocation);){
            File file2 = this.createTempFile(resourceLocation, tempFolder);
            this.copyToFile(resourceLocation, input, file2);
            File file = file2;
            return file;
        }
        catch (JRException e) {
            if (!"repo.input.stream.not.found".equals(e.getMessageKey())) throw new JRRuntimeException(e);
            return null;
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected File createTempFile(String resourceLocation, File tempFolder) {
        try {
            String resourceName = this.getResourceName(resourceLocation);
            File file = File.createTempFile(TEMP_FILE_PREFIX, "_" + resourceName, tempFolder);
            file.deleteOnExit();
            return file;
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void copyToFile(String resourceLocation, InputStream data, File file) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("copying " + resourceLocation + " to " + file));
            }
            byte[] buf = new byte[16384];
            try (FileOutputStream output = new FileOutputStream(file);){
                int read = 0;
                while ((read = data.read(buf)) > 0) {
                    ((OutputStream)output).write(buf, 0, read);
                }
            }
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected String getResourceName(String resourceLocation) {
        int separatorIndex;
        int slashIndex = resourceLocation.lastIndexOf(47);
        int nameIndex = Math.max(slashIndex, separatorIndex = resourceLocation.lastIndexOf(File.separator));
        return nameIndex >= 0 ? resourceLocation.substring(nameIndex + 1) : resourceLocation;
    }

    protected class ContextMappings {
        private final ConcurrentMapping<String, File> resourceFiles;
        private final ConcurrentMapping<String, File> dataResourceFiles;
        protected final File tempFolder;

        public ContextMappings(JasperReportsContext jasperReportsContext) {
            String tempPath = JRPropertiesUtil.getInstance(jasperReportsContext).getProperty(ResourceManager.PROPERTY_TEMPDIR_PATH);
            if (tempPath == null) {
                tempPath = System.getProperty("java.io.tmpdir");
            }
            this.tempFolder = new File(tempPath);
            if (this.tempFolder.exists() && this.tempFolder.isDirectory()) {
                log.info((Object)("Resources temp folder is " + tempPath));
            } else {
                log.error((Object)("The resources temp folder " + tempPath + " does not exist."));
            }
            this.resourceFiles = new ConcurrentMapping<String, File>((key, context) -> ResourceManager.this.copyResource((String)key, context, this.tempFolder));
            this.dataResourceFiles = new ConcurrentMapping<String, File>((resourceName, context) -> ResourceManager.this.createTempFile((String)resourceName, this.tempFolder));
        }

        public File resourceMapping(String resourceLocation, JasperReportsContext jasperReportsContext) {
            return this.resourceFiles.get(resourceLocation, jasperReportsContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public File dataResourceMapping(String resourceName, InputStream data, JasperReportsContext jasperReportsContext) {
            File resourceFile;
            File file = resourceFile = this.dataResourceFiles.get(resourceName, jasperReportsContext);
            synchronized (file) {
                if (resourceFile.length() == 0L) {
                    ResourceManager.this.copyToFile(resourceName, data, resourceFile);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("file " + resourceFile + " already written for " + resourceName));
                }
            }
            return resourceFile;
        }

        public File dataResourceMapping(String resourceName, JasperReportsContext jasperReportsContext) {
            return this.dataResourceFiles.get(resourceName, jasperReportsContext);
        }

        protected void finalize() {
            boolean deleted;
            File file;
            Iterator<File> fileIt = this.resourceFiles.currentValues();
            while (fileIt.hasNext()) {
                file = fileIt.next();
                deleted = file.delete();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("deleted " + file + ": " + deleted));
            }
            this.resourceFiles.clear();
            fileIt = this.dataResourceFiles.currentValues();
            while (fileIt.hasNext()) {
                file = fileIt.next();
                deleted = file.delete();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("deleted " + file + ": " + deleted));
            }
            this.dataResourceFiles.clear();
        }
    }
}

