/*
 Copyright 2013 Andy Earnshaw, MIT License

 Implements the ECMAScript Internationalization API in ES5-compatible environments,
 following the ECMA-402 specification as closely as possible

 ECMA-402: http://ecma-international.org/ecma-402/1.0/

 CLDR format locale data should be provided using IntlPolyfill.__addLocaleData().
*/
var $jscomp=$jscomp||{};$jscomp.scope={};$jscomp.ASSUME_ES5=!1;$jscomp.ASSUME_NO_NATIVE_MAP=!1;$jscomp.ASSUME_NO_NATIVE_SET=!1;$jscomp.defineProperty=$jscomp.ASSUME_ES5||"function"==typeof Object.defineProperties?Object.defineProperty:function(f,k,p){f!=Array.prototype&&f!=Object.prototype&&(f[k]=p.value)};$jscomp.getGlobal=function(f){return"undefined"!=typeof window&&window===f?f:"undefined"!=typeof global&&null!=global?global:f};$jscomp.global=$jscomp.getGlobal(this);$jscomp.SYMBOL_PREFIX="jscomp_symbol_";
$jscomp.initSymbol=function(){$jscomp.initSymbol=function(){};$jscomp.global.Symbol||($jscomp.global.Symbol=$jscomp.Symbol)};$jscomp.symbolCounter_=0;$jscomp.Symbol=function(f){return $jscomp.SYMBOL_PREFIX+(f||"")+$jscomp.symbolCounter_++};
$jscomp.initSymbolIterator=function(){$jscomp.initSymbol();var f=$jscomp.global.Symbol.iterator;f||(f=$jscomp.global.Symbol.iterator=$jscomp.global.Symbol("iterator"));"function"!=typeof Array.prototype[f]&&$jscomp.defineProperty(Array.prototype,f,{configurable:!0,writable:!0,value:function(){return $jscomp.arrayIterator(this)}});$jscomp.initSymbolIterator=function(){}};$jscomp.arrayIterator=function(f){var k=0;return $jscomp.iteratorPrototype(function(){return k<f.length?{done:!1,value:f[k++]}:{done:!0}})};
$jscomp.iteratorPrototype=function(f){$jscomp.initSymbolIterator();f={next:f};f[$jscomp.global.Symbol.iterator]=function(){return this};return f};$jscomp.makeIterator=function(f){$jscomp.initSymbolIterator();var k=f[Symbol.iterator];return k?k.call(f):$jscomp.arrayIterator(f)};
$jscomp.polyfill=function(f,k,p,r){if(k){p=$jscomp.global;f=f.split(".");for(r=0;r<f.length-1;r++){var m=f[r];m in p||(p[m]={});p=p[m]}f=f[f.length-1];r=p[f];k=k(r);k!=r&&null!=k&&$jscomp.defineProperty(p,f,{configurable:!0,writable:!0,value:k})}};$jscomp.FORCE_POLYFILL_PROMISE=!1;
$jscomp.polyfill("Promise",function(f){function k(){this.batch_=null}function p(f){return f instanceof m?f:new m(function(k,z){k(f)})}if(f&&!$jscomp.FORCE_POLYFILL_PROMISE)return f;k.prototype.asyncExecute=function(f){null==this.batch_&&(this.batch_=[],this.asyncExecuteBatch_());this.batch_.push(f);return this};k.prototype.asyncExecuteBatch_=function(){var f=this;this.asyncExecuteFunction(function(){f.executeBatch_()})};var r=$jscomp.global.setTimeout;k.prototype.asyncExecuteFunction=function(f){r(f,
0)};k.prototype.executeBatch_=function(){for(;this.batch_&&this.batch_.length;){var f=this.batch_;this.batch_=[];for(var k=0;k<f.length;++k){var m=f[k];delete f[k];try{m()}catch(N){this.asyncThrow_(N)}}}this.batch_=null};k.prototype.asyncThrow_=function(f){this.asyncExecuteFunction(function(){throw f;})};var m=function(f){this.state_=0;this.result_=void 0;this.onSettledCallbacks_=[];var k=this.createResolveAndReject_();try{f(k.resolve,k.reject)}catch(M){k.reject(M)}};m.prototype.createResolveAndReject_=
function(){function f(f){return function(z){m||(m=!0,f.call(k,z))}}var k=this,m=!1;return{resolve:f(this.resolveTo_),reject:f(this.reject_)}};m.prototype.resolveTo_=function(f){if(f===this)this.reject_(new TypeError("A Promise cannot resolve to itself"));else if(f instanceof m)this.settleSameAsPromise_(f);else{a:switch(typeof f){case "object":var k=null!=f;break a;case "function":k=!0;break a;default:k=!1}k?this.resolveToNonPromiseObj_(f):this.fulfill_(f)}};m.prototype.resolveToNonPromiseObj_=function(f){var k=
void 0;try{k=f.then}catch(M){this.reject_(M);return}"function"==typeof k?this.settleSameAsThenable_(k,f):this.fulfill_(f)};m.prototype.reject_=function(f){this.settle_(2,f)};m.prototype.fulfill_=function(f){this.settle_(1,f)};m.prototype.settle_=function(f,k){if(0!=this.state_)throw Error("Cannot settle("+f+", "+k|"): Promise already settled in state"+this.state_);this.state_=f;this.result_=k;this.executeOnSettledCallbacks_()};m.prototype.executeOnSettledCallbacks_=function(){if(null!=this.onSettledCallbacks_){for(var f=
this.onSettledCallbacks_,k=0;k<f.length;++k)f[k].call(),f[k]=null;this.onSettledCallbacks_=null}};var q=new k;m.prototype.settleSameAsPromise_=function(f){var k=this.createResolveAndReject_();f.callWhenSettled_(k.resolve,k.reject)};m.prototype.settleSameAsThenable_=function(f,k){var m=this.createResolveAndReject_();try{f.call(k,m.resolve,m.reject)}catch(N){m.reject(N)}};m.prototype.then=function(f,k){function p(f,k){return"function"==typeof f?function(k){try{r(f(k))}catch(K){q(K)}}:k}var r,q,z=new m(function(f,
k){r=f;q=k});this.callWhenSettled_(p(f,r),p(k,q));return z};m.prototype.catch=function(f){return this.then(void 0,f)};m.prototype.callWhenSettled_=function(f,k){function m(){switch(p.state_){case 1:f(p.result_);break;case 2:k(p.result_);break;default:throw Error("Unexpected state: "+p.state_);}}var p=this;null==this.onSettledCallbacks_?q.asyncExecute(m):this.onSettledCallbacks_.push(function(){q.asyncExecute(m)})};m.resolve=p;m.reject=function(f){return new m(function(k,m){m(f)})};m.race=function(f){return new m(function(k,
m){for(var r=$jscomp.makeIterator(f),q=r.next();!q.done;q=r.next())p(q.value).callWhenSettled_(k,m)})};m.all=function(f){var k=$jscomp.makeIterator(f),r=k.next();return r.done?p([]):new m(function(f,m){function q(k){return function(m){z[k]=m;C--;0==C&&f(z)}}var z=[],C=0;do z.push(void 0),C++,p(r.value).callWhenSettled_(q(z.length-1),m),r=k.next();while(!r.done)})};return m},"es6","es3");$jscomp.owns=function(f,k){return Object.prototype.hasOwnProperty.call(f,k)};
$jscomp.polyfill("Object.assign",function(f){return f?f:function(f,p){for(var k=1;k<arguments.length;k++){var m=arguments[k];if(m)for(var q in m)$jscomp.owns(m,q)&&(f[q]=m[q])}return f}},"es6","es3");
$jscomp.polyfill("Array.from",function(f){return f?f:function(f,p,r){$jscomp.initSymbolIterator();p=null!=p?p:function(f){return f};var k=[],q=f[Symbol.iterator];if("function"==typeof q)for(f=q.call(f);!(q=f.next()).done;)k.push(p.call(r,q.value));else{q=f.length;for(var z=0;z<q;z++)k.push(p.call(r,f[z]))}return k}},"es6","es3");
$jscomp.checkStringArgs=function(f,k,p){if(null==f)throw new TypeError("The 'this' value for String.prototype."+p+" must not be null or undefined");if(k instanceof RegExp)throw new TypeError("First argument to String.prototype."+p+" must not be a regular expression");return f+""};
$jscomp.polyfill("String.prototype.codePointAt",function(f){return f?f:function(f){var k=$jscomp.checkStringArgs(this,null,"codePointAt"),r=k.length;f=Number(f)||0;if(0<=f&&f<r){f|=0;var m=k.charCodeAt(f);if(55296>m||56319<m||f+1===r)return m;f=k.charCodeAt(f+1);return 56320>f||57343<f?m:1024*(m-55296)+f+9216}}},"es6","es3");$jscomp.polyfill("Number.isFinite",function(f){return f?f:function(f){return"number"!==typeof f?!1:!isNaN(f)&&Infinity!==f&&-Infinity!==f}},"es6","es3");
$jscomp.iteratorFromArray=function(f,k){$jscomp.initSymbolIterator();f instanceof String&&(f+="");var p=0,r={next:function(){if(p<f.length){var m=p++;return{value:k(m,f[m]),done:!1}}r.next=function(){return{done:!0,value:void 0}};return r.next()}};r[Symbol.iterator]=function(){return r};return r};$jscomp.polyfill("Array.prototype.keys",function(f){return f?f:function(){return $jscomp.iteratorFromArray(this,function(f){return f})}},"es6","es3");
(function(f,k){"object"===typeof exports&&"undefined"!==typeof module?module.exports=k():"function"===typeof define&&define.amd?define(k):f.IntlPolyfill=k()})(this,function(){function f(e){for(var g in e)(e instanceof f||v.call(e,g))&&w(this,g,{value:e[g],enumerable:!0,writable:!0,configurable:!0})}function k(){w(this,"length",{writable:!0,value:0});arguments.length&&x.apply(this,O.call(arguments))}function p(){if(y.disableRegExpRestore)return function(){};for(var e={lastMatch:RegExp.lastMatch||"",
leftContext:RegExp.leftContext,multiline:RegExp.multiline,input:RegExp.input},g=!1,a=1;9>=a;a++)g=(e["$"+a]=RegExp["$"+a])||g;return function(){var a=/[.?*+^$[\]\\(){}|-]/g,b=e.lastMatch.replace(a,"\\$&"),d="";if(g)for(var n=1;9>=n;n++){var l=e["$"+n];l?(l=l.replace(a,"\\$&"),d+=b.substring(0,b.indexOf(l))+"(",b=l+")"+b.substring(b.indexOf(l)+l.length)):(d+="(",b=")"+b)}d=(d+b).replace(/((^|[^\\])((\\\\)*\\[()])+|[^()])+/g,function(a){return"[\\s\\S]{"+a.replace(/\\(.)/g,"$1").length+"}"});a=new RegExp(d,
e.multiline?"gm":"g");a.lastIndex=e.leftContext.length;a.exec(e.input)}}function r(e){if(null===e)throw new TypeError("Cannot convert null or undefined to object");return"object"===("undefined"===typeof e?"undefined":D["typeof"](e))?e:Object(e)}function m(e){return"number"===typeof e?e:Number(e)}function q(e){return v.call(e,"__getInternalProperties")?e.__getInternalProperties(P):E(null)}function z(e){for(var g=e.length;g--;){var a=e.charAt(g);"a"<=a&&"z">=a&&(e=e.slice(0,g)+a.toUpperCase()+e.slice(g+
1))}return e}function da(e){return!xa.test(e)||ya.test(e)||za.test(e)?!1:!0}function M(e){var g=void 0;e=e.toLowerCase();e=e.split("-");for(var a=1,c=e.length;a<c;a++)if(2===e[a].length)e[a]=e[a].toUpperCase();else if(4===e[a].length)e[a]=e[a].charAt(0).toUpperCase()+e[a].slice(1);else if(1===e[a].length&&"x"!==e[a])break;e=F.call(e,"-");(g=e.match(ha))&&1<g.length&&(g.sort(),e=e.replace(RegExp("(?:"+ha.source+")+","i"),F.call(g,"")));v.call(L.tags,e)&&(e=L.tags[e]);e=e.split("-");g=1;for(a=e.length;g<
a;g++)v.call(L.subtags,e[g])?e[g]=L.subtags[e[g]]:v.call(L.extLang,e[g])&&(e[g]=L.extLang[e[g]][0],1===g&&L.extLang[e[1]][1]===e[0]&&(e=O.call(e,g++),--a));return F.call(e,"-")}function N(e){e=z(String(e));return!1===Aa.test(e)?!1:!0}function C(e){if(void 0===e)return new k;var g=new k;e="string"===typeof e?[e]:e;e=r(e);var a=m(e.length);a=isNaN(a)?0:0===a||-0===a||Infinity===a||-Infinity===a?a:0>a?-1*Math.floor(Math.abs(a)):Math.floor(Math.abs(a));a=0>=a?0:Infinity===a?Math.pow(2,53)-1:Math.min(a,
Math.pow(2,53)-1);for(var c=0;c<a;){var b=String(c);if(b in e){b=e[b];if(null===b||"string"!==typeof b&&"object"!==("undefined"===typeof b?"undefined":D["typeof"](b)))throw new TypeError("String or Object type expected");b=String(b);if(!da(b))throw new RangeError("'"+b+"' is not a structurally valid language tag");b=M(b);-1===J.call(g,b)&&x.call(g,b)}c++}return g}function ea(e,g){for(;g;){if(-1<J.call(e,g))return g;var a=g.lastIndexOf("-");if(0>a)break;2<=a&&"-"===g.charAt(a-2)&&(a-=2);g=g.substring(0,
a)}}function X(e,g,a,c,b){if(0===e.length)throw new ReferenceError("No locale data has been provided for this object yet.");for(var d=0,n=g.length,l=void 0,h=void 0,k=void 0;d<n&&!l;)h=g[d],k=String(h).replace(Z,""),l=ea(e,k),d++;e=new f;void 0!==l?(e["[[locale]]"]=l,String(h)!==String(k)&&(l=h.match(Z)[0],h=h.indexOf("-u-"),e["[[extension]]"]=l,e["[[extensionIndex]]"]=h)):e["[[locale]]"]=aa;h=e["[[locale]]"];g=k=void 0;if(v.call(e,"[[extension]]")){l=e["[[extension]]"];k=l.length;if(0===k)k=[];else{e=
[];n=!0;for(var u=d=g=3;g<k;)45===l.codePointAt(g)&&(2===g-d?(1<d-u&&(n=l.substring(u,d-1),e.push(n)),d=l.substring(d,g),e.push(d),u=g+1,n=!1):!0===n&&(d=l.substring(d,g),e.push(d),u=g+1),d=g+1),g+=1;2===k-d&&(1<d-u&&(g=l.substring(u,d-1),e.push(g)),u=d);l=l.substring(u,k);e.push(l);k=e}g=k.length}e=new f;e["[[dataLocale]]"]=h;l="-u";d=0;for(n=c.length;d<n;){u=c[d];var m=b[h][u],p=m["0"],r="",q=J;if(void 0!==k){var t=q.call(k,u);-1!==t&&(t+1<g&&2<k[t+1].length?(t=k[t+1],-1!==q.call(m,t)&&(p=t,r="-"+
u+"-"+p)):-1!==q(m,"true")&&(p="true"))}v.call(a,"[["+u+"]]")&&(t=a["[["+u+"]]"],-1!==q.call(m,t)&&t!==p&&(p=t,r=""));e["[["+u+"]]"]=p;l+=r;d++}2<l.length&&(c=h.indexOf("-x-"),-1===c?h+=l:(a=h.substring(0,c),c=h.substring(c),h=a+l+c),h=M(h));e["[[locale]]"]=h;return e}function Y(e,g,a){if(void 0!==a&&(a=new f(r(a)),a=a.localeMatcher,void 0!==a&&(a=String(a),"lookup"!==a&&"best fit"!==a)))throw new RangeError('matcher should be "lookup" or "best fit"');a=g.length;for(var c=new k,b=0;b<a;){var d=g[b],
n=String(d).replace(Z,"");void 0!==ea(e,n)&&x.call(c,d);b++}e=O.call(c);for(var l in e)v.call(e,l)&&w(e,l,{writable:!1,configurable:!1,value:e[l]});try{w(e,"length",{writable:!1})}catch(fa){}return e}function A(e,g,a,c,b){e=e[g];if(void 0!==e){e="boolean"===a?!!e:"string"===a?String(e):e;if(void 0!==c&&-1===J.call(c,e))throw new RangeError("'"+e+"' is not an allowed value for `"+g+"`");return e}return b}function K(e,g,a,c,b){e=e[g];if(void 0!==e){e=Number(e);if(isNaN(e)||e<a||e>c)throw new RangeError("Value is not a number or outside accepted range");
return Math.floor(e)}return b}function ia(e,g){return this&&this!==t?Ea(r(this),e,g):new t.NumberFormat(e,g)}function ja(e,g,a){var c=K(g,"minimumIntegerDigits",1,21,1);a=K(g,"minimumFractionDigits",0,20,a);var b=K(g,"maximumFractionDigits",a,20),d=g.minimumSignificantDigits,n=g.maximumSignificantDigits;e["[[minimumIntegerDigits]]"]=c;e["[[minimumFractionDigits]]"]=a;e["[[maximumFractionDigits]]"]=b;if(void 0!==d||void 0!==n)d=K(g,"minimumSignificantDigits",1,21,1),n=K(g,"maximumSignificantDigits",
d,21,21),e["[[minimumSignificantDigits]]"]=d,e["[[maximumSignificantDigits]]"]=n}function Ea(e,g,a){var c=q(e),b=p();if(!0===c["[[initializedIntlObject]]"])throw new TypeError("`this` object has already been initialized as an Intl object");w(e,"__getInternalProperties",{value:function(a){if(a===P)return c}});c["[[initializedIntlObject]]"]=!0;var d=C(g);a=void 0===a?{}:r(a);var n=new f;g=A(a,"localeMatcher","string",new k("lookup","best fit"),"best fit");n["[[localeMatcher]]"]=g;g=y.NumberFormat["[[localeData]]"];
d=X(y.NumberFormat["[[availableLocales]]"],d,n,y.NumberFormat["[[relevantExtensionKeys]]"],g);c["[[locale]]"]=d["[[locale]]"];c["[[numberingSystem]]"]=d["[[nu]]"];c["[[dataLocale]]"]=d["[[dataLocale]]"];d=d["[[dataLocale]]"];n=A(a,"style","string",new k("decimal","percent","currency"),"decimal");c["[[style]]"]=n;var l=A(a,"currency","string");if(void 0!==l&&!N(l))throw new RangeError("'"+l+"' is not a valid currency code");if("currency"===n&&void 0===l)throw new TypeError("Currency code is required when style is currency");
var h=void 0;"currency"===n&&(l=l.toUpperCase(),c["[[currency]]"]=l,h=void 0!==ka[l]?ka[l]:2);l=A(a,"currencyDisplay","string",new k("code","symbol","name"),"symbol");"currency"===n&&(c["[[currencyDisplay]]"]=l);ja(c,a,"currency"===n?h:0);void 0===c["[[maximumFractionDigits]]"]&&(c["[[maximumFractionDigits]]"]="currency"===n?Math.max(c["[[minimumFractionDigits]]"],h):"percent"===n?Math.max(c["[[minimumFractionDigits]]"],0):Math.max(c["[[minimumFractionDigits]]"],3));a=A(a,"useGrouping","boolean",
void 0,!0);c["[[useGrouping]]"]=a;a=g[d].patterns[n];c["[[positivePattern]]"]=a.positivePattern;c["[[negativePattern]]"]=a.negativePattern;c["[[boundFormat]]"]=void 0;c["[[initializedNumberFormat]]"]=!0;la&&(e.format=ma.call(e));b();return e}function ma(){var e=null!==this&&"object"===D["typeof"](this)&&q(this);if(!e||!e["[[initializedNumberFormat]]"])throw new TypeError("`this` value for format() is not an initialized Intl.NumberFormat object.");if(void 0===e["[[boundFormat]]"]){var g=Q.call(function(a){return T(this,
Number(a))},this);e["[[boundFormat]]"]=g}return e["[[boundFormat]]"]}function Fa(e,g){var a=q(e);if(v.call(a,"[[minimumSignificantDigits]]")&&v.call(a,"[[maximumSignificantDigits]]")){e=a["[[minimumSignificantDigits]]"];var c=a["[[maximumSignificantDigits]]"];if(0===g)g=F.call(Array(c+1),"0"),a=0;else{a=Math.abs(g);if("function"===typeof Math.log10)a=Math.floor(Math.log10(a));else{var b=Math.round(Math.log(a)*Math.LOG10E);a=b-(Number("1e"+b)>a)}b=Math.round(Math.exp(Math.abs(a-c+1)*Math.LN10));g=
String(Math.round(0>a-c+1?g*b:g/b))}if(a>=c)e=g+F.call(Array(a-c+2),"0");else{if(a!==c-1&&(0<=a?g=g.slice(0,a+1)+"."+g.slice(a+1):0>a&&(g="0."+F.call(Array(-(a+1)+1),"0")+g),0<=g.indexOf(".")&&c>e)){for(e=c-e;0<e&&"0"===g.charAt(g.length-1);)g=g.slice(0,-1),e--;"."===g.charAt(g.length-1)&&(g=g.slice(0,-1))}e=g}}else{e=a["[[minimumIntegerDigits]]"];c=a["[[minimumFractionDigits]]"];a=a["[[maximumFractionDigits]]"];g*=Math.pow(10,a);g=0===g?"0":g.toFixed(0);b=void 0;var d=-1<(b=g.indexOf("e"))?g.slice(b+
1):0;d&&(g=g.slice(0,b).replace(".",""),g+=F.call(Array(d-(g.length-1)+1),"0"));0!==a?(d=g.length,d<=a&&(g=F.call(Array(a+1-d+1),"0")+g,d=a+1),b=g.substring(0,d-a),g=g.substring(d-a,g.length),g=b+"."+g,b=b.length):b=g.length;for(c=a-c;0<c&&"0"===g.slice(-1);)g=g.slice(0,-1),c--;"."===g.slice(-1)&&(g=g.slice(0,-1));b<e&&(g=F.call(Array(e-b+1),"0")+g);e=g}return e}function na(e,g){var a=q(e),c=a["[[numberingSystem]]"],b=y.NumberFormat["[[localeData]]"][a["[[dataLocale]]"]],d=b.symbols[c]||b.symbols.latn,
n=void 0;!isNaN(g)&&0>g?(g=-g,n=a["[[negativePattern]]"]):n=a["[[positivePattern]]"];for(var l=new k,f=n.indexOf("{",0),h=0,u=0,m=n.length;-1<f&&f<m;){h=n.indexOf("}",f);if(-1===h)throw Error();f>u&&(u=n.substring(u,f),x.call(l,{"[[type]]":"literal","[[value]]":u}));u=n.substring(f+1,h);if("number"===u)if(isNaN(g))x.call(l,{"[[type]]":"nan","[[value]]":d.nan});else if(isFinite(g)){"percent"===a["[[style]]"]&&(g*=100);var p=Fa(e,g);oa[c]?function(){var a=oa[c];p=String(p).replace(/\d/g,function(b){return a[b]})}():
p=String(p);u=f=void 0;u=p.indexOf(".",0);0<u?(f=p.substring(0,u),u=p.substring(u+1,u.length)):(f=p,u=void 0);if(!0===a["[[useGrouping]]"]){var r=d.group,t=[],v=b.patterns.primaryGroupSize||3,w=b.patterns.secondaryGroupSize||v;if(f.length>v){v=f.length-v;var z=v%w,A=f.slice(0,z);for(A.length&&x.call(t,A);z<v;)x.call(t,f.slice(z,z+w)),z+=w;x.call(t,f.slice(v))}else x.call(t,f);if(0===t.length)throw Error();for(;t.length;)f=pa.call(t),x.call(l,{"[[type]]":"integer","[[value]]":f}),t.length&&x.call(l,
{"[[type]]":"group","[[value]]":r})}else x.call(l,{"[[type]]":"integer","[[value]]":f});void 0!==u&&(x.call(l,{"[[type]]":"decimal","[[value]]":d.decimal}),x.call(l,{"[[type]]":"fraction","[[value]]":u}))}else x.call(l,{"[[type]]":"infinity","[[value]]":d.infinity});else"plusSign"===u?x.call(l,{"[[type]]":"plusSign","[[value]]":d.plusSign}):"minusSign"===u?x.call(l,{"[[type]]":"minusSign","[[value]]":d.minusSign}):"percentSign"===u&&"percent"===a["[[style]]"]?x.call(l,{"[[type]]":"literal","[[value]]":d.percentSign}):
"currency"===u&&"currency"===a["[[style]]"]?(f=a["[[currency]]"],u=void 0,"code"===a["[[currencyDisplay]]"]?u=f:"symbol"===a["[[currencyDisplay]]"]?u=b.currencies[f]||f:"name"===a["[[currencyDisplay]]"]&&(u=f),x.call(l,{"[[type]]":"currency","[[value]]":u})):(f=n.substring(f,h),x.call(l,{"[[type]]":"literal","[[value]]":f}));u=h+1;f=n.indexOf("{",u)}u<m&&(e=n.substring(u,m),x.call(l,{"[[type]]":"literal","[[value]]":e}));return l}function T(e,g){e=na(e,g);g="";for(var a=0;e.length>a;a++)g+=e[a]["[[value]]"];
return g}function qa(e){e.pattern12=e.extendedPattern.replace(/'([^']*)'/g,function(e,a){return a?a:"'"});e.pattern=e.pattern12.replace("{ampm}","").replace(Ga,"");return e}function ra(e,g){switch(e.charAt(0)){case "G":return g.era=["short","short","short","long","narrow"][e.length-1],"{era}";case "y":case "Y":case "u":case "U":case "r":return g.year=2===e.length?"2-digit":"numeric","{year}";case "Q":case "q":return g.quarter=["numeric","2-digit","short","long","narrow"][e.length-1],"{quarter}";case "M":case "L":return g.month=
["numeric","2-digit","short","long","narrow"][e.length-1],"{month}";case "w":return g.week=2===e.length?"2-digit":"numeric","{weekday}";case "W":return g.week="numeric","{weekday}";case "d":return g.day=2===e.length?"2-digit":"numeric","{day}";case "D":case "F":case "g":return g.day="numeric","{day}";case "E":return g.weekday="short short short long narrow short".split(" ")[e.length-1],"{weekday}";case "e":return g.weekday="numeric 2-digit short long narrow short".split(" ")[e.length-1],"{weekday}";
case "c":return g.weekday=["numeric",void 0,"short","long","narrow","short"][e.length-1],"{weekday}";case "a":case "b":case "B":return g.hour12=!0,"{ampm}";case "h":case "H":return g.hour=2===e.length?"2-digit":"numeric","{hour}";case "k":case "K":return g.hour12=!0,g.hour=2===e.length?"2-digit":"numeric","{hour}";case "m":return g.minute=2===e.length?"2-digit":"numeric","{minute}";case "s":return g.second=2===e.length?"2-digit":"numeric","{second}";case "S":case "A":return g.second="numeric","{second}";
case "z":case "Z":case "O":case "v":case "V":case "X":case "x":return g.timeZoneName=4>e.length?"short":"long","{timeZoneName}"}}function ba(e,g){if(!Ha.test(g)){var a={originalPattern:g,_:{}};a.extendedPattern=g.replace(sa,function(c){return ra(c,a._)});e.replace(sa,function(c){return ra(c,a)});return qa(a)}}function U(e,g,a,c,b){e=e[g]&&e[g][a]?e[g][a]:e.gregory[a];g={narrow:["short","long"],short:["long","narrow"],long:["short","narrow"]};c=v.call(e,c)?e[c]:v.call(e,g[c][0])?e[g[c][0]]:e[g[c][1]];
return null!==b?c[b]:c}function R(e,g){return this&&this!==t?Ia(r(this),e,g):new t.DateTimeFormat(e,g)}function Ia(e,g,a){var c=q(e),b=p();if(!0===c["[[initializedIntlObject]]"])throw new TypeError("`this` object has already been initialized as an Intl object");w(e,"__getInternalProperties",{value:function(a){if(a===P)return c}});c["[[initializedIntlObject]]"]=!0;var d=C(g);a=V(a,"any","date");g=new f;var n=A(a,"localeMatcher","string",new k("lookup","best fit"),"best fit");g["[[localeMatcher]]"]=
n;var l=y.DateTimeFormat;n=l["[[localeData]]"];g=X(l["[[availableLocales]]"],d,g,l["[[relevantExtensionKeys]]"],n);c["[[locale]]"]=g["[[locale]]"];c["[[calendar]]"]=g["[[ca]]"];c["[[numberingSystem]]"]=g["[[nu]]"];c["[[dataLocale]]"]=g["[[dataLocale]]"];l=g["[[dataLocale]]"];g=a.timeZone;if(void 0!==g&&(g=z(g),"UTC"!==g))throw new RangeError("timeZone is not supported.");c["[[timeZone]]"]=g;g=new f;for(var h in B)v.call(B,h)&&(d=A(a,h,"string",B[h]),g["[["+h+"]]"]=d);d=void 0;h=n[l];d=Ja(h.formats);
n=A(a,"formatMatcher","string",new k("basic","best fit"),"best fit");h.formats=d;"basic"===n?d=Ka(g,d):(n=A(a,"hour12","boolean"),g.hour12=void 0===n?h.hour12:n,d=La(g,d));for(var m in B)v.call(B,m)&&v.call(d,m)&&(g=d[m],g=d._&&v.call(d._,m)?d._[m]:g,c["[["+m+"]]"]=g);m=void 0;a=A(a,"hour12","boolean");c["[[hour]]"]?(a=void 0===a?h.hour12:a,c["[[hour12]]"]=a,!0===a?(c["[[hourNo0]]"]=h.hourNo0,m=d.pattern12):m=d.pattern):m=d.pattern;c["[[pattern]]"]=m;c["[[boundFormat]]"]=void 0;c["[[initializedDateTimeFormat]]"]=
!0;la&&(e.format=ta.call(e));b();return e}function Ja(e){if("[object Array]"===Object.prototype.toString.call(e))return e;var g=e.availableFormats,a=e.timeFormats,c=e.dateFormats,b=[],d=void 0,n,l=[],f=[];for(d in g)if(g.hasOwnProperty(d)){var h=g[d];if(n=ba(d,h)){b.push(n);a:{h=n;for(var k=0;k<G.length;k+=1)if(h.hasOwnProperty(G[k])){h=!1;break a}h=!0}if(h)f.push(n);else{a:{h=n;for(k=0;k<H.length;k+=1)if(h.hasOwnProperty(H[k])){h=!1;break a}h=!0}h&&l.push(n)}}}for(d in a)a.hasOwnProperty(d)&&(h=
a[d],n=ba(d,h))&&(b.push(n),l.push(n));for(d in c)c.hasOwnProperty(d)&&(h=c[d],n=ba(d,h))&&(b.push(n),f.push(n));for(g=0;g<l.length;g+=1)for(a=0;a<f.length;a+=1){h="long"===f[a].month?f[a].weekday?e.full:e.long:"short"===f[a].month?e.medium:e.short;d=f[a];n=l[g];c={_:{}};for(k=0;k<H.length;k+=1)d[H[k]]&&(c[H[k]]=d[H[k]]),d._[H[k]]&&(c._[H[k]]=d._[H[k]]);for(d=0;d<G.length;d+=1)n[G[d]]&&(c[G[d]]=n[G[d]]),n._[G[d]]&&(c._[G[d]]=n._[G[d]]);n=c;n.originalPattern=h;n.extendedPattern=h.replace("{0}",l[g].extendedPattern).replace("{1}",
f[a].extendedPattern).replace(/^[,\s]+|[,\s]+$/gi,"");b.push(qa(n))}return b}function V(e,g,a){if(void 0===e)e=null;else{var c=r(e);e=new f;for(var b in c)e[b]=c[b]}e=E(e);c=!0;if("date"===g||"any"===g)if(void 0!==e.weekday||void 0!==e.year||void 0!==e.month||void 0!==e.day)c=!1;if("time"===g||"any"===g)if(void 0!==e.hour||void 0!==e.minute||void 0!==e.second)c=!1;!c||"date"!==a&&"all"!==a||(e.year=e.month=e.day="numeric");!c||"time"!==a&&"all"!==a||(e.hour=e.minute=e.second="numeric");return e}function Ka(e,
g){for(var a=-Infinity,c=void 0,b=0,d=g.length;b<d;){var n=g[b],l=0,f;for(f in B)if(v.call(B,f)){var h=e["[["+f+"]]"],k=v.call(n,f)?n[f]:void 0;if(void 0===h&&void 0!==k)l-=20;else if(void 0!==h&&void 0===k)l-=120;else{var m=["2-digit","numeric","narrow","short","long"];h=J.call(m,h);k=J.call(m,k);k=Math.max(Math.min(k-h,2),-2);2===k?l-=6:1===k?l-=3:-1===k?l-=6:-2===k&&(l-=8)}}l>a&&(a=l,c=n);b++}return c}function La(e,g){var a=[];for(c in B)v.call(B,c)&&void 0!==e["[["+c+"]]"]&&a.push(c);if(1===a.length){var c=
a[0];a=e["[["+a[0]+"]]"];if(ca[c]&&ca[c][a]){var b;a=(b={originalPattern:ca[c][a],_:S({},c,a),extendedPattern:"{"+c+"}"},S(b,c,a),S(b,"pattern12","{"+c+"}"),S(b,"pattern","{"+c+"}"),b)}else a=void 0;if(a)return a}b=-Infinity;a=void 0;c=0;for(var d=g.length;c<d;){var n=g[c],l=0,f;for(f in B)if(v.call(B,f)){var h=e["[["+f+"]]"],k=v.call(n,f)?n[f]:void 0,m=v.call(n._,f)?n._[f]:void 0;h!==m&&(l-=2);void 0===h&&void 0!==k?l-=20:void 0!==h&&void 0===k?l-=120:(m=["2-digit","numeric","narrow","short","long"],
h=J.call(m,h),k=J.call(m,k),m=Math.max(Math.min(k-h,2),-2),1>=k&&2<=h||2<=k&&1>=h?0<m?l-=6:0>m&&(l-=8):1<m?l-=3:-1>m&&(l-=6))}n._.hour12!==e.hour12&&--l;l>b&&(b=l,a=n);c++}return a}function ta(){var e=null!==this&&"object"===D["typeof"](this)&&q(this);if(!e||!e["[[initializedDateTimeFormat]]"])throw new TypeError("`this` value for format() is not an initialized Intl.DateTimeFormat object.");if(void 0===e["[[boundFormat]]"]){var g=Q.call(function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:
void 0;a=void 0===a?Date.now():m(a);return W(this,a)},this);e["[[boundFormat]]"]=g}return e["[[boundFormat]]"]}function ua(e,g){if(!isFinite(g))throw new RangeError("Invalid valid date passed to format");e=e.__getInternalProperties(P);p();var a=e["[[locale]]"],c=new t.NumberFormat([a],{useGrouping:!1}),b=new t.NumberFormat([a],{minimumIntegerDigits:2,useGrouping:!1});g=new Date(g);var d="get"+(e["[[timeZone]]"]||"");g=new f({"[[weekday]]":g[d+"Day"](),"[[era]]":+(0<=g[d+"FullYear"]()),"[[year]]":g[d+
"FullYear"](),"[[month]]":g[d+"Month"](),"[[day]]":g[d+"Date"](),"[[hour]]":g[d+"Hours"](),"[[minute]]":g[d+"Minutes"](),"[[second]]":g[d+"Seconds"](),"[[inDST]]":!1});d=e["[[pattern]]"];for(var n=new k,l=0,h=d.indexOf("{"),m=0,u=y.DateTimeFormat["[[localeData]]"][e["[[dataLocale]]"]].calendars,r=e["[[calendar]]"];-1!==h;){var q=void 0;m=d.indexOf("}",h);if(-1===m)throw Error("Unclosed pattern");h>l&&x.call(n,{type:"literal",value:d.substring(l,h)});l=d.substring(h+1,m);if(B.hasOwnProperty(l)){h=
e["[["+l+"]]"];var v=g["[["+l+"]]"];"year"===l&&0>=v?v=1-v:"month"===l?v++:"hour"===l&&!0===e["[[hour12]]"]&&(v%=12,0===v&&!0===e["[[hourNo0]]"]&&(v=12));if("numeric"===h)q=T(c,v);else if("2-digit"===h)q=T(b,v),2<q.length&&(q=q.slice(-2));else if(h in Ma)switch(l){case "month":q=U(u,r,"months",h,g["[["+l+"]]"]);break;case "weekday":try{q=U(u,r,"days",h,g["[["+l+"]]"])}catch(Da){throw Error("Could not find weekday data for locale "+a);}break;case "timeZoneName":q="";break;case "era":try{q=U(u,r,"eras",
h,g["[["+l+"]]"])}catch(Da){throw Error("Could not find era data for locale "+a);}break;default:q=g["[["+l+"]]"]}x.call(n,{type:l,value:q})}else"ampm"===l?(q=U(u,r,"dayPeriods",11<g["[[hour]]"]?"pm":"am",null),x.call(n,{type:"dayPeriod",value:q})):x.call(n,{type:"literal",value:d.substring(h,m+1)});l=m+1;h=d.indexOf("{",l)}m<d.length-1&&x.call(n,{type:"literal",value:d.substr(m+1)});return n}function W(e,g){e=ua(e,g);g="";for(var a=0;e.length>a;a++)g+=e[a].value;return g}function va(e,g){return this&&
this!==t?Na(r(this),e,g):new t.PluralRules(e,g)}function Na(e,g,a){var c=q(e);if(!0===c["[[InitializedIntlObject]]"])throw new TypeError("`this` object has already been initialized as an Intl object");w(e,"__getInternalProperties",{value:function(a){if(a===P)return c}});c["[[InitializedIntlObject]]"]=!0;g=C(g);a=void 0===a?{}:r(a);var b=A(a,"type","string",new k("cardinal","ordinal"),"cardinal");c["[[type]]"]=b;b=new f;var d=A(a,"localeMatcher","string",new k("lookup","best fit"),"best fit");b["[[localeMatcher]]"]=
d;ja(y,a,0);void 0===y["[[maximumFractionDigits]]"]&&(y["[[maximumFractionDigits]]"]=Math.max(y["[[minimumFractionDigits]]"],3));a=X(y.PluralRules["[[availableLocales]]"],g,b,y.PluralRules["[[relevantExtensionKeys]]"],y.PluralRules["[[localeData]]"]);c["[[locale]]"]=a["[[locale]]"];c["[[InitializedPluralRules]]"]=!0;return e}var h="function"===typeof Symbol&&"symbol"===typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"===typeof Symbol&&e.constructor===Symbol&&e!==
Symbol.prototype?"symbol":typeof e},Oa=function(){var e="function"===typeof Symbol&&Symbol.for&&Symbol.for("react.element")||60103;return function(g,a,c,b){var d=g&&g.defaultProps,f=arguments.length-3;a||0===f||(a={});if(a&&d)for(var l in d)void 0===a[l]&&(a[l]=d[l]);else a||(a=d||{});if(1===f)a.children=b;else if(1<f){d=Array(f);for(l=0;l<f;l++)d[l]=arguments[l+3];a.children=d}return{$$typeof:e,type:g,key:void 0===c?null:""+c,ref:null,props:a,_owner:null}}}(),Pa=function(){function e(a){this.value=
a}function g(a){function c(d,g){try{var f=a[d](g),l=f.value;l instanceof e?Promise.resolve(l.value).then(function(a){c("next",a)},function(a){c("throw",a)}):b(f.done?"return":"normal",f.value)}catch(Ca){b("throw",Ca)}}function b(a,b){switch(a){case "return":d.resolve({value:b,done:!0});break;case "throw":d.reject(b);break;default:d.resolve({value:b,done:!1})}(d=d.next)?c(d.key,d.arg):g=null}var d,g;this._invoke=function(a,b){return new Promise(function(e,f){e={key:a,arg:b,resolve:e,reject:f,next:null};
g?g=g.next=e:(d=g=e,c(a,b))})};"function"!==typeof a.return&&(this.return=void 0)}"function"===typeof Symbol&&Symbol.asyncIterator&&(g.prototype[Symbol.asyncIterator]=function(){return this});g.prototype.next=function(a){return this._invoke("next",a)};g.prototype.throw=function(a){return this._invoke("throw",a)};g.prototype.return=function(a){return this._invoke("return",a)};return{wrap:function(a){return function(){return new g(a.apply(this,arguments))}},await:function(a){return new e(a)}}}(),Qa=
function(){function e(e,a){for(var c=0;c<a.length;c++){var b=a[c];b.enumerable=b.enumerable||!1;b.configurable=!0;"value"in b&&(b.writable=!0);Object.defineProperty(e,b.key,b)}}return function(g,a,c){a&&e(g.prototype,a);c&&e(g,c);return g}}(),S=function(e,g,a){g in e?Object.defineProperty(e,g,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[g]=a;return e},Ra=Object.assign||function(e){for(var g=1;g<arguments.length;g++){var a=arguments[g],c;for(c in a)Object.prototype.hasOwnProperty.call(a,
c)&&(e[c]=a[c])}return e},Sa="undefined"===typeof global?self:global,Ta=function(){return function(e,g){if(Array.isArray(e))return e;if(Symbol.iterator in Object(e)){var a=[],c=!0,b=!1,d=void 0;try{for(var f=e[Symbol.iterator](),l;!(c=(l=f.next()).done)&&(a.push(l.value),!g||a.length!==g);c=!0);}catch(fa){b=!0,d=fa}finally{try{if(!c&&f["return"])f["return"]()}finally{if(b)throw d;}}return a}throw new TypeError("Invalid attempt to destructure non-iterable instance");}}(),D=Object.freeze({jsx:Oa,asyncIterator:function(e){if("function"===
typeof Symbol){if(Symbol.asyncIterator){var g=e[Symbol.asyncIterator];if(null!=g)return g.call(e)}if(Symbol.iterator)return e[Symbol.iterator]()}throw new TypeError("Object is not async iterable");},asyncGenerator:Pa,asyncGeneratorDelegate:function(e,g){function a(a,c){b=!0;c=new Promise(function(b){b(e[a](c))});return{done:!1,value:g(c)}}var c={},b=!1;"function"===typeof Symbol&&Symbol.iterator&&(c[Symbol.iterator]=function(){return this});c.next=function(c){return b?(b=!1,c):a("next",c)};"function"===
typeof e.throw&&(c.throw=function(c){if(b)throw b=!1,c;return a("throw",c)});"function"===typeof e.return&&(c.return=function(b){return a("return",b)});return c},asyncToGenerator:function(e){return function(){var g=e.apply(this,arguments);return new Promise(function(a,c){function b(d,e){try{var f=g[d](e);var h=f.value}catch(Ba){c(Ba);return}if(f.done)a(h);else return Promise.resolve(h).then(function(a){b("next",a)},function(a){b("throw",a)})}return b("next")})}},classCallCheck:function(e,g){if(!(e instanceof
g))throw new TypeError("Cannot call a class as a function");},createClass:Qa,defineEnumerableProperties:function(e,g){for(var a in g){var c=g[a];c.configurable=c.enumerable=!0;"value"in c&&(c.writable=!0);Object.defineProperty(e,a,c)}return e},defaults:function(e,g){for(var a=Object.getOwnPropertyNames(g),c=0;c<a.length;c++){var b=a[c],d=Object.getOwnPropertyDescriptor(g,b);d&&d.configurable&&void 0===e[b]&&Object.defineProperty(e,b,d)}return e},defineProperty:S,get:function g(a,c,b){null===a&&(a=
Function.prototype);var d=Object.getOwnPropertyDescriptor(a,c);if(void 0===d){if(a=Object.getPrototypeOf(a),null!==a)return g(a,c,b)}else{if("value"in d)return d.value;c=d.get;return void 0===c?void 0:c.call(b)}},inherits:function(g,a){if("function"!==typeof a&&null!==a)throw new TypeError("Super expression must either be null or a function, not "+typeof a);g.prototype=Object.create(a&&a.prototype,{constructor:{value:g,enumerable:!1,writable:!0,configurable:!0}});a&&(Object.setPrototypeOf?Object.setPrototypeOf(g,
a):g.__proto__=a)},interopRequireDefault:function(g){return g&&g.__esModule?g:{default:g}},interopRequireWildcard:function(g){if(g&&g.__esModule)return g;var a={};if(null!=g)for(var c in g)Object.prototype.hasOwnProperty.call(g,c)&&(a[c]=g[c]);a.default=g;return a},newArrowCheck:function(g,a){if(g!==a)throw new TypeError("Cannot instantiate an arrow function");},objectDestructuringEmpty:function(g){if(null==g)throw new TypeError("Cannot destructure undefined");},objectWithoutProperties:function(g,
a){var c={},b;for(b in g)0<=a.indexOf(b)||Object.prototype.hasOwnProperty.call(g,b)&&(c[b]=g[b]);return c},possibleConstructorReturn:function(g,a){if(!g)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!a||"object"!==typeof a&&"function"!==typeof a?g:a},selfGlobal:Sa,set:function a(c,b,d,f){var h=Object.getOwnPropertyDescriptor(c,b);void 0===h?(c=Object.getPrototypeOf(c),null!==c&&a(c,b,d,f)):"value"in h&&h.writable?h.value=d:(b=h.set,void 0!==b&&b.call(f,
d));return d},slicedToArray:Ta,slicedToArrayLoose:function(a,c){if(Array.isArray(a))return a;if(Symbol.iterator in Object(a)){var b=[];a=a[Symbol.iterator]();for(var d;!(d=a.next()).done&&(b.push(d.value),!c||b.length!==c););return b}throw new TypeError("Invalid attempt to destructure non-iterable instance");},taggedTemplateLiteral:function(a,c){return Object.freeze(Object.defineProperties(a,{raw:{value:Object.freeze(c)}}))},taggedTemplateLiteralLoose:function(a,c){a.raw=c;return a},temporalRef:function(a,
c,b){if(a===b)throw new ReferenceError(c+" is not defined - temporal dead zone");return a},temporalUndefined:{},toArray:function(a){return Array.isArray(a)?a:Array.from(a)},toConsumableArray:function(a){if(Array.isArray(a)){for(var c=0,b=Array(a.length);c<a.length;c++)b[c]=a[c];return b}return Array.from(a)},typeof:h,extends:Ra,instanceof:function(a,c){return null!=c&&"undefined"!==typeof Symbol&&c[Symbol.hasInstance]?c[Symbol.hasInstance](a):a instanceof c}});h=function(){var a=function(){};try{return Object.defineProperty(a,
"a",{get:function(){return 1}}),Object.defineProperty(a,"prototype",{writable:!1}),1===a.a&&a.prototype instanceof Object}catch(c){return!1}}();var la=!h&&!Object.prototype.__defineGetter__,v=Object.prototype.hasOwnProperty,w=h?Object.defineProperty:function(a,c,b){if("get"in b&&a.__defineGetter__)a.__defineGetter__(c,b.get);else if(!v.call(a,c)||"value"in b)a[c]=b.value},J=Array.prototype.indexOf||function(a,c){if(!this.length)return-1;c=c||0;for(var b=this.length;c<b;c++)if(this[c]===a)return c;
return-1},E=Object.create||function(a,c){function b(){}var d=void 0;b.prototype=a;d=new b;for(var f in c)v.call(c,f)&&w(d,f,c[f]);return d},O=Array.prototype.slice,Ua=Array.prototype.concat,x=Array.prototype.push,F=Array.prototype.join,pa=Array.prototype.shift,Q=Function.prototype.bind||function(a){var c=this,b=O.call(arguments,1);return function(){return c.apply(a,Ua.call(b,O.call(arguments)))}},y=E(null),P=Math.random();f.prototype=E(null);k.prototype=E(null);var xa=/^(?:(?:[a-z]{2,3}(?:-[a-z]{3}(?:-[a-z]{3}){0,2})?|[a-z]{4}|[a-z]{5,8})(?:-[a-z]{4})?(?:-(?:[a-z]{2}|\d{3}))?(?:-(?:[a-z0-9]{5,8}|\d[a-z0-9]{3}))*(?:-[0-9a-wy-z](?:-[a-z0-9]{2,8})+)*(?:-x(?:-[a-z0-9]{1,8})+)?|x(?:-[a-z0-9]{1,8})+|(?:(?:en-GB-oed|i-(?:ami|bnn|default|enochian|hak|klingon|lux|mingo|navajo|pwn|tao|tay|tsu)|sgn-(?:BE-FR|BE-NL|CH-DE))|(?:art-lojban|cel-gaulish|no-bok|no-nyn|zh-(?:guoyu|hakka|min|min-nan|xiang))))$/i,
ya=/^(?!x).*?-((?:[a-z0-9]{5,8}|\d[a-z0-9]{3}))-(?:\w{4,8}-(?!x-))*\1\b/i,za=/^(?!x).*?-([0-9a-wy-z])-(?:\w+-(?!x-))*\1\b/i,ha=/-[0-9a-wy-z](?:-[a-z0-9]{2,8})+/ig,aa=void 0,L={tags:{"art-lojban":"jbo","i-ami":"ami","i-bnn":"bnn","i-hak":"hak","i-klingon":"tlh","i-lux":"lb","i-navajo":"nv","i-pwn":"pwn","i-tao":"tao","i-tay":"tay","i-tsu":"tsu","no-bok":"nb","no-nyn":"nn","sgn-BE-FR":"sfb","sgn-BE-NL":"vgt","sgn-CH-DE":"sgg","zh-guoyu":"cmn","zh-hakka":"hak","zh-min-nan":"nan","zh-xiang":"hsn","sgn-BR":"bzs",
"sgn-CO":"csn","sgn-DE":"gsg","sgn-DK":"dsl","sgn-ES":"ssp","sgn-FR":"fsl","sgn-GB":"bfi","sgn-GR":"gss","sgn-IE":"isg","sgn-IT":"ise","sgn-JP":"jsl","sgn-MX":"mfs","sgn-NI":"ncs","sgn-NL":"dse","sgn-NO":"nsl","sgn-PT":"psr","sgn-SE":"swl","sgn-US":"ase","sgn-ZA":"sfs","zh-cmn":"cmn","zh-cmn-Hans":"cmn-Hans","zh-cmn-Hant":"cmn-Hant","zh-gan":"gan","zh-wuu":"wuu","zh-yue":"yue"},subtags:{BU:"MM",DD:"DE",FX:"FR",TP:"TL",YD:"YE",ZR:"CD",heploc:"alalc97","in":"id",iw:"he",ji:"yi",jw:"jv",mo:"ro",ayx:"nun",
bjd:"drl",ccq:"rki",cjr:"mom",cka:"cmr",cmk:"xch",drh:"khk",drw:"prs",gav:"dev",hrr:"jal",ibi:"opa",kgh:"kml",lcq:"ppr",mst:"mry",myt:"mry",sca:"hle",tie:"ras",tkk:"twm",tlw:"weo",tnf:"prs",ybd:"rki",yma:"lrr"},extLang:{aao:["aao","ar"],abh:["abh","ar"],abv:["abv","ar"],acm:["acm","ar"],acq:["acq","ar"],acw:["acw","ar"],acx:["acx","ar"],acy:["acy","ar"],adf:["adf","ar"],ads:["ads","sgn"],aeb:["aeb","ar"],aec:["aec","ar"],aed:["aed","sgn"],aen:["aen","sgn"],afb:["afb","ar"],afg:["afg","sgn"],ajp:["ajp",
"ar"],apc:["apc","ar"],apd:["apd","ar"],arb:["arb","ar"],arq:["arq","ar"],ars:["ars","ar"],ary:["ary","ar"],arz:["arz","ar"],ase:["ase","sgn"],asf:["asf","sgn"],asp:["asp","sgn"],asq:["asq","sgn"],asw:["asw","sgn"],auz:["auz","ar"],avl:["avl","ar"],ayh:["ayh","ar"],ayl:["ayl","ar"],ayn:["ayn","ar"],ayp:["ayp","ar"],bbz:["bbz","ar"],bfi:["bfi","sgn"],bfk:["bfk","sgn"],bjn:["bjn","ms"],bog:["bog","sgn"],bqn:["bqn","sgn"],bqy:["bqy","sgn"],btj:["btj","ms"],bve:["bve","ms"],bvl:["bvl","sgn"],bvu:["bvu",
"ms"],bzs:["bzs","sgn"],cdo:["cdo","zh"],cds:["cds","sgn"],cjy:["cjy","zh"],cmn:["cmn","zh"],coa:["coa","ms"],cpx:["cpx","zh"],csc:["csc","sgn"],csd:["csd","sgn"],cse:["cse","sgn"],csf:["csf","sgn"],csg:["csg","sgn"],csl:["csl","sgn"],csn:["csn","sgn"],csq:["csq","sgn"],csr:["csr","sgn"],czh:["czh","zh"],czo:["czo","zh"],doq:["doq","sgn"],dse:["dse","sgn"],dsl:["dsl","sgn"],dup:["dup","ms"],ecs:["ecs","sgn"],esl:["esl","sgn"],esn:["esn","sgn"],eso:["eso","sgn"],eth:["eth","sgn"],fcs:["fcs","sgn"],
fse:["fse","sgn"],fsl:["fsl","sgn"],fss:["fss","sgn"],gan:["gan","zh"],gds:["gds","sgn"],gom:["gom","kok"],gse:["gse","sgn"],gsg:["gsg","sgn"],gsm:["gsm","sgn"],gss:["gss","sgn"],gus:["gus","sgn"],hab:["hab","sgn"],haf:["haf","sgn"],hak:["hak","zh"],hds:["hds","sgn"],hji:["hji","ms"],hks:["hks","sgn"],hos:["hos","sgn"],hps:["hps","sgn"],hsh:["hsh","sgn"],hsl:["hsl","sgn"],hsn:["hsn","zh"],icl:["icl","sgn"],ils:["ils","sgn"],inl:["inl","sgn"],ins:["ins","sgn"],ise:["ise","sgn"],isg:["isg","sgn"],isr:["isr",
"sgn"],jak:["jak","ms"],jax:["jax","ms"],jcs:["jcs","sgn"],jhs:["jhs","sgn"],jls:["jls","sgn"],jos:["jos","sgn"],jsl:["jsl","sgn"],jus:["jus","sgn"],kgi:["kgi","sgn"],knn:["knn","kok"],kvb:["kvb","ms"],kvk:["kvk","sgn"],kvr:["kvr","ms"],kxd:["kxd","ms"],lbs:["lbs","sgn"],lce:["lce","ms"],lcf:["lcf","ms"],liw:["liw","ms"],lls:["lls","sgn"],lsg:["lsg","sgn"],lsl:["lsl","sgn"],lso:["lso","sgn"],lsp:["lsp","sgn"],lst:["lst","sgn"],lsy:["lsy","sgn"],ltg:["ltg","lv"],lvs:["lvs","lv"],lzh:["lzh","zh"],max:["max",
"ms"],mdl:["mdl","sgn"],meo:["meo","ms"],mfa:["mfa","ms"],mfb:["mfb","ms"],mfs:["mfs","sgn"],min:["min","ms"],mnp:["mnp","zh"],mqg:["mqg","ms"],mre:["mre","sgn"],msd:["msd","sgn"],msi:["msi","ms"],msr:["msr","sgn"],mui:["mui","ms"],mzc:["mzc","sgn"],mzg:["mzg","sgn"],mzy:["mzy","sgn"],nan:["nan","zh"],nbs:["nbs","sgn"],ncs:["ncs","sgn"],nsi:["nsi","sgn"],nsl:["nsl","sgn"],nsp:["nsp","sgn"],nsr:["nsr","sgn"],nzs:["nzs","sgn"],okl:["okl","sgn"],orn:["orn","ms"],ors:["ors","ms"],pel:["pel","ms"],pga:["pga",
"ar"],pks:["pks","sgn"],prl:["prl","sgn"],prz:["prz","sgn"],psc:["psc","sgn"],psd:["psd","sgn"],pse:["pse","ms"],psg:["psg","sgn"],psl:["psl","sgn"],pso:["pso","sgn"],psp:["psp","sgn"],psr:["psr","sgn"],pys:["pys","sgn"],rms:["rms","sgn"],rsi:["rsi","sgn"],rsl:["rsl","sgn"],sdl:["sdl","sgn"],sfb:["sfb","sgn"],sfs:["sfs","sgn"],sgg:["sgg","sgn"],sgx:["sgx","sgn"],shu:["shu","ar"],slf:["slf","sgn"],sls:["sls","sgn"],sqk:["sqk","sgn"],sqs:["sqs","sgn"],ssh:["ssh","ar"],ssp:["ssp","sgn"],ssr:["ssr","sgn"],
svk:["svk","sgn"],swc:["swc","sw"],swh:["swh","sw"],swl:["swl","sgn"],syy:["syy","sgn"],tmw:["tmw","ms"],tse:["tse","sgn"],tsm:["tsm","sgn"],tsq:["tsq","sgn"],tss:["tss","sgn"],tsy:["tsy","sgn"],tza:["tza","sgn"],ugn:["ugn","sgn"],ugy:["ugy","sgn"],ukl:["ukl","sgn"],uks:["uks","sgn"],urk:["urk","ms"],uzn:["uzn","uz"],uzs:["uzs","uz"],vgt:["vgt","sgn"],vkk:["vkk","ms"],vkt:["vkt","ms"],vsi:["vsi","sgn"],vsl:["vsl","sgn"],vsv:["vsv","sgn"],wuu:["wuu","zh"],xki:["xki","sgn"],xml:["xml","sgn"],xmm:["xmm",
"ms"],xms:["xms","sgn"],yds:["yds","sgn"],ysl:["ysl","sgn"],yue:["yue","zh"],zib:["zib","sgn"],zlm:["zlm","ms"],zmi:["zmi","ms"],zsl:["zsl","sgn"],zsm:["zsm","ms"]}},Aa=/^[A-Z]{3}$/,Z=/-u(?:-[0-9a-z]{2,8})+/gi,t={};Object.defineProperty(t,"getCanonicalLocales",{enumerable:!1,configurable:!0,writable:!0,value:function(a){a=C(a);for(var c=[],b=a.length,d=0;d<b;)c[d]=a[d],d++;return c}});var ka={BHD:3,BYR:0,XOF:0,BIF:0,XAF:0,CLF:4,CLP:0,KMF:0,DJF:0,XPF:0,GNF:0,ISK:0,IQD:3,JPY:0,JOD:3,KRW:0,KWD:3,LYD:3,
OMR:3,PYG:0,RWF:0,TND:3,UGX:0,UYI:0,VUV:0,VND:0};w(t,"NumberFormat",{configurable:!0,writable:!0,value:ia});w(t.NumberFormat,"prototype",{writable:!1});y.NumberFormat={"[[availableLocales]]":[],"[[relevantExtensionKeys]]":["nu"],"[[localeData]]":{}};w(t.NumberFormat,"supportedLocalesOf",{configurable:!0,writable:!0,value:Q.call(function(a,c){if(!v.call(this,"[[availableLocales]]"))throw new TypeError("supportedLocalesOf() is not a constructor");var b=p(),d=this["[[availableLocales]]"];a=C(a);b();
return Y(d,a,c)},y.NumberFormat)});w(t.NumberFormat.prototype,"format",{configurable:!0,get:ma});Object.defineProperty(t.NumberFormat.prototype,"formatToParts",{configurable:!0,enumerable:!1,writable:!0,value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:void 0,c=null!==this&&"object"===D["typeof"](this)&&q(this);if(!c||!c["[[initializedNumberFormat]]"])throw new TypeError("`this` value for formatToParts() is not an initialized Intl.NumberFormat object.");a=na(this,Number(a));
c=[];for(var b=0,d=0;a.length>d;d++){var f=a[d],h={};h.type=f["[[type]]"];h.value=f["[[value]]"];c[b]=h;b+=1}return c}});var oa={arab:"\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669".split(""),arabext:"\u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9".split(""),bali:"\u1b50\u1b51\u1b52\u1b53\u1b54\u1b55\u1b56\u1b57\u1b58\u1b59".split(""),beng:"\u09e6\u09e7\u09e8\u09e9\u09ea\u09eb\u09ec\u09ed\u09ee\u09ef".split(""),deva:"\u0966\u0967\u0968\u0969\u096a\u096b\u096c\u096d\u096e\u096f".split(""),
fullwide:"\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19".split(""),gujr:"\u0ae6\u0ae7\u0ae8\u0ae9\u0aea\u0aeb\u0aec\u0aed\u0aee\u0aef".split(""),guru:"\u0a66\u0a67\u0a68\u0a69\u0a6a\u0a6b\u0a6c\u0a6d\u0a6e\u0a6f".split(""),hanidec:"\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d".split(""),khmr:"\u17e0\u17e1\u17e2\u17e3\u17e4\u17e5\u17e6\u17e7\u17e8\u17e9".split(""),knda:"\u0ce6\u0ce7\u0ce8\u0ce9\u0cea\u0ceb\u0cec\u0ced\u0cee\u0cef".split(""),laoo:"\u0ed0\u0ed1\u0ed2\u0ed3\u0ed4\u0ed5\u0ed6\u0ed7\u0ed8\u0ed9".split(""),
latn:"0123456789".split(""),limb:"\u1946\u1947\u1948\u1949\u194a\u194b\u194c\u194d\u194e\u194f".split(""),mlym:"\u0d66\u0d67\u0d68\u0d69\u0d6a\u0d6b\u0d6c\u0d6d\u0d6e\u0d6f".split(""),mong:"\u1810\u1811\u1812\u1813\u1814\u1815\u1816\u1817\u1818\u1819".split(""),mymr:"\u1040\u1041\u1042\u1043\u1044\u1045\u1046\u1047\u1048\u1049".split(""),orya:"\u0b66\u0b67\u0b68\u0b69\u0b6a\u0b6b\u0b6c\u0b6d\u0b6e\u0b6f".split(""),tamldec:"\u0be6\u0be7\u0be8\u0be9\u0bea\u0beb\u0bec\u0bed\u0bee\u0bef".split(""),telu:"\u0c66\u0c67\u0c68\u0c69\u0c6a\u0c6b\u0c6c\u0c6d\u0c6e\u0c6f".split(""),
thai:"\u0e50\u0e51\u0e52\u0e53\u0e54\u0e55\u0e56\u0e57\u0e58\u0e59".split(""),tibt:"\u0f20\u0f21\u0f22\u0f23\u0f24\u0f25\u0f26\u0f27\u0f28\u0f29".split("")};w(t.NumberFormat.prototype,"resolvedOptions",{configurable:!0,writable:!0,value:function(){var a,c=new f,b="locale numberingSystem style currency currencyDisplay minimumIntegerDigits minimumFractionDigits maximumFractionDigits minimumSignificantDigits maximumSignificantDigits useGrouping".split(" "),d=null!==this&&"object"===D["typeof"](this)&&
q(this);if(!d||!d["[[initializedNumberFormat]]"])throw new TypeError("`this` value for resolvedOptions() is not an initialized Intl.NumberFormat object.");for(var h=0,l=b.length;h<l;h++)v.call(d,a="[["+b[h]+"]]")&&(c[b[h]]={value:d[a],writable:!0,configurable:!0,enumerable:!0});return E({},c)}});var sa=/(?:[Eec]{1,6}|G{1,5}|[Qq]{1,5}|(?:[yYur]+|U{1,5})|[ML]{1,5}|d{1,2}|D{1,3}|F{1}|[abB]{1,5}|[hkHK]{1,2}|w{1,2}|W{1}|m{1,2}|s{1,2}|[zZOvVxX]{1,4})(?=([^']*'[^']*')*[^']*$)/g,Ga=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,
Ha=/[rqQASjJgwWIQq]/,H="era year month day weekday quarter".split(" "),G=["hour","minute","second","hour12","timeZoneName"],ca={second:{numeric:"s","2-digit":"ss"},minute:{numeric:"m","2-digit":"mm"},year:{numeric:"y","2-digit":"yy"},day:{numeric:"d","2-digit":"dd"},month:{numeric:"L","2-digit":"LL",narrow:"LLLLL",short:"LLL",long:"LLLL"},weekday:{narrow:"ccccc",short:"ccc",long:"cccc"}},Ma=E(null,{narrow:{},short:{},long:{}});w(t,"DateTimeFormat",{configurable:!0,writable:!0,value:R});w(R,"prototype",
{writable:!1});var B={weekday:["narrow","short","long"],era:["narrow","short","long"],year:["2-digit","numeric"],month:["2-digit","numeric","narrow","short","long"],day:["2-digit","numeric"],hour:["2-digit","numeric"],minute:["2-digit","numeric"],second:["2-digit","numeric"],timeZoneName:["short","long"]};y.DateTimeFormat={"[[availableLocales]]":[],"[[relevantExtensionKeys]]":["ca","nu"],"[[localeData]]":{}};w(t.DateTimeFormat,"supportedLocalesOf",{configurable:!0,writable:!0,value:Q.call(function(a,
c){if(!v.call(this,"[[availableLocales]]"))throw new TypeError("supportedLocalesOf() is not a constructor");var b=p(),d=this["[[availableLocales]]"];a=C(a);b();return Y(d,a,c)},y.NumberFormat)});w(t.DateTimeFormat.prototype,"format",{configurable:!0,get:ta});Object.defineProperty(t.DateTimeFormat.prototype,"formatToParts",{enumerable:!1,writable:!0,configurable:!0,value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:void 0,c=null!==this&&"object"===D["typeof"](this)&&q(this);
if(!c||!c["[[initializedDateTimeFormat]]"])throw new TypeError("`this` value for formatToParts() is not an initialized Intl.DateTimeFormat object.");a=void 0===a?Date.now():m(a);a=ua(this,a);c=[];for(var b=0;a.length>b;b++){var d=a[b];c.push({type:d.type,value:d.value})}return c}});w(t.DateTimeFormat.prototype,"resolvedOptions",{writable:!0,configurable:!0,value:function(){var a,c=new f,b="locale calendar numberingSystem timeZone hour12 weekday era year month day hour minute second timeZoneName".split(" "),
d=null!==this&&"object"===D["typeof"](this)&&q(this);if(!d||!d["[[initializedDateTimeFormat]]"])throw new TypeError("`this` value for resolvedOptions() is not an initialized Intl.DateTimeFormat object.");for(var h=0,l=b.length;h<l;h++)v.call(d,a="[["+b[h]+"]]")&&(c[b[h]]={value:d[a],writable:!0,configurable:!0,enumerable:!0});return E({},c)}});var I=t.__localeSensitiveProtos={Number:{},Date:{}};I.Number.toLocaleString=function(a,c){if("[object Number]"!==Object.prototype.toString.call(this))throw new TypeError("`this` value must be a number for Number.prototype.toLocaleString()");
return T(new ia(a,c),this)};I.Date.toLocaleString=function(a,c){if("[object Date]"!==Object.prototype.toString.call(this))throw new TypeError("`this` value must be a Date instance for Date.prototype.toLocaleString()");var b=+this;if(isNaN(b))return"Invalid Date";c=V(c,"any","all");a=new R(a,c);return W(a,b)};I.Date.toLocaleDateString=function(a,c){if("[object Date]"!==Object.prototype.toString.call(this))throw new TypeError("`this` value must be a Date instance for Date.prototype.toLocaleDateString()");
var b=+this;if(isNaN(b))return"Invalid Date";c=V(c,"date","date");a=new R(a,c);return W(a,b)};I.Date.toLocaleTimeString=function(a,c){if("[object Date]"!==Object.prototype.toString.call(this))throw new TypeError("`this` value must be a Date instance for Date.prototype.toLocaleTimeString()");var b=+this;if(isNaN(b))return"Invalid Date";c=V(c,"time","time");a=new R(a,c);return W(a,b)};h=[function(a,c){return"other"},function(a,c){return c?"other":1==a?"one":"other"},function(a,c){return c?"other":0==
a||1==a?"one":"other"},function(a,c){var b=!String(a).split(".")[1];return c?"other":1==a&&b?"one":"other"}];var wa={af:h[1],ak:h[2],am:function(a,c){return c?"other":0<=a&&1>=a?"one":"other"},ar:function(a,c){var b=String(a).split(".");b=Number(b[0])==a&&b[0].slice(-2);return c?"other":0==a?"zero":1==a?"one":2==a?"two":3<=b&&10>=b?"few":11<=b&&99>=b?"many":"other"},ars:function(a,c){var b=String(a).split(".");b=Number(b[0])==a&&b[0].slice(-2);return c?"other":0==a?"zero":1==a?"one":2==a?"two":3<=
b&&10>=b?"few":11<=b&&99>=b?"many":"other"},as:function(a,c){return c?1==a||5==a||7==a||8==a||9==a||10==a?"one":2==a||3==a?"two":4==a?"few":6==a?"many":"other":0<=a&&1>=a?"one":"other"},asa:h[1],ast:h[3],az:function(a,c){var b=String(a).split(".")[0],d=b.slice(-1),f=b.slice(-2),h=b.slice(-3);return c?1==d||2==d||5==d||7==d||8==d||20==f||50==f||70==f||80==f?"one":3==d||4==d||100==h||200==h||300==h||400==h||500==h||600==h||700==h||800==h||900==h?"few":0==b||6==d||40==f||60==f||90==f?"many":"other":
1==a?"one":"other"},be:function(a,c){var b=String(a).split("."),d=(a=Number(b[0])==a)&&b[0].slice(-1);b=a&&b[0].slice(-2);return c?2!=d&&3!=d||12==b||13==b?"other":"few":1==d&&11!=b?"one":2<=d&&4>=d&&(12>b||14<b)?"few":a&&0==d||5<=d&&9>=d||11<=b&&14>=b?"many":"other"},bem:h[1],bez:h[1],bg:h[1],bh:h[2],bm:h[0],bn:function(a,c){return c?1==a||5==a||7==a||8==a||9==a||10==a?"one":2==a||3==a?"two":4==a?"few":6==a?"many":"other":0<=a&&1>=a?"one":"other"},bo:h[0],br:function(a,c){var b=String(a).split("."),
d=Number(b[0])==a,f=d&&b[0].slice(-1),h=d&&b[0].slice(-2);b=d&&b[0].slice(-6);return c?"other":1==f&&11!=h&&71!=h&&91!=h?"one":2==f&&12!=h&&72!=h&&92!=h?"two":(3==f||4==f||9==f)&&(10>h||19<h)&&(70>h||79<h)&&(90>h||99<h)?"few":0!=a&&d&&0==b?"many":"other"},brx:h[1],bs:function(a,c){var b=String(a).split("."),d=b[0];a=b[1]||"";b=!b[1];var f=d.slice(-1);d=d.slice(-2);var h=a.slice(-1);a=a.slice(-2);return c?"other":b&&1==f&&11!=d||1==h&&11!=a?"one":b&&2<=f&&4>=f&&(12>d||14<d)||2<=h&&4>=h&&(12>a||14<
a)?"few":"other"},ca:function(a,c){var b=!String(a).split(".")[1];return c?1==a||3==a?"one":2==a?"two":4==a?"few":"other":1==a&&b?"one":"other"},ce:h[1],cgg:h[1],chr:h[1],ckb:h[1],cs:function(a,c){var b=String(a).split("."),d=b[0];b=!b[1];return c?"other":1==a&&b?"one":2<=d&&4>=d&&b?"few":b?"other":"many"},cy:function(a,c){return c?0==a||7==a||8==a||9==a?"zero":1==a?"one":2==a?"two":3==a||4==a?"few":5==a||6==a?"many":"other":0==a?"zero":1==a?"one":2==a?"two":3==a?"few":6==a?"many":"other"},da:function(a,
c){var b=String(a).split("."),d=b[0];b=Number(b[0])==a;return c?"other":1!=a&&(b||0!=d&&1!=d)?"other":"one"},de:h[3],dsb:function(a,c){var b=String(a).split("."),d=b[1]||"";a=!b[1];b=b[0].slice(-2);d=d.slice(-2);return c?"other":a&&1==b||1==d?"one":a&&2==b||2==d?"two":a&&(3==b||4==b)||3==d||4==d?"few":"other"},dv:h[1],dz:h[0],ee:h[1],el:h[1],en:function(a,c){var b=String(a).split("."),d=!b[1],f=Number(b[0])==a,h=f&&b[0].slice(-1);b=f&&b[0].slice(-2);return c?1==h&&11!=b?"one":2==h&&12!=b?"two":3==
h&&13!=b?"few":"other":1==a&&d?"one":"other"},eo:h[1],es:h[1],et:h[3],eu:h[1],fa:function(a,c){return c?"other":0<=a&&1>=a?"one":"other"},ff:function(a,c){return c?"other":0<=a&&2>a?"one":"other"},fi:h[3],fil:function(a,c){var b=String(a).split("."),d=b[0],f=b[1]||"";b=!b[1];var h=d.slice(-1);f=f.slice(-1);return c?1==a?"one":"other":b&&(1==d||2==d||3==d)||b&&4!=h&&6!=h&&9!=h||!b&&4!=f&&6!=f&&9!=f?"one":"other"},fo:h[1],fr:function(a,c){return c?1==a?"one":"other":0<=a&&2>a?"one":"other"},fur:h[1],
fy:h[3],ga:function(a,c){var b=String(a).split(".");b=Number(b[0])==a;return c?1==a?"one":"other":1==a?"one":2==a?"two":b&&3<=a&&6>=a?"few":b&&7<=a&&10>=a?"many":"other"},gd:function(a,c){var b=String(a).split(".");b=Number(b[0])==a;return c?"other":1==a||11==a?"one":2==a||12==a?"two":b&&3<=a&&10>=a||b&&13<=a&&19>=a?"few":"other"},gl:h[3],gsw:h[1],gu:function(a,c){return c?1==a?"one":2==a||3==a?"two":4==a?"few":6==a?"many":"other":0<=a&&1>=a?"one":"other"},guw:h[2],gv:function(a,c){var b=String(a).split(".");
a=b[0];b=!b[1];var d=a.slice(-1);a=a.slice(-2);return c?"other":b&&1==d?"one":b&&2==d?"two":!b||0!=a&&20!=a&&40!=a&&60!=a&&80!=a?b?"other":"many":"few"},ha:h[1],haw:h[1],he:function(a,c){var b=String(a).split("."),d=b[0],f=!b[1],h=Number(b[0])==a;b=h&&b[0].slice(-1);return c?"other":1==a&&f?"one":2==d&&f?"two":f&&(0>a||10<a)&&h&&0==b?"many":"other"},hi:function(a,c){return c?1==a?"one":2==a||3==a?"two":4==a?"few":6==a?"many":"other":0<=a&&1>=a?"one":"other"},hr:function(a,c){var b=String(a).split("."),
d=b[0];a=b[1]||"";b=!b[1];var f=d.slice(-1);d=d.slice(-2);var h=a.slice(-1);a=a.slice(-2);return c?"other":b&&1==f&&11!=d||1==h&&11!=a?"one":b&&2<=f&&4>=f&&(12>d||14<d)||2<=h&&4>=h&&(12>a||14<a)?"few":"other"},hsb:function(a,c){var b=String(a).split("."),d=b[1]||"";a=!b[1];b=b[0].slice(-2);d=d.slice(-2);return c?"other":a&&1==b||1==d?"one":a&&2==b||2==d?"two":a&&(3==b||4==b)||3==d||4==d?"few":"other"},hu:function(a,c){return c?1==a||5==a?"one":"other":1==a?"one":"other"},hy:function(a,c){return c?
1==a?"one":"other":0<=a&&2>a?"one":"other"},id:h[0],ig:h[0],ii:h[0],"in":h[0],is:function(a,c){var b=String(a).split("."),d=b[0];a=Number(b[0])==a;b=d.slice(-1);d=d.slice(-2);return c?"other":a&&1==b&&11!=d||!a?"one":"other"},it:function(a,c){var b=!String(a).split(".")[1];return c?11==a||8==a||80==a||800==a?"many":"other":1==a&&b?"one":"other"},iu:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},iw:function(a,c){var b=String(a).split("."),d=b[0],f=!b[1],h=Number(b[0])==a;b=h&&b[0].slice(-1);
return c?"other":1==a&&f?"one":2==d&&f?"two":f&&(0>a||10<a)&&h&&0==b?"many":"other"},ja:h[0],jbo:h[0],jgo:h[1],ji:h[3],jmc:h[1],jv:h[0],jw:h[0],ka:function(a,c){var b=String(a).split(".")[0],d=b.slice(-2);return c?1==b?"one":0==b||2<=d&&20>=d||40==d||60==d||80==d?"many":"other":1==a?"one":"other"},kab:function(a,c){return c?"other":0<=a&&2>a?"one":"other"},kaj:h[1],kcg:h[1],kde:h[0],kea:h[0],kk:function(a,c){var b=String(a).split("."),d=Number(b[0])==a;b=d&&b[0].slice(-1);return c?6==b||9==b||d&&
0==b&&0!=a?"many":"other":1==a?"one":"other"},kkj:h[1],kl:h[1],km:h[0],kn:function(a,c){return c?"other":0<=a&&1>=a?"one":"other"},ko:h[0],ks:h[1],ksb:h[1],ksh:function(a,c){return c?"other":0==a?"zero":1==a?"one":"other"},ku:h[1],kw:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},ky:h[1],lag:function(a,c){var b=String(a).split(".")[0];return c?"other":0==a?"zero":0!=b&&1!=b||0==a?"other":"one"},lb:h[1],lg:h[1],lkt:h[0],ln:h[2],lo:function(a,c){return c?1==a?"one":"other":"other"},lt:function(a,
c){var b=String(a).split("."),d=b[1]||"",f=Number(b[0])==a;a=f&&b[0].slice(-1);b=f&&b[0].slice(-2);return c?"other":1==a&&(11>b||19<b)?"one":2<=a&&9>=a&&(11>b||19<b)?"few":0!=d?"many":"other"},lv:function(a,c){var b=String(a).split("."),d=b[1]||"",f=d.length,h=(a=Number(b[0])==a)&&b[0].slice(-1);b=a&&b[0].slice(-2);var k=d.slice(-2);d=d.slice(-1);return c?"other":a&&0==h||11<=b&&19>=b||2==f&&11<=k&&19>=k?"zero":1==h&&11!=b||2==f&&1==d&&11!=k||2!=f&&1==d?"one":"other"},mas:h[1],mg:h[2],mgo:h[1],mk:function(a,
c){var b=String(a).split("."),d=b[0];a=b[1]||"";b=!b[1];var f=d.slice(-1);d=d.slice(-2);a=a.slice(-1);return c?1==f&&11!=d?"one":2==f&&12!=d?"two":7!=f&&8!=f||17==d||18==d?"other":"many":b&&1==f||1==a?"one":"other"},ml:h[1],mn:h[1],mo:function(a,c){var b=String(a).split("."),d=!b[1];b=Number(b[0])==a&&b[0].slice(-2);return c?1==a?"one":"other":1==a&&d?"one":!d||0==a||1!=a&&1<=b&&19>=b?"few":"other"},mr:function(a,c){return c?1==a?"one":2==a||3==a?"two":4==a?"few":"other":0<=a&&1>=a?"one":"other"},
ms:function(a,c){return c?1==a?"one":"other":"other"},mt:function(a,c){var b=String(a).split(".");b=Number(b[0])==a&&b[0].slice(-2);return c?"other":1==a?"one":0==a||2<=b&&10>=b?"few":11<=b&&19>=b?"many":"other"},my:h[0],nah:h[1],naq:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},nb:h[1],nd:h[1],ne:function(a,c){var b=String(a).split(".");b=Number(b[0])==a;return c?b&&1<=a&&4>=a?"one":"other":1==a?"one":"other"},nl:h[3],nn:h[1],nnh:h[1],no:h[1],nqo:h[0],nr:h[1],nso:h[2],ny:h[1],nyn:h[1],
om:h[1],or:h[1],os:h[1],pa:h[2],pap:h[1],pl:function(a,c){var b=String(a).split("."),d=b[0];b=!b[1];var f=d.slice(-1),h=d.slice(-2);return c?"other":1==a&&b?"one":b&&2<=f&&4>=f&&(12>h||14<h)?"few":b&&1!=d&&(0==f||1==f)||b&&5<=f&&9>=f||b&&12<=h&&14>=h?"many":"other"},prg:function(a,c){var b=String(a).split("."),d=b[1]||"",f=d.length,h=(a=Number(b[0])==a)&&b[0].slice(-1);b=a&&b[0].slice(-2);var k=d.slice(-2);d=d.slice(-1);return c?"other":a&&0==h||11<=b&&19>=b||2==f&&11<=k&&19>=k?"zero":1==h&&11!=b||
2==f&&1==d&&11!=k||2!=f&&1==d?"one":"other"},ps:h[1],pt:function(a,c){var b=String(a).split(".");return c?"other":Number(b[0])==a&&0<=a&&2>=a&&2!=a?"one":"other"},"pt-PT":h[3],rm:h[1],ro:function(a,c){var b=String(a).split("."),d=!b[1];b=Number(b[0])==a&&b[0].slice(-2);return c?1==a?"one":"other":1==a&&d?"one":!d||0==a||1!=a&&1<=b&&19>=b?"few":"other"},rof:h[1],root:h[0],ru:function(a,c){var b=String(a).split(".");a=b[0];b=!b[1];var d=a.slice(-1);a=a.slice(-2);return c?"other":b&&1==d&&11!=a?"one":
b&&2<=d&&4>=d&&(12>a||14<a)?"few":b&&0==d||b&&5<=d&&9>=d||b&&11<=a&&14>=a?"many":"other"},rwk:h[1],sah:h[0],saq:h[1],sdh:h[1],se:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},seh:h[1],ses:h[0],sg:h[0],sh:function(a,c){var b=String(a).split("."),d=b[0];a=b[1]||"";b=!b[1];var f=d.slice(-1);d=d.slice(-2);var h=a.slice(-1);a=a.slice(-2);return c?"other":b&&1==f&&11!=d||1==h&&11!=a?"one":b&&2<=f&&4>=f&&(12>d||14<d)||2<=h&&4>=h&&(12>a||14<a)?"few":"other"},shi:function(a,c){var b=String(a).split(".");
b=Number(b[0])==a;return c?"other":0<=a&&1>=a?"one":b&&2<=a&&10>=a?"few":"other"},si:function(a,c){var b=String(a).split("."),d=b[0];b=b[1]||"";return c?"other":0==a||1==a||0==d&&1==b?"one":"other"},sk:function(a,c){var b=String(a).split("."),d=b[0];b=!b[1];return c?"other":1==a&&b?"one":2<=d&&4>=d&&b?"few":b?"other":"many"},sl:function(a,c){var b=String(a).split(".");a=!b[1];b=b[0].slice(-2);return c?"other":a&&1==b?"one":a&&2==b?"two":a&&(3==b||4==b)||!a?"few":"other"},sma:function(a,c){return c?
"other":1==a?"one":2==a?"two":"other"},smi:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},smj:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},smn:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},sms:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},sn:h[1],so:h[1],sq:function(a,c){var b=String(a).split("."),d=Number(b[0])==a,f=d&&b[0].slice(-1);b=d&&b[0].slice(-2);return c?1==a?"one":4==f&&14!=b?"many":"other":1==a?"one":"other"},sr:function(a,
c){var b=String(a).split("."),d=b[0];a=b[1]||"";b=!b[1];var f=d.slice(-1);d=d.slice(-2);var h=a.slice(-1);a=a.slice(-2);return c?"other":b&&1==f&&11!=d||1==h&&11!=a?"one":b&&2<=f&&4>=f&&(12>d||14<d)||2<=h&&4>=h&&(12>a||14<a)?"few":"other"},ss:h[1],ssy:h[1],st:h[1],sv:function(a,c){var b=String(a).split("."),d=!b[1],f=Number(b[0])==a,h=f&&b[0].slice(-1);b=f&&b[0].slice(-2);return c?1!=h&&2!=h||11==b||12==b?"other":"one":1==a&&d?"one":"other"},sw:h[3],syr:h[1],ta:h[1],te:h[1],teo:h[1],th:h[0],ti:h[2],
tig:h[1],tk:h[1],tl:function(a,c){var b=String(a).split("."),d=b[0],f=b[1]||"";b=!b[1];var h=d.slice(-1);f=f.slice(-1);return c?1==a?"one":"other":b&&(1==d||2==d||3==d)||b&&4!=h&&6!=h&&9!=h||!b&&4!=f&&6!=f&&9!=f?"one":"other"},tn:h[1],to:h[0],tr:h[1],ts:h[1],tzm:function(a,c){var b=String(a).split(".");b=Number(b[0])==a;return c?"other":0==a||1==a||b&&11<=a&&99>=a?"one":"other"},ug:h[1],uk:function(a,c){var b=String(a).split("."),d=b[0],f=!b[1],h=Number(b[0])==a;a=h&&b[0].slice(-1);b=h&&b[0].slice(-2);
h=d.slice(-1);d=d.slice(-2);return c?3==a&&13!=b?"few":"other":f&&1==h&&11!=d?"one":f&&2<=h&&4>=h&&(12>d||14<d)?"few":f&&0==h||f&&5<=h&&9>=h||f&&11<=d&&14>=d?"many":"other"},ur:h[3],uz:h[1],ve:h[1],vi:function(a,c){return c?1==a?"one":"other":"other"},vo:h[1],vun:h[1],wa:h[2],wae:h[1],wo:h[0],xh:h[1],xog:h[1],yi:h[3],yo:h[0],yue:h[0],zh:h[0],zu:function(a,c){return c?"other":0<=a&&1>=a?"one":"other"}};w(t,"PluralRules",{configurable:!0,writable:!0,value:va});w(va,"prototype",{writable:!1});y.PluralRules=
{"[[availableLocales]]":Object.keys(wa),"[[relevantExtensionKeys]]":[],"[[localeData]]":{}};w(t.PluralRules,"supportedLocalesOf",{configurable:!0,writable:!0,value:Q.call(function(a,c){if(!v.call(this,"[[availableLocales]]"))throw new TypeError("supportedLocalesOf() is not a constructor");var b=p(),d=this["[[availableLocales]]"];a=C(a);b();return Y(d,a,c)},y.PluralRules)});w(t.PluralRules.prototype,"select",{configurable:!0,value:function(a){a=Number(a);if(Number.isFinite(a)){var c=q(this);b:{var b=
c["[[type]]"];for(c=c["[[locale]]"];c;c=c.replace(/[-_]?[^-_]*$/,"")){var d=wa[c];if(d){a=d(a,"ordinal"===b);break b}}a="other"}}else a="other";return a}});w(t.PluralRules.prototype,"resolvedOptions",{configurable:!0,writable:!0,value:function(){var a,c=new f,b="locale type minimumIntegerDigits minimumFractionDigits maximumFractionDigits minimumSignificantDigits maximumSignificantDigits".split(" "),d=null!==this&&"object"===D["typeof"](this)&&q(this);if(!d||!d["[[InitializedPluralRules]]"])throw new TypeError("`this` value for resolvedOptions() is not an initialized Intl.PluralRules object.");
for(var h=0,k=b.length;h<k;h++)v.call(d,a="[["+b[h]+"]]")&&(c[b[h]]={value:d[a],writable:!0,configurable:!0,enumerable:!0});return E({},c)}});w(t,"__applyLocaleSensitivePrototypes",{writable:!0,configurable:!0,value:function(){w(Number.prototype,"toLocaleString",{writable:!0,configurable:!0,value:I.Number.toLocaleString});w(Date.prototype,"toLocaleString",{writable:!0,configurable:!0,value:I.Date.toLocaleString});for(var a in I.Date)v.call(I.Date,a)&&w(Date.prototype,a,{writable:!0,configurable:!0,
value:I.Date[a]})}});w(t,"__addLocaleData",{value:function(a){if(!da(a.locale))throw Error('Invalid language tag "'+a.locale+'" when calling __addLocaleData("'+a.locale+'", ...) to register new locale data.');var c=a.locale;if(!a.number)throw Error("Object passed doesn't contain locale data for Intl.NumberFormat");var b=[c];var d=c.split("-");for(2<d.length&&4===d[1].length&&x.call(b,d[0]+"-"+d[2]);d=pa.call(b);)x.call(y.NumberFormat["[[availableLocales]]"],d),y.NumberFormat["[[localeData]]"][d]=
a.number,a.date&&(a.date.nu=a.number.nu,x.call(y.DateTimeFormat["[[availableLocales]]"],d),y.DateTimeFormat["[[localeData]]"][d]=a.date);void 0===aa&&(aa=c)}});w(t,"__disableRegExpRestore",{value:function(){y.disableRegExpRestore=!0}});if("undefined"===typeof Intl)try{window.Intl=t,t.__applyLocaleSensitivePrototypes()}catch(a){}return t});
