/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.BooleanPropertyAccess;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.IntPropertyAccess;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zk.ui.sys.StringPropertyAccess;
import org.zkoss.zul.impl.InputElement;

public class Textbox
extends InputElement {
    private AuxInfo _auxinf;
    private static HashMap<String, PropertyAccess> _properties = new HashMap(5);
    private static final String TEXT = "text";

    public Textbox() {
        this.setValueDirectly("");
    }

    public Textbox(String value) throws WrongValueException {
        this.setValue(value);
    }

    public String getValue() throws WrongValueException {
        return this.getText();
    }

    public void setValue(String value) throws WrongValueException {
        this.setText(value);
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        return value != null ? value : "";
    }

    protected String coerceToString(Object value) {
        return value != null ? (String)value : "";
    }

    public String getType() {
        return this._auxinf != null ? this._auxinf.type : TEXT;
    }

    public void setType(String type) throws WrongValueException {
        if (!(TEXT.equals(type) || "password".equals(type) || "tel".equals(type) || "email".equals(type) || "url".equals(type))) {
            throw new WrongValueException("Illegal type: " + type);
        }
        if (!type.equals(this._auxinf != null ? this._auxinf.type : TEXT)) {
            this.initAuxInfo().type = type;
            this.smartUpdate("type", this.getType());
        }
    }

    public int getRows() {
        return this._auxinf != null ? this._auxinf.rows : 1;
    }

    public void setRows(int rows) throws WrongValueException {
        if (rows <= 0) {
            throw new WrongValueException("Illegal rows: " + rows);
        }
        if ((this._auxinf != null ? this._auxinf.rows : 1) != rows) {
            this.initAuxInfo().rows = rows;
            if (rows > 1) {
                this.setMultiline(true);
            }
            this.smartUpdate("rows", this.getRows());
        }
    }

    public boolean isMultiline() {
        return this._auxinf != null && this._auxinf.multiline;
    }

    public void setMultiline(boolean multiline) {
        if ((this._auxinf != null && this._auxinf.multiline) != multiline) {
            this.initAuxInfo().multiline = multiline;
            this.smartUpdate("multiline", this.isMultiline());
        }
    }

    public boolean isTabbable() {
        return this._auxinf != null && this._auxinf.tabbable;
    }

    public void setTabbable(boolean tabbable) {
        if ((this._auxinf != null && this._auxinf.tabbable) != tabbable) {
            this.initAuxInfo().tabbable = tabbable;
            this.smartUpdate("tabbable", this.isTabbable());
        }
    }

    public boolean isSubmitByEnter() {
        return this._auxinf != null && this._auxinf.submitByEnter;
    }

    public void setSubmitByEnter(boolean submitByEnter) {
        if ((this._auxinf != null && this._auxinf.submitByEnter) != submitByEnter) {
            this.initAuxInfo().submitByEnter = submitByEnter;
            this.smartUpdate("submitByEnter", this.isSubmitByEnter());
        }
    }

    public Object clone() {
        Textbox clone = (Textbox)super.clone();
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)this._auxinf.clone();
        }
        return clone;
    }

    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "multiline", this.isMultiline());
        int rows = this.getRows();
        if (rows > 1) {
            renderer.render("rows", rows);
        }
        this.render(renderer, "tabbable", this.isTabbable());
        String type = this.getType();
        if (!TEXT.equals(type)) {
            renderer.render("type", type);
        }
        this.render(renderer, "submitByEnter", this.isSubmitByEnter());
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-textbox";
    }

    private AuxInfo initAuxInfo() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    static {
        _properties.put("value", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String value) {
                ((Textbox)cmp).setValue(value);
            }

            public String getValue(Component cmp) {
                return ((Textbox)cmp).getValue();
            }
        });
        _properties.put("type", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String value) {
                ((Textbox)cmp).setType(value);
            }

            public String getValue(Component cmp) {
                return ((Textbox)cmp).getType();
            }
        });
        _properties.put("tabbable", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean value) {
                ((Textbox)cmp).setTabbable(value);
            }

            public Boolean getValue(Component cmp) {
                return ((Textbox)cmp).isTabbable();
            }
        });
        _properties.put("rows", (PropertyAccess)new IntPropertyAccess(){

            public void setValue(Component cmp, Integer value) {
                ((Textbox)cmp).setRows(value);
            }

            public Integer getValue(Component cmp) {
                return ((Textbox)cmp).getRows();
            }
        });
        _properties.put("multiline", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean multiline) {
                ((Textbox)cmp).setMultiline(multiline);
            }

            public Boolean getValue(Component cmp) {
                return ((Textbox)cmp).isMultiline();
            }
        });
        _properties.put("submitByEnter", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean submitByEnter) {
                ((Textbox)cmp).setSubmitByEnter(submitByEnter);
            }

            public Boolean getValue(Component cmp) {
                return ((Textbox)cmp).isSubmitByEnter();
            }
        });
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private String type = "text";
        private int rows = 1;
        private boolean multiline;
        private boolean tabbable;
        private boolean submitByEnter;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

