/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;
import net.sf.jasperreports.engine.virtualization.VirtualizationSerializable;

public class VirtualElementsData
implements Serializable,
VirtualizationSerializable {
    private static final long serialVersionUID = 10200L;
    private Map<Pair<Integer, JREvaluationTime>, Map<JRPrintElement, Integer>> elementEvaluations;
    private List<JRPrintElement> elements;

    public VirtualElementsData() {
    }

    public VirtualElementsData(List<JRPrintElement> elements) {
        this.elements = elements;
    }

    public void setElementEvaluations(int fillerId, JREvaluationTime evaluationTime, Map<JRPrintElement, Integer> evaluations) {
        if (this.elementEvaluations == null) {
            this.elementEvaluations = new HashMap<Pair<Integer, JREvaluationTime>, Map<JRPrintElement, Integer>>();
        }
        this.elementEvaluations.put(new Pair<Integer, JREvaluationTime>(fillerId, evaluationTime), evaluations);
    }

    public Map<JRPrintElement, Integer> getElementEvaluations(int fillerId, JREvaluationTime evaluationTime) {
        return this.elementEvaluations == null ? null : this.elementEvaluations.get(new Pair<Integer, JREvaluationTime>(fillerId, evaluationTime));
    }

    public List<JRPrintElement> getElements() {
        return this.elements;
    }

    @Override
    public void writeVirtualized(VirtualizationOutput out) throws IOException {
        boolean hasEvaluations;
        boolean bl = hasEvaluations = this.elementEvaluations != null && !this.elementEvaluations.isEmpty();
        if (hasEvaluations) {
            out.writeIntCompressed(this.elementEvaluations.size());
            for (Map.Entry entry : this.elementEvaluations.entrySet()) {
                Pair key = (Pair)entry.getKey();
                out.writeIntCompressed((Integer)key.first());
                out.writeJRObject(key.second());
                Map evaluations = (Map)entry.getValue();
                if (evaluations == null || evaluations.isEmpty()) {
                    out.writeIntCompressed(0);
                    continue;
                }
                out.writeIntCompressed(evaluations.size());
                for (Map.Entry evaluationEntry : evaluations.entrySet()) {
                    JRPrintElement element = (JRPrintElement)evaluationEntry.getKey();
                    out.writeJRObject(element, true, true);
                    out.writeIntCompressed((Integer)evaluationEntry.getValue());
                }
            }
        } else {
            out.writeIntCompressed(0);
        }
        out.writeIntCompressed(this.elements.size());
        for (JRPrintElement jRPrintElement : this.elements) {
            if (hasEvaluations) {
                out.writeJRObject(jRPrintElement, true, false);
                continue;
            }
            out.writeJRObject(jRPrintElement);
        }
    }

    @Override
    public void readVirtualized(VirtualizationInput in) throws IOException {
        boolean hasEvaluations;
        int evaluationsCount = in.readIntCompressed();
        boolean bl = hasEvaluations = evaluationsCount > 0;
        if (hasEvaluations) {
            this.elementEvaluations = new HashMap<Pair<Integer, JREvaluationTime>, Map<JRPrintElement, Integer>>(evaluationsCount * 4 / 3 + 1, 0.75f);
            for (int i = 0; i < evaluationsCount; ++i) {
                HashMap<JRPrintElement, Integer> evaluations;
                int fillerId = in.readIntCompressed();
                JREvaluationTime evalTime = (JREvaluationTime)in.readJRObject();
                int count = in.readIntCompressed();
                if (count == 0) {
                    evaluations = null;
                } else {
                    evaluations = new HashMap<JRPrintElement, Integer>(count * 4 / 3 + 1, 0.75f);
                    for (int j = 0; j < count; ++j) {
                        JRPrintElement element = (JRPrintElement)in.readJRObject(true);
                        int value = in.readIntCompressed();
                        evaluations.put(element, value);
                    }
                }
                this.elementEvaluations.put(new Pair<Integer, JREvaluationTime>(fillerId, evalTime), evaluations);
            }
        }
        int size = in.readIntCompressed();
        this.elements = new ArrayList<JRPrintElement>(size);
        for (int i = 0; i < size; ++i) {
            JRPrintElement element = (JRPrintElement)in.readJRObject();
            this.elements.add(element);
        }
    }

    public VirtualElementsData copy() {
        ArrayList<JRPrintElement> elementsCopy = new ArrayList<JRPrintElement>(this.elements);
        VirtualElementsData copy = new VirtualElementsData(elementsCopy);
        if (this.elementEvaluations != null) {
            for (Map.Entry<Pair<Integer, JREvaluationTime>, Map<JRPrintElement, Integer>> entry : this.elementEvaluations.entrySet()) {
                Pair<Integer, JREvaluationTime> key = entry.getKey();
                Map<JRPrintElement, Integer> evals = entry.getValue();
                LinkedHashMap<JRPrintElement, Integer> evalsClone = new LinkedHashMap<JRPrintElement, Integer>(evals);
                copy.setElementEvaluations(key.first(), key.second(), evalsClone);
            }
        }
        return copy;
    }
}

