/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfStructureElement;
import com.lowagie.text.pdf.PdfStructureTreeRoot;
import com.lowagie.text.pdf.PdfWriter;
import java.util.Stack;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.export.JRPdfExporter;

public class JRPdfExporterTagHelper {
    public static final String PROPERTY_TAG_TABLE = "net.sf.jasperreports.export.pdf.tag.table";
    public static final String PROPERTY_TAG_TR = "net.sf.jasperreports.export.pdf.tag.tr";
    public static final String PROPERTY_TAG_TH = "net.sf.jasperreports.export.pdf.tag.th";
    public static final String PROPERTY_TAG_TD = "net.sf.jasperreports.export.pdf.tag.td";
    public static final String PROPERTY_TAG_L = "net.sf.jasperreports.export.pdf.tag.l";
    public static final String PROPERTY_TAG_LI = "net.sf.jasperreports.export.pdf.tag.li";
    public static final String PROPERTY_TAG_H1 = "net.sf.jasperreports.export.pdf.tag.h1";
    public static final String PROPERTY_TAG_H2 = "net.sf.jasperreports.export.pdf.tag.h2";
    public static final String PROPERTY_TAG_H3 = "net.sf.jasperreports.export.pdf.tag.h3";
    public static final String PROPERTY_TAG_H4 = "net.sf.jasperreports.export.pdf.tag.h4";
    public static final String PROPERTY_TAG_H5 = "net.sf.jasperreports.export.pdf.tag.h5";
    public static final String PROPERTY_TAG_H6 = "net.sf.jasperreports.export.pdf.tag.h6";
    public static final String PROPERTY_TAG_COLSPAN = "net.sf.jasperreports.export.pdf.tag.colspan";
    public static final String PROPERTY_TAG_ROWSPAN = "net.sf.jasperreports.export.pdf.tag.rowspan";
    public static final String TAG_START = "start";
    public static final String TAG_END = "end";
    public static final String TAG_FULL = "full";
    protected JRPdfExporter exporter;
    protected PdfContentByte pdfContentByte;
    protected PdfWriter pdfWriter;
    protected PdfStructureElement allTag;
    protected Stack<PdfStructureElement> tagStack;
    protected boolean isTagEmpty = true;
    protected int crtCrosstabRowY = -1;
    protected boolean insideCrosstabCellFrame;
    protected boolean isDataCellPrinted;
    protected boolean isTagged;
    protected String language;

    protected JRPdfExporterTagHelper(JRPdfExporter exporter) {
        this.exporter = exporter;
    }

    protected void setTagged(boolean isTagged) {
        this.isTagged = isTagged;
    }

    protected void setLanguage(String language) {
        this.language = language;
    }

    protected void setPdfWriter(PdfWriter pdfWriter) {
        this.pdfWriter = pdfWriter;
        if (this.isTagged) {
            pdfWriter.setTagged();
        }
    }

    protected void init(PdfContentByte pdfContentByte) {
        this.pdfContentByte = pdfContentByte;
        if (this.isTagged) {
            PdfStructureTreeRoot root = this.pdfWriter.getStructureTreeRoot();
            PdfName pdfNameALL = new PdfName("All");
            root.mapRole(pdfNameALL, PdfName.SECT);
            root.mapRole(PdfName.IMAGE, PdfName.FIGURE);
            root.mapRole(PdfName.TEXT, PdfName.TEXT);
            this.allTag = new PdfStructureElement(root, pdfNameALL);
            if (this.pdfWriter.getPDFXConformance() == 3) {
                root.mapRole(new PdfName("Anchor"), PdfName.NONSTRUCT);
                root.mapRole(PdfName.TEXT, PdfName.SPAN);
            } else {
                root.mapRole(new PdfName("Anchor"), PdfName.TEXT);
            }
            if (this.language != null) {
                this.allTag.put(PdfName.LANG, (PdfObject)new PdfString(this.language));
            }
            this.tagStack = new Stack();
            this.tagStack.push(this.allTag);
        }
    }

    protected void startPageAnchor() {
        if (this.isTagged) {
            PdfStructureElement textTag = new PdfStructureElement(this.allTag, new PdfName("Anchor"));
            this.pdfContentByte.beginMarkedContentSequence(textTag);
        }
    }

    protected void endPageAnchor() {
        if (this.isTagged) {
            this.pdfContentByte.endMarkedContentSequence();
        }
    }

    protected void startPage() {
        this.crtCrosstabRowY = -1;
        this.insideCrosstabCellFrame = false;
        this.isDataCellPrinted = false;
    }

    protected void endPage() {
        if (this.isTagged && this.crtCrosstabRowY >= 0) {
            this.tagStack.pop();
            this.tagStack.pop();
        }
    }

    protected void startElement(JRPrintElement element) {
        if (this.isTagged) {
            boolean isCellContentsFrame;
            JRPrintFrame frame = element instanceof JRPrintFrame ? (JRPrintFrame)element : null;
            boolean bl = isCellContentsFrame = frame != null && frame.getPropertiesMap().hasProperties() && frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type") != null;
            if (isCellContentsFrame) {
                this.insideCrosstabCellFrame = true;
                if (this.crtCrosstabRowY >= 0) {
                    if ("Data".equals(frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type"))) {
                        this.isDataCellPrinted = true;
                    }
                    if (this.crtCrosstabRowY != frame.getY()) {
                        this.tagStack.pop();
                        if (this.isDataCellPrinted && ("CrosstabHeader".equals(frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type")) || "ColumnHeader".equals(frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type")))) {
                            this.tagStack.pop();
                            this.createTableStartTag();
                            this.isDataCellPrinted = false;
                        }
                        this.createTrStartTag();
                        this.crtCrosstabRowY = frame.getY();
                    }
                } else {
                    this.createTableStartTag();
                    this.createTrStartTag();
                    this.crtCrosstabRowY = frame.getY();
                    this.isDataCellPrinted = false;
                }
            } else if (this.crtCrosstabRowY >= 0 && !this.insideCrosstabCellFrame) {
                this.tagStack.pop();
                this.tagStack.pop();
                this.crtCrosstabRowY = -1;
            }
            this.createStartTags(element);
        }
    }

    protected void endElement(JRPrintElement element) {
        if (this.isTagged) {
            boolean isCellContentsFrame;
            JRPrintFrame frame = element instanceof JRPrintFrame ? (JRPrintFrame)element : null;
            boolean bl = isCellContentsFrame = frame != null && frame.getPropertiesMap().hasProperties() && frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type") != null;
            if (isCellContentsFrame) {
                this.insideCrosstabCellFrame = false;
            }
            this.createEndTags(element);
        }
    }

    protected void startImage(JRPrintImage printImage) {
        if (this.isTagged) {
            PdfStructureElement imageTag = new PdfStructureElement(this.allTag, PdfName.IMAGE);
            this.pdfContentByte.beginMarkedContentSequence(imageTag);
            if (printImage.getHyperlinkTooltip() != null) {
                imageTag.put(PdfName.ALT, (PdfObject)new PdfString(printImage.getHyperlinkTooltip()));
            }
        }
    }

    protected void endImage() {
        if (this.isTagged) {
            this.pdfContentByte.endMarkedContentSequence();
        }
    }

    protected void startText(boolean isHyperlink) {
        if (this.isTagged) {
            PdfStructureElement textTag = new PdfStructureElement(this.tagStack.peek(), isHyperlink ? PdfName.LINK : PdfName.TEXT);
            this.pdfContentByte.beginMarkedContentSequence(textTag);
        }
    }

    protected void startText(String text, boolean isHyperlink) {
        if (this.isTagged) {
            PdfDictionary markedContentProps = new PdfDictionary();
            markedContentProps.put(PdfName.ACTUALTEXT, (PdfObject)new PdfString(text, "UnicodeBig"));
            PdfStructureElement textTag = new PdfStructureElement(this.tagStack.peek(), isHyperlink ? PdfName.LINK : PdfName.TEXT);
            this.pdfContentByte.beginMarkedContentSequence(textTag, markedContentProps);
        }
    }

    protected void endText() {
        if (this.isTagged) {
            this.pdfContentByte.endMarkedContentSequence();
            this.isTagEmpty = false;
        }
    }

    protected void createStartTags(JRPrintElement element) {
        if (element.hasProperties()) {
            String prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TABLE);
            if (TAG_START.equals(prop) || TAG_FULL.equals(prop)) {
                this.createTableStartTag();
            }
            if (TAG_START.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TR)) || TAG_FULL.equals(prop)) {
                this.createTrStartTag();
            }
            if (TAG_START.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TH)) || TAG_FULL.equals(prop)) {
                this.createThStartTag(element);
            }
            if (TAG_START.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TD)) || TAG_FULL.equals(prop)) {
                this.createTdStartTag(element);
            }
            if ("CrosstabHeader".equals(prop = element.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type")) || "ColumnHeader".equals(prop) || "RowHeader".equals(prop)) {
                this.createThStartTag(element);
            }
            if ("Data".equals(prop)) {
                this.createTdStartTag(element);
            }
            if (TAG_START.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_L)) || TAG_FULL.equals(prop)) {
                this.createListStartTag();
            }
            if (TAG_START.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_LI)) || TAG_FULL.equals(prop)) {
                this.createListItemStartTag(element);
            }
            this.createStartHeadingTags(element.getPropertiesMap().getProperty(PROPERTY_TAG_H1), PdfName.H1);
            this.createStartHeadingTags(element.getPropertiesMap().getProperty(PROPERTY_TAG_H2), PdfName.H2);
            this.createStartHeadingTags(element.getPropertiesMap().getProperty(PROPERTY_TAG_H3), PdfName.H3);
            this.createStartHeadingTags(element.getPropertiesMap().getProperty(PROPERTY_TAG_H4), PdfName.H4);
            this.createStartHeadingTags(element.getPropertiesMap().getProperty(PROPERTY_TAG_H5), PdfName.H5);
            this.createStartHeadingTags(element.getPropertiesMap().getProperty(PROPERTY_TAG_H6), PdfName.H6);
        }
    }

    protected void createStartHeadingTags(String prop, PdfName pdfName) {
        if (TAG_START.equals(prop) || TAG_FULL.equals(prop)) {
            PdfStructureElement headingTag = new PdfStructureElement(this.tagStack.peek(), pdfName);
            headingTag.put(PdfName.K, (PdfObject)new PdfArray());
            this.tagStack.push(headingTag);
            this.isTagEmpty = true;
        }
    }

    protected void createTableStartTag() {
        PdfStructureElement tableTag = new PdfStructureElement(this.allTag, PdfName.TABLE);
        tableTag.put(PdfName.K, (PdfObject)new PdfArray());
        this.tagStack.push(tableTag);
    }

    protected void createTrStartTag() {
        PdfStructureElement tableRowTag = new PdfStructureElement(this.tagStack.peek(), PdfName.TABLEROW);
        tableRowTag.put(PdfName.K, (PdfObject)new PdfArray());
        this.tagStack.push(tableRowTag);
    }

    protected void createThStartTag(JRPrintElement element) {
        PdfStructureElement tableHeaderTag = new PdfStructureElement(this.tagStack.peek(), PdfName.TH);
        tableHeaderTag.put(PdfName.K, (PdfObject)new PdfArray());
        this.tagStack.push(tableHeaderTag);
        this.isTagEmpty = true;
        this.createSpanTags(element, tableHeaderTag);
    }

    protected void createTdStartTag(JRPrintElement element) {
        PdfStructureElement tableCellTag = new PdfStructureElement(this.tagStack.peek(), PdfName.TD);
        tableCellTag.put(PdfName.K, (PdfObject)new PdfArray());
        this.tagStack.push(tableCellTag);
        this.isTagEmpty = true;
        this.createSpanTags(element, tableCellTag);
    }

    protected void createSpanTags(JRPrintElement element, PdfStructureElement parentTag) {
        int colSpan = 0;
        int rowSpan = 0;
        try {
            colSpan = Integer.valueOf(element.getPropertiesMap().getProperty(PROPERTY_TAG_COLSPAN));
        }
        catch (NumberFormatException e) {
            try {
                colSpan = Integer.valueOf(element.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.column.span"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            rowSpan = Integer.valueOf(element.getPropertiesMap().getProperty(PROPERTY_TAG_ROWSPAN));
        }
        catch (NumberFormatException e) {
            try {
                rowSpan = Integer.valueOf(element.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.row.span"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (colSpan > 1 || rowSpan > 1) {
            PdfArray a = new PdfArray();
            PdfDictionary dict = new PdfDictionary();
            if (colSpan > 1) {
                dict.put(new PdfName("ColSpan"), (PdfObject)new PdfNumber(colSpan));
            }
            if (rowSpan > 1) {
                dict.put(new PdfName("RowSpan"), (PdfObject)new PdfNumber(rowSpan));
            }
            dict.put(PdfName.O, (PdfObject)PdfName.TABLE);
            a.add((PdfObject)dict);
            parentTag.put(PdfName.A, (PdfObject)a);
        }
    }

    protected void createListStartTag() {
        PdfStructureElement listTag = new PdfStructureElement(this.allTag, PdfName.L);
        listTag.put(PdfName.K, (PdfObject)new PdfArray());
        this.tagStack.push(listTag);
    }

    protected void createListItemStartTag(JRPrintElement element) {
        PdfStructureElement listItemTag = new PdfStructureElement(this.tagStack.peek(), PdfName.LI);
        listItemTag.put(PdfName.K, (PdfObject)new PdfArray());
        this.tagStack.push(listItemTag);
        this.isTagEmpty = true;
    }

    protected void createEndTags(JRPrintElement element) {
        if (element.hasProperties()) {
            this.createEndHeadingTags(element.getPropertiesMap().getProperty(PROPERTY_TAG_H6));
            this.createEndHeadingTags(element.getPropertiesMap().getProperty(PROPERTY_TAG_H5));
            this.createEndHeadingTags(element.getPropertiesMap().getProperty(PROPERTY_TAG_H4));
            this.createEndHeadingTags(element.getPropertiesMap().getProperty(PROPERTY_TAG_H3));
            this.createEndHeadingTags(element.getPropertiesMap().getProperty(PROPERTY_TAG_H2));
            this.createEndHeadingTags(element.getPropertiesMap().getProperty(PROPERTY_TAG_H1));
            String prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_LI);
            if (TAG_END.equals(prop) || TAG_FULL.equals(prop)) {
                if (this.isTagEmpty) {
                    this.pdfContentByte.beginMarkedContentSequence(new PdfStructureElement(this.tagStack.peek(), PdfName.SPAN));
                    this.pdfContentByte.endMarkedContentSequence();
                }
                this.tagStack.pop();
            }
            if (TAG_END.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_L)) || TAG_FULL.equals(prop)) {
                this.tagStack.pop();
            }
            if ((prop = element.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type")) != null && ("CrosstabHeader".equals(prop) || "ColumnHeader".equals(prop) || "RowHeader".equals(prop) || "Data".equals(prop))) {
                if (this.isTagEmpty) {
                    this.pdfContentByte.beginMarkedContentSequence(new PdfStructureElement(this.tagStack.peek(), PdfName.SPAN));
                    this.pdfContentByte.endMarkedContentSequence();
                }
                this.tagStack.pop();
            }
            if (TAG_END.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TD)) || TAG_FULL.equals(prop)) {
                if (this.isTagEmpty) {
                    this.pdfContentByte.beginMarkedContentSequence(new PdfStructureElement(this.tagStack.peek(), PdfName.SPAN));
                    this.pdfContentByte.endMarkedContentSequence();
                }
                this.tagStack.pop();
            }
            if (TAG_END.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TH)) || TAG_FULL.equals(prop)) {
                if (this.isTagEmpty) {
                    this.pdfContentByte.beginMarkedContentSequence(new PdfStructureElement(this.tagStack.peek(), PdfName.SPAN));
                    this.pdfContentByte.endMarkedContentSequence();
                }
                this.tagStack.pop();
            }
            if (TAG_END.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TR)) || TAG_FULL.equals(prop)) {
                this.tagStack.pop();
            }
            if (TAG_END.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TABLE)) || TAG_FULL.equals(prop)) {
                this.tagStack.pop();
            }
        }
    }

    protected void createEndHeadingTags(String prop) {
        if (TAG_END.equals(prop) || TAG_FULL.equals(prop)) {
            if (this.isTagEmpty) {
                this.pdfContentByte.beginMarkedContentSequence(new PdfStructureElement(this.tagStack.peek(), PdfName.SPAN));
                this.pdfContentByte.endMarkedContentSequence();
            }
            this.tagStack.pop();
        }
    }
}

