/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zsoup.nodes;

import java.util.ArrayList;
import java.util.List;
import org.zkoss.zsoup.Connection;
import org.zkoss.zsoup.Zsoup;
import org.zkoss.zsoup.helper.HttpConnection;
import org.zkoss.zsoup.helper.Validate;
import org.zkoss.zsoup.nodes.Attributes;
import org.zkoss.zsoup.nodes.Element;
import org.zkoss.zsoup.parser.Tag;
import org.zkoss.zsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormElement
extends Element {
    private final Elements elements = new Elements();

    public FormElement(Tag tag, String baseUri, Attributes attributes) {
        super(tag, baseUri, attributes);
    }

    public Elements elements() {
        return this.elements;
    }

    public FormElement addElement(Element element) {
        this.elements.add(element);
        return this;
    }

    public Connection submit() {
        String action = this.hasAttr("action") ? this.absUrl("action") : this.baseUri();
        Validate.notEmpty(action, "Could not determine a form action URL for submit. Ensure you set a base URI when parsing.");
        Connection.Method method = this.attr("method").toUpperCase().equals("POST") ? Connection.Method.POST : Connection.Method.GET;
        Connection con = Zsoup.connect(action).data(this.formData()).method(method);
        return con;
    }

    public List<Connection.KeyVal> formData() {
        ArrayList<Connection.KeyVal> data = new ArrayList<Connection.KeyVal>();
        for (Element el : this.elements) {
            String name;
            if (!el.tag().isFormSubmittable() || (name = el.attr("name")).length() == 0) continue;
            if ("select".equals(el.tagName())) {
                Elements options = el.select("option[selected]");
                for (Element option : options) {
                    data.add(HttpConnection.KeyVal.create(name, option.val()));
                }
                continue;
            }
            data.add(HttpConnection.KeyVal.create(name, el.val()));
        }
        return data;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

